/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import io.netty.channel.DefaultFileRegion;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.storage.BlockData;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ListBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0004\b\u0005/!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003$\u0011!9\u0003A!A!\u0002\u0013A\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u000bE\u0002A\u0011\u0001\u001a\t\u000ba\u0002A\u0011I\u001d\t\u000bu\u0002A\u0011\t \t\u000b}\u0002A\u0011\t!\t\u000bY\u0003A\u0011I,\t\u000ba\u0003A\u0011I-\t\u000bi\u0003A\u0011I.\t\u000b}\u0003A\u0011\u00021\u0003\u001b\u0011K7o\u001b\"m_\u000e\\G)\u0019;b\u0015\ty\u0001#A\u0004ti>\u0014\u0018mZ3\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010!\u001b\u0005q\u0011BA\u0011\u000f\u0005%\u0011En\\2l\t\u0006$\u0018-A\tnS:lU-\\8ss6\u000b\u0007OQ=uKN\u0004\"!\u0007\u0013\n\u0005\u0015R\"\u0001\u0002'p]\u001e\f\u0011#\\1y\u001b\u0016lwN]=NCB\u0014\u0015\u0010^3t\u0003\u00111\u0017\u000e\\3\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013AA5p\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\t\u0019KG.Z\u0001\nE2|7m[*ju\u0016\fa\u0001P5oSRtD#B\u001a5kY:\u0004CA\u0010\u0001\u0011\u0015\u0011S\u00011\u0001$\u0011\u00151S\u00011\u0001$\u0011\u00159S\u00011\u0001)\u0011\u0015\u0001T\u00011\u0001$\u00035!x.\u00138qkR\u001cFO]3b[R\t!\b\u0005\u0002*w%\u0011AH\u000b\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0004u_:+G\u000f^=\u0015\u0003a\t1\u0003^8DQVt7.\u001a3CsR,')\u001e4gKJ$\"!\u0011%\u0011\u0005\t3U\"A\"\u000b\u0005-\"%BA#\u0011\u0003\u0011)H/\u001b7\n\u0005\u001d\u001b%!E\"ik:\\W\r\u001a\"zi\u0016\u0014UO\u001a4fe\")\u0011\n\u0003a\u0001\u0015\u0006I\u0011\r\u001c7pG\u0006$xN\u001d\t\u00053-k\u0005+\u0003\u0002M5\tIa)\u001e8di&|g.\r\t\u000339K!a\u0014\u000e\u0003\u0007%sG\u000f\u0005\u0002R)6\t!K\u0003\u0002TY\u0005\u0019a.[8\n\u0005U\u0013&A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006aAo\u001c\"zi\u0016\u0014UO\u001a4feR\t\u0001+\u0001\u0003tSj,W#A\u0012\u0002\u000f\u0011L7\u000f]8tKR\tA\f\u0005\u0002\u001a;&\u0011aL\u0007\u0002\u0005+:LG/\u0001\u0003pa\u0016tG#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011\u0014\u0016\u0001C2iC:tW\r\\:\n\u0005\u0019\u001c'a\u0003$jY\u0016\u001c\u0005.\u00198oK2\u0004")
public class DiskBlockData
implements BlockData {
    private final long minMemoryMapBytes;
    private final long maxMemoryMapBytes;
    private final File file;
    private final long blockSize;

    @Override
    public InputStream toInputStream() {
        return new FileInputStream(this.file);
    }

    @Override
    public Object toNetty() {
        return new DefaultFileRegion(this.file, 0L, this.size());
    }

    @Override
    public ChunkedByteBuffer toChunkedByteBuffer(Function1<Object, ByteBuffer> allocator) {
        return (ChunkedByteBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.open(), (Function1 & Serializable & scala.Serializable)channel -> {
            long chunkSize;
            ListBuffer chunks = new ListBuffer();
            for (long remaining = $this.blockSize; remaining > 0L; remaining -= chunkSize) {
                chunkSize = package$.MODULE$.min(remaining, $this.maxMemoryMapBytes);
                ByteBuffer chunk = (ByteBuffer)allocator.apply((Object)BoxesRunTime.boxToInteger((int)((int)chunkSize)));
                JavaUtils.readFully((ReadableByteChannel)channel, (ByteBuffer)chunk);
                chunk.flip();
                chunks.$plus$eq((Object)chunk);
            }
            return new ChunkedByteBuffer((ByteBuffer[])chunks.toArray(ClassTag$.MODULE$.apply(ByteBuffer.class)));
        });
    }

    @Override
    public ByteBuffer toByteBuffer() {
        Predef$.MODULE$.require(this.blockSize < this.maxMemoryMapBytes, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("can't create a byte buffer of size ").append($this.blockSize).append(" since it exceeds ").append(Utils$.MODULE$.bytesToString($this.maxMemoryMapBytes)).append(".").toString());
        return (ByteBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.open(), (Function1 & Serializable & scala.Serializable)channel -> {
            if ($this.blockSize < $this.minMemoryMapBytes) {
                ByteBuffer buf = ByteBuffer.allocate((int)$this.blockSize);
                JavaUtils.readFully((ReadableByteChannel)channel, (ByteBuffer)buf);
                buf.flip();
                return buf;
            }
            return channel.map(FileChannel.MapMode.READ_ONLY, 0L, $this.file.length());
        });
    }

    @Override
    public long size() {
        return this.blockSize;
    }

    @Override
    public void dispose() {
    }

    private FileChannel open() {
        return new FileInputStream(this.file).getChannel();
    }

    public DiskBlockData(long minMemoryMapBytes, long maxMemoryMapBytes, File file, long blockSize) {
        this.minMemoryMapBytes = minMemoryMapBytes;
        this.maxMemoryMapBytes = maxMemoryMapBytes;
        this.file = file;
        this.blockSize = blockSize;
    }
}

