/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockFetcherIterator;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ShuffleBlockFetcherIterator$ {
    public static ShuffleBlockFetcherIterator$ MODULE$;
    private final AtomicBoolean isNettyOOMOnShuffle;

    static {
        new ShuffleBlockFetcherIterator$();
    }

    public Clock $lessinit$greater$default$18() {
        return new SystemClock();
    }

    public AtomicBoolean isNettyOOMOnShuffle() {
        return this.isNettyOOMOnShuffle;
    }

    public void resetNettyOOMFlagIfPossible(long freeMemoryLowerBound) {
        if (this.isNettyOOMOnShuffle().get() && NettyUtils.freeDirectMemory() >= freeMemoryLowerBound) {
            this.isNettyOOMOnShuffle().compareAndSet(true, false);
            return;
        }
    }

    public Seq<ShuffleBlockFetcherIterator.FetchBlockInfo> mergeContinuousShuffleBlockIdsIfNeeded(Seq<ShuffleBlockFetcherIterator.FetchBlockInfo> blocks, boolean doBatchFetch) {
        ArrayBuffer arrayBuffer;
        if (doBatchFetch) {
            ArrayBuffer curBlocks = new ArrayBuffer();
            ArrayBuffer mergedBlockInfo = new ArrayBuffer();
            for (ShuffleBlockFetcherIterator.FetchBlockInfo info : blocks) {
                ArrayBuffer arrayBuffer2;
                if (info.blockId() instanceof ShuffleBlockBatchId) {
                    arrayBuffer2 = mergedBlockInfo.$plus$eq((Object)info);
                    continue;
                }
                if (curBlocks.isEmpty()) {
                    arrayBuffer2 = curBlocks.$plus$eq((Object)info);
                    continue;
                }
                ShuffleBlockId curBlockId = (ShuffleBlockId)info.blockId();
                long currentMapId = ((ShuffleBlockId)((ShuffleBlockFetcherIterator.FetchBlockInfo)curBlocks.head()).blockId()).mapId();
                if (curBlockId.mapId() != currentMapId) {
                    mergedBlockInfo.$plus$eq((Object)ShuffleBlockFetcherIterator$.mergeFetchBlockInfo$1(curBlocks, mergedBlockInfo));
                    curBlocks.clear();
                }
                arrayBuffer2 = curBlocks.$plus$eq((Object)info);
            }
            Object object = curBlocks.nonEmpty() ? mergedBlockInfo.$plus$eq((Object)ShuffleBlockFetcherIterator$.mergeFetchBlockInfo$1(curBlocks, mergedBlockInfo)) : BoxedUnit.UNIT;
            arrayBuffer = mergedBlockInfo;
        } else {
            arrayBuffer = blocks;
        }
        ArrayBuffer result = arrayBuffer;
        return result;
    }

    private static final boolean shouldMergeIntoPreviousBatchBlockId$1(ArrayBuffer mergedBlockInfo$1, ShuffleBlockId startBlockId$1) {
        return ((ShuffleBlockBatchId)((ShuffleBlockFetcherIterator.FetchBlockInfo)mergedBlockInfo$1.last()).blockId()).mapId() == startBlockId$1.mapId();
    }

    private static final ShuffleBlockFetcherIterator.FetchBlockInfo mergeFetchBlockInfo$1(ArrayBuffer toBeMerged, ArrayBuffer mergedBlockInfo$1) {
        Tuple2.mcIJ.sp sp2;
        Tuple2.mcIJ.sp sp3;
        ShuffleBlockId startBlockId = (ShuffleBlockId)((ShuffleBlockFetcherIterator.FetchBlockInfo)toBeMerged.head()).blockId();
        if (mergedBlockInfo$1.nonEmpty() && ShuffleBlockFetcherIterator$.shouldMergeIntoPreviousBatchBlockId$1(mergedBlockInfo$1, startBlockId)) {
            ShuffleBlockFetcherIterator.FetchBlockInfo removed = (ShuffleBlockFetcherIterator.FetchBlockInfo)mergedBlockInfo$1.remove(mergedBlockInfo$1.length() - 1);
            sp3 = new Tuple2.mcIJ.sp(((ShuffleBlockBatchId)removed.blockId()).startReduceId(), removed.size() + BoxesRunTime.unboxToLong((Object)((TraversableOnce)toBeMerged.map((Function1 & java.io.Serializable & Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25.size()), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        } else {
            sp3 = sp2 = new Tuple2.mcIJ.sp(startBlockId.reduceId(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)toBeMerged.map((Function1 & java.io.Serializable & Serializable)x$26 -> BoxesRunTime.boxToLong((long)x$26.size()), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int startReduceId = sp2._1$mcI$sp();
        long size = sp2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp4 = new Tuple2.mcIJ.sp(startReduceId, size);
        int startReduceId2 = sp4._1$mcI$sp();
        long size2 = sp4._2$mcJ$sp();
        return new ShuffleBlockFetcherIterator.FetchBlockInfo(new ShuffleBlockBatchId(startBlockId.shuffleId(), startBlockId.mapId(), startReduceId2, ((ShuffleBlockId)((ShuffleBlockFetcherIterator.FetchBlockInfo)toBeMerged.last()).blockId()).reduceId() + 1), size2, ((ShuffleBlockFetcherIterator.FetchBlockInfo)toBeMerged.head()).mapIndex());
    }

    private ShuffleBlockFetcherIterator$() {
        MODULE$ = this;
        this.isNettyOOMOnShuffle = new AtomicBoolean(false);
    }
}

