/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ExportResultSetForObject;
import org.apache.derby.impl.load.ExportWriteDataAbstract;

abstract class ExportAbstract {
    protected ControlInfo controlFileReader;
    protected ExportResultSetForObject exportResultSetForObject;
    protected ExportWriteDataAbstract exportWriteData;
    protected Connection con;
    protected String entityName;
    protected String schemaName;
    protected String selectStatement;
    protected boolean lobsInExtFile = false;

    ExportAbstract() {
    }

    protected ResultSet resultSetForEntity() throws Exception {
        this.exportResultSetForObject = new ExportResultSetForObject(this.con, this.schemaName, this.entityName, this.selectStatement);
        ResultSet resultSet = this.exportResultSetForObject.getResultSet();
        return resultSet;
    }

    private String[] getOneRowAtATime(ResultSet resultSet, boolean[] blArray, boolean[] blArray2) throws Exception {
        if (resultSet.next()) {
            int n = this.exportResultSetForObject.getColumnCount();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                String string;
                if (this.lobsInExtFile && (blArray2[i] || blArray[i])) {
                    Closeable closeable;
                    if (blArray[i]) {
                        closeable = resultSet.getBinaryStream(i + 1);
                        string = this.exportWriteData.writeBinaryColumnToExternalFile((InputStream)closeable);
                    } else {
                        closeable = resultSet.getCharacterStream(i + 1);
                        string = this.exportWriteData.writeCharColumnToExternalFile((Reader)closeable);
                    }
                    stringArray[i] = string;
                    continue;
                }
                int n2 = i + 1;
                string = resultSetMetaData.getColumnType(n2) == 2000 ? ExportAbstract.stringifyObject(resultSet.getObject(n2)) : resultSet.getString(n2);
                stringArray[i] = string;
            }
            return stringArray;
        }
        resultSet.close();
        this.exportResultSetForObject.close();
        return null;
    }

    public static String stringifyObject(Object object) throws Exception {
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(dynamicByteArrayOutputStream);
        objectOutputStream.writeObject(object);
        byte[] byArray = dynamicByteArrayOutputStream.getByteArray();
        int n = dynamicByteArrayOutputStream.getUsed();
        return StringUtil.toHexString(byArray, 0, n);
    }

    protected ControlInfo getControlFileReader() {
        return this.controlFileReader;
    }

    protected abstract ExportWriteDataAbstract getExportWriteData() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAllTheWork() throws Exception {
        ResultSet resultSet = null;
        try {
            resultSet = this.resultSetForEntity();
            if (resultSet != null) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                boolean[] blArray = new boolean[n];
                boolean[] blArray2 = new boolean[n];
                boolean[] blArray3 = new boolean[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = resultSetMetaData.getColumnType(i + 1);
                    blArray[i] = n2 == -5 || n2 == 3 || n2 == 8 || n2 == 6 || n2 == 4 || n2 == 2 || n2 == 7 || n2 == 5 || n2 == -6;
                    blArray2[i] = n2 == 2005;
                    blArray3[i] = n2 == 2004;
                }
                this.exportWriteData = this.getExportWriteData();
                this.exportWriteData.writeColumnDefinitionOptionally(this.exportResultSetForObject.getColumnDefinition(), this.exportResultSetForObject.getColumnTypes());
                this.exportWriteData.setColumnLengths(this.controlFileReader.getColumnWidths());
                String[] stringArray = this.getOneRowAtATime(resultSet, blArray3, blArray2);
                while (stringArray != null) {
                    this.exportWriteData.writeData(stringArray, blArray);
                    stringArray = this.getOneRowAtATime(resultSet, blArray3, blArray2);
                }
            }
        }
        finally {
            if (this.exportWriteData != null) {
                this.exportWriteData.noMoreRows();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }
}

