/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FindInSet$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, str_array) - Returns the index (1-based) of the given string (`str`) in the comma-delimited list (`str_array`).\n      Returns 0, if the string was not found or if the given string (`str`) contains a comma.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ab','abc,b,ab,c,def');\n       3\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u000f\u001e\u0001*B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\"A\u0001\n\u0001BK\u0002\u0013\u00051\t\u0003\u0005J\u0001\tE\t\u0015!\u0003E\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015\u0011\u0007\u0001\"\u0015d\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015Q\b\u0001\"\u0011|\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u00111\u0003\u0001\u0005R\u0005U\u0001\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0011%\t9\u0003AI\u0001\n\u0003\tI\u0003C\u0005\u0002@\u0001\t\n\u0011\"\u0001\u0002*!I\u0011\u0011\t\u0001\u0002\u0002\u0013\u0005\u00131\t\u0005\n\u0003'\u0002\u0011\u0011!C\u0001\u0003+B\u0011\"!\u0018\u0001\u0003\u0003%\t!a\u0018\t\u0013\u0005\u0015\u0004!!A\u0005B\u0005\u001d\u0004\"CA;\u0001\u0005\u0005I\u0011AA<\u0011%\t\t\tAA\u0001\n\u0003\n\u0019iB\u0005\u0002(v\t\t\u0011#\u0001\u0002*\u001aAA$HA\u0001\u0012\u0003\tY\u000b\u0003\u0004K-\u0011\u0005\u0011\u0011\u0018\u0005\n\u0003w3\u0012\u0011!C#\u0003{C\u0011\"a0\u0017\u0003\u0003%\t)!1\t\u0013\u0005\u001dg#!A\u0005\u0002\u0006%\u0007\"CAn-\u0005\u0005I\u0011BAo\u0005%1\u0015N\u001c3J]N+GO\u0003\u0002\u001f?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0005dCR\fG._:u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0019\u00011f\f\u001a:\u007fA\u0011A&L\u0007\u0002;%\u0011a&\b\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\f\u0019\n\u0005Ej\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005M2dB\u0001\u00175\u0013\t)T$A\u0004qC\u000e\\\u0017mZ3\n\u0005]B$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003ku\u0001\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002;\u0001&\u0011\u0011i\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001E!\taS)\u0003\u0002G;\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019A*\u0014(\u0011\u00051\u0002\u0001\"\u0002\"\u0006\u0001\u0004!\u0005\"\u0002%\u0006\u0001\u0004!\u0015AC5oaV$H+\u001f9fgV\t\u0011\u000bE\u0002S3rs!a\u0015-\u000f\u0005Q;V\"A+\u000b\u0005YK\u0013A\u0002\u001fs_>$h(C\u0001=\u0013\t)4(\u0003\u0002[7\n\u00191+Z9\u000b\u0005UZ\u0004CA/a\u001b\u0005q&BA0\"\u0003\u0015!\u0018\u0010]3t\u0013\t\tgL\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019AmZ5\u0011\u0005i*\u0017B\u00014<\u0005\r\te.\u001f\u0005\u0006Q\u001e\u0001\r\u0001Z\u0001\u0005o>\u0014H\rC\u0003k\u000f\u0001\u0007A-A\u0002tKR\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u00075\u001c\b\u0010\u0005\u0002oc6\tqN\u0003\u0002q;\u000591m\u001c3fO\u0016t\u0017B\u0001:p\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002;\t\u0001\u0004)\u0018aA2uqB\u0011aN^\u0005\u0003o>\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003z\u0011\u0001\u0007Q.\u0001\u0002fm\u0006AA-\u0019;b)f\u0004X-F\u0001}!\tiV0\u0003\u0002\u007f=\nAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0001\u0011\t\u0005\u0015\u0011Q\u0002\b\u0005\u0003\u000f\tI\u0001\u0005\u0002Uw%\u0019\u00111B\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\ty!!\u0005\u0003\rM#(/\u001b8h\u0015\r\tYaO\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$R\u0001TA\f\u00037Aa!!\u0007\f\u0001\u0004!\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u0003;Y\u0001\u0019\u0001#\u0002\u00119,wOU5hQR\fAaY8qsR)A*a\t\u0002&!9!\t\u0004I\u0001\u0002\u0004!\u0005b\u0002%\r!\u0003\u0005\r\u0001R\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYCK\u0002E\u0003[Y#!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003sY\u0014AC1o]>$\u0018\r^5p]&!\u0011QHA\u001a\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\t\t\u0005\u0003\u000f\n\t&\u0004\u0002\u0002J)!\u00111JA'\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0013\u0001\u00026bm\u0006LA!a\u0004\u0002J\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u000b\t\u0004u\u0005e\u0013bAA.w\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A-!\u0019\t\u0013\u0005\r\u0014#!AA\u0002\u0005]\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002jA)\u00111NA9I6\u0011\u0011Q\u000e\u0006\u0004\u0003_Z\u0014AC2pY2,7\r^5p]&!\u00111OA7\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e\u0014q\u0010\t\u0004u\u0005m\u0014bAA?w\t9!i\\8mK\u0006t\u0007\u0002CA2'\u0005\u0005\t\u0019\u00013\u0002\r\u0015\fX/\u00197t)\u0011\tI(!\"\t\u0011\u0005\rD#!AA\u0002\u0011D3\u0003AAE\u0003\u001f\u000b\t*!&\u0002\u0018\u0006m\u0015QTAQ\u0003G\u00032\u0001LAF\u0013\r\ti)\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019*AAb\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue2\u00023\u000f\u001e:`CJ\u0014\u0018-_\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!S:$W\r\u001f\u0011)c5\u0012\u0017m]3eS\u0001zg\r\t;iK\u0002:\u0017N^3oAM$(/\u001b8hA!\u00027\u000f\u001e:aS\u0001Jg\u000e\t;iK\u0002\u001aw.\\7b[\u0011,G.[7ji\u0016$\u0007\u0005\\5ti\u0002B\u0003m\u001d;s?\u0006\u0014(/Y=aS9R\u0001\u0005\t\u0011!A\u0001\u0012V\r^;s]N\u0004\u0003\u0007\f\u0011jM\u0002\"\b.\u001a\u0011tiJLgn\u001a\u0011xCN\u0004cn\u001c;!M>,h\u000e\u001a\u0011pe\u0002Jg\r\t;iK\u0002:\u0017N^3oAM$(/\u001b8hA!\u00027\u000f\u001e:aS\u0001\u001awN\u001c;bS:\u001c\b%\u0019\u0011d_6l\u0017M\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u001a\u0006A%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014bE\u001ebs%\u00192dY\td\u0013M\u0019\u0017dY\u0011,gmJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003?\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!!*\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0013\u0019Kg\u000eZ%o'\u0016$\bC\u0001\u0017\u0017'\u00111\u0012QV \u0011\u000f\u0005=\u0016Q\u0017#E\u00196\u0011\u0011\u0011\u0017\u0006\u0004\u0003g[\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003o\u000b\tLA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!+\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b1\u000b\u0019-!2\t\u000b\tK\u0002\u0019\u0001#\t\u000b!K\u0002\u0019\u0001#\u0002\u000fUt\u0017\r\u001d9msR!\u00111ZAl!\u0015Q\u0014QZAi\u0013\r\tym\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bi\n\u0019\u000e\u0012#\n\u0007\u0005U7H\u0001\u0004UkBdWM\r\u0005\t\u00033T\u0012\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u0004B!a\u0012\u0002b&!\u00111]A%\u0005\u0019y%M[3di\u0002")
public class FindInSet
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(FindInSet findInSet) {
        return FindInSet$.MODULE$.unapply(findInSet);
    }

    public static Function1<Tuple2<Expression, Expression>, FindInSet> tupled() {
        return FindInSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FindInSet>> curried() {
        return FindInSet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Object nullSafeEval(Object word, Object set) {
        return BoxesRunTime.boxToInteger((int)((UTF8String)set).findInSet((UTF8String)word));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(word, set) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)set).append(".findInSet(").append((String)word).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "find_in_set";
    }

    @Override
    public FindInSet withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public FindInSet copy(Expression left, Expression right) {
        return new FindInSet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FindInSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FindInSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FindInSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        FindInSet findInSet = (FindInSet)x$1;
        Expression expression = this.left();
        Expression expression2 = findInSet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = findInSet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!findInSet.canEqual(this)) return false;
        return true;
    }

    public FindInSet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

