/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorFilterDesc;

@Explain(displayName="Filter Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class FilterDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private ExprNodeDesc predicate;
    private boolean isSamplingPred;
    private boolean syntheticJoinPredicate;
    private transient SampleDesc sampleDescr;
    private boolean isSortedFilter;
    private transient boolean isGenerated;

    public FilterDesc() {
    }

    public FilterDesc(ExprNodeDesc predicate, boolean isSamplingPred) {
        this.predicate = predicate;
        this.isSamplingPred = isSamplingPred;
        this.sampleDescr = null;
    }

    public FilterDesc(ExprNodeDesc predicate, boolean isSamplingPred, SampleDesc sampleDescr) {
        this.predicate = predicate;
        this.isSamplingPred = isSamplingPred;
        this.sampleDescr = sampleDescr;
    }

    @Explain(displayName="predicate")
    public String getPredicateString() {
        return PlanUtils.getExprListString(Arrays.asList(this.predicate));
    }

    @Explain(displayName="predicate", explainLevels={Explain.Level.USER})
    public String getUserLevelExplainPredicateString() {
        return PlanUtils.getExprListString(Arrays.asList(this.predicate), true);
    }

    public ExprNodeDesc getPredicate() {
        return this.predicate;
    }

    public void setPredicate(ExprNodeDesc predicate) {
        this.predicate = predicate;
    }

    @Explain(displayName="isSamplingPred", explainLevels={Explain.Level.EXTENDED})
    public boolean getIsSamplingPred() {
        return this.isSamplingPred;
    }

    public void setIsSamplingPred(boolean isSamplingPred) {
        this.isSamplingPred = isSamplingPred;
    }

    public SampleDesc getSampleDescr() {
        return this.sampleDescr;
    }

    public void setSampleDescr(SampleDesc sampleDescr) {
        this.sampleDescr = sampleDescr;
    }

    @Explain(displayName="sampleDesc", explainLevels={Explain.Level.EXTENDED})
    public String getSampleDescExpr() {
        return this.sampleDescr == null ? null : this.sampleDescr.toString();
    }

    public boolean isSortedFilter() {
        return this.isSortedFilter;
    }

    public void setSortedFilter(boolean isSortedFilter) {
        this.isSortedFilter = isSortedFilter;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void setGenerated(boolean isGenerated) {
        this.isGenerated = isGenerated;
    }

    public boolean isSyntheticJoinPredicate() {
        return this.syntheticJoinPredicate;
    }

    public void setSyntheticJoinPredicate(boolean syntheticJoinPredicate) {
        this.syntheticJoinPredicate = syntheticJoinPredicate;
    }

    @Override
    public Object clone() {
        FilterDesc filterDesc = new FilterDesc(this.getPredicate().clone(), this.getIsSamplingPred());
        if (this.getIsSamplingPred()) {
            filterDesc.setSampleDescr(this.getSampleDescr());
        }
        filterDesc.setSortedFilter(this.isSortedFilter());
        return filterDesc;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="Filter Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public FilterOperatorExplainVectorization getFilterVectorization() {
        if (this.vectorDesc == null) {
            return null;
        }
        return new FilterOperatorExplainVectorization(this, this.vectorDesc);
    }

    public class FilterOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final FilterDesc filterDesc;
        private final VectorFilterDesc vectorFilterDesc;

        public FilterOperatorExplainVectorization(FilterDesc filterDesc, VectorDesc vectorDesc) {
            super(vectorDesc, true);
            this.filterDesc = filterDesc;
            this.vectorFilterDesc = (VectorFilterDesc)vectorDesc;
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="predicateExpression", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getPredicateExpression() {
            return this.vectorFilterDesc.getPredicateExpression().toString();
        }
    }

    public static class SampleDesc
    implements Cloneable {
        private int numerator;
        private int denominator;
        private boolean inputPruning;

        public SampleDesc() {
        }

        public SampleDesc(int numerator, int denominator, List<String> tabBucketCols, boolean inputPruning) {
            this.numerator = numerator;
            this.denominator = denominator;
            this.inputPruning = inputPruning;
        }

        public int getNumerator() {
            return this.numerator;
        }

        public int getDenominator() {
            return this.denominator;
        }

        public boolean getInputPruning() {
            return this.inputPruning;
        }

        public Object clone() {
            SampleDesc desc = new SampleDesc(this.numerator, this.denominator, null, this.inputPruning);
            return desc;
        }

        public String toString() {
            return this.inputPruning ? "BUCKET " + this.numerator + " OUT OF " + this.denominator : null;
        }
    }
}

