/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncRadiansDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncRadiansLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="radians", value="_FUNC_(x) - Converts degrees to radians", extended="Example:\n  > SELECT _FUNC_(90) FROM src LIMIT 1;\n  1.5707963267949mo\n")
@VectorizedExpressions(value={FuncRadiansLongToDouble.class, FuncRadiansDoubleToDouble.class})
public class UDFRadians
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        this.result.set(Math.toRadians(a.get()));
        return this.result;
    }
}

