/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.fs.Path;

public class StringInternUtils {
    private static Class uriClass = URI.class;
    private static Field stringField;
    private static Field schemeField;
    private static Field authorityField;
    private static Field hostField;
    private static Field pathField;
    private static Field fragmentField;
    private static Field schemeSpecificPartField;

    public static URI internStringsInUri(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            String schemeSpecificPart;
            String fragment;
            String path;
            String host;
            String authority;
            String scheme;
            String string = (String)stringField.get(uri);
            if (string != null) {
                stringField.set(uri, string.intern());
            }
            if ((scheme = (String)schemeField.get(uri)) != null) {
                schemeField.set(uri, scheme.intern());
            }
            if ((authority = (String)authorityField.get(uri)) != null) {
                authorityField.set(uri, authority.intern());
            }
            if ((host = (String)hostField.get(uri)) != null) {
                hostField.set(uri, host.intern());
            }
            if ((path = (String)pathField.get(uri)) != null) {
                pathField.set(uri, path.intern());
            }
            if ((fragment = (String)fragmentField.get(uri)) != null) {
                fragmentField.set(uri, fragment.intern());
            }
            if ((schemeSpecificPart = (String)schemeSpecificPartField.get(uri)) != null) {
                schemeSpecificPartField.set(uri, schemeSpecificPart.intern());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    public static Path internUriStringsInPath(Path path) {
        if (path != null) {
            StringInternUtils.internStringsInUri(path.toUri());
        }
        return path;
    }

    public static Path[] internUriStringsInPathArray(Path[] paths) {
        if (paths != null) {
            for (Path path : paths) {
                StringInternUtils.internUriStringsInPath(path);
            }
        }
        return paths;
    }

    public static List<String> internStringsInList(List<String> list) {
        if (list != null) {
            try {
                ListIterator<String> it = list.listIterator();
                while (it.hasNext()) {
                    it.set(it.next().intern());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return list;
    }

    public static String[] internStringsInArray(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) continue;
            strings[i] = strings[i].intern();
        }
        return strings;
    }

    public static <K> Map<K, String> internValuesInMap(Map<K, String> map) {
        if (map != null) {
            for (K key : map.keySet()) {
                String value = map.get(key);
                if (value == null) continue;
                map.put(key, value.intern());
            }
        }
        return map;
    }

    public static String internIfNotNull(String s) {
        if (s != null) {
            s = s.intern();
        }
        return s;
    }

    static {
        try {
            stringField = uriClass.getDeclaredField("string");
            schemeField = uriClass.getDeclaredField("scheme");
            authorityField = uriClass.getDeclaredField("authority");
            hostField = uriClass.getDeclaredField("host");
            pathField = uriClass.getDeclaredField("path");
            fragmentField = uriClass.getDeclaredField("fragment");
            schemeSpecificPartField = uriClass.getDeclaredField("schemeSpecificPart");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        stringField.setAccessible(true);
        schemeField.setAccessible(true);
        authorityField.setAccessible(true);
        hostField.setAccessible(true);
        pathField.setAccessible(true);
        fragmentField.setAccessible(true);
        schemeSpecificPartField.setAccessible(true);
    }
}

