/*
 * Decompiled with CFR 0.152.
 */
package breeze.signal.support;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.convert$;
import breeze.linalg.diff$;
import breeze.linalg.max$;
import breeze.linalg.min$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.sum$;
import breeze.math.Semiring$;
import breeze.numerics.package$cos$;
import breeze.numerics.package$cos$cosDoubleImpl$;
import breeze.numerics.package$isEven$;
import breeze.numerics.package$isOdd$;
import breeze.numerics.package$sincpi$;
import breeze.numerics.package$sincpi$sincpiDoubleImpl$;
import breeze.signal.OptWindowFunction;
import breeze.signal.OptWindowFunction$None$;
import breeze.signal.support.CanFirwin;
import breeze.signal.support.FIRKernel1D;
import breeze.signal.support.WindowFunctions$;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Array$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Long$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class CanFirwin$ {
    public static CanFirwin$ MODULE$;

    static {
        new CanFirwin$();
    }

    public CanFirwin<Object> firwinDouble() {
        return new CanFirwin<Object>(){

            public FIRKernel1D<Object> apply(int taps, DenseVector<Object> omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow) {
                return new FIRKernel1D<Object>(CanFirwin$.MODULE$.firwinDoubleImpl(taps, omegas, nyquist, zeroPass, scale, optWindow).$times(BoxesRunTime.boxToDouble((double)multiplier), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), multiplier, new StringBuilder(59).append("FIRKernel1D(firwin): ").append(taps).append(" taps, ").append(omegas).append(", ").append(optWindow).append(", zeroPass=").append(zeroPass).append(", nyquist=").append(nyquist).append(", scale=").append(scale).toString());
            }
        };
    }

    public CanFirwin<Object> firwinT_Int() {
        return new CanFirwin<Object>(){

            public FIRKernel1D<Object> apply(int taps, DenseVector<Object> omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow) {
                return new FIRKernel1D<Object>(convert$.MODULE$.apply(CanFirwin$.MODULE$.firwinDoubleImpl(taps, omegas, nyquist, zeroPass, scale, optWindow).$times(BoxesRunTime.boxToDouble((double)multiplier), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), Int$.MODULE$, HasOps$.MODULE$.canMapV1DV(DenseVector$.MODULE$.DV_scalarOf(), convert$.MODULE$.impl2_Double_Int(), DenseVector$.MODULE$.DV_canMapValues$mDIc$sp((ClassTag<Object>)ClassTag$.MODULE$.Int()))), multiplier, new StringBuilder(59).append("FIRKernel1D(firwin): ").append(taps).append(" taps, ").append(omegas).append(", ").append(optWindow).append(", zeroPass=").append(zeroPass).append(", nyquist=").append(nyquist).append(", scale=").append(scale).toString());
            }
        };
    }

    public CanFirwin<Object> firwinT_Long() {
        return new CanFirwin<Object>(){

            public FIRKernel1D<Object> apply(int taps, DenseVector<Object> omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow) {
                return new FIRKernel1D<Object>(convert$.MODULE$.apply(CanFirwin$.MODULE$.firwinDoubleImpl(taps, omegas, nyquist, zeroPass, scale, optWindow).$times(BoxesRunTime.boxToDouble((double)multiplier), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), Long$.MODULE$, HasOps$.MODULE$.canMapV1DV(DenseVector$.MODULE$.DV_scalarOf(), convert$.MODULE$.impl2_Double_Long(), DenseVector$.MODULE$.DV_canMapValues(ClassTag$.MODULE$.Long()))), multiplier, new StringBuilder(59).append("FIRKernel1D(firwin): ").append(taps).append(" taps, ").append(omegas).append(", ").append(optWindow).append(", zeroPass=").append(zeroPass).append(", nyquist=").append(nyquist).append(", scale=").append(scale).toString());
            }
        };
    }

    public CanFirwin<Object> firwinT_Float() {
        return new CanFirwin<Object>(){

            public FIRKernel1D<Object> apply(int taps, DenseVector<Object> omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow) {
                return new FIRKernel1D<Object>(convert$.MODULE$.apply(CanFirwin$.MODULE$.firwinDoubleImpl(taps, omegas, nyquist, zeroPass, scale, optWindow).$times(BoxesRunTime.boxToDouble((double)multiplier), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), Float$.MODULE$, HasOps$.MODULE$.canMapV1DV(DenseVector$.MODULE$.DV_scalarOf(), convert$.MODULE$.impl2_Double_Float(), DenseVector$.MODULE$.DV_canMapValues$mDFc$sp((ClassTag<Object>)ClassTag$.MODULE$.Float()))), multiplier, new StringBuilder(59).append("FIRKernel1D(firwin): ").append(taps).append(" taps, ").append(omegas).append(", ").append(optWindow).append(", zeroPass=").append(zeroPass).append(", nyquist=").append(nyquist).append(", scale=").append(scale).toString());
            }
        };
    }

    public DenseVector<Object> firwinDoubleImpl(int taps, DenseVector<Object> omegas, double nyquist, boolean zeroPass, boolean scale, OptWindowFunction optWindow) {
        Object object;
        DenseVector<Object> denseVector;
        Predef$.MODULE$.require(omegas.length() > 0, (Function0 & Serializable & scala.Serializable)() -> "At least one cutoff frequency must be given!");
        Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)min$.MODULE$.apply(omegas, min$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) >= 0.0, (Function0 & Serializable & scala.Serializable)() -> "The cutoff frequencies must be bigger than zero!");
        Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(omegas, max$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) <= nyquist, (Function0 & Serializable & scala.Serializable)() -> "The cutoff frequencies must be smaller than the nyquist frequency!");
        if (omegas.length() > 1) {
            Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)min$.MODULE$.apply(diff$.MODULE$.apply(omegas, diff$.MODULE$.implDV_DV_Double()), min$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) > 0.0, (Function0 & Serializable & scala.Serializable)() -> "The cutoff frequency must be monotonically increasing.");
        }
        boolean nyquistPass = zeroPass != BoxesRunTime.unboxToBoolean((Object)package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger((int)omegas.length()), package$isOdd$.MODULE$.isOddImpl_Int()));
        double[] tempCutoff = omegas.$div(BoxesRunTime.boxToDouble((double)nyquist), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpDiv()).toArray$mcD$sp((ClassTag<Object>)ClassTag$.MODULE$.Double());
        if (zeroPass) {
            tempCutoff = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(tempCutoff)).$plus$colon((Object)BoxesRunTime.boxToDouble((double)0.0), ClassTag$.MODULE$.Double());
        }
        if (nyquistPass) {
            tempCutoff = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(tempCutoff)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)1.0), ClassTag$.MODULE$.Double());
        }
        Vector scaledCutoff = DenseVector$.MODULE$.apply$mDc$sp(tempCutoff);
        Predef$.MODULE$.require(!nyquistPass || !BoxesRunTime.unboxToBoolean((Object)package$isEven$.MODULE$.apply(BoxesRunTime.boxToInteger((int)taps), package$isEven$.MODULE$.isEvenImpl_Int())), (Function0 & Serializable & scala.Serializable)() -> "A filter with an even number of taps must have zero response at the Nyquist rate.");
        double alpha = 0.5 * (double)(taps - 1);
        DenseVector<Object> m = DenseVector$.MODULE$.tabulate$mDc$sp(taps, (Function1<Object, Object>)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> i, (ClassTag<Object>)ClassTag$.MODULE$.Double()).$minus(BoxesRunTime.boxToDouble((double)alpha), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpSub());
        DenseVector<Object> h = DenseVector$.MODULE$.zeros$mDc$sp(m.length(), (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(((DenseVector)scaledCutoff).toArray$mcD$sp((ClassTag<Object>)ClassTag$.MODULE$.Double()))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)band -> BoxesRunTime.unboxToBoolean((Object)package$isEven$.MODULE$.apply(BoxesRunTime.boxToInteger((int)band._2$mcI$sp()), package$isEven$.MODULE$.isEvenImpl_Int())) ? (DenseVector)h.$minus$eq(((ImmutableNumericOps)package$sincpi$.MODULE$.apply(m.$times$colon$times(BoxesRunTime.boxToDouble((double)band._1$mcD$sp()), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), package$sincpi$sincpiDoubleImpl$.MODULE$, DenseVector$.MODULE$.DV_canMapValues$mDDc$sp((ClassTag<Object>)ClassTag$.MODULE$.Double())))).$times$colon$times(BoxesRunTime.boxToDouble((double)band._1$mcD$sp()), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double()) : (DenseVector)h.$plus$eq(((ImmutableNumericOps)package$sincpi$.MODULE$.apply(m.$times$colon$times(BoxesRunTime.boxToDouble((double)band._1$mcD$sp()), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), package$sincpi$sincpiDoubleImpl$.MODULE$, DenseVector$.MODULE$.DV_canMapValues$mDDc$sp((ClassTag<Object>)ClassTag$.MODULE$.Double())))).$times$colon$times(BoxesRunTime.boxToDouble((double)band._1$mcD$sp()), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double()));
        OptWindowFunction optWindowFunction = optWindow;
        if (optWindowFunction instanceof OptWindowFunction.Hamming) {
            OptWindowFunction.Hamming hamming = (OptWindowFunction.Hamming)optWindowFunction;
            double alpha2 = hamming.alpha();
            double beta = hamming.beta();
            denseVector = WindowFunctions$.MODULE$.hammingWindow(taps, alpha2, beta);
        } else if (optWindowFunction instanceof OptWindowFunction.Hanning) {
            OptWindowFunction.Hanning hanning = (OptWindowFunction.Hanning)optWindowFunction;
            double alpha3 = hanning.alpha();
            double beta = hanning.beta();
            denseVector = WindowFunctions$.MODULE$.hammingWindow(taps, alpha3, beta);
        } else if (optWindowFunction instanceof OptWindowFunction.Blackman) {
            OptWindowFunction.Blackman blackman = (OptWindowFunction.Blackman)optWindowFunction;
            double a0 = blackman.a0();
            double a1 = blackman.a1();
            double a2 = blackman.a2();
            denseVector = WindowFunctions$.MODULE$.blackmanWindow(taps, a0, a1, a2);
        } else if (OptWindowFunction$None$.MODULE$.equals(optWindowFunction)) {
            denseVector = DenseVector$.MODULE$.ones$mDc$sp(taps, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD());
        } else if (optWindowFunction instanceof OptWindowFunction.User) {
            OptWindowFunction.User user = (OptWindowFunction.User)optWindowFunction;
            DenseVector<Object> dv = user.dv();
            Predef$.MODULE$.require(dv.length() == taps, (Function0 & Serializable & scala.Serializable)() -> "Length of specified window function is not the same as taps option!");
            denseVector = dv;
        } else {
            throw new MatchError((Object)optWindowFunction);
        }
        DenseVector<Object> win = denseVector;
        h.$times$eq(win, HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpMulScalar());
        if (scale) {
            double scaleFrequency = ((DenseVector)scaledCutoff).apply$mcD$sp(0) == 0.0 ? 0.0 : (((DenseVector)scaledCutoff).apply$mcD$sp(1) == 1.0 ? 1.0 : (((DenseVector)scaledCutoff).apply$mcD$sp(0) + ((DenseVector)scaledCutoff).apply$mcD$sp(1)) / 2.0);
            DenseVector<Object> c = package$cos$.MODULE$.apply(m.$times$colon$times(BoxesRunTime.boxToDouble((double)(Math.PI * scaleFrequency)), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()), HasOps$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.DV_scalarOf(), package$cos$cosDoubleImpl$.MODULE$, DenseVector$.MODULE$.DV_canMapValues$mDDc$sp((ClassTag<Object>)ClassTag$.MODULE$.Double())));
            double s = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(h.$times$colon$times(c, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues())));
            object = h.$div$eq(BoxesRunTime.boxToDouble((double)s), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpDiv());
        } else {
            object = BoxedUnit.UNIT;
        }
        return h;
    }

    private CanFirwin$() {
        MODULE$ = this;
    }
}

