/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.aead.subtle;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.SubtleUtil;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@Alpha
public final class AesGcmSiv
implements Aead {
    private static final ThreadLocal<Cipher> localCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return EngineFactory.CIPHER.getInstance("AES/GCM-SIV/NoPadding");
            }
            catch (GeneralSecurityException ex) {
                throw new IllegalStateException(ex);
            }
        }
    };
    private static final int IV_SIZE_IN_BYTES = 12;
    private static final int TAG_SIZE_IN_BYTES = 16;
    private static final boolean HAS_GCM_PARAMETER_SPEC_CLASS = AesGcmSiv.hasGCMParameterSpecClass();
    private final SecretKey keySpec;

    public AesGcmSiv(byte[] key) throws GeneralSecurityException {
        Validators.validateAesKeySize(key.length);
        this.keySpec = new SecretKeySpec(key, "AES");
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        int written;
        if (plaintext.length > 2147483619) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] ciphertext = new byte[12 + plaintext.length + 16];
        byte[] iv = Random.randBytes(12);
        System.arraycopy(iv, 0, ciphertext, 0, 12);
        AlgorithmParameterSpec params = AesGcmSiv.getParams(iv);
        localCipher.get().init(1, (Key)this.keySpec, params);
        if (associatedData != null && associatedData.length != 0) {
            localCipher.get().updateAAD(associatedData);
        }
        if ((written = localCipher.get().doFinal(plaintext, 0, plaintext.length, ciphertext, 12)) != plaintext.length + 16) {
            int actualTagSize = written - plaintext.length;
            throw new GeneralSecurityException(String.format("encryption failed; GCM tag must be %s bytes, but got only %s bytes", 16, actualTagSize));
        }
        return ciphertext;
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        if (ciphertext.length < 28) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        AlgorithmParameterSpec params = AesGcmSiv.getParams(ciphertext, 0, 12);
        localCipher.get().init(2, (Key)this.keySpec, params);
        if (associatedData != null && associatedData.length != 0) {
            localCipher.get().updateAAD(associatedData);
        }
        return localCipher.get().doFinal(ciphertext, 12, ciphertext.length - 12);
    }

    private static AlgorithmParameterSpec getParams(byte[] iv) throws GeneralSecurityException {
        return AesGcmSiv.getParams(iv, 0, iv.length);
    }

    private static AlgorithmParameterSpec getParams(byte[] buf, int offset, int len) throws GeneralSecurityException {
        if (HAS_GCM_PARAMETER_SPEC_CLASS) {
            return new GCMParameterSpec(128, buf, offset, len);
        }
        if (SubtleUtil.isAndroid()) {
            return new IvParameterSpec(buf, offset, len);
        }
        throw new GeneralSecurityException("cannot use AES-GCM: javax.crypto.spec.GCMParameterSpec not found");
    }

    private static boolean hasGCMParameterSpecClass() {
        try {
            Class.forName("javax.crypto.spec.GCMParameterSpec");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

