/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy$;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GradientBoostingClassificationExample$ {
    public static GradientBoostingClassificationExample$ MODULE$;

    static {
        new GradientBoostingClassificationExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("GradientBoostedTreesClassificationExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] splits = data.randomSplit(new double[]{0.7, 0.3}, data.randomSplit$default$2());
        Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)splits[1]);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RDD trainingData = (RDD)tuple2._1();
        RDD testData = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)trainingData, (Object)testData);
        RDD trainingData2 = (RDD)tuple22._1();
        RDD testData2 = (RDD)tuple22._2();
        BoostingStrategy boostingStrategy = BoostingStrategy$.MODULE$.defaultParams("Classification");
        boostingStrategy.numIterations_$eq(3);
        boostingStrategy.treeStrategy().numClasses_$eq(2);
        boostingStrategy.treeStrategy().maxDepth_$eq(5);
        boostingStrategy.treeStrategy().categoricalFeaturesInfo_$eq((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        GradientBoostedTreesModel model = GradientBoostedTrees$.MODULE$.train(trainingData2, boostingStrategy);
        RDD labelAndPreds = testData2.map((Function1 & Serializable & scala.Serializable)point -> {
            double prediction = model.predict(point.features());
            return new Tuple2.mcDD.sp(point.label(), prediction);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        double testErr = (double)labelAndPreds.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)GradientBoostingClassificationExample$.$anonfun$main$2(r))).count() / (double)testData2.count();
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("Test Error = ").append(testErr).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(35).append("Learned classification GBT model:\n ").append(model.toDebugString()).toString());
        model.save(sc, "target/tmp/myGradientBoostingClassificationModel");
        GradientBoostedTreesModel sameModel = GradientBoostedTreesModel$.MODULE$.load(sc, "target/tmp/myGradientBoostingClassificationModel");
        sc.stop();
    }

    public static final /* synthetic */ boolean $anonfun$main$2(Tuple2 r) {
        return r._1$mcD$sp() != r._2$mcD$sp();
    }

    private GradientBoostingClassificationExample$() {
        MODULE$ = this;
    }
}

