/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.classic;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OptionList;
import org.apache.spark.sql.catalyst.plans.logical.TableSpecBase;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedTableSpec;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.classic.DataStreamWriter$;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.V2TableWithV1Fallback;
import org.apache.spark.sql.connector.expressions.ClusterByTransform;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.python.PythonDataSourceV2;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.sources.ForeachBatchSink;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable;
import org.apache.spark.sql.execution.streaming.sources.ForeachWriterTable$;
import org.apache.spark.sql.execution.streaming.sources.MemoryPlan;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\r\rh\u0001\u0002)R\u0005qC\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\u0007m\u0002!\taU<\t\u000bi\u0004A\u0011A>\t\ri\u0004A\u0011AA\u0002\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\t9\u0007\u0001C\u0001\u0003sBq!a#\u0001\t\u0003\ti\tC\u0004\u0002\f\u0002!\t!!'\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\"9\u0011Q \u0001\u0005\n\u0005}\b\"\u0003B\u0010\u0001E\u0005I\u0011\u0002B\u0011\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kA\u0011Ba\u001f\u0001#\u0003%IA! \t\u0013\t\u0005\u0005!%A\u0005\n\t\r\u0005\"\u0003BD\u0001E\u0005I\u0011\u0002B\u0011\u0011\u001d\u0011I\t\u0001C\u0005\u0005\u0017CqAa(\u0001\t\u0003\u0011\t\u000b\u0003\u0005\u00030\u0002!\ta\u0015BY\u0011)\u0011I\rAI\u0001\n\u0003\u0019&1\u001a\u0005\b\u0005\u001f\u0004A\u0011\u0001Bi\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005cDqa!\u0001\u0001\t\u0013\u0011\t\u0010C\u0004\u0004\u0004\u0001!Ia!\u0002\t\u000f\r=\u0001\u0001\"\u0003\u0004\u0012!91q\u0003\u0001\u0005\n\re\u0001bBA.\u0001\u0011\u000531\u0004\u0005\b\u00037\u0002A\u0011IB\u0011\u0011\u001d\tY\u0006\u0001C!\u0007OAqAa4\u0001\t\u0003\u001a\u0019\u0004C\u0005\u00026\u0001\u0001\r\u0011\"\u0003\u00026\"I11\u000b\u0001A\u0002\u0013%1Q\u000b\u0005\t\u00077\u0002\u0001\u0015)\u0003\u0002\b!A!\u0010\u0001a\u0001\n\u0013\u0019i\u0006C\u0005\u0004`\u0001\u0001\r\u0011\"\u0003\u0004b!91Q\r\u0001!B\u0013q\b\"CA\u000f\u0001\u0001\u0007I\u0011BB4\u0011%\u0019I\u0007\u0001a\u0001\n\u0013\u0019Y\u0007\u0003\u0005\u0004p\u0001\u0001\u000b\u0015BA\u0012\u0011%\u0019\t\b\u0001a\u0001\n\u0013\u0019\u0019\bC\u0005\u0004v\u0001\u0001\r\u0011\"\u0003\u0004x!A11\u0010\u0001!B\u0013\u0011i\u0005C\u0006\u0004~\u0001\u0001\r\u00111A\u0005\n\r}\u0004bCBA\u0001\u0001\u0007\t\u0019!C\u0005\u0007\u0007C1ba\"\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00036\"I1\u0011\u0012\u0001A\u0002\u0013%11\u0012\u0005\n\u0007\u001b\u0003\u0001\u0019!C\u0005\u0007\u001fC\u0001ba%\u0001A\u0003&!Q\u0018\u0005\f\u0007+\u0003\u0001\u0019!a\u0001\n\u0013\u00199\nC\u0006\u0004\u001a\u0002\u0001\r\u00111A\u0005\n\rm\u0005bCBP\u0001\u0001\u0007\t\u0011)Q\u0005\u0005/D\u0011b!)\u0001\u0001\u0004%IA!=\t\u0013\r\r\u0006\u00011A\u0005\n\r\u0015\u0006\u0002CBU\u0001\u0001\u0006KAa=\t\u0013\r-\u0006\u00011A\u0005\n\tE\b\"CBW\u0001\u0001\u0007I\u0011BBX\u0011!\u0019\u0019\f\u0001Q!\n\tMxaBB\\#\"\u00051\u0011\u0018\u0004\u0007!FC\taa/\t\rY\u0004E\u0011ABb\u0011%\u0019)\r\u0011b\u0001\n\u0003\t)\f\u0003\u0005\u0004H\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019I\r\u0011b\u0001\n\u0003\t)\f\u0003\u0005\u0004L\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019i\r\u0011b\u0001\n\u0003\t)\f\u0003\u0005\u0004P\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019\t\u000e\u0011b\u0001\n\u0003\t)\f\u0003\u0005\u0004T\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019)\u000e\u0011b\u0001\n\u0003\t)\f\u0003\u0005\u0004X\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019I\u000e\u0011b\u0001\n\u0003\t)\f\u0003\u0005\u0004\\\u0002\u0003\u000b\u0011BA\u0004\u0011%\u0019i\u000e\u0011b\u0001\n\u0003\u0019y\u000e\u0003\u0005\u0004b\u0002\u0003\u000b\u0011\u0002B{\u0005A!\u0015\r^1TiJ,\u0017-\\,sSR,'O\u0003\u0002S'\u000691\r\\1tg&\u001c'B\u0001+V\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003-^\u000bQa\u001d9be.T!\u0001W-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0016aA8sO\u000e\u0001QCA/f'\t\u0001a\fE\u0002`E\u000el\u0011\u0001\u0019\u0006\u0003CN\u000b\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005A\u0003\u0007C\u00013f\u0019\u0001!QA\u001a\u0001C\u0002\u001d\u0014\u0011\u0001V\t\u0003Q:\u0004\"!\u001b7\u000e\u0003)T\u0011a[\u0001\u0006g\u000e\fG.Y\u0005\u0003[*\u0014qAT8uQ&tw\r\u0005\u0002j_&\u0011\u0001O\u001b\u0002\u0004\u0003:L\u0018A\u00013t!\r\u0019HoY\u0007\u0002#&\u0011Q/\u0015\u0002\b\t\u0006$\u0018m]3u\u0003\u0019a\u0014N\\5u}Q\u0011\u00010\u001f\t\u0004g\u0002\u0019\u0007\"B9\u0003\u0001\u0004\u0011\u0018AC8viB,H/T8eKR\u0011A0`\u0007\u0002\u0001!)!p\u0001a\u0001}B\u0011ql`\u0005\u0004\u0003\u0003\u0001'AC(viB,H/T8eKR\u0019A0!\u0002\t\ri$\u0001\u0019AA\u0004!\u0011\tI!a\u0006\u000f\t\u0005-\u00111\u0003\t\u0004\u0003\u001bQWBAA\b\u0015\r\t\tbW\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U!.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tYB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003+Q\u0017a\u0002;sS\u001e<WM\u001d\u000b\u0004y\u0006\u0005\u0002bBA\u000f\u000b\u0001\u0007\u00111\u0005\t\u0004?\u0006\u0015\u0012bAA\u0014A\n9AK]5hO\u0016\u0014\u0018!C9vKJLh*Y7f)\ra\u0018Q\u0006\u0005\b\u0003S1\u0001\u0019AA\u0004\u0003\u00191wN]7biR\u0019A0a\r\t\u000f\u0005Ur\u00011\u0001\u0002\b\u000511o\\;sG\u0016\f1\u0002]1si&$\u0018n\u001c8CsR\u0019A0a\u000f\t\u000f\u0005u\u0002\u00021\u0001\u0002@\u0005A1m\u001c7OC6,7\u000fE\u0003j\u0003\u0003\n9!C\u0002\u0002D)\u0014!\u0002\u0010:fa\u0016\fG/\u001a3?Q\rA\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n6\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005-#a\u0002<be\u0006\u0014xm]\u0001\nG2,8\u000f^3s\u0005f$2\u0001`A,\u0011\u001d\ti$\u0003a\u0001\u0003\u007fA3!CA$\u0003\u0019y\u0007\u000f^5p]R)A0a\u0018\u0002d!9\u0011\u0011\r\u0006A\u0002\u0005\u001d\u0011aA6fs\"9\u0011Q\r\u0006A\u0002\u0005\u001d\u0011!\u0002<bYV,\u0017aB8qi&|gn\u001d\u000b\u0004y\u0006-\u0004bBA4\u0017\u0001\u0007\u0011Q\u000e\t\t\u0003_\n)(a\u0002\u0002\b5\u0011\u0011\u0011\u000f\u0006\u0004\u0003gR\u0017AC2pY2,7\r^5p]&!\u0011qOA9\u0005\ri\u0015\r\u001d\u000b\u0004y\u0006m\u0004bBA4\u0019\u0001\u0007\u0011Q\u0010\t\t\u0003\u007f\nI)a\u0002\u0002\b5\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003vi&d'BAAD\u0003\u0011Q\u0017M^1\n\t\u0005]\u0014\u0011Q\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u0003\u001f\u000b)\nE\u0002`\u0003#K1!a%a\u00059\u0019FO]3b[&tw-U;fefDq!a&\u000e\u0001\u0004\t9!\u0001\u0003qCRDGCAAHQ\u0015q\u0011QTAX!\u0015I\u0017qTAR\u0013\r\t\tK\u001b\u0002\u0007i\"\u0014xn^:\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OSA!!+\u0002\u0002\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u00055\u0016q\u0015\u0002\u0011)&lWm\\;u\u000bb\u001cW\r\u001d;j_:\ftAHA\u0004\u0003c\u000bY.M\u0005$\u0003g\u000bI,!5\u0002<V!\u0011QWA\\+\t\t9\u0001\u0002\u0004g7\n\u0007\u0011\u0011Y\u0005\u0005\u0003w\u000bi,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003\u007fS\u0017A\u0002;ie><8/E\u0002i\u0003\u0007\u0004B!!2\u0002L:\u0019\u0011.a2\n\u0007\u0005%'.A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0017q\u001a\u0002\n)\"\u0014xn^1cY\u0016T1!!3kc%\u0019\u00131[Ak\u0003/\fyLD\u0002j\u0003+L1!a0kc\u0015\u0011\u0013N[Am\u0005\u0015\u00198-\u00197bc\r1\u00131U\u0001\bi>$\u0016M\u00197f)\u0011\ty)!9\t\u000f\u0005\rx\u00021\u0001\u0002\b\u0005IA/\u00192mK:\u000bW.\u001a\u0015\u0004\u001f\u0005\u001d\b\u0003BAu\u0003[l!!a;\u000b\u0007\u00055S+\u0003\u0003\u0002p\u0006-(\u0001C#w_24\u0018N\\4)\u000b=\ti*a=2\u000fy\t9!!>\u0002|FJ1%a-\u0002:\u0006]\u00181X\u0019\nG\u0005M\u0017Q[A}\u0003\u007f\u000bTAI5k\u00033\f4AJAR\u00035\u0019H/\u0019:u\u0013:$XM\u001d8bYR1\u0011q\u0012B\u0001\u0005\u0013Aq!a&\u0011\u0001\u0004\u0011\u0019\u0001E\u0003j\u0005\u000b\t9!C\u0002\u0003\b)\u0014aa\u00149uS>t\u0007\"\u0003B\u0006!A\u0005\t\u0019\u0001B\u0007\u00031\u0019\u0017\r^1m_\u001e$\u0016M\u00197f!\u0015I'Q\u0001B\b!\u0011\u0011\tBa\u0007\u000e\u0005\tM!\u0002\u0002B\u000b\u0005/\tqaY1uC2|wMC\u0002\u0003\u001aM\u000b\u0001bY1uC2L8\u000f^\u0005\u0005\u0005;\u0011\u0019B\u0001\u0007DCR\fGn\\4UC\ndW-A\fti\u0006\u0014H/\u00138uKJt\u0017\r\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0005\u0016\u0005\u0005\u001b\u0011)c\u000b\u0002\u0003(A!!\u0011\u0006B\u0018\u001b\t\u0011YC\u0003\u0003\u0003.\u0005-\u0013!C;oG\",7m[3e\u0013\u0011\u0011\tDa\u000b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006ti\u0006\u0014H/U;fef$B\"a$\u00038\t%#q\u000bB1\u0005sBqA!\u000f\u0013\u0001\u0004\u0011Y$\u0001\u0003tS:\\\u0007\u0003\u0002B\u001f\u0005\u000bj!Aa\u0010\u000b\t\tU!\u0011\t\u0006\u0004\u0005\u0007\u001a\u0016!C2p]:,7\r^8s\u0013\u0011\u00119Ea\u0010\u0003\u000bQ\u000b'\r\\3\t\u000f\t-#\u00031\u0001\u0003N\u0005Qa.Z<PaRLwN\\:\u0011\r\t=#1KA\u0004\u001b\t\u0011\tF\u0003\u0003\u0002\u0004\n]\u0011\u0002\u0002B+\u0005#\u0012!cQ1tK&s7/\u001a8tSRLg/Z'ba\"I!\u0011\f\n\u0011\u0002\u0003\u0007!1L\u0001\u0016e\u0016\u001cwN^3s\rJ|Wn\u00115fG.\u0004x.\u001b8u!\rI'QL\u0005\u0004\u0005?R'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005G\u0012\u0002\u0013!a\u0001\u0005K\nqbY1uC2|w-\u00118e\u0013\u0012,g\u000e\u001e\t\u0006S\n\u0015!q\r\t\bS\n%$Q\u000eB:\u0013\r\u0011YG\u001b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\tu\"qN\u0005\u0005\u0005c\u0012yD\u0001\u0007UC\ndWmQ1uC2|w\r\u0005\u0003\u0003>\tU\u0014\u0002\u0002B<\u0005\u007f\u0011!\"\u00133f]RLg-[3s\u0011%\u0011YA\u0005I\u0001\u0002\u0004\u0011i!\u0001\u000bti\u0006\u0014H/U;fef$C-\u001a4bk2$HeM\u000b\u0003\u0005\u007fRCAa\u0017\u0003&\u0005!2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIQ*\"A!\"+\t\t\u0015$QE\u0001\u0015gR\f'\u000f^)vKJLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u0019\r\u0014X-\u0019;f-F\u001a\u0016N\\6\u0015\t\t5%1\u0014\t\u0005\u0005\u001f\u00139*\u0004\u0002\u0003\u0012*\u0019\u0011Ma%\u000b\u0007\tU5+A\u0005fq\u0016\u001cW\u000f^5p]&!!\u0011\u0014BI\u0005\u0011\u0019\u0016N\\6\t\u000f\tue\u00031\u0001\u0003N\u0005yq\u000e\u001d;j_:\u001cx+\u001b;i!\u0006$\b.A\u0004g_J,\u0017m\u00195\u0015\u0007q\u0014\u0019\u000bC\u0004\u0003&^\u0001\rAa*\u0002\r]\u0014\u0018\u000e^3s!\u0015\u0011IKa+d\u001b\u0005\u0019\u0016b\u0001BW'\niai\u001c:fC\u000eDwK]5uKJ\fQCZ8sK\u0006\u001c\u0007.S7qY\u0016lWM\u001c;bi&|g\u000eF\u0003}\u0005g\u00139\fC\u0004\u0003&b\u0001\rA!.\u0011\u000b\t%&1\u00168\t\u0013\te\u0006\u0004%AA\u0002\tm\u0016aB3oG>$WM\u001d\t\u0006S\n\u0015!Q\u0018\t\u0006\u0005\u007f\u0013)M\\\u0007\u0003\u0005\u0003TAAa1\u0003\u0018\u0005AQM\\2pI\u0016\u00148/\u0003\u0003\u0003H\n\u0005'!E#yaJ,7o]5p]\u0016s7m\u001c3fe\u0006ybm\u001c:fC\u000eD\u0017*\u001c9mK6,g\u000e^1uS>tG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t5'\u0006\u0002B^\u0005K\tABZ8sK\u0006\u001c\u0007NQ1uG\"$2\u0001 Bj\u0011\u001d\u0011)N\u0007a\u0001\u0005/\f\u0001BZ;oGRLwN\u001c\t\nS\ne'Q\u001cBq\u0005OL1Aa7k\u0005%1UO\\2uS>t'\u0007E\u0003\u0003*\n}7-\u0003\u0002v'B\u0019\u0011Na9\n\u0007\t\u0015(N\u0001\u0003M_:<\u0007cA5\u0003j&\u0019!1\u001e6\u0003\tUs\u0017\u000e\u001e\u0015\u00045\u0005\u001d\u0018!\u00058pe6\fG.\u001b>fIB\u000b'oQ8mgV\u0011!1\u001f\t\u0006S\n\u0015!Q\u001f\t\u0007\u0005o\u0014i0a\u0002\u000f\t\te\u0018q\u0019\b\u0005\u0003\u001b\u0011Y0C\u0001l\u0013\u0011\u0011y0a4\u0003\u0007M+\u0017/\u0001\ro_Jl\u0017\r\\5{K\u0012\u001cE.^:uKJLgnZ\"pYN\f\u0011B\\8s[\u0006d\u0017N_3\u0015\r\u0005\u001d1qAB\u0006\u0011\u001d\u0019I!\ba\u0001\u0003\u000f\t!bY8mk6tg*Y7f\u0011\u001d\u0019i!\ba\u0001\u0003\u000f\t!bY8mk6tG+\u001f9f\u0003Q\t7o]3si:{G\u000fU1si&$\u0018n\u001c8fIR!!q]B\n\u0011\u001d\u0019)B\ba\u0001\u0003\u000f\t\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0002CY\fG.\u001b3bi\u0016\u0004\u0016M\u001d;ji&|g.\u001b8h\u0003:$7\t\\;ti\u0016\u0014\u0018N\\4\u0015\u0005\t\u001dH#\u0002?\u0004\u001e\r}\u0001bBA1A\u0001\u0007\u0011q\u0001\u0005\b\u0003K\u0002\u0003\u0019\u0001B.)\u0015a81EB\u0013\u0011\u001d\t\t'\ta\u0001\u0003\u000fAq!!\u001a\"\u0001\u0004\u0011\t\u000fF\u0003}\u0007S\u0019Y\u0003C\u0004\u0002b\t\u0002\r!a\u0002\t\u000f\u0005\u0015$\u00051\u0001\u0004.A\u0019\u0011na\f\n\u0007\rE\"N\u0001\u0004E_V\u0014G.\u001a\u000b\u0004y\u000eU\u0002b\u0002BkG\u0001\u00071q\u0007\t\t\u0007s\u0019\u0019E!8\u0004H5\u001111\b\u0006\u0005\u0005+\u001ciD\u0003\u0003\u0002\b\u000e}\"bAB!+\u0006\u0019\u0011\r]5\n\t\r\u001531\b\u0002\u000e->LGMR;oGRLwN\u001c\u001a\u0011\t\r%3qJ\u0007\u0003\u0007\u0017RAa!\u0014\u0002\u0006\u0006!A.\u00198h\u0013\u0011\u0011)oa\u0013)\u0007\r\n9/\u0001\u0006t_V\u00148-Z0%KF$BAa:\u0004X!I1\u0011L\u0013\u0002\u0002\u0003\u0007\u0011qA\u0001\u0004q\u0012\n\u0014aB:pkJ\u001cW\rI\u000b\u0002}\u0006qq.\u001e;qkRlu\u000eZ3`I\u0015\fH\u0003\u0002Bt\u0007GB\u0001b!\u0017)\u0003\u0003\u0005\rA`\u0001\f_V$\b/\u001e;N_\u0012,\u0007%\u0006\u0002\u0002$\u0005YAO]5hO\u0016\u0014x\fJ3r)\u0011\u00119o!\u001c\t\u0013\re3&!AA\u0002\u0005\r\u0012\u0001\u0003;sS\u001e<WM\u001d\u0011\u0002\u0019\u0015DHO]1PaRLwN\\:\u0016\u0005\t5\u0013\u0001E3yiJ\fw\n\u001d;j_:\u001cx\fJ3r)\u0011\u00119o!\u001f\t\u0013\rec&!AA\u0002\t5\u0013!D3yiJ\fw\n\u001d;j_:\u001c\b%A\u0007g_J,\u0017m\u00195Xe&$XM]\u000b\u0003\u0005k\u000b\u0011CZ8sK\u0006\u001c\u0007n\u0016:ji\u0016\u0014x\fJ3r)\u0011\u00119o!\"\t\u0013\re\u0013'!AA\u0002\tU\u0016A\u00044pe\u0016\f7\r[,sSR,'\u000fI\u0001\u0015M>\u0014X-Y2i/JLG/\u001a:F]\u000e|G-\u001a:\u0016\u0005\tu\u0016\u0001\u00074pe\u0016\f7\r[,sSR,'/\u00128d_\u0012,'o\u0018\u0013fcR!!q]BI\u0011%\u0019I\u0006NA\u0001\u0002\u0004\u0011i,A\u000bg_J,\u0017m\u00195Xe&$XM]#oG>$WM\u001d\u0011\u0002%\u0019|'/Z1dQ\n\u000bGo\u00195Xe&$XM]\u000b\u0003\u0005/\faCZ8sK\u0006\u001c\u0007NQ1uG\"<&/\u001b;fe~#S-\u001d\u000b\u0005\u0005O\u001ci\nC\u0005\u0004Z]\n\t\u00111\u0001\u0003X\u0006\u0019bm\u001c:fC\u000eD')\u0019;dQ^\u0013\u0018\u000e^3sA\u0005\u0019\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7og\u00069\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7og~#S-\u001d\u000b\u0005\u0005O\u001c9\u000bC\u0005\u0004Zi\n\t\u00111\u0001\u0003t\u0006!\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7og\u0002\n\u0011c\u00197vgR,'/\u001b8h\u0007>dW/\u001c8t\u0003U\u0019G.^:uKJLgnZ\"pYVlgn]0%KF$BAa:\u00042\"I1\u0011L\u001f\u0002\u0002\u0003\u0007!1_\u0001\u0013G2,8\u000f^3sS:<7i\u001c7v[:\u001c\b\u0005K\u0002\u0001\u0003O\f\u0001\u0003R1uCN#(/Z1n/JLG/\u001a:\u0011\u0005M\u00045c\u0001!\u0004>B\u0019\u0011na0\n\u0007\r\u0005'N\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0007s\u000b!cU(V%\u000e+uLT!N\u000b~kU)T(S3\u0006\u00192kT+S\u0007\u0016{f*Q'F?6+Uj\u0014*ZA\u0005\u00192kT+S\u0007\u0016{f*Q'F?\u001a{%+R!D\u0011\u0006!2kT+S\u0007\u0016{f*Q'F?\u001a{%+R!D\u0011\u0002\n\u0011dU(V%\u000e+uLT!N\u000b~3uJU#B\u0007\"{&)\u0011+D\u0011\u0006Q2kT+S\u0007\u0016{f*Q'F?\u001a{%+R!D\u0011~\u0013\u0015\tV\"IA\u0005\u00192kT+S\u0007\u0016{f*Q'F?\u000e{ejU(M\u000b\u0006!2kT+S\u0007\u0016{f*Q'F?\u000e{ejU(M\u000b\u0002\n\u0011cU(V%\u000e+uLT!N\u000b~#\u0016I\u0011'F\u0003I\u0019v*\u0016*D\u000b~s\u0015)T#`)\u0006\u0013E*\u0012\u0011\u0002!M{UKU\"F?:\u000bU*R0O\u001f>\u0003\u0016!E*P+J\u001bUi\u0018(B\u001b\u0016{fjT(QA\u0005a2kT+S\u0007\u0016\u001bv,\u0011'M\u001f^{vJT#`)&kUiX)V\u000bJKVC\u0001B{\u0003u\u0019v*\u0016*D\u000bN{\u0016\t\u0014'P/~{e*R0U\u00136+u,U+F%f\u0003\u0003")
public final class DataStreamWriter<T>
extends org.apache.spark.sql.streaming.DataStreamWriter<T> {
    private final org.apache.spark.sql.classic.Dataset<T> ds;
    private String source;
    private OutputMode outputMode;
    private Trigger trigger;
    private CaseInsensitiveMap<String> extraOptions;
    private ForeachWriter<Object> foreachWriter;
    private ExpressionEncoder<Object> foreachWriterEncoder;
    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> clusteringColumns;

    public static Seq<String> SOURCES_ALLOW_ONE_TIME_QUERY() {
        return DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY();
    }

    public static String SOURCE_NAME_NOOP() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_NOOP();
    }

    public static String SOURCE_NAME_TABLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_TABLE();
    }

    public static String SOURCE_NAME_CONSOLE() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_CONSOLE();
    }

    public static String SOURCE_NAME_FOREACH_BATCH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
    }

    public static String SOURCE_NAME_FOREACH() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
    }

    public static String SOURCE_NAME_MEMORY() {
        return DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
    }

    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataStreamWriter<T> clusterBy(String ... colNames) {
        return this.clusterBy((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.outputMode_$eq(outputMode);
        return this;
    }

    public DataStreamWriter<T> outputMode(String outputMode) {
        this.outputMode_$eq(InternalOutputModes$.MODULE$.apply(outputMode));
        return this;
    }

    public DataStreamWriter<T> trigger(Trigger trigger) {
        this.trigger_$eq(trigger);
        return this;
    }

    public DataStreamWriter<T> queryName(String queryName) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queryName"), (Object)queryName)));
        return this;
    }

    public DataStreamWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        this.validatePartitioningAndClustering();
        return this;
    }

    public DataStreamWriter<T> clusterBy(Seq<String> colNames) {
        this.clusteringColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        this.validatePartitioningAndClustering();
        return this;
    }

    public DataStreamWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(options).asScala());
        return this;
    }

    public StreamingQuery start(String path) {
        if (!this.ds.sparkSession().sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("start");
        }
        return this.startInternal((Option<String>)new Some((Object)path), this.startInternal$default$2());
    }

    public StreamingQuery start() throws TimeoutException {
        return this.startInternal((Option<String>)None$.MODULE$, this.startInternal$default$2());
    }

    @Evolving
    public StreamingQuery toTable(String tableName) throws TimeoutException {
        SupportsWrite supportsWrite;
        Table tableInstance;
        Option option;
        ParserInterface parser = this.ds.sparkSession().sessionState().sqlParser();
        Seq originalMultipartIdentifier = parser.parseMultipartIdentifier(tableName);
        Seq seq = originalMultipartIdentifier;
        if (seq == null || (option = this.ds.sparkSession().sessionState().analyzer().CatalogAndIdentifier().unapply(seq)).isEmpty()) {
            throw new MatchError((Object)seq);
        }
        CatalogPlugin catalog = (CatalogPlugin)((Tuple2)option.get())._1();
        Identifier identifier = (Identifier)((Tuple2)option.get())._2();
        Tuple2 tuple2 = new Tuple2((Object)catalog, (Object)identifier);
        CatalogPlugin catalog2 = (CatalogPlugin)tuple2._1();
        Identifier identifier2 = (Identifier)tuple2._2();
        if (this.ds.sparkSession().sessionState().catalog().isTempView(originalMultipartIdentifier)) {
            throw QueryCompilationErrors$.MODULE$.tempViewNotSupportStreamingWriteError(tableName);
        }
        if (!CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().tableExists(identifier2)) {
            scala.collection.immutable.Map properties = (scala.collection.immutable.Map)this.normalizedClusteringCols().map((Function1 & Serializable)cols -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)cols))}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
            ArraySeq partitioningOrClusteringTransform = (ArraySeq)this.normalizedClusteringCols().map((Function1 & Serializable)colNames -> ArrayImplicits$.MODULE$.SparkArrayOps((Object)new ClusterByTransform[]{new ClusterByTransform((Seq)colNames.map((Function1 & Serializable)col -> FieldReference$.MODULE$.apply(col)))}).toImmutableArraySeq()).getOrElse((Function0 & Serializable)() -> ArrayImplicits$.MODULE$.SparkArrayOps((Object)CatalogV2Implicits$.MODULE$.PartitionTypeHelper((Seq)this.partitioningColumns().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).asTransforms()).toImmutableArraySeq());
            UnresolvedTableSpec tableSpec = new UnresolvedTableSpec(properties, (Option)new Some((Object)this.source()), new OptionList((Seq)package$.MODULE$.Seq().empty()), this.extraOptions().get("path"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
            CreateTable cmd = new CreateTable((LogicalPlan)new UnresolvedIdentifier(originalMultipartIdentifier, UnresolvedIdentifier$.MODULE$.apply$default$2()), (Seq)this.ds.schema().asNullable().map((Function1 & Serializable)x$2 -> ColumnDefinition$.MODULE$.fromV1Column(x$2, parser)), (Seq)partitioningOrClusteringTransform, (TableSpecBase)tableSpec, false);
            v0 = Dataset$.MODULE$.ofRows(this.ds.sparkSession(), (LogicalPlan)cmd);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        Table table = tableInstance = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog().loadTable(identifier2);
        if (table instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table)).supports(TableCapability.STREAMING_WRITE)) {
            SupportsWrite x$1 = supportsWrite;
            CaseInsensitiveMap<String> x$22 = this.extraOptions();
            Some x$3 = new Some((Object)new Tuple2((Object)CatalogV2Implicits$.MODULE$.CatalogHelper(catalog2).asTableCatalog(), (Object)identifier2));
            boolean x$4 = this.startQuery$default$3();
            Option<CatalogTable> x$5 = this.startQuery$default$5();
            return this.startQuery((Table)x$1, x$22, x$4, (Option<Tuple2<TableCatalog, Identifier>>)x$3, x$5);
        }
        if (table instanceof V2TableWithV1Fallback) {
            V2TableWithV1Fallback v2TableWithV1Fallback = (V2TableWithV1Fallback)table;
            return this.writeToV1Table$1(v2TableWithV1Fallback.v1Table(), tableName);
        }
        if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            return this.writeToV1Table$1(v1Table.v1Table(), tableName);
        }
        throw QueryCompilationErrors$.MODULE$.tableNotSupportStreamingWriteError(tableName, table);
    }

    private StreamingQuery startInternal(Option<String> path, Option<CatalogTable> catalogTable) {
        Sink sink;
        Sink sink2;
        CaseInsensitiveMap optionsWithPath;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw QueryCompilationErrors$.MODULE$.cannotOperateOnHiveDataSourceFilesError("write");
        }
        String string3 = this.source();
        String string4 = DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_MEMORY());
            if (this.extraOptions().get("queryName").isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.queryNameNotSpecifiedForMemorySinkError();
            }
            MemorySink sink3 = new MemorySink();
            org.apache.spark.sql.classic.Dataset<Row> resultDf = Dataset$.MODULE$.ofRows(this.ds.sparkSession(), new MemoryPlan(sink3, (Seq<Attribute>)DataTypeUtils$.MODULE$.toAttributes(this.ds.schema())));
            OutputMode outputMode = this.outputMode();
            OutputMode outputMode2 = OutputMode.Complete();
            boolean recoverFromCheckpoint = !(outputMode != null ? !outputMode.equals(outputMode2) : outputMode2 != null);
            MemorySink x$1 = sink3;
            CaseInsensitiveMap<String> x$2 = this.extraOptions();
            boolean x$3 = recoverFromCheckpoint;
            Option<CatalogTable> x$4 = catalogTable;
            Option<Tuple2<TableCatalog, Identifier>> x$5 = this.startQuery$default$4();
            StreamingQuery query = this.startQuery(x$1, x$2, x$3, x$5, x$4);
            resultDf.createOrReplaceTempView(query.name());
            return query;
        }
        String string5 = this.source();
        String string6 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH();
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            ForeachWriterTable<?> sink4;
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
            ForeachWriterTable<?> x$6 = sink4 = ForeachWriterTable$.MODULE$.apply(this.foreachWriter(), this.foreachWriterEncoder());
            CaseInsensitiveMap<String> x$7 = this.extraOptions();
            Option<CatalogTable> x$8 = catalogTable;
            boolean x$9 = this.startQuery$default$3();
            Option<Tuple2<TableCatalog, Identifier>> x$10 = this.startQuery$default$4();
            return this.startQuery(x$6, x$7, x$9, x$10, x$8);
        }
        String string7 = this.source();
        String string8 = DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH();
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            ForeachBatchSink<T> sink5;
            this.assertNotPartitioned(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
            if (this.trigger() instanceof ContinuousTrigger) {
                throw QueryCompilationErrors$.MODULE$.sourceNotSupportedWithContinuousTriggerError(this.source());
            }
            ForeachBatchSink<T> x$11 = sink5 = new ForeachBatchSink<T>(this.foreachBatchWriter(), this.ds.exprEnc());
            CaseInsensitiveMap<String> x$12 = this.extraOptions();
            Option<CatalogTable> x$13 = catalogTable;
            boolean x$14 = this.startQuery$default$3();
            Option<Tuple2<TableCatalog, Identifier>> x$15 = this.startQuery$default$4();
            return this.startQuery(x$11, x$12, x$14, x$15, x$13);
        }
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.ds.sparkSession().sessionState().conf());
        Seq disabledSources = Utils$.MODULE$.stringToSeq(this.ds.sparkSession().sessionState().conf().disabledV2StreamingWriters());
        boolean useV1Source = disabledSources.contains((Object)cls.getCanonicalName()) || FileDataSourceV2.class.isAssignableFrom(cls);
        CaseInsensitiveMap caseInsensitiveMap = optionsWithPath = path.isEmpty() ? this.extraOptions() : this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), path.get()));
        if (TableProvider.class.isAssignableFrom(cls) && !useV1Source) {
            SupportsWrite supportsWrite;
            Table table;
            TableProvider provider = (TableProvider)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.ds.sparkSession().sessionState().conf());
            scala.collection.immutable.Map finalOptions = (scala.collection.immutable.Map)((MapOps)sessionOptions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$startInternal$1(optionsWithPath, x0$1)))).$plus$plus((IterableOnce)optionsWithPath.originalMap());
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)finalOptions).asJava());
            None$ outputSchema = provider.supportsExternalMetadata() ? new Some((Object)this.ds.schema()) : None$.MODULE$;
            TableProvider tableProvider = provider;
            if (tableProvider instanceof PythonDataSourceV2) {
                PythonDataSourceV2 pythonDataSourceV2 = (PythonDataSourceV2)tableProvider;
                pythonDataSourceV2.setShortName(this.source());
            }
            Table table2 = table = DataSourceV2Utils$.MODULE$.getTableFromProvider(provider, dsOptions, (Option<StructType>)outputSchema);
            sink2 = table2 instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table2)).supports(TableCapability.STREAMING_WRITE) ? supportsWrite : this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
        } else {
            sink2 = this.createV1Sink((CaseInsensitiveMap<String>)optionsWithPath);
        }
        Sink x$16 = sink = sink2;
        CaseInsensitiveMap x$17 = optionsWithPath;
        Option<CatalogTable> x$18 = catalogTable;
        boolean x$19 = this.startQuery$default$3();
        Option<Tuple2<TableCatalog, Identifier>> x$20 = this.startQuery$default$4();
        return this.startQuery(x$16, (CaseInsensitiveMap<String>)x$17, x$19, x$20, x$18);
    }

    private Option<CatalogTable> startInternal$default$2() {
        return None$.MODULE$;
    }

    private StreamingQuery startQuery(Table sink, CaseInsensitiveMap<String> newOptions, boolean recoverFromCheckpoint, Option<Tuple2<TableCatalog, Identifier>> catalogAndIdent, Option<CatalogTable> catalogTable) {
        boolean useTempCheckpointLocation = DataStreamWriter$.MODULE$.SOURCES_ALLOW_ONE_TIME_QUERY().contains((Object)this.source());
        Option x$1 = newOptions.get("queryName");
        Option x$2 = newOptions.get("checkpointLocation");
        org.apache.spark.sql.classic.Dataset<T> x$3 = this.ds;
        scala.collection.immutable.Map x$4 = newOptions.originalMap();
        Table x$5 = sink;
        OutputMode x$6 = this.outputMode();
        boolean x$7 = useTempCheckpointLocation;
        boolean x$8 = recoverFromCheckpoint;
        Trigger x$9 = this.trigger();
        Option<Tuple2<TableCatalog, Identifier>> x$10 = catalogAndIdent;
        Option<CatalogTable> x$11 = catalogTable;
        Clock x$12 = this.ds.sparkSession().sessionState().streamingQueryManager().startQuery$default$10();
        return this.ds.sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)x$1, (Option<String>)x$2, x$3, (scala.collection.immutable.Map<String, String>)x$4, x$5, x$6, x$7, x$8, x$9, x$12, x$10, x$11);
    }

    private boolean startQuery$default$3() {
        return true;
    }

    private Option<Tuple2<TableCatalog, Identifier>> startQuery$default$4() {
        return None$.MODULE$;
    }

    private Option<CatalogTable> startQuery$default$5() {
        return None$.MODULE$;
    }

    private Sink createV1Sink(CaseInsensitiveMap<String> optionsWithPath) {
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map optionsWithoutClusteringKey = (scala.collection.immutable.Map)optionsWithPath.originalMap().$minus((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY());
        Option<Seq<String>> option = this.normalizedClusteringCols();
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq cols = (Seq)some.value();
            map = (scala.collection.immutable.Map)optionsWithoutClusteringKey.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.CLUSTERING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)cols)));
        } else if (None$.MODULE$.equals(option)) {
            map = optionsWithoutClusteringKey;
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map optionsWithClusteringColumns = map;
        SparkSession x$1 = this.ds.sparkSession();
        String x$2 = this.source();
        scala.collection.immutable.Map x$3 = optionsWithClusteringColumns;
        Seq x$4 = (Seq)this.normalizedParCols().getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource ds = new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$4, x$7, (scala.collection.immutable.Map<String, String>)x$3, x$8);
        return ds.createSink(this.outputMode());
    }

    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        return this.foreachImplementation(writer, this.foreachImplementation$default$2());
    }

    public DataStreamWriter<T> foreachImplementation(ForeachWriter<Object> writer, Option<ExpressionEncoder<Object>> encoder) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH());
        if (writer == null) {
            throw new IllegalArgumentException("foreach writer cannot be null");
        }
        this.foreachWriter_$eq((ForeachWriter<Object>)((ForeachWriter)this.ds.sparkSession().sparkContext().clean(writer, this.ds.sparkSession().sparkContext().clean$default$2())));
        encoder.foreach((Function1 & Serializable)e -> {
            this.foreachWriterEncoder_$eq((ExpressionEncoder<Object>)e);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public Option<ExpressionEncoder<Object>> foreachImplementation$default$2() {
        return None$.MODULE$;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(Function2<Dataset<T>, Object, BoxedUnit> function) {
        this.source_$eq(DataStreamWriter$.MODULE$.SOURCE_NAME_FOREACH_BATCH());
        if (function == null) {
            throw new IllegalArgumentException("foreachBatch function cannot be null");
        }
        this.foreachBatchWriter_$eq(function);
        return this;
    }

    private Option<Seq<String>> normalizedParCols() {
        return this.partitioningColumns().map((Function1 & Serializable)cols -> (Seq)cols.map((Function1 & Serializable)x$3 -> this.normalize((String)x$3, "Partition")));
    }

    private Option<Seq<String>> normalizedClusteringCols() {
        return this.clusteringColumns().map((Function1 & Serializable)cols -> (Seq)cols.map((Function1 & Serializable)x$4 -> this.normalize((String)x$4, "Clustering")));
    }

    private String normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.ds.logicalPlan().output().map((Function1 & Serializable)x$5 -> x$5.name());
        return (String)validColumnNames.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DataStreamWriter.$anonfun$normalize$2(this, columnName, x$6))).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnNotFoundInExistingColumnsError(columnType, columnName, validColumnNames);
        });
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.operationNotSupportPartitioningError(operation);
        }
    }

    private void validatePartitioningAndClustering() {
        if (this.clusteringColumns().nonEmpty() && this.partitioningColumns().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.clusterByWithPartitionedBy();
        }
    }

    public DataStreamWriter<T> option(String key, boolean value) {
        return (DataStreamWriter)super.option(key, value);
    }

    public DataStreamWriter<T> option(String key, long value) {
        return (DataStreamWriter)super.option(key, value);
    }

    public DataStreamWriter<T> option(String key, double value) {
        return (DataStreamWriter)super.option(key, value);
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(VoidFunction2<Dataset<T>, Long> function) {
        return (DataStreamWriter)super.foreachBatch(function);
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private OutputMode outputMode() {
        return this.outputMode;
    }

    private void outputMode_$eq(OutputMode x$1) {
        this.outputMode = x$1;
    }

    private Trigger trigger() {
        return this.trigger;
    }

    private void trigger_$eq(Trigger x$1) {
        this.trigger = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private ForeachWriter<Object> foreachWriter() {
        return this.foreachWriter;
    }

    private void foreachWriter_$eq(ForeachWriter<Object> x$1) {
        this.foreachWriter = x$1;
    }

    private ExpressionEncoder<Object> foreachWriterEncoder() {
        return this.foreachWriterEncoder;
    }

    private void foreachWriterEncoder_$eq(ExpressionEncoder<Object> x$1) {
        this.foreachWriterEncoder = x$1;
    }

    private Function2<Dataset<T>, Object, BoxedUnit> foreachBatchWriter() {
        return this.foreachBatchWriter;
    }

    private void foreachBatchWriter_$eq(Function2<Dataset<T>, Object, BoxedUnit> x$1) {
        this.foreachBatchWriter = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> clusteringColumns() {
        return this.clusteringColumns;
    }

    private void clusteringColumns_$eq(Option<Seq<String>> x$1) {
        this.clusteringColumns = x$1;
    }

    private final StreamingQuery writeToV1Table$1(CatalogTable table, String tableName$1) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.streamingIntoViewNotSupportedError(tableName$1);
        }
        Predef$.MODULE$.require(table.provider().isDefined());
        String string = this.source();
        Object object = table.provider().get();
        if (string == null ? object != null : !string.equals(object)) {
            throw QueryCompilationErrors$.MODULE$.inputSourceDiffersFromDataSourceProviderError(this.source(), tableName$1, table);
        }
        return super.startInternal((Option<String>)new Some((Object)new Path(table.location()).toString()), (Option<CatalogTable>)new Some((Object)table));
    }

    public static final /* synthetic */ boolean $anonfun$startInternal$1(CaseInsensitiveMap optionsWithPath$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !optionsWithPath$1.contains(k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$normalize$2(DataStreamWriter $this, String columnName$1, String x$6) {
        return BoxesRunTime.unboxToBoolean((Object)$this.ds.sparkSession().sessionState().analyzer().resolver().apply((Object)x$6, (Object)columnName$1));
    }

    public DataStreamWriter(org.apache.spark.sql.classic.Dataset<T> ds) {
        this.ds = ds;
        this.source = ds.sparkSession().sessionState().conf().defaultDataSourceName();
        this.outputMode = OutputMode.Append();
        this.trigger = Trigger.ProcessingTime((long)0L);
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.foreachWriterEncoder = ds.exprEnc();
        this.partitioningColumns = None$.MODULE$;
        this.clusteringColumns = None$.MODULE$;
    }
}

