/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.avro.AvroDeserializer;
import org.apache.spark.sql.avro.AvroOptions;
import org.apache.spark.sql.avro.AvroOptions$;
import org.apache.spark.sql.avro.AvroSerializer;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.execution.streaming.StateStoreColumnFamilySchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.AvroEncoder;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RangeKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RocksDBDataEncoder;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaIdRow;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadataKey;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadataValue;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.Platform;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001\u0002\u0017.\u0001qB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u001dy\u0007A1A\u0005\nADa\u0001\u001e\u0001!\u0002\u0013\t\b\u0002C;\u0001\u0011\u000b\u0007I\u0011\u0002<\t\u0011i\u0004\u0001R1A\u0005\nYD\u0001b\u001f\u0001\t\u0006\u0004%I\u0001 \u0005\u000b\u0003\u000f\u0001\u0001R1A\u0005\n\u0005%\u0001\"CA\u000e\u0001!\u0015\r\u0011\"\u0003}\u0011)\ti\u0002\u0001EC\u0002\u0013%\u0011\u0011\u0002\u0005\u000b\u0003?\u0001\u0001R1A\u0005\n\u0005\u0005\u0002\"CA\u0012\u0001!\u0015\r\u0011\"\u0003}\u0011)\t)\u0003\u0001EC\u0002\u0013%\u0011\u0011\u0002\u0005\u000b\u0003O\u0001\u0001R1A\u0005\n\u0005%\u0002BCA'\u0001!\u0015\r\u0011\"\u0003\u0002\"!I\u0011q\n\u0001\t\u0006\u0004%I\u0001 \u0005\u000b\u0003#\u0002\u0001R1A\u0005\n\u0005%\u0001BCA*\u0001!\u0015\r\u0011\"\u0003\u0002\"!I\u0011Q\u000b\u0001\t\u0006\u0004%I\u0001 \u0005\u000b\u0003/\u0002\u0001R1A\u0005\n\u0005%\u0001bBA-\u0001\u0011%\u00111\f\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!a \u0001\t\u0003\n\t\tC\u0004\u0002\n\u0002!I!a#\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"A\u0011\u0011\u0019\u0001\u0005\u0002M\n\u0019\r\u0003\u0005\u0002J\u0002!\taMAf\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!!5\u0001\t\u0003\t\t\u000fC\u0005\u00020\u0002\u0011\r\u0011\"\u0003\u0002r\"A\u00111\u001f\u0001!\u0002\u0013\t\t\fC\u0004\u0002v\u0002!\t%a>\t\u000f\u0005m\b\u0001\"\u0011\u0002~\"9!\u0011\u0001\u0001\u0005B\t\r\u0001b\u0002B\u0004\u0001\u0011\u0005#\u0011\u0002\u0005\b\u0005\u001b\u0001A\u0011\tB\b\u0011\u001d\u0011)\u0002\u0001C!\u0005/AqAa\u0007\u0001\t\u0003\u0012i\u0002C\u0004\u0003\"\u0001!\tEa\t\u0003!\u00053(o\\*uCR,WI\\2pI\u0016\u0014(B\u0001\u00180\u0003\u0015\u0019H/\u0019;f\u0015\t\u0001\u0014'A\u0005tiJ,\u0017-\\5oO*\u0011!gM\u0001\nKb,7-\u001e;j_:T!\u0001N\u001b\u0002\u0007M\fHN\u0003\u00027o\u0005)1\u000f]1sW*\u0011\u0001(O\u0001\u0007CB\f7\r[3\u000b\u0003i\n1a\u001c:h\u0007\u0001\u00192\u0001A\u001fB!\tqt(D\u0001.\u0013\t\u0001UF\u0001\nS_\u000e\\7\u000f\u0012\"ECR\fWI\\2pI\u0016\u0014\bC\u0001\"F\u001b\u0005\u0019%B\u0001#6\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001$D\u0005\u001daunZ4j]\u001e\f1c[3z'R\fG/Z#oG>$WM]*qK\u000e\u0004\"AP%\n\u0005)k#aE&fsN#\u0018\r^3F]\u000e|G-\u001a:Ta\u0016\u001c\u0017a\u0003<bYV,7k\u00195f[\u0006\u0004\"!\u0014)\u000e\u00039S!aT\u001a\u0002\u000bQL\b/Z:\n\u0005Es%AC*ueV\u001cG\u000fV=qK\u0006\u00192\u000f^1uKN\u001b\u0007.Z7b!J|g/\u001b3feB\u0019AkV-\u000e\u0003US\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u0013aa\u00149uS>t\u0007C\u0001 [\u0013\tYVFA\nTi\u0006$XmU2iK6\f\u0007K]8wS\u0012,'/\u0001\td_2,XN\u001c$b[&d\u0017PT1nKB\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001Y+\u000e\u0003\u0005T!AY\u001e\u0002\rq\u0012xn\u001c;?\u0013\t!W+\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u00013V\u0003\u0019a\u0014N\\5u}Q)!n\u001b7n]B\u0011a\b\u0001\u0005\u0006\u000f\u0016\u0001\r\u0001\u0013\u0005\u0006\u0017\u0016\u0001\r\u0001\u0014\u0005\u0006%\u0016\u0001\ra\u0015\u0005\u00069\u0016\u0001\r!X\u0001\fCZ\u0014x.\u00128d_\u0012,'/F\u0001r!\tq$/\u0003\u0002t[\tY\u0011I\u001e:p\u000b:\u001cw\u000eZ3s\u00031\tgO]8F]\u000e|G-\u001a:!\u0003I\u0019WO\u001d:f]R\\U-_*dQ\u0016l\u0017-\u00133\u0016\u0003]\u0004\"\u0001\u0016=\n\u0005e,&!B*i_J$\u0018AE2veJ,g\u000e\u001e,bYN\u001b\u0007.Z7b\u0013\u0012\f1b[3z\u0003Z\u0014x\u000eV=qKV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u00039\u0014\u0001B1we>L1!!\u0002\u0000\u0005\u0019\u00196\r[3nC\u000691.Z=Qe>TWCAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t1\"\u001a=qe\u0016\u001c8/[8og*\u0019\u0011QC\u001a\u0002\u0011\r\fG/\u00197zgRLA!!\u0007\u0002\u0010\t\u0001RK\\:bM\u0016\u0004&o\u001c6fGRLwN\\\u0001\u000em\u0006dW/Z!we>$\u0016\u0010]3\u0002\u0013Y\fG.^3Qe>T\u0017a\u00049sK\u001aL\u0007pS3z'\u000eDW-\\1\u0016\u00031\u000b\u0011\u0003\u001d:fM&D8*Z=BmJ|G+\u001f9f\u00035\u0001(/\u001a4jq.+\u0017\u0010\u0015:pU\u0006i\"/\u00198hKN\u001b\u0017M\\&fs\u001aKW\r\u001c3t/&$\bn\u0014:eS:\fG.\u0006\u0002\u0002,A1\u0011QFA\u001c\u0003wi!!a\f\u000b\t\u0005E\u00121G\u0001\nS6lW\u000f^1cY\u0016T1!!\u000eV\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\tyCA\u0002TKF\u0004r\u0001VA\u001f\u0003\u0003\n9%C\u0002\u0002@U\u0013a\u0001V;qY\u0016\u0014\u0004cA'\u0002D%\u0019\u0011Q\t(\u0003\u0017M#(/^2u\r&,G\u000e\u001a\t\u0004)\u0006%\u0013bAA&+\n\u0019\u0011J\u001c;\u0002'I\fgnZ3TG\u0006t\u0017I\u001e:p'\u000eDW-\\1\u0002#I\fgnZ3TG\u0006t\u0017I\u001e:p)f\u0004X-A\fsC:<WmU2b]\u00063(o\u001c)s_*,7\r^5p]\u0006\u0011\"/Z7bS:LgnZ&fsN\u001b\u0007.Z7b\u0003Q\u0011X-\\1j]&twmS3z\u0003Z\u0014x\u000eV=qK\u0006Q\"/Z7bS:LgnZ&fs\u00063(o\u001c)s_*,7\r^5p]\u0006\tr-\u001a;BmJ|7+\u001a:jC2L'0\u001a:\u0015\t\u0005u\u0013q\r\t\u0005\u0003?\n\u0019'\u0004\u0002\u0002b)\u0019\u0011\u0011A\u001a\n\t\u0005\u0015\u0014\u0011\r\u0002\u000f\u0003Z\u0014xnU3sS\u0006d\u0017N_3s\u0011\u0019\tI\u0007\u0007a\u0001\u0019\u000611o\u00195f[\u0006\f1cZ3u\u0003Z\u0014x\u000eR3tKJL\u0017\r\\5{KJ$B!a\u001c\u0002vA!\u0011qLA9\u0013\u0011\t\u0019(!\u0019\u0003!\u00053(o\u001c#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bBBA53\u0001\u0007A*A\u0007de\u0016\fG/Z!we>,en\u0019\u000b\u0006c\u0006m\u0014Q\u0010\u0005\u0006\u000fj\u0001\r\u0001\u0013\u0005\u0006\u0017j\u0001\r\u0001T\u0001\u0018gV\u0004\bo\u001c:ugN\u001b\u0007.Z7b\u000bZ|G.\u001e;j_:,\"!a!\u0011\u0007Q\u000b))C\u0002\u0002\bV\u0013qAQ8pY\u0016\fg.\u0001\fhKR\u001cF/\u0019;f'\u000eDW-\\1Qe>4\u0018\u000eZ3s+\u0005I\u0016!F3oG>$W-\u00168tC\u001a,'k\\<U_\u00063(o\u001c\u000b\u000b\u0003#\u000bi*a*\u0002,\u00065\u0006#\u0002+\u0002\u0014\u0006]\u0015bAAK+\n)\u0011I\u001d:bsB\u0019A+!'\n\u0007\u0005mUK\u0001\u0003CsR,\u0007bBAP;\u0001\u0007\u0011\u0011U\u0001\u0004e><\b\u0003BA\u0007\u0003GKA!!*\u0002\u0010\tIQK\\:bM\u0016\u0014vn\u001e\u0005\b\u0003Sk\u0002\u0019AA/\u00039\tgO]8TKJL\u0017\r\\5{KJDa!a\u0007\u001e\u0001\u0004i\bbBAX;\u0001\u0007\u0011\u0011W\u0001\u0004_V$\b\u0003BAZ\u0003{k!!!.\u000b\t\u0005]\u0016\u0011X\u0001\u0003S>T!!a/\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\u000b)LA\u000bCsR,\u0017I\u001d:bs>+H\u000f];u'R\u0014X-Y7\u0002%A\u0014X\r]3oIZ+'o]5p]\nKH/\u001a\u000b\u0005\u0003#\u000b)\rC\u0004\u0002Hz\u0001\r!!%\u0002\u001b\tLH/Z:U_\u0016s7m\u001c3f\u0003E\u0011X-\\8wKZ+'o]5p]\nKH/\u001a\u000b\u0005\u0003#\u000bi\rC\u0004\u0002P~\u0001\r!!%\u0002\u000b\tLH/Z:\u00023\u0011,7m\u001c3f\rJ|W.\u0011<s_R{WK\\:bM\u0016\u0014vn\u001e\u000b\u000b\u0003C\u000b).!7\u0002^\u0006}\u0007bBAlA\u0001\u0007\u0011\u0011S\u0001\u000bm\u0006dW/\u001a\"zi\u0016\u001c\bbBAnA\u0001\u0007\u0011qN\u0001\u0011CZ\u0014x\u000eR3tKJL\u0017\r\\5{KJDa!a\u0007!\u0001\u0004i\bbBA\u000fA\u0001\u0007\u00111\u0002\u000b\r\u0003C\u000b\u0019/!:\u0002h\u0006-\u0018q\u001e\u0005\b\u0003/\f\u0003\u0019AAI\u0011\u001d\tY.\ta\u0001\u0003_Ba!!;\"\u0001\u0004i\u0018\u0001D<sSR,'oU2iK6\f\u0007BBAwC\u0001\u0007Q0\u0001\u0007sK\u0006$WM]*dQ\u0016l\u0017\rC\u0004\u0002\u001e\u0005\u0002\r!a\u0003\u0016\u0005\u0005E\u0016\u0001B8vi\u0002\n\u0011\"\u001a8d_\u0012,7*Z=\u0015\t\u0005E\u0015\u0011 \u0005\b\u0003?#\u0003\u0019AAQ\u0003I)gnY8eKJ+W.Y5oS:<7*Z=\u0015\t\u0005E\u0015q \u0005\b\u0003?+\u0003\u0019AAQ\u0003m)gnY8eKB\u0013XMZ5y\u0017\u0016Lhi\u001c:SC:<WmU2b]R!\u0011\u0011\u0013B\u0003\u0011\u001d\tyJ\na\u0001\u0003C\u000b1\"\u001a8d_\u0012,g+\u00197vKR!\u0011\u0011\u0013B\u0006\u0011\u001d\tyj\na\u0001\u0003C\u000b\u0011\u0002Z3d_\u0012,7*Z=\u0015\t\u0005\u0005&\u0011\u0003\u0005\b\u0005'A\u0003\u0019AAI\u0003!\u0011xn\u001e\"zi\u0016\u001c\u0018A\u00053fG>$WMU3nC&t\u0017N\\4LKf$B!!)\u0003\u001a!9!1C\u0015A\u0002\u0005E\u0015a\u00073fG>$W\r\u0015:fM&D8*Z=G_J\u0014\u0016M\\4f'\u000e\fg\u000e\u0006\u0003\u0002\"\n}\u0001b\u0002B\nU\u0001\u0007\u0011\u0011S\u0001\fI\u0016\u001cw\u000eZ3WC2,X\r\u0006\u0003\u0002\"\n\u0015\u0002b\u0002B\nW\u0001\u0007\u0011\u0011\u0013")
public class AvroStateEncoder
extends RocksDBDataEncoder
implements Logging {
    private short currentKeySchemaId;
    private short currentValSchemaId;
    private Schema keyAvroType;
    private UnsafeProjection keyProj;
    private Schema valueAvroType;
    private UnsafeProjection valueProj;
    private StructType prefixKeySchema;
    private Schema prefixKeyAvroType;
    private UnsafeProjection prefixKeyProj;
    private Seq<Tuple2<StructField, Object>> rangeScanKeyFieldsWithOrdinal;
    private StructType rangeScanAvroSchema;
    private Schema rangeScanAvroType;
    private UnsafeProjection rangeScanAvroProjection;
    private StructType remainingKeySchema;
    private Schema remainingKeyAvroType;
    private UnsafeProjection remainingKeyAvroProjection;
    private final KeyStateEncoderSpec keyStateEncoderSpec;
    private final StructType valueSchema;
    private final Option<StateSchemaProvider> stateSchemaProvider;
    private final String columnFamilyName;
    private final AvroEncoder avroEncoder;
    private final ByteArrayOutputStream out;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private AvroEncoder avroEncoder() {
        return this.avroEncoder;
    }

    private short currentKeySchemaId$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 1) == 0) {
                this.currentKeySchemaId = this.getStateSchemaProvider().getCurrentStateSchemaId(this.columnFamilyName, true);
                this.bitmap$0 |= 1;
            }
        }
        return this.currentKeySchemaId;
    }

    private short currentKeySchemaId() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.currentKeySchemaId$lzycompute();
        }
        return this.currentKeySchemaId;
    }

    private short currentValSchemaId$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 2) == 0) {
                this.currentValSchemaId = this.getStateSchemaProvider().getCurrentStateSchemaId(this.columnFamilyName, false);
                this.bitmap$0 |= 2;
            }
        }
        return this.currentValSchemaId;
    }

    private short currentValSchemaId() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.currentValSchemaId$lzycompute();
        }
        return this.currentValSchemaId;
    }

    private Schema keyAvroType$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 4) == 0) {
                this.keyAvroType = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(this.keySchema());
                this.bitmap$0 |= 4;
            }
        }
        return this.keyAvroType;
    }

    private Schema keyAvroType() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.keyAvroType$lzycompute();
        }
        return this.keyAvroType;
    }

    private UnsafeProjection keyProj$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 8) == 0) {
                this.keyProj = UnsafeProjection$.MODULE$.create(this.keySchema());
                this.bitmap$0 |= 8;
            }
        }
        return this.keyProj;
    }

    private UnsafeProjection keyProj() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.keyProj$lzycompute();
        }
        return this.keyProj;
    }

    private Schema valueAvroType$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.valueAvroType = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(this.valueSchema);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.valueAvroType;
    }

    private Schema valueAvroType() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.valueAvroType$lzycompute();
        }
        return this.valueAvroType;
    }

    private UnsafeProjection valueProj$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.valueProj = UnsafeProjection$.MODULE$.create(this.valueSchema);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.valueProj;
    }

    private UnsafeProjection valueProj() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.valueProj$lzycompute();
        }
        return this.valueProj;
    }

    private StructType prefixKeySchema$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x40) == 0) {
                KeyStateEncoderSpec keyStateEncoderSpec = this.keyStateEncoderSpec;
                if (!(keyStateEncoderSpec instanceof PrefixKeyScanStateEncoderSpec)) {
                    throw this.unsupportedOperationForKeyStateEncoder("prefixKeySchema");
                }
                PrefixKeyScanStateEncoderSpec prefixKeyScanStateEncoderSpec = (PrefixKeyScanStateEncoderSpec)keyStateEncoderSpec;
                StructType keySchema = prefixKeyScanStateEncoderSpec.keySchema();
                int numColsPrefixKey = prefixKeyScanStateEncoderSpec.numColsPrefixKey();
                this.prefixKeySchema = StructType$.MODULE$.apply((Seq)keySchema.take(numColsPrefixKey));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.prefixKeySchema;
    }

    private StructType prefixKeySchema() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.prefixKeySchema$lzycompute();
        }
        return this.prefixKeySchema;
    }

    private Schema prefixKeyAvroType$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.prefixKeyAvroType = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(this.prefixKeySchema());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.prefixKeyAvroType;
    }

    private Schema prefixKeyAvroType() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.prefixKeyAvroType$lzycompute();
        }
        return this.prefixKeyAvroType;
    }

    private UnsafeProjection prefixKeyProj$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.prefixKeyProj = UnsafeProjection$.MODULE$.create(this.prefixKeySchema());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.prefixKeyProj;
    }

    private UnsafeProjection prefixKeyProj() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.prefixKeyProj$lzycompute();
        }
        return this.prefixKeyProj;
    }

    private Seq<Tuple2<StructField, Object>> rangeScanKeyFieldsWithOrdinal$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x200) == 0) {
                KeyStateEncoderSpec keyStateEncoderSpec = this.keyStateEncoderSpec;
                if (!(keyStateEncoderSpec instanceof RangeKeyScanStateEncoderSpec)) {
                    throw this.unsupportedOperationForKeyStateEncoder("rangeScanKey");
                }
                RangeKeyScanStateEncoderSpec rangeKeyScanStateEncoderSpec = (RangeKeyScanStateEncoderSpec)keyStateEncoderSpec;
                StructType keySchema = rangeKeyScanStateEncoderSpec.keySchema();
                Seq<Object> orderingOrdinals = rangeKeyScanStateEncoderSpec.orderingOrdinals();
                this.rangeScanKeyFieldsWithOrdinal = (Seq)orderingOrdinals.map((Function1 & Serializable)ordinal -> AvroStateEncoder.$anonfun$rangeScanKeyFieldsWithOrdinal$1(keySchema, BoxesRunTime.unboxToInt((Object)ordinal)));
                this.bitmap$0 |= 0x200;
            }
        }
        return this.rangeScanKeyFieldsWithOrdinal;
    }

    private Seq<Tuple2<StructField, Object>> rangeScanKeyFieldsWithOrdinal() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.rangeScanKeyFieldsWithOrdinal$lzycompute();
        }
        return this.rangeScanKeyFieldsWithOrdinal;
    }

    private StructType rangeScanAvroSchema$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.rangeScanAvroSchema = StateStoreColumnFamilySchemaUtils$.MODULE$.convertForRangeScan(new StructType((StructField[])((IterableOnceOps)this.rangeScanKeyFieldsWithOrdinal().map((Function1 & Serializable)x$4 -> (StructField)x$4._1())).toArray(ClassTag$.MODULE$.apply(StructField.class))), StateStoreColumnFamilySchemaUtils$.MODULE$.convertForRangeScan$default$2());
                this.bitmap$0 |= 0x400;
            }
        }
        return this.rangeScanAvroSchema;
    }

    private StructType rangeScanAvroSchema() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.rangeScanAvroSchema$lzycompute();
        }
        return this.rangeScanAvroSchema;
    }

    private Schema rangeScanAvroType$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.rangeScanAvroType = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(this.rangeScanAvroSchema());
                this.bitmap$0 |= 0x800;
            }
        }
        return this.rangeScanAvroType;
    }

    private Schema rangeScanAvroType() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.rangeScanAvroType$lzycompute();
        }
        return this.rangeScanAvroType;
    }

    private UnsafeProjection rangeScanAvroProjection$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.rangeScanAvroProjection = UnsafeProjection$.MODULE$.create(this.rangeScanAvroSchema());
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.rangeScanAvroProjection;
    }

    private UnsafeProjection rangeScanAvroProjection() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.rangeScanAvroProjection$lzycompute();
        }
        return this.rangeScanAvroProjection;
    }

    private StructType remainingKeySchema$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                StructType structType;
                KeyStateEncoderSpec keyStateEncoderSpec = this.keyStateEncoderSpec;
                if (keyStateEncoderSpec instanceof PrefixKeyScanStateEncoderSpec) {
                    PrefixKeyScanStateEncoderSpec prefixKeyScanStateEncoderSpec = (PrefixKeyScanStateEncoderSpec)keyStateEncoderSpec;
                    StructType keySchema = prefixKeyScanStateEncoderSpec.keySchema();
                    int numColsPrefixKey = prefixKeyScanStateEncoderSpec.numColsPrefixKey();
                    structType = StructType$.MODULE$.apply((Seq)keySchema.drop(numColsPrefixKey));
                } else if (keyStateEncoderSpec instanceof RangeKeyScanStateEncoderSpec) {
                    RangeKeyScanStateEncoderSpec rangeKeyScanStateEncoderSpec = (RangeKeyScanStateEncoderSpec)keyStateEncoderSpec;
                    StructType keySchema = rangeKeyScanStateEncoderSpec.keySchema();
                    Seq<Object> orderingOrdinals = rangeKeyScanStateEncoderSpec.orderingOrdinals();
                    structType = StructType$.MODULE$.apply((Seq)((IndexedSeqOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), keySchema.length()).diff(orderingOrdinals)).map((Function1 & Serializable)x$5 -> keySchema.apply(BoxesRunTime.unboxToInt((Object)x$5))));
                } else {
                    throw this.unsupportedOperationForKeyStateEncoder("remainingKeySchema");
                }
                this.remainingKeySchema = structType;
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.remainingKeySchema;
    }

    private StructType remainingKeySchema() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.remainingKeySchema$lzycompute();
        }
        return this.remainingKeySchema;
    }

    private Schema remainingKeyAvroType$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.remainingKeyAvroType = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(this.remainingKeySchema());
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.remainingKeyAvroType;
    }

    private Schema remainingKeyAvroType() {
        if ((this.bitmap$0 & 0x4000) == 0) {
            return this.remainingKeyAvroType$lzycompute();
        }
        return this.remainingKeyAvroType;
    }

    private UnsafeProjection remainingKeyAvroProjection$lzycompute() {
        AvroStateEncoder avroStateEncoder = this;
        synchronized (avroStateEncoder) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.remainingKeyAvroProjection = UnsafeProjection$.MODULE$.create(this.remainingKeySchema());
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.remainingKeyAvroProjection;
    }

    private UnsafeProjection remainingKeyAvroProjection() {
        if ((this.bitmap$0 & 0x8000) == 0) {
            return this.remainingKeyAvroProjection$lzycompute();
        }
        return this.remainingKeyAvroProjection;
    }

    private AvroSerializer getAvroSerializer(StructType schema) {
        Schema avroType = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(schema);
        return new AvroSerializer((DataType)schema, avroType, false);
    }

    private AvroDeserializer getAvroDeserializer(StructType schema) {
        Schema avroType = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(schema);
        AvroOptions avroOptions = AvroOptions$.MODULE$.apply((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        return new AvroDeserializer(avroType, (DataType)schema, avroOptions.datetimeRebaseModeInRead(), avroOptions.useStableIdForUnionType(), avroOptions.stableIdPrefixForUnionType(), avroOptions.recursiveFieldMaxDepth());
    }

    private AvroEncoder createAvroEnc(KeyStateEncoderSpec keyStateEncoderSpec, StructType valueSchema) {
        None$ none$;
        StructType structType;
        AvroSerializer valueSerializer = this.getAvroSerializer(valueSchema);
        AvroDeserializer valueDeserializer = this.getAvroDeserializer(valueSchema);
        KeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        if (keyStateEncoderSpec2 instanceof NoPrefixKeyStateEncoderSpec) {
            StructType schema2;
            NoPrefixKeyStateEncoderSpec noPrefixKeyStateEncoderSpec = (NoPrefixKeyStateEncoderSpec)keyStateEncoderSpec2;
            structType = schema2 = noPrefixKeyStateEncoderSpec.keySchema();
        } else if (keyStateEncoderSpec2 instanceof PrefixKeyScanStateEncoderSpec) {
            PrefixKeyScanStateEncoderSpec prefixKeyScanStateEncoderSpec = (PrefixKeyScanStateEncoderSpec)keyStateEncoderSpec2;
            StructType schema3 = prefixKeyScanStateEncoderSpec.keySchema();
            int numColsPrefixKey = prefixKeyScanStateEncoderSpec.numColsPrefixKey();
            structType = StructType$.MODULE$.apply((Seq)schema3.take(numColsPrefixKey));
        } else if (keyStateEncoderSpec2 instanceof RangeKeyScanStateEncoderSpec) {
            RangeKeyScanStateEncoderSpec rangeKeyScanStateEncoderSpec = (RangeKeyScanStateEncoderSpec)keyStateEncoderSpec2;
            StructType schema4 = rangeKeyScanStateEncoderSpec.keySchema();
            Seq<Object> orderingOrdinals = rangeKeyScanStateEncoderSpec.orderingOrdinals();
            IndexedSeq remainingSchema = (IndexedSeq)((IndexedSeqOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), schema4.length()).diff(orderingOrdinals)).map((Function1 & Serializable)ordinal -> schema4.apply(BoxesRunTime.unboxToInt((Object)ordinal)));
            structType = StructType$.MODULE$.apply((Seq)remainingSchema);
        } else {
            throw new MatchError((Object)keyStateEncoderSpec2);
        }
        StructType keySchema = structType;
        KeyStateEncoderSpec keyStateEncoderSpec3 = keyStateEncoderSpec;
        if (keyStateEncoderSpec3 instanceof PrefixKeyScanStateEncoderSpec) {
            PrefixKeyScanStateEncoderSpec prefixKeyScanStateEncoderSpec = (PrefixKeyScanStateEncoderSpec)keyStateEncoderSpec3;
            StructType schema5 = prefixKeyScanStateEncoderSpec.keySchema();
            int numColsPrefixKey = prefixKeyScanStateEncoderSpec.numColsPrefixKey();
            none$ = new Some((Object)StructType$.MODULE$.apply((Seq)schema5.drop(numColsPrefixKey)));
        } else {
            none$ = None$.MODULE$;
        }
        None$ suffixKeySchema = none$;
        AvroSerializer keySerializer = this.getAvroSerializer(keySchema);
        AvroDeserializer keyDeserializer = this.getAvroDeserializer(keySchema);
        return new AvroEncoder(keySerializer, keyDeserializer, valueSerializer, valueDeserializer, (Option<AvroSerializer>)suffixKeySchema.map((Function1 & Serializable)schema -> this.getAvroSerializer((StructType)schema)), (Option<AvroDeserializer>)suffixKeySchema.map((Function1 & Serializable)schema -> this.getAvroDeserializer((StructType)schema)));
    }

    @Override
    public boolean supportsSchemaEvolution() {
        return true;
    }

    private StateSchemaProvider getStateSchemaProvider() {
        Predef$.MODULE$.assert(this.stateSchemaProvider.isDefined(), (Function0 & Serializable)() -> "StateSchemaProvider should always be defined for the Avro encoder");
        return (StateSchemaProvider)this.stateSchemaProvider.get();
    }

    public byte[] encodeUnsafeRowToAvro(UnsafeRow row, AvroSerializer avroSerializer, Schema valueAvroType, ByteArrayOutputStream out) {
        Object avroData = avroSerializer.serialize(row);
        out.reset();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        GenericDatumWriter writer = new GenericDatumWriter(valueAvroType);
        writer.write(avroData, (Encoder)encoder);
        encoder.flush();
        return out.toByteArray();
    }

    public byte[] prependVersionByte(byte[] bytesToEncode) {
        byte[] encodedBytes = new byte[bytesToEncode.length + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()];
        Platform.putByte((Object)encodedBytes, (long)Platform.BYTE_ARRAY_OFFSET, (byte)RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_VERSION());
        Platform.copyMemory((Object)bytesToEncode, (long)Platform.BYTE_ARRAY_OFFSET, (Object)encodedBytes, (long)(Platform.BYTE_ARRAY_OFFSET + RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()), (long)bytesToEncode.length);
        return encodedBytes;
    }

    public byte[] removeVersionByte(byte[] bytes) {
        byte[] resultBytes = new byte[bytes.length - RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES()];
        Platform.copyMemory((Object)bytes, (long)(RocksDBStateStoreProvider$.MODULE$.STATE_ENCODING_NUM_VERSION_BYTES() + Platform.BYTE_ARRAY_OFFSET), (Object)resultBytes, (long)Platform.BYTE_ARRAY_OFFSET, (long)resultBytes.length);
        return resultBytes;
    }

    public UnsafeRow decodeFromAvroToUnsafeRow(byte[] valueBytes, AvroDeserializer avroDeserializer, Schema valueAvroType, UnsafeProjection valueProj) {
        if (valueBytes != null) {
            GenericDatumReader reader = new GenericDatumReader(valueAvroType);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(valueBytes, 0, valueBytes.length, null);
            Object genericData = reader.read(null, (Decoder)decoder);
            InternalRow internalRow = (InternalRow)avroDeserializer.deserialize(genericData).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return valueProj.apply(internalRow);
        }
        return null;
    }

    public UnsafeRow decodeFromAvroToUnsafeRow(byte[] valueBytes, AvroDeserializer avroDeserializer, Schema writerSchema, Schema readerSchema, UnsafeProjection valueProj) {
        if (valueBytes != null) {
            GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(valueBytes, 0, valueBytes.length, null);
            Object genericData = reader.read(null, (Decoder)decoder);
            InternalRow internalRow = (InternalRow)avroDeserializer.deserialize(genericData).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return valueProj.apply(internalRow);
        }
        return null;
    }

    private ByteArrayOutputStream out() {
        return this.out;
    }

    @Override
    public byte[] encodeKey(UnsafeRow row) {
        byte[] byArray;
        KeyStateEncoderSpec keyStateEncoderSpec = this.keyStateEncoderSpec;
        if (keyStateEncoderSpec instanceof NoPrefixKeyStateEncoderSpec) {
            byte[] avroRow = this.encodeUnsafeRowToAvro(row, this.avroEncoder().keySerializer(), this.keyAvroType(), this.out());
            byArray = this.encodeWithStateSchemaId(new StateSchemaIdRow(this.currentKeySchemaId(), avroRow));
        } else if (keyStateEncoderSpec instanceof PrefixKeyScanStateEncoderSpec) {
            byArray = this.encodeUnsafeRowToAvro(row, this.avroEncoder().keySerializer(), this.prefixKeyAvroType(), this.out());
        } else {
            throw this.unsupportedOperationForKeyStateEncoder("encodeKey");
        }
        byte[] keyBytes = byArray;
        return this.prependVersionByte(keyBytes);
    }

    @Override
    public byte[] encodeRemainingKey(UnsafeRow row) {
        byte[] byArray;
        KeyStateEncoderSpec keyStateEncoderSpec = this.keyStateEncoderSpec;
        if (keyStateEncoderSpec instanceof PrefixKeyScanStateEncoderSpec) {
            byArray = this.encodeUnsafeRowToAvro(row, (AvroSerializer)this.avroEncoder().suffixKeySerializer().get(), this.remainingKeyAvroType(), this.out());
        } else if (keyStateEncoderSpec instanceof RangeKeyScanStateEncoderSpec) {
            byArray = this.encodeUnsafeRowToAvro(row, this.avroEncoder().keySerializer(), this.remainingKeyAvroType(), this.out());
        } else {
            throw this.unsupportedOperationForKeyStateEncoder("encodeRemainingKey");
        }
        byte[] avroRow = byArray;
        return this.prependVersionByte(this.encodeWithStateSchemaId(new StateSchemaIdRow(this.currentKeySchemaId(), avroRow)));
    }

    @Override
    public byte[] encodePrefixKeyForRangeScan(UnsafeRow row) {
        GenericData.Record record = new GenericData.Record(this.rangeScanAvroType());
        IntRef fieldIdx = IntRef.create((int)0);
        ((IterableOnceOps)this.rangeScanKeyFieldsWithOrdinal().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            AvroStateEncoder.$anonfun$encodePrefixKeyForRangeScan$3(this, row, record, fieldIdx, x0$1);
            return BoxedUnit.UNIT;
        });
        this.out().reset();
        GenericDatumWriter writer = new GenericDatumWriter(this.rangeScanAvroType());
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)this.out(), null);
        writer.write((Object)record, (Encoder)encoder);
        encoder.flush();
        return this.prependVersionByte(this.out().toByteArray());
    }

    @Override
    public byte[] encodeValue(UnsafeRow row) {
        byte[] avroRow = this.encodeUnsafeRowToAvro(row, this.avroEncoder().valueSerializer(), this.valueAvroType(), this.out());
        return this.prependVersionByte(this.encodeWithStateSchemaId(new StateSchemaIdRow(this.currentValSchemaId(), avroRow)));
    }

    @Override
    public UnsafeRow decodeKey(byte[] rowBytes) {
        byte[] bytes = this.removeVersionByte(rowBytes);
        KeyStateEncoderSpec keyStateEncoderSpec = this.keyStateEncoderSpec;
        if (keyStateEncoderSpec instanceof NoPrefixKeyStateEncoderSpec) {
            StateSchemaIdRow schemaIdRow = this.decodeStateSchemaIdRow(bytes);
            return this.decodeFromAvroToUnsafeRow(schemaIdRow.bytes(), this.avroEncoder().keyDeserializer(), this.keyAvroType(), this.keyProj());
        }
        if (keyStateEncoderSpec instanceof PrefixKeyScanStateEncoderSpec) {
            return this.decodeFromAvroToUnsafeRow(bytes, this.avroEncoder().keyDeserializer(), this.prefixKeyAvroType(), this.prefixKeyProj());
        }
        throw this.unsupportedOperationForKeyStateEncoder("decodeKey");
    }

    @Override
    public UnsafeRow decodeRemainingKey(byte[] rowBytes) {
        byte[] bytes = this.removeVersionByte(rowBytes);
        StateSchemaIdRow schemaIdRow = this.decodeStateSchemaIdRow(bytes);
        KeyStateEncoderSpec keyStateEncoderSpec = this.keyStateEncoderSpec;
        if (keyStateEncoderSpec instanceof PrefixKeyScanStateEncoderSpec) {
            return this.decodeFromAvroToUnsafeRow(schemaIdRow.bytes(), (AvroDeserializer)this.avroEncoder().suffixKeyDeserializer().get(), this.remainingKeyAvroType(), this.remainingKeyAvroProjection());
        }
        if (keyStateEncoderSpec instanceof RangeKeyScanStateEncoderSpec) {
            return this.decodeFromAvroToUnsafeRow(schemaIdRow.bytes(), this.avroEncoder().keyDeserializer(), this.remainingKeyAvroType(), this.remainingKeyAvroProjection());
        }
        throw this.unsupportedOperationForKeyStateEncoder("decodeRemainingKey");
    }

    @Override
    public UnsafeRow decodePrefixKeyForRangeScan(byte[] rowBytes) {
        byte[] bytes = this.removeVersionByte(rowBytes);
        GenericDatumReader reader = new GenericDatumReader(this.rangeScanAvroType());
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, 0, bytes.length, null);
        GenericRecord record = (GenericRecord)reader.read(null, (Decoder)decoder);
        UnsafeRowWriter rowWriter = new UnsafeRowWriter(this.rangeScanKeyFieldsWithOrdinal().length());
        rowWriter.resetRowWriter();
        IntRef fieldIdx = IntRef.create((int)0);
        ((IterableOnceOps)this.rangeScanKeyFieldsWithOrdinal().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            AvroStateEncoder.$anonfun$decodePrefixKeyForRangeScan$3(this, record, fieldIdx, rowWriter, x0$1);
            return BoxedUnit.UNIT;
        });
        return rowWriter.getRow();
    }

    @Override
    public UnsafeRow decodeValue(byte[] rowBytes) {
        byte[] bytes = this.removeVersionByte(rowBytes);
        StateSchemaIdRow schemaIdRow = this.decodeStateSchemaIdRow(bytes);
        StateSchemaMetadataValue writerSchema = this.getStateSchemaProvider().getSchemaMetadataValue(new StateSchemaMetadataKey(this.columnFamilyName, schemaIdRow.schemaId(), false));
        return this.decodeFromAvroToUnsafeRow(schemaIdRow.bytes(), this.avroEncoder().valueDeserializer(), writerSchema.avroSchema(), this.valueAvroType(), this.valueProj());
    }

    public static final /* synthetic */ Tuple2 $anonfun$rangeScanKeyFieldsWithOrdinal$1(StructType keySchema$1, int ordinal) {
        StructField field = keySchema$1.apply(ordinal);
        return new Tuple2((Object)field, (Object)BoxesRunTime.boxToInteger((int)ordinal));
    }

    public static final /* synthetic */ void $anonfun$encodePrefixKeyForRangeScan$3(AvroStateEncoder $this, UnsafeRow row$3, GenericData.Record record$1, IntRef fieldIdx$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 fieldWithOrdinal = (Tuple2)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            StructField field = (StructField)fieldWithOrdinal._1();
            Object value = row$3.get(idx, field.dataType());
            ByteBuffer markerBuffer = ByteBuffer.allocate(1);
            markerBuffer.order(ByteOrder.BIG_ENDIAN);
            if (value == null) {
                markerBuffer.put($this.nullValMarker());
                record$1.put(fieldIdx$1.elem, (Object)ByteBuffer.wrap(markerBuffer.array()));
                record$1.put(fieldIdx$1.elem + 1, (Object)ByteBuffer.wrap(new byte[field.dataType().defaultSize()]));
            } else {
                DataType dataType = field.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    markerBuffer.put($this.positiveValMarker());
                    record$1.put(fieldIdx$1.elem, (Object)ByteBuffer.wrap(markerBuffer.array()));
                    ByteBuffer valueBuffer = ByteBuffer.allocate(1);
                    valueBuffer.put(BoxesRunTime.unboxToBoolean((Object)value) ? (byte)1 : (byte)0);
                    record$1.put(fieldIdx$1.elem + 1, (Object)ByteBuffer.wrap(valueBuffer.array()));
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    byte byteVal = BoxesRunTime.unboxToByte((Object)value);
                    markerBuffer.put(byteVal < 0 ? $this.negativeValMarker() : $this.positiveValMarker());
                    record$1.put(fieldIdx$1.elem, (Object)ByteBuffer.wrap(markerBuffer.array()));
                    ByteBuffer valueBuffer = ByteBuffer.allocate(1);
                    valueBuffer.order(ByteOrder.BIG_ENDIAN);
                    valueBuffer.put(byteVal);
                    record$1.put(fieldIdx$1.elem + 1, (Object)ByteBuffer.wrap(valueBuffer.array()));
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    short shortVal = BoxesRunTime.unboxToShort((Object)value);
                    markerBuffer.put(shortVal < 0 ? $this.negativeValMarker() : $this.positiveValMarker());
                    record$1.put(fieldIdx$1.elem, (Object)ByteBuffer.wrap(markerBuffer.array()));
                    ByteBuffer valueBuffer = ByteBuffer.allocate(2);
                    valueBuffer.order(ByteOrder.BIG_ENDIAN);
                    valueBuffer.putShort(shortVal);
                    record$1.put(fieldIdx$1.elem + 1, (Object)ByteBuffer.wrap(valueBuffer.array()));
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    int intVal = BoxesRunTime.unboxToInt((Object)value);
                    markerBuffer.put(intVal < 0 ? $this.negativeValMarker() : $this.positiveValMarker());
                    record$1.put(fieldIdx$1.elem, (Object)ByteBuffer.wrap(markerBuffer.array()));
                    ByteBuffer valueBuffer = ByteBuffer.allocate(4);
                    valueBuffer.order(ByteOrder.BIG_ENDIAN);
                    valueBuffer.putInt(intVal);
                    record$1.put(fieldIdx$1.elem + 1, (Object)ByteBuffer.wrap(valueBuffer.array()));
                } else if (LongType$.MODULE$.equals(dataType)) {
                    long longVal = BoxesRunTime.unboxToLong((Object)value);
                    markerBuffer.put(longVal < 0L ? $this.negativeValMarker() : $this.positiveValMarker());
                    record$1.put(fieldIdx$1.elem, (Object)ByteBuffer.wrap(markerBuffer.array()));
                    ByteBuffer valueBuffer = ByteBuffer.allocate(8);
                    valueBuffer.order(ByteOrder.BIG_ENDIAN);
                    valueBuffer.putLong(longVal);
                    record$1.put(fieldIdx$1.elem + 1, (Object)ByteBuffer.wrap(valueBuffer.array()));
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    float floatVal = BoxesRunTime.unboxToFloat((Object)value);
                    int rawBits = Float.floatToRawIntBits(floatVal);
                    markerBuffer.put((rawBits & $this.floatSignBitMask()) != 0 ? $this.negativeValMarker() : $this.positiveValMarker());
                    record$1.put(fieldIdx$1.elem, (Object)ByteBuffer.wrap(markerBuffer.array()));
                    ByteBuffer valueBuffer = ByteBuffer.allocate(4);
                    valueBuffer.order(ByteOrder.BIG_ENDIAN);
                    if ((rawBits & $this.floatSignBitMask()) != 0) {
                        int updatedVal = rawBits ^ $this.floatFlipBitMask();
                        v0 = valueBuffer.putFloat(Float.intBitsToFloat(updatedVal));
                    } else {
                        v0 = valueBuffer.putFloat(floatVal);
                    }
                    record$1.put(fieldIdx$1.elem + 1, (Object)ByteBuffer.wrap(valueBuffer.array()));
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    double doubleVal = BoxesRunTime.unboxToDouble((Object)value);
                    long rawBits = Double.doubleToRawLongBits(doubleVal);
                    markerBuffer.put((rawBits & $this.doubleSignBitMask()) != 0L ? $this.negativeValMarker() : $this.positiveValMarker());
                    record$1.put(fieldIdx$1.elem, (Object)ByteBuffer.wrap(markerBuffer.array()));
                    ByteBuffer valueBuffer = ByteBuffer.allocate(8);
                    valueBuffer.order(ByteOrder.BIG_ENDIAN);
                    if ((rawBits & $this.doubleSignBitMask()) != 0L) {
                        long updatedVal = rawBits ^ $this.doubleFlipBitMask();
                        v1 = valueBuffer.putDouble(Double.longBitsToDouble(updatedVal));
                    } else {
                        v1 = valueBuffer.putDouble(doubleVal);
                    }
                    record$1.put(fieldIdx$1.elem + 1, (Object)ByteBuffer.wrap(valueBuffer.array()));
                } else {
                    throw new UnsupportedOperationException("Range scan encoding not supported for data type: " + field.dataType());
                }
            }
            fieldIdx$1.elem += 2;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$decodePrefixKeyForRangeScan$3(AvroStateEncoder $this, GenericRecord record$2, IntRef fieldIdx$2, UnsafeRowWriter rowWriter$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 fieldWithOrdinal = (Tuple2)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            StructField field = (StructField)fieldWithOrdinal._1();
            byte[] markerBytes = ((ByteBuffer)record$2.get(fieldIdx$2.elem)).array();
            ByteBuffer markerBuf = ByteBuffer.wrap(markerBytes);
            markerBuf.order(ByteOrder.BIG_ENDIAN);
            byte marker = markerBuf.get();
            if (marker == $this.nullValMarker()) {
                rowWriter$1.setNullAt(idx);
            } else {
                DataType dataType = field.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    byte[] bytes = ((ByteBuffer)record$2.get(fieldIdx$2.elem + 1)).array();
                    rowWriter$1.write(idx, bytes[0] == 1);
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    byte[] bytes = ((ByteBuffer)record$2.get(fieldIdx$2.elem + 1)).array();
                    ByteBuffer valueBuf = ByteBuffer.wrap(bytes);
                    valueBuf.order(ByteOrder.BIG_ENDIAN);
                    rowWriter$1.write(idx, valueBuf.get());
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    byte[] bytes = ((ByteBuffer)record$2.get(fieldIdx$2.elem + 1)).array();
                    ByteBuffer valueBuf = ByteBuffer.wrap(bytes);
                    valueBuf.order(ByteOrder.BIG_ENDIAN);
                    rowWriter$1.write(idx, valueBuf.getShort());
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    byte[] bytes = ((ByteBuffer)record$2.get(fieldIdx$2.elem + 1)).array();
                    ByteBuffer valueBuf = ByteBuffer.wrap(bytes);
                    valueBuf.order(ByteOrder.BIG_ENDIAN);
                    rowWriter$1.write(idx, valueBuf.getInt());
                } else if (LongType$.MODULE$.equals(dataType)) {
                    byte[] bytes = ((ByteBuffer)record$2.get(fieldIdx$2.elem + 1)).array();
                    ByteBuffer valueBuf = ByteBuffer.wrap(bytes);
                    valueBuf.order(ByteOrder.BIG_ENDIAN);
                    rowWriter$1.write(idx, valueBuf.getLong());
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    byte[] bytes = ((ByteBuffer)record$2.get(fieldIdx$2.elem + 1)).array();
                    ByteBuffer valueBuf = ByteBuffer.wrap(bytes);
                    valueBuf.order(ByteOrder.BIG_ENDIAN);
                    if (marker == $this.negativeValMarker()) {
                        float floatVal = valueBuf.getFloat();
                        int updatedVal = Float.floatToRawIntBits(floatVal) ^ $this.floatFlipBitMask();
                        rowWriter$1.write(idx, Float.intBitsToFloat(updatedVal));
                    } else {
                        rowWriter$1.write(idx, valueBuf.getFloat());
                    }
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    byte[] bytes = ((ByteBuffer)record$2.get(fieldIdx$2.elem + 1)).array();
                    ByteBuffer valueBuf = ByteBuffer.wrap(bytes);
                    valueBuf.order(ByteOrder.BIG_ENDIAN);
                    if (marker == $this.negativeValMarker()) {
                        double doubleVal = valueBuf.getDouble();
                        long updatedVal = Double.doubleToRawLongBits(doubleVal) ^ $this.doubleFlipBitMask();
                        rowWriter$1.write(idx, Double.longBitsToDouble(updatedVal));
                    } else {
                        rowWriter$1.write(idx, valueBuf.getDouble());
                    }
                } else {
                    throw new UnsupportedOperationException("Range scan decoding not supported for data type: " + field.dataType());
                }
            }
            fieldIdx$2.elem += 2;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public AvroStateEncoder(KeyStateEncoderSpec keyStateEncoderSpec, StructType valueSchema, Option<StateSchemaProvider> stateSchemaProvider, String columnFamilyName) {
        this.keyStateEncoderSpec = keyStateEncoderSpec;
        this.valueSchema = valueSchema;
        this.stateSchemaProvider = stateSchemaProvider;
        this.columnFamilyName = columnFamilyName;
        super(keyStateEncoderSpec, valueSchema);
        Logging.$init$((Logging)this);
        this.avroEncoder = this.createAvroEnc(keyStateEncoderSpec, valueSchema);
        this.out = new ByteArrayOutputStream();
    }
}

