/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpInStr$;
import org.apache.spark.sql.catalyst.expressions.RegExpUtils$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp) - Searches a string for a regular expression and returns an integer that indicates the beginning position of the matched substring. Positions are 1-based, not 0-based. If no match is found, returns 0.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser, see the unescaping rules at <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#string-literal\">String Literal</a>.\n          For example, to match \"\\abc\", a regular expression for `regexp` can be \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".<br><br>\n          It's recommended to use a raw string literal (with the `r` prefix) to avoid escaping\n          special characters in the pattern string if exists.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(r\"\\abc\", r\"^\\\\abc$\");\n       1\n      > SELECT _FUNC_('user@spark.apache.org', '@[^.]*');\n       5\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0011\"\u0001:B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u00031\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000b=\u0003A\u0011A+\t\u000bi\u0003A\u0011I.\t\u000b\r\u0004A\u0011\t3\t\u000b-\u0004A\u0011\t7\t\u000bU\u0004A\u0011\u000b<\t\u000f\u0005%\u0001\u0001\"\u0015\u0002\f!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003G\u0001\u0011\u0013!C\u0001\u0003KA\u0011\"a\u000f\u0001#\u0003%\t!!\n\t\u0013\u0005u\u0002!%A\u0005\u0002\u0005\u0015\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003g\u0002\u0011\u0011!C\u0001\u0003kB\u0011\"a \u0001\u0003\u0003%\t%!!\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001du!CAYC\u0005\u0005\t\u0012AAZ\r!\u0001\u0013%!A\t\u0002\u0005U\u0006BB(\u001b\t\u0003\ti\rC\u0005\u0002Pj\t\t\u0011\"\u0012\u0002R\"I\u00111\u001b\u000e\u0002\u0002\u0013\u0005\u0015Q\u001b\u0005\n\u0003;T\u0012\u0011!CA\u0003?D\u0011\"!=\u001b\u0003\u0003%I!a=\u0003\u0017I+w-\u0012=q\u0013:\u001cFO\u001d\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M!\u0001aL\u001a:!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014EA\tSK\u001e,\u0005\u0010]#yiJ\f7\r\u001e\"bg\u0016\u0004\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002;\u0005:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}5\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005\u0005+\u0014a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!Q\u001b\u0002\u000fM,(M[3diV\tq\t\u0005\u00021\u0011&\u0011\u0011*\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001C:vE*,7\r\u001e\u0011\u0002\rI,w-\u001a=q\u0003\u001d\u0011XmZ3ya\u0002\n1!\u001b3y\u0003\u0011IG\r\u001f\u0011\u0002\rqJg.\u001b;?)\u0011\t&k\u0015+\u0011\u0005A\u0002\u0001\"B#\b\u0001\u00049\u0005\"B&\b\u0001\u00049\u0005\"B'\b\u0001\u00049EcA)W1\")q\u000b\u0003a\u0001\u000f\u0006\t1\u000fC\u0003Z\u0011\u0001\u0007q)A\u0001s\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011av\fY1\u0011\u0005Qj\u0016B\u000106\u0005\r\te.\u001f\u0005\u0006/&\u0001\r\u0001\u0018\u0005\u00063&\u0001\r\u0001\u0018\u0005\u0006E&\u0001\r\u0001X\u0001\u0002S\u0006AA-\u0019;b)f\u0004X-F\u0001f!\t1\u0017.D\u0001h\u0015\tAW%A\u0003usB,7/\u0003\u0002kO\nAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!\u001c\t\u0003]Jt!a\u001c9\u0011\u0005q*\u0014BA96\u0003\u0019\u0001&/\u001a3fM&\u00111\u000f\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E,\u0014!\u00033p\u000f\u0016t7i\u001c3f)\u00119X0!\u0002\u0011\u0005a\\X\"A=\u000b\u0005i\f\u0013aB2pI\u0016<WM\\\u0005\u0003yf\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006}2\u0001\ra`\u0001\u0004GRD\bc\u0001=\u0002\u0002%\u0019\u00111A=\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011q\u0001\u0007A\u0002]\f!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB)\u0002\u000e\u0005E\u0011Q\u0003\u0005\u0007\u0003\u001fi\u0001\u0019A$\u0002\u00119,wOR5sgRDa!a\u0005\u000e\u0001\u00049\u0015!\u00038foN+7m\u001c8e\u0011\u0019\t9\"\u0004a\u0001\u000f\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLHcB)\u0002\u001e\u0005}\u0011\u0011\u0005\u0005\b\u000b:\u0001\n\u00111\u0001H\u0011\u001dYe\u0002%AA\u0002\u001dCq!\u0014\b\u0011\u0002\u0003\u0007q)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d\"fA$\u0002*-\u0012\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003%)hn\u00195fG.,GMC\u0002\u00026U\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI$a\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0011\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005!A.\u00198h\u0015\t\ti%\u0001\u0003kCZ\f\u0017bA:\u0002H\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u000b\t\u0004i\u0005]\u0013bAA-k\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A,a\u0018\t\u0013\u0005\u0005D#!AA\u0002\u0005U\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002hA)\u0011\u0011NA896\u0011\u00111\u000e\u0006\u0004\u0003[*\u0014AC2pY2,7\r^5p]&!\u0011\u0011OA6\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0014Q\u0010\t\u0004i\u0005e\u0014bAA>k\t9!i\\8mK\u0006t\u0007\u0002CA1-\u0005\u0005\t\u0019\u0001/\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\n\u0019\tC\u0005\u0002b]\t\t\u00111\u0001\u0002V\u00051Q-];bYN$B!a\u001e\u0002\n\"A\u0011\u0011\r\r\u0002\u0002\u0003\u0007A\fK\f\u0001\u0003\u001b\u000b\u0019*!&\u0002\u001a\u0006m\u0015qTAQ\u0003K\u000b9+a+\u0002.B\u0019\u0001'a$\n\u0007\u0005E\u0015EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005]\u0015!!3\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\u0012XmZ3ya&\u0002S\u0006I*fCJ\u001c\u0007.Z:!C\u0002\u001aHO]5oO\u00022wN\u001d\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011b]\u0012\u0004#/\u001a;ve:\u001c\b%\u00198!S:$XmZ3sAQD\u0017\r\u001e\u0011j]\u0012L7-\u0019;fg\u0002\"\b.\u001a\u0011cK\u001eLgN\\5oO\u0002\u0002xn]5uS>t\u0007e\u001c4!i\",\u0007%\\1uG\",G\rI:vEN$(/\u001b8h]\u0001\u0002vn]5uS>t7\u000fI1sK\u0002\nTFY1tK\u0012d\u0003E\\8uAAj#-Y:fI:\u0002\u0013J\u001a\u0011o_\u0002j\u0017\r^2iA%\u001c\bEZ8v]\u0012d\u0003E]3ukJt7\u000f\t\u0019/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\ti*ADF\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o])\u0001\u0003\u0005\t\u0011!A)\u0002#/Z4fqB\u0004S\u0006I1!gR\u0014\u0018N\\4!e\u0016\u0004(/Z:f]RLgn\u001a\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!)\",\u0007E]3hKb\u00043\u000f\u001e:j]\u001e\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003ES1wC\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/y\t\u0014h\b\u00102s})\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I*j]\u000e,\u0007e\u00159be.\u0004#G\f\u0019-AM$(/\u001b8hA1LG/\u001a:bYN\u0004\u0003&\u001b8dYV$\u0017N\\4!e\u0016<W\r\u001f\u0011qCR$XM\u001d8tS\u0001\n'/\u001a\u0011v]\u0016\u001c8-\u00199fI\u0002Jg\u000eI8ve\u0002\u001a\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0018M]:fe2\u00023/Z3!i\",\u0007%\u001e8fg\u000e\f\u0007/\u001b8hAI,H.Z:!CR\u0004C(\u0019\u0011ie\u00164WH\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gFdWF]3g[1LG/\u001a:bYNt\u0003\u000e^7mGM$(/\u001b8h[1LG/\u001a:bY\nr4\u000b\u001e:j]\u001e\u0004C*\u001b;fe\u0006dGhL1?])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t$pe\u0002*\u00070Y7qY\u0016d\u0003\u0005^8![\u0006$8\r\u001b\u0011#9\u0006\u00147M\t\u0017!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!M>\u0014\b\u0005\u0019:fO\u0016D\b\u000f\u0019\u0011dC:\u0004#-\u001a\u0011#=rc\u0016MY2%E9b$M\u001d =EJt$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!)\",'/\u001a\u0011jg\u0002\n\u0007eU)MA\r|gNZ5hA\u001d\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u0014!i\"\fG\u000fI2b]\u0002\u0012W\rI;tK\u0012\u0004Co\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012\u0017\r\u001c7cC\u000e\\\u0007\u0005^8!i\",\u0007e\u00159be.\u0004\u0013G\f\u001c!E\u0016D\u0017M^5pe\u0002\u0012XmZ1sI&tw\rI:ue&tw\r\t7ji\u0016\u0014\u0018\r\u001c\u0011qCJ\u001c\u0018N\\4/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013N\u001a\u0011uQ\u0016\u00043m\u001c8gS\u001e\u0004\u0013n\u001d\u0011f]\u0006\u0014G.\u001a3-AQDW\r\t1sK\u001e,\u0007\u0010\u001d1!i\"\fG\u000fI2b]\u0002j\u0017\r^2iA\tb\u0016MY2#A%\u001c\bE\t0]C\n\u001cGE\t\u0018=EJtDH\u0019:?\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u0013;(g\u0002\u0012XmY8n[\u0016tG-\u001a3!i>\u0004So]3!C\u0002\u0012\u0018m\u001e\u0011tiJLgn\u001a\u0011mSR,'/\u00197!Q]LG\u000f\u001b\u0011uQ\u0016\u0004\u0003M\u001d1!aJ,g-\u001b=*AQ|\u0007%\u0019<pS\u0012\u0004Sm]2ba&twM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AM\u0004XmY5bY\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011j]\u0002\"\b.\u001a\u0011qCR$XM\u001d8!gR\u0014\u0018N\\4!S\u001a\u0004S\r_5tiNt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a)\u0002\u0003'Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\u001d\u0012]C\n\u001c'\u0005\f\u0011sEycF,\u00192dI\tJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d*8/\u001a:AgB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e<C\u0006I\u0014A7zsSLK\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001*$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005%\u0016!B\u001a/i9\u0002\u0014!B4s_V\u0004\u0018EAAX\u00031\u0019HO]5oO~3WO\\2t\u0003-\u0011VmZ#ya&s7\u000b\u001e:\u0011\u0005AR2#\u0002\u000e\u00028\u0006\r\u0007\u0003CA]\u0003\u007f;uiR)\u000e\u0005\u0005m&bAA_k\u00059!/\u001e8uS6,\u0017\u0002BAa\u0003w\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\t)-a3\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\n!![8\n\u0007\r\u000b9\r\u0006\u0002\u00024\u0006AAo\\*ue&tw\r\u0006\u0002\u0002D\u0005)\u0011\r\u001d9msR9\u0011+a6\u0002Z\u0006m\u0007\"B#\u001e\u0001\u00049\u0005\"B&\u001e\u0001\u00049\u0005\"B'\u001e\u0001\u00049\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003C\fi\u000fE\u00035\u0003G\f9/C\u0002\u0002fV\u0012aa\u00149uS>t\u0007C\u0002\u001b\u0002j\u001e;u)C\u0002\u0002lV\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAx=\u0005\u0005\t\u0019A)\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002vB!\u0011QIA|\u0013\u0011\tI0a\u0012\u0003\r=\u0013'.Z2u\u0001")
public class RegExpInStr
extends RegExpExtractBase
implements Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpInStr x$0) {
        return RegExpInStr$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpInStr> tupled() {
        return RegExpInStr$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpInStr>>> curried() {
        return RegExpInStr$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object r, Object i) {
        Integer n;
        block3: {
            try {
                Matcher m = this.getLastMatcher(s, r);
                if (m.find()) {
                    n = BoxesRunTime.boxToInteger((int)(m.toMatchResult().start() + 1));
                    break block3;
                }
                n = BoxesRunTime.boxToInteger((int)0);
            }
            catch (IllegalStateException illegalStateException) {
                n = BoxesRunTime.boxToInteger((int)0);
            }
        }
        return n;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "regexp_instr";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String matcher = ctx.freshName("matcher");
        String setEvNotNull = this.nullable() ? ev.isNull() + " = false;" : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(subject, regexp, x$10) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |try {\n         |  " + setEvNotNull + "\n         |  " + RegExpUtils$.MODULE$.initLastMatcherCode(ctx, (String)subject, (String)regexp, matcher, this.prettyName(), this.collationId()) + "\n         |  if (" + matcher + ".find()) {\n         |    " + ev.value() + " = " + matcher + ".toMatchResult().start() + 1;\n         |  } else {\n         |    " + ev.value() + " = 0;\n         |  }\n         |} catch (IllegalStateException e) {\n         |  " + ev.value() + " = 0;\n         |}\n         |")));
    }

    @Override
    public RegExpInStr withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public RegExpInStr copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpInStr(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpInStr";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.subject();
            }
            case 1: {
                return this.regexp();
            }
            case 2: {
                return this.idx();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpInStr;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "subject";
            }
            case 1: {
                return "regexp";
            }
            case 2: {
                return "idx";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpInStr)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpInStr regExpInStr = (RegExpInStr)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpInStr.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpInStr.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpInStr.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpInStr.canEqual(this)) return false;
        return true;
    }

    public RegExpInStr(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpInStr(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

