/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.VariantVal;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001\u0002\u0011\"\u00019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!AQ\t\u0001B\u0001B\u0003%a\tC\u0003K\u0001\u0011\u00051*\u0002\u0003Q\u0001\u0011\t\u0006\u0002\u00031\u0001\u0011\u000b\u0007I\u0011B1\t\u0011\u001d\u0004\u0001R1A\u0005\n!D\u0001\"\u001b\u0001\t\u0006\u0004%I\u0001\u001b\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019A\b\u0001)A\u0005Y\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bbBA\u0007\u0001\u0001\u0006Ia\u001f\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#A\u0001\"a\b\u0001A\u0003%\u00111\u0003\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003#A\u0001\"a\t\u0001A\u0003%\u00111\u0003\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003OA\u0001\"a\f\u0001A\u0003%\u0011\u0011\u0006\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~!9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003W\u0003A\u0011AAU\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!!,\u0001\t\u0003\t\u0019\fC\u0004\u0002.\u0002!\t!a.\t\u000f\u00055\u0006\u0001\"\u0001\u0002<\"9\u0011q\u001a\u0001\u0005\u0002\u0005%&\u0001\u0005&bG.\u001cxN\\$f]\u0016\u0014\u0018\r^8s\u0015\t\u00113%\u0001\u0003kg>t'B\u0001\u0013&\u0003!\u0019\u0017\r^1msN$(B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011C\u0001\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u0006AA-\u0019;b)f\u0004X\r\u0005\u00028u5\t\u0001H\u0003\u0002:K\u0005)A/\u001f9fg&\u00111\b\u000f\u0002\t\t\u0006$\u0018\rV=qK\u00061qO]5uKJ\u0004\"AP\"\u000e\u0003}R!\u0001Q!\u0002\u0005%|'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\t~\u0012aa\u0016:ji\u0016\u0014\u0018aB8qi&|gn\u001d\t\u0003\u000f\"k\u0011!I\u0005\u0003\u0013\u0006\u00121BS*P\u001d>\u0003H/[8og\u00061A(\u001b8jiz\"B\u0001T'O\u001fB\u0011q\t\u0001\u0005\u0006k\u0011\u0001\rA\u000e\u0005\u0006y\u0011\u0001\r!\u0010\u0005\u0006\u000b\u0012\u0001\rA\u0012\u0002\f-\u0006dW/Z,sSR,'\u000fE\u00031%RSV,\u0003\u0002Tc\tIa)\u001e8di&|gN\r\t\u0003+bk\u0011A\u0016\u0006\u0003/\u000e\n1\"\u001a=qe\u0016\u001c8/[8og&\u0011\u0011L\u0016\u0002\u0013'B,7-[1mSj,GmR3ui\u0016\u00148\u000f\u0005\u000217&\u0011A,\r\u0002\u0004\u0013:$\bC\u0001\u0019_\u0013\ty\u0016G\u0001\u0003V]&$\u0018\u0001\u0005:p_R4\u0015.\u001a7e/JLG/\u001a:t+\u0005\u0011\u0007c\u0001\u0019dK&\u0011A-\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003M\u0016i\u0011\u0001A\u0001\u0011CJ\u0014X\t\\3nK:$xK]5uKJ,\u0012!Z\u0001\u0011[\u0006\u0004X\t\\3nK:$xK]5uKJ\f1aZ3o+\u0005a\u0007CA7w\u001b\u0005q'BA8q\u0003\u0011\u0019wN]3\u000b\u0005E\u0014\u0018a\u00026bG.\u001cxN\u001c\u0006\u0003gR\f\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0003U\f1aY8n\u0013\t9hNA\u0007Kg>tw)\u001a8fe\u0006$xN]\u0001\u0005O\u0016t\u0007%A\u0007mS:,7+\u001a9be\u0006$xN]\u000b\u0002wB\u0019A0a\u0002\u000f\u0007u\f\u0019\u0001\u0005\u0002\u007fc5\tqPC\u0002\u0002\u00025\na\u0001\u0010:p_Rt\u0014bAA\u0003c\u00051\u0001K]3eK\u001aLA!!\u0003\u0002\f\t11\u000b\u001e:j]\u001eT1!!\u00022\u00039a\u0017N\\3TKB\f'/\u0019;pe\u0002\n!\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;feV\u0011\u00111\u0003\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\u0012\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\t9B\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\u0018a\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\u0004\u0013!\u0006;j[\u0016\u001cH/Y7q\u001dRSfi\u001c:nCR$XM]\u0001\u0017i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3sA\u0005iA-\u0019;f\r>\u0014X.\u0019;uKJ,\"!!\u000b\u0011\t\u0005U\u00111F\u0005\u0005\u0003[\t9BA\u0007ECR,gi\u001c:nCR$XM]\u0001\u000fI\u0006$XMR8s[\u0006$H/\u001a:!\u0003)i\u0017m[3Xe&$XM\u001d\u000b\u0004K\u0006U\u0002\"B\u001b\u0014\u0001\u00041\u0014aC<sSR,wJ\u00196fGR$2!XA\u001e\u0011!\ti\u0004\u0006CA\u0002\u0005}\u0012!\u00014\u0011\tA\n\t%X\u0005\u0004\u0003\u0007\n$\u0001\u0003\u001fcs:\fW.\u001a \u0002\u0017]\u0014\u0018\u000e^3GS\u0016dGm\u001d\u000b\b;\u0006%\u0013QKA0\u0011\u001d\tY%\u0006a\u0001\u0003\u001b\n1A]8x!\u0011\ty%!\u0015\u000e\u0003\rJ1!a\u0015$\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000f\u0005]S\u00031\u0001\u0002Z\u000511o\u00195f[\u0006\u00042aNA.\u0013\r\ti\u0006\u000f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA1+\u0001\u0007\u00111M\u0001\rM&,G\u000eZ,sSR,'o\u001d\t\u0006\u0003K\ny'\u001a\b\u0005\u0003O\nYGD\u0002\u007f\u0003SJ\u0011AM\u0005\u0004\u0003[\n\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003c\n\u0019HA\u0002TKFT1!!\u001c2\u0003)9(/\u001b;f\u0003J\u0014\u0018-\u001f\u000b\u0004;\u0006e\u0004\u0002CA\u001f-\u0011\u0005\r!a\u0010\u0002\u001d]\u0014\u0018\u000e^3BeJ\f\u0017\u0010R1uCR)Q,a \u0002\n\"9\u0011\u0011Q\fA\u0002\u0005\r\u0015!B1se\u0006L\b\u0003BA\u000b\u0003\u000bKA!a\"\u0002\u0018\tI\u0011I\u001d:bs\u0012\u000bG/\u0019\u0005\u0007\u0003\u0017;\u0002\u0019A3\u0002\u0017\u0019LW\r\u001c3Xe&$XM]\u0001\roJLG/Z'ba\u0012\u000bG/\u0019\u000b\b;\u0006E\u00151TAS\u0011\u001d\t\u0019\n\u0007a\u0001\u0003+\u000b1!\\1q!\u0011\t)\"a&\n\t\u0005e\u0015q\u0003\u0002\b\u001b\u0006\u0004H)\u0019;b\u0011\u001d\ti\n\u0007a\u0001\u0003?\u000bq!\\1q)f\u0004X\rE\u00028\u0003CK1!a)9\u0005\u001di\u0015\r\u001d+za\u0016Da!a#\u0019\u0001\u0004)\u0017!B2m_N,G#A/\u0002\u000b\u0019dWo\u001d5\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007u\u000b\t\fC\u0004\u0002Lm\u0001\r!!\u0014\u0015\u0007u\u000b)\fC\u0004\u0002\u0002r\u0001\r!a!\u0015\u0007u\u000bI\fC\u0004\u0002\u0014v\u0001\r!!&\u0015\u0007u\u000bi\fC\u0004\u0002@z\u0001\r!!1\u0002\u0003Y\u0004B!a1\u0002L6\u0011\u0011Q\u0019\u0006\u0004s\u0005\u001d'bAAeO\u00051QO\\:bM\u0016LA!!4\u0002F\nQa+\u0019:jC:$h+\u00197\u0002\u001f]\u0014\u0018\u000e^3MS:,WI\u001c3j]\u001e\u0004")
public class JacksonGenerator {
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private Function2<SpecializedGetters, Object, BoxedUnit> arrElementWriter;
    private Function2<SpecializedGetters, Object, BoxedUnit> mapElementWriter;
    private final DataType dataType;
    private final JSONOptions options;
    private final JsonGenerator gen;
    private final String lineSeparator;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final DateFormatter dateFormatter;
    private volatile byte bitmap$0;

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters$lzycompute() {
        JacksonGenerator jacksonGenerator = this;
        synchronized (jacksonGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType2 = this.dataType;
                if (!(dataType2 instanceof StructType)) {
                    throw QueryExecutionErrors$.MODULE$.initialTypeNotTargetDataTypeError(this.dataType, StructType$.MODULE$.simpleString());
                }
                StructType structType = (StructType)dataType2;
                this.rootFieldWriters = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$1 -> x$1.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.rootFieldWriters;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.rootFieldWriters$lzycompute();
        }
        return this.rootFieldWriters;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> arrElementWriter$lzycompute() {
        JacksonGenerator jacksonGenerator = this;
        synchronized (jacksonGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Function2<SpecializedGetters, Object, BoxedUnit> function2;
                DataType dataType = this.dataType;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    function2 = this.makeWriter(arrayType.elementType());
                } else if (dataType instanceof StructType ? true : dataType instanceof MapType) {
                    function2 = this.makeWriter(this.dataType);
                } else {
                    throw QueryExecutionErrors$.MODULE$.initialTypeNotTargetDataTypesError(this.dataType);
                }
                this.arrElementWriter = function2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.arrElementWriter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> arrElementWriter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.arrElementWriter$lzycompute();
        }
        return this.arrElementWriter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> mapElementWriter$lzycompute() {
        JacksonGenerator jacksonGenerator = this;
        synchronized (jacksonGenerator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                DataType dataType = this.dataType;
                if (!(dataType instanceof MapType)) {
                    throw QueryExecutionErrors$.MODULE$.initialTypeNotTargetDataTypeError(this.dataType, MapType$.MODULE$.simpleString());
                }
                MapType mapType = (MapType)dataType;
                this.mapElementWriter = this.makeWriter(mapType.valueType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.mapElementWriter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> mapElementWriter() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.mapElementWriter$lzycompute();
        }
        return this.mapElementWriter;
    }

    private JsonGenerator gen() {
        return this.gen;
    }

    private String lineSeparator() {
        return this.lineSeparator;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType2) {
        while (true) {
            DataType dataType3;
            if (NullType$.MODULE$.equals(dataType3 = dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (BooleanType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ByteType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ShortType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (IntegerType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (LongType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (FloatType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DoubleType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof StringType) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (TimestampType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (TimestampNTZType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DateType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof YearMonthIntervalType) {
                YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType3;
                byte start = yearMonthIntervalType.startField();
                byte end = yearMonthIntervalType.endField();
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$14(this, start, end, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof DayTimeIntervalType) {
                DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType3;
                byte start = dayTimeIntervalType.startField();
                byte end = dayTimeIntervalType.endField();
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$15(this, start, end, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (BinaryType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$16(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType3;
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$17(this, decimalType, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof StructType) {
                StructType structType = (StructType)dataType3;
                Seq fieldWriters = (Seq)((IterableOps)structType.map((Function1 & Serializable)x$2 -> x$2.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType));
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, (Seq<Function2<SpecializedGetters, Object, BoxedUnit>>)fieldWriters));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType3;
                Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType());
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.writeArray((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeArrayData(row.getArray(BoxesRunTime.unboxToInt((Object)ordinal)), (Function2<SpecializedGetters, Object, BoxedUnit>)elementWriter));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof MapType) {
                MapType mapType = (MapType)dataType3;
                Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType());
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeMapData(row.getMap(BoxesRunTime.unboxToInt((Object)ordinal)), mapType, (Function2<SpecializedGetters, Object, BoxedUnit>)valueWriter));
                    return BoxedUnit.UNIT;
                };
            }
            if (VariantType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.write(row.getVariant(BoxesRunTime.unboxToInt((Object)ordinal)));
                    return BoxedUnit.UNIT;
                };
            }
            if (!(dataType3 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            dataType2 = userDefinedType.sqlType();
        }
        return (Function2 & Serializable)(row, ordinal) -> JacksonGenerator.$anonfun$makeWriter$27(dataType2, row, BoxesRunTime.unboxToInt((Object)ordinal));
    }

    private void writeObject(Function0<BoxedUnit> f) {
        this.gen().writeStartObject();
        f.apply$mcV$sp();
        this.gen().writeEndObject();
    }

    private void writeFields(InternalRow row, StructType schema, Seq<Function2<SpecializedGetters, Object, BoxedUnit>> fieldWriters) {
        for (int i = 0; i < row.numFields(); ++i) {
            Object object;
            StructField field = schema.apply(i);
            if (!row.isNullAt(i)) {
                this.gen().writeFieldName(field.name());
                object = ((Function2)fieldWriters.apply(i)).apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            if (!this.options.ignoreNullFields() || this.options.writeNullIfWithDefaultValue() && field.getExistenceDefaultValue().isDefined()) {
                this.gen().writeFieldName(field.name());
                this.gen().writeNull();
            }
            object = BoxedUnit.UNIT;
        }
    }

    private void writeArray(Function0<BoxedUnit> f) {
        this.gen().writeStartArray();
        f.apply$mcV$sp();
        this.gen().writeEndArray();
    }

    private void writeArrayData(ArrayData array, Function2<SpecializedGetters, Object, BoxedUnit> fieldWriter) {
        for (int i = 0; i < array.numElements(); ++i) {
            Object object;
            if (!array.isNullAt(i)) {
                object = fieldWriter.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            this.gen().writeNull();
            object = BoxedUnit.UNIT;
        }
    }

    private void writeMapData(MapData map, MapType mapType, Function2<SpecializedGetters, Object, BoxedUnit> fieldWriter) {
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        for (int i = 0; i < map.numElements(); ++i) {
            Object object;
            this.gen().writeFieldName(keyArray.get(i, mapType.keyType()).toString());
            if (!valueArray.isNullAt(i)) {
                object = fieldWriter.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            this.gen().writeNull();
            object = BoxedUnit.UNIT;
        }
    }

    public void close() {
        this.gen().close();
    }

    public void flush() {
        this.gen().flush();
    }

    public void write(InternalRow row) {
        this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            ArraySeq x$1 = ArrayImplicits$.MODULE$.SparkArrayOps(this.rootFieldWriters()).toImmutableArraySeq();
            InternalRow x$2 = row;
            StructType x$3 = (StructType)$this.dataType;
            this.writeFields(x$2, x$3, (Seq<Function2<SpecializedGetters, Object, BoxedUnit>>)x$1);
        });
    }

    public void write(ArrayData array) {
        this.writeArray((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeArrayData(array, this.arrElementWriter()));
    }

    public void write(MapData map) {
        this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Function2<SpecializedGetters, Object, BoxedUnit> x$1 = this.mapElementWriter();
            MapData x$2 = map;
            MapType x$3 = (MapType)$this.dataType;
            this.writeMapData(x$2, x$3, x$1);
        });
    }

    public void write(VariantVal v) {
        this.gen().writeRawValue(v.toJson(this.options.zoneId()));
    }

    public void writeLineEnding() {
        this.gen().writeRaw(this.lineSeparator());
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNull();
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber((short)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeString(row.getUTF8String(ordinal).toString());
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String timestampString = $this.timestampFormatter().format(row.getLong(ordinal));
        $this.gen().writeString(timestampString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String timestampString = $this.timestampNTZFormatter().format(DateTimeUtils$.MODULE$.microsToLocalDateTime(row.getLong(ordinal)));
        $this.gen().writeString(timestampString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String dateString = $this.dateFormatter().format(row.getInt(ordinal));
        $this.gen().writeString(dateString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeString(row.getInterval(ordinal).toString());
    }

    public static final /* synthetic */ void $anonfun$makeWriter$14(JacksonGenerator $this, byte start$1, byte end$1, SpecializedGetters row, int ordinal) {
        String ymString = IntervalUtils$.MODULE$.toYearMonthIntervalString(row.getInt(ordinal), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start$1, end$1);
        $this.gen().writeString(ymString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$15(JacksonGenerator $this, byte start$2, byte end$2, SpecializedGetters row, int ordinal) {
        String dtString = IntervalUtils$.MODULE$.toDayTimeIntervalString(row.getLong(ordinal), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start$2, end$2);
        $this.gen().writeString(dtString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$16(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeBinary(row.getBinary(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$17(JacksonGenerator $this, DecimalType x18$1, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getDecimal(ordinal, x18$1.precision(), x18$1.scale()).toJavaBigDecimal());
    }

    public static final /* synthetic */ Nothing$ $anonfun$makeWriter$27(DataType dataType$1, SpecializedGetters row, int ordinal) {
        Object v = row.get(ordinal, dataType$1);
        throw QueryExecutionErrors$.MODULE$.failToConvertValueToJsonError(v, v.getClass(), dataType$1);
    }

    public JacksonGenerator(DataType dataType, Writer writer, JSONOptions options) {
        this.dataType = dataType;
        this.options = options;
        Predef$.MODULE$.require(dataType instanceof StructType || dataType instanceof MapType || dataType instanceof ArrayType || dataType instanceof VariantType, (Function0 & Serializable)() -> "JacksonGenerator only supports to be initialized with a " + StructType$.MODULE$.simpleString() + ", " + MapType$.MODULE$.simpleString() + ", " + ArrayType$.MODULE$.simpleString() + " or " + VariantType$.MODULE$.simpleString() + " but got " + $this.dataType.catalogString());
        JsonGenerator generator = new JsonFactory().createGenerator(writer).setRootValueSeparator(null);
        Object object = options.pretty() ? generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter(PrettyPrinter.DEFAULT_SEPARATORS.withRootSeparator(""))) : BoxedUnit.UNIT;
        Object object2 = options.writeNonAsciiCharacterAsCodePoint() ? generator.setHighestNonEscapedChar(127) : BoxedUnit.UNIT;
        this.gen = generator;
        this.lineSeparator = options.lineSeparatorInWrite();
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInWrite(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInWrite(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false, true);
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormatInWrite(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
    }
}

