/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.optimizer;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.time.LocalDateTime;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimeZone;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.LocalTimestamp;
import org.apache.spark.sql.catalyst.expressions.Now;
import org.apache.spark.sql.catalyst.optimizer.ComputeCurrentTime$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ComputeCurrentTime$
extends Rule<LogicalPlan> {
    public static final ComputeCurrentTime$ MODULE$ = new ComputeCurrentTime$();

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        Instant instant = Instant.now();
        long currentTimestampMicros = DateTimeUtils$.MODULE$.instantToMicros(instant);
        Literal currentTime = Literal$.MODULE$.create(BoxesRunTime.boxToLong((long)currentTimestampMicros), (DataType)TimestampType$.MODULE$);
        Literal timezone = Literal$.MODULE$.create(this.conf().sessionLocalTimeZone(), (DataType)StringType$.MODULE$);
        HashMap currentDates = HashMap$.MODULE$.empty();
        HashMap localTimestamps = HashMap$.MODULE$.empty();
        return (LogicalPlan)plan2.transformDownWithSubqueriesAndPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)treePatternbits -> BoxesRunTime.boxToBoolean((boolean)ComputeCurrentTime$.org$apache$spark$sql$catalyst$optimizer$ComputeCurrentTime$$transformCondition$1(treePatternbits)), plan2.transformDownWithSubqueriesAndPruning$default$2(), new Serializable(currentDates, currentTimestampMicros, currentTime, timezone, localTimestamps, instant){
            private static final long serialVersionUID = 0L;
            public final HashMap currentDates$1;
            public final long currentTimestampMicros$1;
            public final Literal currentTime$1;
            public final Literal timezone$1;
            public final HashMap localTimestamps$1;
            public final Instant instant$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)A1.transformAllExpressionsWithPruning((Function1 & Serializable)treePatternbits -> BoxesRunTime.boxToBoolean((boolean)anonfun.apply.8.$anonfun$applyOrElse$2(treePatternbits)), A1.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
                    private static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.apply.8 $outer;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof CurrentDate) {
                            CurrentDate currentDate = (CurrentDate)A1;
                            return (B1)this.$outer.currentDates$1.getOrElseUpdate((Object)currentDate.zoneId(), (Function0 & Serializable)() -> Literal$.MODULE$.create(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.microsToDays($this.$outer.currentTimestampMicros$1, currentDate.zoneId())), (DataType)DateType$.MODULE$));
                        }
                        if (A1 instanceof CurrentTimestamp ? true : A1 instanceof Now) {
                            return (B1)this.$outer.currentTime$1;
                        }
                        if (A1 instanceof CurrentTimeZone) {
                            return (B1)this.$outer.timezone$1;
                        }
                        if (A1 instanceof LocalTimestamp) {
                            LocalTimestamp localTimestamp = (LocalTimestamp)A1;
                            return (B1)this.$outer.localTimestamps$1.getOrElseUpdate((Object)localTimestamp.zoneId(), (Function0 & Serializable)() -> {
                                LocalDateTime asDateTime = LocalDateTime.ofInstant($this.$outer.instant$1, localTimestamp.zoneId());
                                return Literal$.MODULE$.create(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(asDateTime)), (DataType)TimestampNTZType$.MODULE$);
                            });
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Expression x1) {
                        Expression expression = x1;
                        if (expression instanceof CurrentDate) {
                            return true;
                        }
                        if (expression instanceof CurrentTimestamp ? true : expression instanceof Now) {
                            return true;
                        }
                        if (expression instanceof CurrentTimeZone) {
                            return true;
                        }
                        return expression instanceof LocalTimestamp;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.optimizer.ComputeCurrentTime$$anonfun$apply$8$$anonfun$applyOrElse$3 org.apache.spark.sql.catalyst.expressions.CurrentDate ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.optimizer.ComputeCurrentTime$$anonfun$apply$8$$anonfun$applyOrElse$3 org.apache.spark.sql.catalyst.expressions.LocalTimestamp )}, serializedLambda);
                    }
                });
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return true;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2(TreePatternBits treePatternbits) {
                return ComputeCurrentTime$.org$apache$spark$sql$catalyst$optimizer$ComputeCurrentTime$$transformCondition$1(treePatternbits);
            }
            {
                this.currentDates$1 = currentDates$1;
                this.currentTimestampMicros$1 = currentTimestampMicros$1;
                this.currentTime$1 = currentTime$1;
                this.timezone$1 = timezone$1;
                this.localTimestamps$1 = localTimestamps$1;
                this.instant$1 = instant$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2$adapted(org.apache.spark.sql.catalyst.trees.TreePatternBits )}, serializedLambda);
            }
        });
    }

    public static final boolean org$apache$spark$sql$catalyst$optimizer$ComputeCurrentTime$$transformCondition$1(TreePatternBits treePatternbits) {
        return treePatternbits.containsPattern(TreePattern$.MODULE$.CURRENT_LIKE());
    }

    private ComputeCurrentTime$() {
    }
}

