/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class StructuredKafkaWordCount$ {
    public static final StructuredKafkaWordCount$ MODULE$ = new StructuredKafkaWordCount$();

    public void main(String[] args) {
        Object object;
        String[] stringArray;
        if (args.length < 3) {
            System.err.println("Usage: StructuredKafkaWordCount <bootstrap-servers> <subscribe-type> <topics> [<checkpoint-location>]");
            System.exit(1);
        }
        if ((stringArray = args) == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) < 0) {
            throw new MatchError((Object)stringArray);
        }
        String bootstrapServers = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        String subscribeType = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        String topics = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
        Tuple3 tuple3 = new Tuple3((Object)bootstrapServers, (Object)subscribeType, (Object)topics);
        String bootstrapServers2 = (String)tuple3._1();
        String subscribeType2 = (String)tuple3._2();
        String topics2 = (String)tuple3._3();
        Object checkpointLocation = args.length > 3 ? args[3] : "/tmp/temporary-" + UUID.randomUUID().toString();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("StructuredKafkaWordCount").getOrCreate();
        Dataset lines = spark.readStream().format("kafka").option("kafka.bootstrap.servers", bootstrapServers2).option(subscribeType2, topics2).load().selectExpr((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(value AS STRING)"})).as(spark.implicits().newStringEncoder());
        Dataset wordCounts = lines.flatMap((Function1 & Serializable)x$2 -> Predef$.MODULE$.wrapRefArray((Object[])x$2.split(" ")), spark.implicits().newStringEncoder()).groupBy("value", (Seq)Nil$.MODULE$).count();
        StreamingQuery query = ((DataStreamWriter)wordCounts.writeStream().outputMode("complete").format("console").option("checkpointLocation", (String)checkpointLocation)).start();
        query.awaitTermination();
    }

    private StructuredKafkaWordCount$() {
    }
}

