/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.artifact;

import jakarta.ws.rs.core.UriBuilder;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Cleaner;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.spark.JobArtifactSet$;
import org.apache.spark.JobArtifactState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.sql.Artifact;
import org.apache.spark.sql.artifact.ArtifactManager$;
import org.apache.spark.sql.artifact.ArtifactManager$SparkContextResourceType$;
import org.apache.spark.sql.artifact.ArtifactStateForCleanup;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.util.ArtifactUtils$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.CacheId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.StubClassLoader$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r5d\u0001\u0002*T\u0001yC\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\u0006y\u0002!\t\" \u0005\f\u0003\u001b\u0001\u0001R1A\u0005\u0002M\u000by\u0001\u0003\u0007\u0002,\u0001\u0001\n\u0011aA!\u0002\u0013\ti\u0003C\u0005\u00026\u0001\u0011\r\u0011\"\u0005T{\"9\u0011q\u0007\u0001!\u0002\u0013q\bBCA\u001d\u0001\t\u0007I\u0011C*\u0002\u0010!A\u00111\b\u0001!\u0002\u0013\t\t\u0002\u0003\u0007\u0002>\u0001\u0001\n\u0011aA!\u0002\u0013\ti\u0003C\u0005\u0002@\u0001\u0011\r\u0011\"\u0005T{\"9\u0011\u0011\t\u0001!\u0002\u0013q\bBCA\"\u0001\t\u0007I\u0011C*\u0002\u0010!A\u0011Q\t\u0001!\u0002\u0013\t\t\u0002\u0003\u0006\u0002H\u0001A)\u0019!C\u0005\u0003\u0013B!\"!\u0015\u0001\u0011\u000b\u0007I\u0011BA%\u0011-\t\u0019\u0006\u0001EC\u0002\u0013EQ+!\u0016\t\u0013\u0005}\u0003A1A\u0005\u0012\u0005\u0005\u0004\u0002CA<\u0001\u0001\u0006I!a\u0019\t\u0013\u0005e\u0004\u00011A\u0005\u0012\u0005m\u0004\"CAE\u0001\u0001\u0007I\u0011CAF\u0011!\t)\n\u0001Q!\n\u0005u\u0004bBAP\u0001\u0011%\u0011\u0011\u0015\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011%\t\u0019\u000e\u0001b\u0001\n#\t)\u000e\u0003\u0005\u0002l\u0002\u0001\u000b\u0011BAl\u0011%\ti\u000f\u0001b\u0001\n#\ty\u000f\u0003\u0005\u0002t\u0002\u0001\u000b\u0011BAy\u0011%\t)\u0010\u0001b\u0001\n#\t9\u0010\u0003\u0005\u0002|\u0002\u0001\u000b\u0011BA}\u0011%\ti\u0010\u0001b\u0001\n#\ty\u0010\u0003\u0005\u0003(\u0002\u0001\u000b\u0011\u0002B\u0001\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005WCqAa3\u0001\t\u0003\u0011i\rC\u0004\u0003R\u0002!IAa5\t\u0013\t\u0015\b!%A\u0005\n\t\u001d\b\"\u0003B\u007f\u0001E\u0005I\u0011\u0002Bt\u0011\u001d\u0011y\u0010\u0001C\u0005\u0007\u0003Aqaa\u0002\u0001\t\u0003\u0019I\u0001C\u0005\u0004\u001c\u0001\t\n\u0011\"\u0001\u0003h\"A1Q\u0004\u0001\u0005\u0002U\u001by\u0002C\u0004\u00040\u0001!\ta!\r\t\u000f\rM\u0002\u0001\"\u0003\u00042!A1Q\u0007\u0001\u0005\u0002U\u001b9\u0004C\u0005\u0004>\u0001\u0011\r\u0011\"\u0003\u0004@!A1\u0011\t\u0001!\u0002\u0013\u0011i\bC\u0004\u0004D\u0001!Ia!\u0012\t\u0013\rU\u0003\u00011A\u0005\n\r\u0015\u0003\"CB,\u0001\u0001\u0007I\u0011BB-\u0011!\u0019i\u0006\u0001Q!\n\r\u001d\u0003bBB0\u0001\u0011%!1\u0012\u0005\b\u0007C\u0002A\u0011\tBF\u0011!\u0019\u0019\u0007\u0001C\u0001+\n-\u0005bBB3\u0001\u0011\u00051qM\u0004\b\u0005\u001f\u0019\u0006\u0012\u0001B\t\r\u0019\u00116\u000b#\u0001\u0003\u0014!1q\u000f\u000fC\u0001\u00057A\u0011B!\b9\u0005\u0004%\tAa\b\t\u0011\t\u0015\u0002\b)A\u0005\u0005CA\u0011Ba\n9\u0005\u0004%\tAa\b\t\u0011\t%\u0002\b)A\u0005\u0005CA!Ba\u000b9\u0011\u000b\u0007I\u0011A*~\u000f!\u0011i\u0003\u000fE\u0001'\n=b\u0001\u0003B\u001aq!\u00051K!\u000e\t\r]\u0004E\u0011\u0001B\u001f\u000b\u0019\u0011y\u0004\u0011\u0001\u0003B!I!\u0011\n!C\u0002\u0013\u0005!1\n\u0005\t\u0005\u001b\u0002\u0005\u0015!\u0003\u0003B!I!q\n!C\u0002\u0013\u0005!1\n\u0005\t\u0005#\u0002\u0005\u0015!\u0003\u0003B!I!1\u000b!C\u0002\u0013\u0005!1\n\u0005\t\u0005+\u0002\u0005\u0015!\u0003\u0003B!I!q\u000b!\u0002\u0002\u0013%!\u0011\f\u0005\b\u00057BD\u0011\u0002B/\r\u0019\u0011\t\b\u000f\u0003\u0003t!Q!1P&\u0003\u0002\u0003\u0006IA! \t\r]\\E\u0011\u0001BB\u0011\u001d\u0011Ii\u0013C!\u0005\u0017C\u0011B!$9\u0005\u0004%IAa$\t\u0011\tu\u0005\b)A\u0005\u0005#CqAa(9\t\u0013\u0011\tKA\bBeRLg-Y2u\u001b\u0006t\u0017mZ3s\u0015\t!V+\u0001\u0005beRLg-Y2u\u0015\t1v+A\u0002tc2T!\u0001W-\u0002\u000bM\u0004\u0018M]6\u000b\u0005i[\u0016AB1qC\u000eDWMC\u0001]\u0003\ry'oZ\u0002\u0001'\u0011\u0001ql\u001a6\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001\u00027b]\u001eT\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002gC\n1qJ\u00196fGR\u0004\"\u0001\u00195\n\u0005%\f'!D!vi>\u001cEn\\:fC\ndW\r\u0005\u0002l]6\tAN\u0003\u0002n/\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002pY\n9Aj\\4hS:<\u0017aB:fgNLwN\u001c\t\u0003eVl\u0011a\u001d\u0006\u0003iV\u000bqa\u00197bgNL7-\u0003\u0002wg\na1\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"\"!_>\u0011\u0005i\u0004Q\"A*\t\u000bA\u0014\u0001\u0019A9\u0002!\u0005\u0014H/\u001b4bGR\u0014vn\u001c;QCRDW#\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u00111\u0017\u000e\\3\u000b\u0007\u0005\u001d1-A\u0002oS>LA!a\u0003\u0002\u0002\t!\u0001+\u0019;i\u0003=\t'\u000f^5gC\u000e$(k\\8u+JKUCAA\t!\u0011\t\u0019\"!\n\u000f\t\u0005U\u0011\u0011\u0005\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D/\u0002\rq\u0012xn\u001c;?\u0015\t\ty\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002$\u0005u\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0005%\"AB*ue&twM\u0003\u0003\u0002$\u0005u\u0011a\u0001=%cA9\u0011qFA\u0019}\u0006EQBAA\u000f\u0013\u0011\t\u0019$!\b\u0003\rQ+\b\u000f\\33\u00031\t'\u000f^5gC\u000e$\b+\u0019;i\u00035\t'\u000f^5gC\u000e$\b+\u0019;iA\u0005Y\u0011M\u001d;jM\u0006\u001cG/\u0016*J\u00031\t'\u000f^5gC\u000e$XKU%!\u0003\rAHEM\u0001\tG2\f7o\u001d#je\u0006I1\r\\1tg\u0012K'\u000fI\u0001\re\u0016\u0004Hn\u00117bgN,&+S\u0001\u000ee\u0016\u0004Hn\u00117bgN,&+\u0013\u0011\u0002-\u0005dw/Y=t\u0003B\u0004H._\"mCN\u001cHj\\1eKJ,\"!a\u0013\u0011\t\u0005=\u0012QJ\u0005\u0005\u0003\u001f\niBA\u0004C_>dW-\u00198\u0002\u001fM,7o]5p]&\u001bx\u000e\\1uK\u0012\fQa\u001d;bi\u0016,\"!a\u0016\u0011\t\u0005e\u00131L\u0007\u0002/&\u0019\u0011QL,\u0003!){'-\u0011:uS\u001a\f7\r^*uCR,\u0017\u0001F:fgNLwN\\!si&4\u0017m\u0019;BI\u0012,G-\u0006\u0002\u0002dA!\u0011QMA:\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014AB1u_6L7M\u0003\u0003\u0002n\u0005=\u0014AC2p]\u000e,(O]3oi*\u0019\u0011\u0011O2\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003k\n9GA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u0016g\u0016\u001c8/[8o\u0003J$\u0018NZ1di\u0006#G-\u001a3!\u0003E\u0019\u0017m\u00195fI\u000ec\u0017m]:M_\u0006$WM]\u000b\u0003\u0003{\u0002b!a\f\u0002\u0000\u0005\r\u0015\u0002BAA\u0003;\u0011aa\u00149uS>t\u0007c\u00011\u0002\u0006&\u0019\u0011qQ1\u0003\u0017\rc\u0017m]:M_\u0006$WM]\u0001\u0016G\u0006\u001c\u0007.\u001a3DY\u0006\u001c8\u000fT8bI\u0016\u0014x\fJ3r)\u0011\ti)a%\u0011\t\u0005=\u0012qR\u0005\u0005\u0003#\u000biB\u0001\u0003V]&$\b\"CA\u0016+\u0005\u0005\t\u0019AA?\u0003I\u0019\u0017m\u00195fI\u000ec\u0017m]:M_\u0006$WM\u001d\u0011)\u0007Y\tI\n\u0005\u0003\u00020\u0005m\u0015\u0002BAO\u0003;\u0011\u0001B^8mCRLG.Z\u0001\u0018o&$\bn\u00117bgNdu.\u00193fe&3g*Z3eK\u0012,B!a)\u0002*R!\u0011QUA^!\u0011\t9+!+\r\u0001\u00119\u00111V\fC\u0002\u00055&!\u0001+\u0012\t\u0005=\u0016Q\u0017\t\u0005\u0003_\t\t,\u0003\u0003\u00024\u0006u!a\u0002(pi\"Lgn\u001a\t\u0005\u0003_\t9,\u0003\u0003\u0002:\u0006u!aA!os\"A\u0011QX\f\u0005\u0002\u0004\ty,A\u0001g!\u0019\ty#!1\u0002&&!\u00111YA\u000f\u0005!a$-\u001f8b[\u0016t\u0014!D<ji\"\u0014Vm]8ve\u000e,7/\u0006\u0003\u0002J\u00065G\u0003BAf\u0003\u001f\u0004B!a*\u0002N\u00129\u00111\u0016\rC\u0002\u00055\u0006\u0002CA_1\u0011\u0005\r!!5\u0011\r\u0005=\u0012\u0011YAf\u0003E\u0019\u0017m\u00195fI\ncwnY6JI2K7\u000f^\u000b\u0003\u0003/\u0004b!!7\u0002\\\u0006}WBAA6\u0013\u0011\ti.a\u001b\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u!\u0011\t\t/a:\u000e\u0005\u0005\r(bAAs/\u000691\u000f^8sC\u001e,\u0017\u0002BAu\u0003G\u0014qaQ1dQ\u0016LE-\u0001\ndC\u000eDW\r\u001a\"m_\u000e\\\u0017\n\u001a'jgR\u0004\u0013\u0001\u00036beNd\u0015n\u001d;\u0016\u0005\u0005E\b#BAm\u00037t\u0018!\u00036beNd\u0015n\u001d;!\u0003E\u0001\u0018\u0010\u001e5p]&s7\r\\;eK2K7\u000f^\u000b\u0003\u0003s\u0004b!!7\u0002\\\u0006E\u0011A\u00059zi\"|g.\u00138dYV$W\rT5ti\u0002\n\u0011d\u001d9be.\u001cuN\u001c;fqR\u0014V\r\\1uSZ,\u0007+\u0019;igV\u0011!\u0011\u0001\t\u0007\u00033\fYNa\u0001\u0011\u0013\u0005=\"Q\u0001B\u0005}\n\u0015\u0016\u0002\u0002B\u0004\u0003;\u0011a\u0001V;qY\u0016\u001c\u0004c\u0001B\u0006\u0005:\u0019!QB \u000f\u0005i<\u0014aD!si&4\u0017m\u0019;NC:\fw-\u001a:\u0011\u0005iD4\u0003\u0002\u001d\u0003\u0016)\u0004B!a\f\u0003\u0018%!!\u0011DA\u000f\u0005\u0019\te.\u001f*fMR\u0011!\u0011C\u0001\u0012M>\u0014x/\u0019:e)>45\u000b\u0015:fM&DXC\u0001B\u0011!\r\u0001'1E\u0005\u0004\u0003O\t\u0017A\u00054pe^\f'\u000f\u001a+p\rN\u0003&/\u001a4jq\u0002\n\u0011$\u0011*U\u0013\u001a\u000b5\tV0E\u0013J+5\tV(S3~\u0003&+\u0012$J1\u0006Q\u0012I\u0015+J\r\u0006\u001bEk\u0018#J%\u0016\u001bEk\u0014*Z?B\u0013VIR%YA\u0005)\u0012M\u001d;jM\u0006\u001cGOU8pi\u0012K'/Z2u_JL\u0018\u0001G*qCJ\\7i\u001c8uKb$(+Z:pkJ\u001cW\rV=qKB\u0019!\u0011\u0007!\u000e\u0003a\u0012\u0001d\u00159be.\u001cuN\u001c;fqR\u0014Vm]8ve\u000e,G+\u001f9f'\r\u0001%q\u0007\t\u0005\u0003_\u0011I$\u0003\u0003\u0003<\u0005u!aC#ok6,'/\u0019;j_:$\"Aa\f\u0003\u0019I+7o\\;sG\u0016$\u0016\u0010]3\u0011\t\t\r#QI\u0007\u0002\u0001&!!q\tB\u001d\u0005\u00151\u0016\r\\;f\u0003\rQ\u0015IU\u000b\u0003\u0005\u0003\nAAS!SA\u0005!a)\u0013'F\u0003\u00151\u0015\nT#!\u0003\u001d\t%k\u0011%J-\u0016\u000b\u0001\"\u0011*D\u0011&3V\tI\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002?\u0006I1m\u001c9z\u00052|7m\u001b\u000b\t\u0003?\u0014yFa\u0019\u0003h!9!\u0011\r&A\u0002\u0005}\u0017A\u00024s_6LE\rC\u0004\u0003f)\u0003\r!a8\u0002\tQ|\u0017\n\u001a\u0005\b\u0005SR\u0005\u0019\u0001B6\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s!\u0011\t\tO!\u001c\n\t\t=\u00141\u001d\u0002\r\u00052|7m['b]\u0006<WM\u001d\u0002\u0013'R\fG/Z\"mK\u0006tW\u000f\u001d*v]:,'o\u0005\u0003L?\nU\u0004c\u00011\u0003x%\u0019!\u0011P1\u0003\u0011I+hN\\1cY\u0016\fAb\u00197fC:,\bo\u0015;bi\u0016\u00042A\u001fB@\u0013\r\u0011\ti\u0015\u0002\u0018\u0003J$\u0018NZ1diN#\u0018\r^3G_J\u001cE.Z1okB$BA!\"\u0003\bB\u0019!\u0011G&\t\u000f\tmT\n1\u0001\u0003~\u0005\u0019!/\u001e8\u0015\u0005\u00055\u0015aB2mK\u0006tWM]\u000b\u0003\u0005#\u0003BAa%\u0003\u001a6\u0011!Q\u0013\u0006\u0004\u0005/\u000b\u0017a\u0001:fM&!!1\u0014BK\u0005\u001d\u0019E.Z1oKJ\f\u0001b\u00197fC:,'\u000fI\u0001\u0017G2,\u0017M\\+q\u000f2|'-\u00197SKN|WO]2fgR!\u0011Q\u0012BR\u0011\u001d\u0011Y(\u0015a\u0001\u0005{\u0002b!a\f\u0002\u0000\u0005E\u0011AG:qCJ\\7i\u001c8uKb$(+\u001a7bi&4X\rU1uQN\u0004\u0013\u0001D4fi\u0006#G-\u001a3KCJ\u001cXC\u0001BW!\u0019\u0011yK!/\u0003@:!!\u0011\u0017B[\u001d\u0011\t9Ba-\n\u0005\u0005}\u0011\u0002\u0002B\\\u0003;\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003<\nu&aA*fc*!!qWA\u000f!\u0011\u0011\tMa2\u000e\u0005\t\r'b\u0001BcG\u0006\u0019a.\u001a;\n\t\t%'1\u0019\u0002\u0004+Jc\u0015!E4fiBKH\u000f[8o\u0013:\u001cG.\u001e3fgV\u0011!q\u001a\t\u0007\u0005_\u0013I,!\u0005\u0002\u0019Q\u0014\u0018M\\:gKJ4\u0015\u000e\\3\u0015\u0015\u00055%Q\u001bBm\u0005;\u0014\t\u000f\u0003\u0004\u0003X\u000e\u0002\rA`\u0001\u0007g>,(oY3\t\r\tm7\u00051\u0001\u007f\u0003\u0019!\u0018M]4fi\"I!q\\\u0012\u0011\u0002\u0003\u0007\u00111J\u0001\u000fC2dwn^(wKJ<(/\u001b;f\u0011%\u0011\u0019o\tI\u0001\u0002\u0004\tY%\u0001\u0007eK2,G/Z*pkJ\u001cW-\u0001\fue\u0006t7OZ3s\r&dW\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011IO\u000b\u0003\u0002L\t-8F\u0001Bw!\u0011\u0011yO!?\u000e\u0005\tE(\u0002\u0002Bz\u0005k\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\t]\u0018QD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B~\u0005c\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y!(/\u00198tM\u0016\u0014h)\u001b7fI\u0011,g-Y;mi\u0012\"\u0014!\u00048pe6\fG.\u001b>f!\u0006$\b\u000eF\u0002\u007f\u0007\u0007Aaa!\u0002'\u0001\u0004q\u0018\u0001\u00029bi\"\f1\"\u00193e\u0003J$\u0018NZ1diRQ\u0011QRB\u0006\u0007\u001f\u0019\u0019ba\u0006\t\r\r5q\u00051\u0001\u007f\u0003I\u0011X-\\8uKJ+G.\u0019;jm\u0016\u0004\u0016\r\u001e5\t\r\rEq\u00051\u0001\u007f\u0003Y\u0019XM\u001d<fe2{7-\u00197Ti\u0006<\u0017N\\4QCRD\u0007bBB\u000bO\u0001\u0007!QU\u0001\tMJ\fw-\\3oi\"I1\u0011D\u0014\u0011\u0002\u0003\u0007\u00111J\u0001\u0011I\u0016dW\r^3Ti\u0006<W\r\u001a$jY\u0016\fQ#\u00193e\u0003J$\u0018NZ1di\u0012\"WMZ1vYR$C'A\tbI\u0012dunY1m\u0003J$\u0018NZ1diN$B!!$\u0004\"!911E\u0015A\u0002\r\u0015\u0012!C1si&4\u0017m\u0019;t!\u0019\u0011yK!/\u0004(A!1\u0011FB\u0016\u001b\u0005)\u0016bAB\u0017+\nA\u0011I\u001d;jM\u0006\u001cG/A\u0006dY\u0006\u001c8\u000f\\8bI\u0016\u0014XCAAB\u0003A\u0011W/\u001b7e\u00072\f7o\u001d'pC\u0012,'/A\u0003dY>tW\rF\u0002z\u0007sAaaa\u000f-\u0001\u0004\t\u0018A\u00038foN+7o]5p]\u0006q2\r\\3b]V\u00038\u000b^1uK\u001a{'o\u00127pE\u0006d'+Z:pkJ\u001cWm]\u000b\u0003\u0005{\nqd\u00197fC:,\u0006o\u0015;bi\u00164uN]$m_\n\fGNU3t_V\u00148-Z:!\u000319W\r^\"mK\u0006t\u0017M\u00197f+\t\u00199\u0005\u0005\u0003\u0004J\r=c\u0002\u0002BJ\u0007\u0017JAa!\u0014\u0003\u0016\u000691\t\\3b]\u0016\u0014\u0018\u0002BB)\u0007'\u0012\u0011b\u00117fC:\f'\r\\3\u000b\t\r5#QS\u0001\nG2,\u0017M\\1cY\u0016\fQb\u00197fC:\f'\r\\3`I\u0015\fH\u0003BAG\u00077B\u0011\"a\u000b2\u0003\u0003\u0005\raa\u0012\u0002\u0015\rdW-\u00198bE2,\u0007%\u0001\tdY\u0016\fg.\u00169SKN|WO]2fg\u0006)1\r\\8tK\u0006Q2\r\\3b]V\u0003(+Z:pkJ\u001cWm\u001d$peR+7\u000f^5oO\u0006\u0011R\u000f\u001d7pC\u0012\f%\u000f^5gC\u000e$Hk\u001c$t)\u0019\tii!\u001b\u0004l!11Q\u0002\u001cA\u0002yDaa!\u00057\u0001\u0004q\b")
public class ArtifactManager
implements AutoCloseable,
Logging {
    private String artifactRootURI;
    private boolean alwaysApplyClassLoader;
    private boolean sessionIsolated;
    private JobArtifactState state;
    private final SparkSession session;
    private final /* synthetic */ Tuple2 x$1;
    private final Path artifactPath;
    private final String artifactURI;
    private final /* synthetic */ Tuple2 x$2;
    private final Path classDir;
    private final String replClassURI;
    private final AtomicBoolean sessionArtifactAdded;
    private volatile Option<ClassLoader> cachedClassLoader;
    private final CopyOnWriteArrayList<CacheId> cachedBlockIdList;
    private final CopyOnWriteArrayList<Path> jarsList;
    private final CopyOnWriteArrayList<String> pythonIncludeList;
    private final CopyOnWriteArrayList<Tuple3<Enumeration.Value, Path, Option<String>>> sparkContextRelativePaths;
    private final ArtifactStateForCleanup cleanUpStateForGlobalResources;
    private Cleaner.Cleanable cleanable;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String ARTIFACT_DIRECTORY_PREFIX() {
        return ArtifactManager$.MODULE$.ARTIFACT_DIRECTORY_PREFIX();
    }

    public static String forwardToFSPrefix() {
        return ArtifactManager$.MODULE$.forwardToFSPrefix();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Path artifactRootPath() {
        return ArtifactManager$.MODULE$.artifactRootDirectory();
    }

    private String artifactRootURI$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.artifactRootURI = SparkEnv$.MODULE$.get().rpcEnv().fileServer().addDirectoryIfAbsent(ArtifactManager$.MODULE$.ARTIFACT_DIRECTORY_PREFIX(), this.artifactRootPath().toFile());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.artifactRootURI;
    }

    public String artifactRootURI() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.artifactRootURI$lzycompute();
        }
        return this.artifactRootURI;
    }

    public Path artifactPath() {
        return this.artifactPath;
    }

    public String artifactURI() {
        return this.artifactURI;
    }

    public Path classDir() {
        return this.classDir;
    }

    public String replClassURI() {
        return this.replClassURI;
    }

    private boolean alwaysApplyClassLoader$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.alwaysApplyClassLoader = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.session.conf().get(SQLConf$.MODULE$.ARTIFACTS_SESSION_ISOLATION_ALWAYS_APPLY_CLASSLOADER().key())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.alwaysApplyClassLoader;
    }

    private boolean alwaysApplyClassLoader() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.alwaysApplyClassLoader$lzycompute();
        }
        return this.alwaysApplyClassLoader;
    }

    private boolean sessionIsolated$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sessionIsolated = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(this.session.conf().get(SQLConf$.MODULE$.ARTIFACTS_SESSION_ISOLATION_ENABLED().key())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sessionIsolated;
    }

    private boolean sessionIsolated() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sessionIsolated$lzycompute();
        }
        return this.sessionIsolated;
    }

    private JobArtifactState state$lzycompute() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.state = this.sessionIsolated() ? new JobArtifactState(this.session.sessionUUID(), (Option)new Some((Object)this.replClassURI())) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.state;
    }

    public JobArtifactState state() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.state$lzycompute();
        }
        return this.state;
    }

    public AtomicBoolean sessionArtifactAdded() {
        return this.sessionArtifactAdded;
    }

    public Option<ClassLoader> cachedClassLoader() {
        return this.cachedClassLoader;
    }

    public void cachedClassLoader_$eq(Option<ClassLoader> x$1) {
        this.cachedClassLoader = x$1;
    }

    private <T> T withClassLoaderIfNeeded(Function0<T> f) {
        String log = " classloader for session " + this.session.sessionUUID() + " because alwaysApplyClassLoader=" + this.alwaysApplyClassLoader() + ", sessionArtifactAdded=" + this.sessionArtifactAdded().get() + ".";
        if (this.alwaysApplyClassLoader() || this.sessionArtifactAdded().get()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Applying " + log);
            return (T)Utils$.MODULE$.withContextClassLoader(this.classloader(), f);
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Not applying " + log);
        return (T)f.apply();
    }

    public <T> T withResources(Function0<T> f) {
        return this.withClassLoaderIfNeeded((Function0 & Serializable)() -> JobArtifactSet$.MODULE$.withActiveJobArtifactState(this.state(), f));
    }

    public CopyOnWriteArrayList<CacheId> cachedBlockIdList() {
        return this.cachedBlockIdList;
    }

    public CopyOnWriteArrayList<Path> jarsList() {
        return this.jarsList;
    }

    public CopyOnWriteArrayList<String> pythonIncludeList() {
        return this.pythonIncludeList;
    }

    public CopyOnWriteArrayList<Tuple3<Enumeration.Value, Path, Option<String>>> sparkContextRelativePaths() {
        return this.sparkContextRelativePaths;
    }

    public Seq<URL> getAddedJars() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jarsList()).asScala().map((Function1 & Serializable)x$3 -> ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), x$3))).map((Function1 & Serializable)x$4 -> x$4.toUri().toURL())).toSeq();
    }

    public Seq<String> getPythonIncludes() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.pythonIncludeList()).asScala().toSeq();
    }

    private void transferFile(Path source, Path target, boolean allowOverwrite, boolean deleteSource) {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        if (allowOverwrite) {
            ArtifactManager.execute$1(source, target, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING}), deleteSource);
            return;
        }
        ArtifactManager.execute$1(source, target, (Seq)Nil$.MODULE$, deleteSource);
    }

    private boolean transferFile$default$3() {
        return false;
    }

    private boolean transferFile$default$4() {
        return true;
    }

    private Path normalizePath(Path path) {
        String normalizedPathString = ((Object)path).toString().replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return Paths.get(normalizedPathString, new String[0]).normalize();
    }

    public void addArtifact(Path remoteRelativePath, Path serverLocalStagingPath, Option<String> fragment, boolean deleteStagedFile) {
        Object object = new Object();
        try {
            JobArtifactSet$.MODULE$.withActiveJobArtifactState(this.state(), (Function0 & Serializable)() -> {
                Predef$.MODULE$.require(!remoteRelativePath.isAbsolute());
                Path normalizedRemoteRelativePath = this.normalizePath(remoteRelativePath);
                if (normalizedRemoteRelativePath.startsWith("cache" + File.separator)) {
                    File tmpFile = serverLocalStagingPath.toFile();
                    JFunction0.mcZ.sp & Serializable x$12 = (JFunction0.mcZ.sp & Serializable)() -> {
                        BlockManager blockManager = $this.session.sparkContext().env().blockManager();
                        CacheId blockId = new CacheId($this.session.sessionUUID(), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)normalizedRemoteRelativePath).toString()), "cache" + File.separator));
                        BlockManager.TempFileBasedBlockStoreUpdater updater = new BlockManager.TempFileBasedBlockStoreUpdater(blockManager, (BlockId)blockId, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), tmpFile, tmpFile.length(), false, blockManager.TempFileBasedBlockStoreUpdater().apply$default$7());
                        updater.save();
                        return this.cachedBlockIdList().add(blockId);
                    };
                    JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> tmpFile.delete();
                    JFunction0.mcV.sp & Serializable x$3 = () -> ArtifactManager.$anonfun$addArtifact$4((Function0)x$12);
                    return Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$12, (Function0)x$3, (Function0)x$2);
                }
                if (normalizedRemoteRelativePath.startsWith("classes" + File.separator)) {
                    Path target = ArtifactUtils$.MODULE$.concatenatePaths(this.classDir(), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)normalizedRemoteRelativePath).toString()), "classes" + File.separator));
                    this.transferFile(serverLocalStagingPath, target, true, deleteStagedFile);
                    this.sessionArtifactAdded().set(true);
                    this.cachedClassLoader_$eq((Option<ClassLoader>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                Path target = ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), normalizedRemoteRelativePath);
                if (Files.exists(target, new LinkOption[0])) {
                    if (FileUtils.contentEquals((File)target.toFile(), (File)serverLocalStagingPath.toFile())) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    throw new SparkRuntimeException("ARTIFACT_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"normalizedRemoteRelativePath"), (Object)((Object)normalizedRemoteRelativePath).toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
                }
                Path x$4 = serverLocalStagingPath;
                Path x$5 = target;
                boolean x$6 = deleteStagedFile;
                boolean x$7 = this.transferFile$default$3();
                this.transferFile(x$4, x$5, x$7, x$6);
                String uri = this.artifactURI() + "/" + Utils$.MODULE$.encodeRelativeUnixPathToURIRawPath(FilenameUtils.separatorsToUnix((String)((Object)normalizedRemoteRelativePath).toString()));
                if (normalizedRemoteRelativePath.startsWith("jars" + File.separator)) {
                    $this.session.sparkContext().addJar(uri);
                    this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.JAR(), (Object)normalizedRemoteRelativePath, (Object)fragment));
                    this.jarsList().add(normalizedRemoteRelativePath);
                    this.sessionArtifactAdded().set(true);
                    this.cachedClassLoader_$eq((Option<ClassLoader>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                if (normalizedRemoteRelativePath.startsWith("pyfiles" + File.separator)) {
                    $this.session.sparkContext().addFile(uri);
                    this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.FILE(), (Object)normalizedRemoteRelativePath, (Object)fragment));
                    String stringRemotePath = ((Object)normalizedRemoteRelativePath).toString();
                    if (stringRemotePath.endsWith(".zip") || stringRemotePath.endsWith(".egg") || stringRemotePath.endsWith(".jar")) {
                        return BoxesRunTime.boxToBoolean((boolean)this.pythonIncludeList().add(((Object)target.getFileName()).toString()));
                    }
                    return BoxedUnit.UNIT;
                }
                if (normalizedRemoteRelativePath.startsWith("archives" + File.separator)) {
                    UriBuilder uriBuilder = Utils$.MODULE$.getUriBuilder(new URI(uri));
                    Object canonicalUri = fragment.map((Function1 & Serializable)x$1 -> uriBuilder.fragment(x$1)).getOrElse((Function0 & Serializable)() -> new URI(uri));
                    $this.session.sparkContext().addArchive(canonicalUri.toString());
                    return BoxesRunTime.boxToBoolean((boolean)this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.ARCHIVE(), (Object)normalizedRemoteRelativePath, (Object)fragment)));
                }
                if (normalizedRemoteRelativePath.startsWith("files" + File.separator)) {
                    $this.session.sparkContext().addFile(uri);
                    return BoxesRunTime.boxToBoolean((boolean)this.sparkContextRelativePaths().add((Tuple3<Enumeration.Value, Path, Option<String>>)new Tuple3((Object)ArtifactManager$SparkContextResourceType$.MODULE$.FILE(), (Object)normalizedRemoteRelativePath, (Object)fragment)));
                }
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public boolean addArtifact$default$4() {
        return true;
    }

    public void addLocalArtifacts(Seq<Artifact> artifacts) {
        artifacts.foreach((Function1 & Serializable)artifact -> {
            ArtifactManager.$anonfun$addLocalArtifacts$1(this, artifact);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized ClassLoader classloader() {
        return (ClassLoader)this.cachedClassLoader().getOrElse((Function0 & Serializable)() -> {
            ClassLoader loader = this.buildClassLoader();
            this.cachedClassLoader_$eq((Option<ClassLoader>)new Some((Object)loader));
            return loader;
        });
    }

    private ClassLoader buildClassLoader() {
        URL[] urls = (URL[])((IterableOnceOps)this.getAddedJars().$colon$plus((Object)this.classDir().toUri().toURL())).toArray(ClassTag$.MODULE$.apply(URL.class));
        Seq prefixes = (Seq)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.CONNECT_SCALA_UDF_STUB_PREFIXES());
        boolean userClasspathFirst = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST()));
        NonClosableMutableURLClassLoader fallbackClassLoader = this.session.sharedState().jarClassLoader();
        Object loader = prefixes.nonEmpty() ? (userClasspathFirst ? new ChildFirstURLClassLoader(urls, (ClassLoader)StubClassLoader$.MODULE$.apply((ClassLoader)((Object)fallbackClassLoader), prefixes)) : new ChildFirstURLClassLoader(urls, (ClassLoader)StubClassLoader$.MODULE$.apply(null, prefixes), (ClassLoader)((Object)fallbackClassLoader))) : (userClasspathFirst ? new ChildFirstURLClassLoader(urls, (ClassLoader)((Object)fallbackClassLoader)) : new URLClassLoader(urls, (ClassLoader)((Object)fallbackClassLoader)));
        this.logDebug((Function0<String>)((Function0 & Serializable)() -> ArtifactManager.$anonfun$buildClassLoader$1((URLClassLoader)loader, urls)));
        return loader;
    }

    public ArtifactManager clone(SparkSession newSession) {
        SparkContext sparkContext = this.session.sparkContext();
        ArtifactManager newArtifactManager = new ArtifactManager(newSession);
        if (this.artifactPath().toFile().exists()) {
            FileUtils.copyDirectory((File)this.artifactPath().toFile(), (File)newArtifactManager.artifactPath().toFile());
        }
        BlockManager blockManager = sparkContext.env().blockManager();
        Buffer newBlockIds = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.cachedBlockIdList()).asScala().map((Function1 & Serializable)blockId -> {
            CacheId newBlockId = blockId.copy(newSession.sessionUUID(), blockId.copy$default$2());
            return ArtifactManager$.MODULE$.org$apache$spark$sql$artifact$ArtifactManager$$copyBlock((CacheId)blockId, newBlockId, blockManager);
        });
        JobArtifactSet$.MODULE$.withActiveJobArtifactState(newArtifactManager.state(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.sparkContextRelativePaths().forEach((Consumer<Tuple3<Enumeration.Value, Path, Option<String>>>)((Consumer<Tuple3>)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                Enumeration.Value resourceType = (Enumeration.Value)tuple3._1();
                Path relativePath = (Path)tuple3._2();
                Option fragment = (Option)tuple3._3();
                String uri = newArtifactManager.artifactURI() + "/" + Utils$.MODULE$.encodeRelativeUnixPathToURIRawPath(FilenameUtils.separatorsToUnix((String)((Object)relativePath).toString()));
                Enumeration.Value value = resourceType;
                Enumeration.Value value2 = ArtifactManager$SparkContextResourceType$.MODULE$.JAR();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    sparkContext.addJar(uri);
                } else {
                    Enumeration.Value value4 = ArtifactManager$SparkContextResourceType$.MODULE$.FILE();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        sparkContext.addFile(uri);
                    } else {
                        Enumeration.Value value6 = ArtifactManager$SparkContextResourceType$.MODULE$.ARCHIVE();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            UriBuilder uriBuilder = Utils$.MODULE$.getUriBuilder(new URI(uri));
                            Object canonicalUri = fragment.map((Function1 & Serializable)x$1 -> uriBuilder.fragment(x$1)).getOrElse((Function0 & Serializable)() -> new URI(uri));
                            sparkContext.addArchive(canonicalUri.toString());
                        } else {
                            throw SparkException$.MODULE$.internalError("Unsupported resource type: " + resourceType);
                        }
                    }
                }
                return;
            }
            throw new MatchError((Object)tuple3);
        })));
        newArtifactManager.cachedBlockIdList().addAll(CollectionConverters$.MODULE$.BufferHasAsJava(newBlockIds).asJava());
        newArtifactManager.jarsList().addAll(this.jarsList());
        newArtifactManager.pythonIncludeList().addAll(this.pythonIncludeList());
        newArtifactManager.sparkContextRelativePaths().addAll(this.sparkContextRelativePaths());
        return newArtifactManager;
    }

    private ArtifactStateForCleanup cleanUpStateForGlobalResources() {
        return this.cleanUpStateForGlobalResources;
    }

    private Cleaner.Cleanable getCleanable() {
        return ArtifactManager$.MODULE$.org$apache$spark$sql$artifact$ArtifactManager$$cleaner().register(this, new StateCleanupRunner(this.cleanUpStateForGlobalResources()));
    }

    private Cleaner.Cleanable cleanable() {
        return this.cleanable;
    }

    private void cleanable_$eq(Cleaner.Cleanable x$1) {
        this.cleanable = x$1;
    }

    private void cleanUpResources() {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Cleaning up resources for session with sessionUUID " + $this.session.sessionUUID());
        this.cleanable().clean();
        this.jarsList().clear();
        this.pythonIncludeList().clear();
        this.cachedBlockIdList().clear();
        this.sparkContextRelativePaths().clear();
        this.cachedClassLoader_$eq((Option<ClassLoader>)None$.MODULE$);
    }

    @Override
    public void close() {
        this.cleanUpResources();
    }

    public void cleanUpResourcesForTesting() {
        this.cleanUpResources();
        this.cleanable_$eq(this.getCleanable());
    }

    public void uploadArtifactToFs(Path remoteRelativePath, Path serverLocalStagingPath) {
        boolean allowDestLocalConf;
        Path normalizedRemoteRelativePath = this.normalizePath(remoteRelativePath);
        Configuration hadoopConf = this.session.sparkContext().hadoopConfiguration();
        Predef$.MODULE$.assert(normalizedRemoteRelativePath.startsWith(ArtifactManager$.MODULE$.forwardToFSPrefix() + File.separator));
        org.apache.hadoop.fs.Path destFSPath = new org.apache.hadoop.fs.Path(((Object)Paths.get(File.separator, new String[0]).resolve(normalizedRemoteRelativePath.subpath(1, normalizedRemoteRelativePath.getNameCount()))).toString());
        Path localPath = serverLocalStagingPath;
        FileSystem fs = destFSPath.getFileSystem(hadoopConf);
        if (fs instanceof LocalFileSystem && !(allowDestLocalConf = BoxesRunTime.unboxToBoolean((Object)this.session.sessionState().conf().getConf(SQLConf$.MODULE$.ARTIFACT_COPY_FROM_LOCAL_TO_FS_ALLOW_DEST_LOCAL()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.session.conf().get("spark.connect.copyFromLocalToFs.allowDestLocal").contains("true"))))) {
            throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3161");
        }
        fs.copyFromLocalFile(false, true, new org.apache.hadoop.fs.Path(((Object)localPath).toString()), destFSPath);
    }

    private static final Path execute$1(Path s, Path t, Seq opt, boolean deleteSource$1) {
        if (deleteSource$1) {
            return Files.move(s, t, (CopyOption[])opt.toArray(ClassTag$.MODULE$.apply(CopyOption.class)));
        }
        return Files.copy(s, t, (CopyOption[])opt.toArray(ClassTag$.MODULE$.apply(CopyOption.class)));
    }

    public static final /* synthetic */ void $anonfun$addArtifact$4(Function0 x$1$1) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$2(x$1$1);
    }

    public static final /* synthetic */ void $anonfun$addLocalArtifacts$4(Function0 x$1$2) {
        Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$2(x$1$2);
    }

    public static final /* synthetic */ void $anonfun$addLocalArtifacts$1(ArtifactManager $this, Artifact artifact) {
        Artifact.LocalData localData = artifact.storage();
        if (localData instanceof Artifact.LocalFile) {
            Artifact.LocalFile localFile = (Artifact.LocalFile)localData;
            $this.addArtifact(artifact.path(), localFile.path(), (Option<String>)None$.MODULE$, false);
            return;
        }
        if (localData instanceof Artifact.InMemory) {
            Artifact.InMemory inMemory = (Artifact.InMemory)localData;
            Path tempDir = Utils$.MODULE$.createTempDir().toPath();
            Path tempFile = tempDir.resolve(artifact.path().getFileName());
            OutputStream outStream = Files.newOutputStream(tempFile, new OpenOption[0]);
            JFunction0.mcV.sp & Serializable x$1 = (JFunction0.mcV.sp & Serializable)() -> {
                inMemory.stream().transferTo(outStream);
                $this.addArtifact(artifact.path(), tempFile, (Option<String>)None$.MODULE$, $this.addArtifact$default$4());
            };
            JFunction0.mcV.sp & Serializable x$2 = (JFunction0.mcV.sp & Serializable)() -> outStream.close();
            JFunction0.mcV.sp & Serializable x$3 = () -> ArtifactManager.$anonfun$addLocalArtifacts$4((Function0)x$1);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$1, (Function0)x$3, (Function0)x$2);
            return;
        }
        throw SparkException$.MODULE$.internalError("Unsupported artifact storage: " + artifact.storage());
    }

    public static final /* synthetic */ String $anonfun$buildClassLoader$1(URLClassLoader loader$1, URL[] urls$1) {
        return "Using class loader: " + loader$1 + ", containing urls: " + urls$1;
    }

    public ArtifactManager(SparkSession session) {
        this.session = session;
        Logging.$init$((Logging)this);
        Tuple2 tuple2 = new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(this.artifactRootPath(), session.sessionUUID()), (Object)(this.artifactRootURI() + "/" + session.sessionUUID()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path artifactPath = (Path)tuple2._1();
        String artifactURI = (String)tuple2._2();
        this.x$1 = new Tuple2((Object)artifactPath, (Object)artifactURI);
        this.artifactPath = (Path)this.x$1._1();
        this.artifactURI = (String)this.x$1._2();
        Tuple2 tuple22 = new Tuple2((Object)ArtifactUtils$.MODULE$.concatenatePaths(this.artifactPath(), "classes"), (Object)(this.artifactURI() + "/classes/"));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Path classDir = (Path)tuple22._1();
        String replClassURI = (String)tuple22._2();
        this.x$2 = new Tuple2((Object)classDir, (Object)replClassURI);
        this.classDir = (Path)this.x$2._1();
        this.replClassURI = (String)this.x$2._2();
        this.sessionArtifactAdded = new AtomicBoolean(false);
        this.cachedClassLoader = None$.MODULE$;
        this.cachedBlockIdList = new CopyOnWriteArrayList();
        this.jarsList = new CopyOnWriteArrayList();
        this.pythonIncludeList = new CopyOnWriteArrayList();
        this.sparkContextRelativePaths = new CopyOnWriteArrayList();
        this.cleanUpStateForGlobalResources = new ArtifactStateForCleanup(session.sessionUUID(), session.sparkContext(), this.state(), this.artifactPath());
        this.cleanable = this.getCleanable();
    }

    private static class StateCleanupRunner
    implements Runnable {
        private final ArtifactStateForCleanup cleanupState;

        @Override
        public void run() {
            ArtifactManager$.MODULE$.org$apache$spark$sql$artifact$ArtifactManager$$cleanUpGlobalResources(this.cleanupState);
        }

        public StateCleanupRunner(ArtifactStateForCleanup cleanupState) {
            this.cleanupState = cleanupState;
        }
    }
}

