/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.geospatial;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class BoundingBox {
    private double xMin = Double.POSITIVE_INFINITY;
    private double xMax = Double.NEGATIVE_INFINITY;
    private double yMin = Double.POSITIVE_INFINITY;
    private double yMax = Double.NEGATIVE_INFINITY;
    private double zMin = Double.POSITIVE_INFINITY;
    private double zMax = Double.NEGATIVE_INFINITY;
    private double mMin = Double.POSITIVE_INFINITY;
    private double mMax = Double.NEGATIVE_INFINITY;
    private boolean valid = true;

    public BoundingBox() {
    }

    public BoundingBox(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, double mMin, double mMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.zMin = zMin;
        this.zMax = zMax;
        this.mMin = mMin;
        this.mMax = mMax;
        this.valid = this.isXYValid();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BoundingBox)) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (obj == this) {
            return true;
        }
        return this.xMin == other.xMin && this.xMax == other.xMax && this.yMin == other.yMin && this.yMax == other.yMax && this.zMin == other.zMin && this.zMax == other.zMax && this.mMin == other.mMin && this.mMax == other.mMax && this.valid == other.valid;
    }

    public int hashCode() {
        return Double.hashCode(this.xMin) ^ Double.hashCode(this.xMax) ^ Double.hashCode(this.yMin) ^ Double.hashCode(this.yMax) ^ Double.hashCode(this.zMin) ^ Double.hashCode(this.zMax) ^ Double.hashCode(this.mMin) ^ Double.hashCode(this.mMax) ^ Boolean.hashCode(this.valid);
    }

    private void resetBBox() {
        this.xMin = Double.POSITIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        this.yMin = Double.POSITIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
        this.zMin = Double.POSITIVE_INFINITY;
        this.zMax = Double.NEGATIVE_INFINITY;
        this.mMin = Double.POSITIVE_INFINITY;
        this.mMax = Double.NEGATIVE_INFINITY;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getZMin() {
        return this.zMin;
    }

    public double getZMax() {
        return this.zMax;
    }

    public double getMMin() {
        return this.mMin;
    }

    public double getMMax() {
        return this.mMax;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isXYValid() {
        return this.isXValid() && this.isYValid();
    }

    public boolean isXValid() {
        return !Double.isNaN(this.xMin) && !Double.isNaN(this.xMax);
    }

    public boolean isYValid() {
        return !Double.isNaN(this.yMin) && !Double.isNaN(this.yMax);
    }

    public boolean isZValid() {
        return !Double.isNaN(this.zMin) && !Double.isNaN(this.zMax);
    }

    public boolean isMValid() {
        return !Double.isNaN(this.mMin) && !Double.isNaN(this.mMax);
    }

    public boolean isXYEmpty() {
        return this.isXEmpty() || this.isYEmpty();
    }

    public boolean isXEmpty() {
        return Double.isInfinite(this.xMin) && Double.isInfinite(this.xMax);
    }

    public boolean isYEmpty() {
        return Double.isInfinite(this.yMin) && Double.isInfinite(this.yMax);
    }

    public boolean isZEmpty() {
        return Double.isInfinite(this.zMin) && Double.isInfinite(this.zMax);
    }

    public boolean isMEmpty() {
        return Double.isInfinite(this.mMin) && Double.isInfinite(this.mMax);
    }

    public void merge(BoundingBox other) {
        if (!this.valid) {
            return;
        }
        if (other == null || !other.valid) {
            this.valid = false;
            this.resetBBox();
            return;
        }
        this.xMin = Math.min(this.xMin, other.xMin);
        this.xMax = Math.max(this.xMax, other.xMax);
        this.yMin = Math.min(this.yMin, other.yMin);
        this.yMax = Math.max(this.yMax, other.yMax);
        this.zMin = Math.min(this.zMin, other.zMin);
        this.zMax = Math.max(this.zMax, other.zMax);
        this.mMin = Math.min(this.mMin, other.mMin);
        this.mMax = Math.max(this.mMax, other.mMax);
        this.valid = this.isXYValid();
    }

    public void update(Geometry geometry) {
        if (!this.valid) {
            return;
        }
        if (geometry == null || geometry.isEmpty()) {
            return;
        }
        Envelope envelope = geometry.getEnvelopeInternal();
        if (!Double.isNaN(envelope.getMinX()) && !Double.isNaN(envelope.getMaxX())) {
            this.xMin = Math.min(this.xMin, envelope.getMinX());
            this.xMax = Math.max(this.xMax, envelope.getMaxX());
        }
        if (!Double.isNaN(envelope.getMinY()) && !Double.isNaN(envelope.getMaxY())) {
            this.yMin = Math.min(this.yMin, envelope.getMinY());
            this.yMax = Math.max(this.yMax, envelope.getMaxY());
        }
        for (Coordinate coord : geometry.getCoordinates()) {
            if (!Double.isNaN(coord.getZ())) {
                this.zMin = Math.min(this.zMin, coord.getZ());
                this.zMax = Math.max(this.zMax, coord.getZ());
            }
            if (Double.isNaN(coord.getM())) continue;
            this.mMin = Math.min(this.mMin, coord.getM());
            this.mMax = Math.max(this.mMax, coord.getM());
        }
        this.valid = this.isXYValid();
    }

    public void reset() {
        this.resetBBox();
        this.valid = true;
    }

    public BoundingBox copy() {
        return new BoundingBox(this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.mMin, this.mMax);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BoundingBox{xMin=").append(this.xMin).append(", xMax=").append(this.xMax).append(", yMin=").append(this.yMin).append(", yMax=").append(this.yMax).append(", zMin=").append(this.zMin).append(", zMax=").append(this.zMax).append(", mMin=").append(this.mMin).append(", mMax=").append(this.mMax);
        if (!this.valid) {
            sb.append(", valid=false");
        }
        sb.append('}');
        return sb.toString();
    }
}

