/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Credentials;
import coursierapi.Repository;
import java.io.Serializable;
import java.util.Objects;

public final class IvyRepository
implements Repository,
Serializable {
    private final String pattern;
    private String metadataPattern;
    private Credentials credentials;
    private boolean dropInfoAttributes;

    private IvyRepository(String string, String string2) {
        this.pattern = string;
        this.metadataPattern = string2;
        this.credentials = null;
        this.dropInfoAttributes = false;
    }

    public static IvyRepository of(String string, String string2) {
        return new IvyRepository(string, string2);
    }

    public static IvyRepository of(String string) {
        return new IvyRepository(string, null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IvyRepository) {
            IvyRepository ivyRepository = (IvyRepository)object;
            return this.pattern.equals(ivyRepository.pattern) && Objects.equals(this.metadataPattern, ivyRepository.metadataPattern) && Objects.equals(this.credentials, ivyRepository.credentials) && this.dropInfoAttributes == ivyRepository.dropInfoAttributes;
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (17 + this.pattern.hashCode()) + Objects.hashCode(this.metadataPattern)) + Objects.hashCode(this.credentials)) + Boolean.hashCode(this.dropInfoAttributes);
    }

    public String toString() {
        String string = "";
        if (this.credentials != null) {
            string = ", " + this.credentials;
        }
        String string2 = "";
        if (this.metadataPattern != null) {
            string2 = ", " + this.metadataPattern;
        }
        return "IvyRepository(" + this.pattern + string2 + string + ", dropInfoAttributes = " + this.dropInfoAttributes + ")";
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getMetadataPattern() {
        return this.metadataPattern;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean getDropInfoAttributes() {
        return this.dropInfoAttributes;
    }

    public IvyRepository withMetadataPattern(String string) {
        this.metadataPattern = string;
        return this;
    }

    public IvyRepository withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public IvyRepository withDropInfoAttributes(boolean bl) {
        this.dropInfoAttributes = bl;
        return this;
    }
}

