/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import scala.Tuple2;

public final class JavaQueueStream {
    private JavaQueueStream() {
    }

    public static void main(String[] args) throws Exception {
        StreamingExamples.setStreamingLogLevels();
        SparkConf sparkConf = new SparkConf().setAppName("JavaQueueStream");
        JavaStreamingContext ssc = new JavaStreamingContext(sparkConf, new Duration(1000L));
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i3 = 0; i3 < 1000; ++i3) {
            list.add(i3);
        }
        LinkedList<JavaRDD> rddQueue = new LinkedList<JavaRDD>();
        for (int i4 = 0; i4 < 30; ++i4) {
            rddQueue.add(ssc.sparkContext().parallelize(list));
        }
        JavaDStream inputStream = ssc.queueStream(rddQueue);
        JavaPairDStream mappedStream = inputStream.mapToPair((PairFunction & Serializable)i -> new Tuple2((Object)(i % 10), (Object)1));
        JavaPairDStream reducedStream = mappedStream.reduceByKey((Function2 & Serializable)(i1, i2) -> i1 + i2);
        reducedStream.print();
        ssc.start();
        ssc.awaitTermination();
    }
}

