/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTClassifierParams;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.ClassificationLoss;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r\u0015c\u0001\u0002\u001e<\u0001\u0019C\u0001\"\u001e\u0001\u0003\u0006\u0004%\tE\u001e\u0005\n\u0003#\u0001!\u0011!Q\u0001\n]D!\"!\u0006\u0001\u0005\u000b\u0007I\u0011BA\f\u0011)\t\t\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003G\u0001!Q1A\u0005\n\u0005\u0015\u0002BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002(!Q\u0011\u0011\u0007\u0001\u0003\u0006\u0004%\t%a\r\t\u0015\u0005u\u0002A!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002B\u0001\u0011)\u0019!C!\u0003gA!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011!\ti\u0005\u0001C\u0001{\u0005=\u0003\u0002CA'\u0001\u0011\u0005Q(!\u0019\t\u000f\u00055\u0003\u0001\"\u0001\u0002l!A\u0011Q\n\u0001\u0005\u0002u\n)\bC\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0018!I\u0011\u0011\u0012\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u00026!9\u0011Q\u0013\u0001\u0005B\u0005\u0015\u0002bBAM\u0001\u0011\u0005\u00131\u0014\u0005\b\u0003g\u0003A\u0011IA[\u0011\u001d\t9\u0010\u0001C!\u0003sDq!a@\u0001\t\u0003\u0012\t\u0001C\u0004\u0003\f\u0001!\tF!\u0004\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016!9!\u0011\u0006\u0001\u0005B\t-\u0002B\u0003B\u0018\u0001!\u0015\r\u0011\"\u0001\u00032!9!Q\u0007\u0001\u0005\n\t]\u0002\u0002\u0003B\u001e\u0001\u0011\u0005QH!\u0010\t\u0013\tE\u0003A1A\u0005\n\tM\u0003\u0002\u0003B0\u0001\u0001\u0006IA!\u0016\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d!9!q\u000f\u0001\u0005B\teta\u0002BCw!\u0005!q\u0011\u0004\u0007umB\tA!#\t\u000f\u000553\u0005\"\u0001\u0003&\"A!qU\u0012C\u0002\u0013%a\u000fC\u0004\u0003*\u000e\u0002\u000b\u0011B<\t\u0011\t-6E1A\u0005\nYDqA!,$A\u0003%q\u000fC\u0004\u00030\u000e\"\tE!-\t\u000f\tm6\u0005\"\u0011\u0003>\u001a9!QY\u0012\u0001G\t\u001d\u0007\"\u0003BeW\t\u0005\t\u0015!\u0003R\u0011\u001d\tie\u000bC\u0001\u0005\u0017DqAa5,\t#\u0012)N\u0002\u0004\u0003`\u000e\"!\u0011\u001d\u0005\b\u0003\u001bzC\u0011\u0001Br\u0011%\u00119o\fb\u0001\n\u0013\u0011I\u000f\u0003\u0005\u0003v>\u0002\u000b\u0011\u0002Bv\u0011%\u00119p\fb\u0001\n\u0013\u0011I\u000f\u0003\u0005\u0003z>\u0002\u000b\u0011\u0002Bv\u0011\u001d\u0011Yl\fC!\u0005wD\u0001Ba@$\t\u0003i4\u0011\u0001\u0005\u000b\u0007?\u0019\u0013\u0013!C\u0001{\r\u0005\u0002BCB\u001bGE\u0005I\u0011A\u001f\u0004\"!I1qG\u0012\u0002\u0002\u0013%1\u0011\b\u0002\u0017\u000f\n#6\t\\1tg&4\u0017nY1uS>tWj\u001c3fY*\u0011A(P\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tqt(\u0001\u0002nY*\u0011\u0001)Q\u0001\u0006gB\f'o\u001b\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u00019%\u000bW1h!\u0011A\u0015jS)\u000e\u0003mJ!AS\u001e\u0003AA\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dv\na\u0001\\5oC2<\u0017B\u0001)N\u0005\u00191Vm\u0019;peB\u0011\u0001\n\u0001\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+v\nA\u0001\u001e:fK&\u0011q\u000b\u0016\u0002\u0014\u000f\n#6\t\\1tg&4\u0017.\u001a:QCJ\fWn\u001d\t\u0004'f[\u0016B\u0001.U\u0005E!&/Z3F]N,WN\u00197f\u001b>$W\r\u001c\t\u00039~k\u0011!\u0018\u0006\u0003=v\n!B]3he\u0016\u001c8/[8o\u0013\t\u0001WLA\u000eEK\u000eL7/[8o)J,WMU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003E\u0016l\u0011a\u0019\u0006\u0003Iv\nA!\u001e;jY&\u0011am\u0019\u0002\u000b\u001b2;&/\u001b;bE2,\u0007C\u00015s\u001d\tIwN\u0004\u0002k[6\t1N\u0003\u0002m\u000b\u00061AH]8pizJ\u0011A\\\u0001\u0006g\u000e\fG.Y\u0005\u0003aF\fq\u0001]1dW\u0006<WMC\u0001o\u0013\t\u0019HO\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002qc\u0006\u0019Q/\u001b3\u0016\u0003]\u0004\"\u0001\u001f?\u000f\u0005eT\bC\u00016r\u0013\tY\u0018/\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>rQ\u0015\t\u0011\u0011AA\u0007!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0011Q\u0001\u0002\u0006'&t7-Z\u0011\u0003\u0003\u001f\tQ!\r\u00187]A\nA!^5eA!*!!!\u0001\u0002\u000e\u00051q\f\u001e:fKN,\"!!\u0007\u0011\u000b\u0005m\u0011QD.\u000e\u0003EL1!a\br\u0005\u0015\t%O]1z\u0003\u001dyFO]3fg\u0002\nAb\u0018;sK\u0016<V-[4iiN,\"!a\n\u0011\r\u0005m\u0011QDA\u0015!\u0011\tY\"a\u000b\n\u0007\u00055\u0012O\u0001\u0004E_V\u0014G.Z\u0001\u000e?R\u0014X-Z,fS\u001eDGo\u001d\u0011\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0003\u0003k\u0001B!a\u0007\u00028%\u0019\u0011\u0011H9\u0003\u0007%sG\u000fK\u0003\b\u0003\u0003\ti!\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005K\u0003\t\u0003\u0003\ti!\u0001\u0006ok6\u001cE.Y:tKNDS!CA\u0001\u0003\u000b\n#!a\u0012\u0002\u000bIr#G\f\u0019\u0002\u00179,Xn\u00117bgN,7\u000f\t\u0015\u0006\u0015\u0005\u0005\u0011QI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0017E\u000b\t&!\u0016\u0002X\u0005e\u0013Q\f\u0005\u0006k.\u0001\ra\u001e\u0015\u0007\u0003#\n\t!!\u0004\t\u000f\u0005U1\u00021\u0001\u0002\u001a!9\u00111E\u0006A\u0002\u0005\u001d\u0002bBA\u0019\u0017\u0001\u0007\u0011Q\u0007\u0015\u0007\u00033\n\t!!\u0004\t\u000f\u0005\u00053\u00021\u0001\u00026!2\u0011QLA\u0001\u0003\u000b\"\u0012\"UA2\u0003K\n9'!\u001b\t\u000bUd\u0001\u0019A<\t\u000f\u0005UA\u00021\u0001\u0002\u001a!9\u00111\u0005\u0007A\u0002\u0005\u001d\u0002bBA\u0019\u0019\u0001\u0007\u0011Q\u0007\u000b\b#\u00065\u0014qNA9\u0011\u0015)X\u00021\u0001x\u0011\u001d\t)\"\u0004a\u0001\u00033Aq!a\t\u000e\u0001\u0004\t9\u0003K\u0003\u000e\u0003\u0003\ti\u0001F\u0001R\u00035)7\u000f^5nCR,GmU5{KV\u0011\u00111\u0010\t\u0005\u00037\ti(C\u0002\u0002\u0000E\u0014A\u0001T8oO\u0006)AO]3fg\"*\u0001#!\u0001\u0002\u0006\u0006\u0012\u0011qQ\u0001\u0006c9\"d\u0006M\u0001\fO\u0016$h*^7Ue\u0016,7\u000fK\u0003\u0012\u0003\u0003\ti)\t\u0002\u0002\u0010\u0006)!G\f\u0019/a\u0005aq-\u001a;Ok6$&/Z3tA!*!#!\u0001\u0002\u000e\u0006YAO]3f/\u0016Lw\r\u001b;tQ\u0015\u0019\u0012\u0011AAC\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BAO\u0003[\u0003B!a(\u0002*6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+A\u0003usB,7OC\u0002\u0002(~\n1a]9m\u0013\u0011\tY+!)\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u00020R\u0001\r!!(\u0002\rM\u001c\u0007.Z7bQ\u0015!\u0012\u0011AA\u0007\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u00028\u0006M\u0007\u0003BA]\u0003\u001btA!a/\u0002L:!\u0011QXAe\u001d\u0011\ty,a2\u000f\t\u0005\u0005\u0017Q\u0019\b\u0004U\u0006\r\u0017\"\u0001#\n\u0005\t\u001b\u0015B\u0001!B\u0013\r\t9kP\u0005\u0004a\u0006\u0015\u0016\u0002BAh\u0003#\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007A\f)\u000bC\u0004\u0002VV\u0001\r!a6\u0002\u000f\u0011\fG/Y:fiB\"\u0011\u0011\\As!\u0019\tY.!8\u0002b6\u0011\u0011QU\u0005\u0005\u0003?\f)KA\u0004ECR\f7/\u001a;\u0011\t\u0005\r\u0018Q\u001d\u0007\u0001\t1\t9/a5\u0002\u0002\u0003\u0005)\u0011AAu\u0005\ryFEM\t\u0005\u0003W\f\t\u0010\u0005\u0003\u0002\u001c\u00055\u0018bAAxc\n9aj\u001c;iS:<\u0007\u0003BA\u000e\u0003gL1!!>r\u0005\r\te._\u0001\baJ,G-[2u)\u0011\tI#a?\t\r\u0005uh\u00031\u0001L\u0003!1W-\u0019;ve\u0016\u001c\u0018A\u00039sK\u0012L7\r\u001e*boR\u00191Ja\u0001\t\r\u0005ux\u00031\u0001LQ\u00159\u0012\u0011\u0001B\u0004C\t\u0011I!A\u00034]Ar\u0003'\u0001\fsC^\u0014\u0004O]8cC\nLG.\u001b;z\u0013:\u0004F.Y2f)\rY%q\u0002\u0005\u0007\u0005#A\u0002\u0019A&\u0002\u001bI\fw\u000f\u0015:fI&\u001cG/[8o\u0003\u0011\u0019w\u000e]=\u0015\u0007E\u00139\u0002C\u0004\u0003\u001ae\u0001\rAa\u0007\u0002\u000b\u0015DHO]1\u0011\t\tu!1E\u0007\u0003\u0005?Q1A!\t>\u0003\u0015\u0001\u0018M]1n\u0013\u0011\u0011)Ca\b\u0003\u0011A\u000b'/Y7NCBDS!GA\u0001\u0003\u000b\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002o\"*!$!\u0001\u0002\u0006\u0006\u0011b-Z1ukJ,\u0017*\u001c9peR\fgnY3t+\u0005Y\u0005&B\u000e\u0002\u0002\u00055\u0015AB7be\u001eLg\u000e\u0006\u0003\u0002*\te\u0002BBA\u007f9\u0001\u00071*A\u0003u_>cG-\u0006\u0002\u0003@A!!\u0011\tB'\u001b\t\u0011\u0019E\u0003\u0003\u0003F\t\u001d\u0013!B7pI\u0016d'bA+\u0003J)\u0019!1J \u0002\u000b5dG.\u001b2\n\t\t=#1\t\u0002\u001a\u000fJ\fG-[3oi\n{wn\u001d;fIR\u0013X-Z:N_\u0012,G.\u0001\u0003m_N\u001cXC\u0001B+!\u0011\u00119Fa\u0017\u000e\u0005\te#\u0002\u0002B)\u0005\u000fJAA!\u0018\u0003Z\t\u00112\t\\1tg&4\u0017nY1uS>tGj\\:t\u0003\u0015awn]:!\u0003U)g/\u00197vCR,W)Y2i\u0013R,'/\u0019;j_:$B!a\n\u0003f!9\u0011Q\u001b\u0011A\u0002\t\u001d\u0004\u0007\u0002B5\u0005[\u0002b!a7\u0002^\n-\u0004\u0003BAr\u0005[\"ABa\u001c\u0003f\u0005\u0005\t\u0011!B\u0001\u0003S\u00141a\u0018\u00134Q\u0015\u0001\u0013\u0011\u0001B:C\t\u0011)(A\u00033]Qr\u0003'A\u0003xe&$X-\u0006\u0002\u0003|A\u0019!M! \n\u0007\t}4M\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0015\t\u0013\u0011AAGQ\u0015\u0001\u0011\u0011AA\u0007\u0003Y9%\tV\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007C\u0001%$'\u001d\u0019#1\u0012BI\u0005/\u0003B!a\u0007\u0003\u000e&\u0019!qR9\u0003\r\u0005s\u0017PU3g!\u0011\u0011'1S)\n\u0007\tU5M\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004BA!'\u0003$6\u0011!1\u0014\u0006\u0005\u0005;\u0013y*\u0001\u0002j_*\u0011!\u0011U\u0001\u0005U\u00064\u0018-C\u0002t\u00057#\"Aa\"\u0002\u001d9,XNR3biV\u0014Xm]&fs\u0006ya.^7GK\u0006$XO]3t\u0017\u0016L\b%A\u0006ok6$&/Z3t\u0017\u0016L\u0018\u0001\u00048v[R\u0013X-Z:LKf\u0004\u0013\u0001\u0002:fC\u0012,\"Aa-\u0011\t\t\u0014),U\u0005\u0004\u0005o\u001b'\u0001C'M%\u0016\fG-\u001a:)\u000b%\n\t!!$\u0002\t1|\u0017\r\u001a\u000b\u0004#\n}\u0006B\u0002BaU\u0001\u0007q/\u0001\u0003qCRD\u0007&\u0002\u0016\u0002\u0002\u00055%\u0001H$C)\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7Xe&$XM]\n\u0004W\tm\u0014\u0001C5ogR\fgnY3\u0015\t\t5'\u0011\u001b\t\u0004\u0005\u001f\\S\"A\u0012\t\r\t%W\u00061\u0001R\u0003!\u0019\u0018M^3J[BdG\u0003\u0002Bl\u0005;\u0004B!a\u0007\u0003Z&\u0019!1\\9\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0005\u0003t\u0003\u0019A<\u00039\u001d\u0013Ek\u00117bgNLg-[2bi&|g.T8eK2\u0014V-\u00193feN\u0019qFa-\u0015\u0005\t\u0015\bc\u0001Bh_\u0005I1\r\\1tg:\u000bW.Z\u000b\u0003\u0005W\u0004BA!<\u0003t6\u0011!q\u001e\u0006\u0005\u0005c\u0014y*\u0001\u0003mC:<\u0017bA?\u0003p\u0006Q1\r\\1tg:\u000bW.\u001a\u0011\u0002\u001bQ\u0014X-Z\"mCN\u001ch*Y7f\u00039!(/Z3DY\u0006\u001c8OT1nK\u0002\"2!\u0015B\u007f\u0011\u0019\u0011\t-\u000ea\u0001o\u00069aM]8n\u001f2$GcC)\u0004\u0004\r\u001d1\u0011CB\u000e\u0007;Aqa!\u00027\u0001\u0004\u0011y$\u0001\u0005pY\u0012lu\u000eZ3m\u0011\u001d\u0019IA\u000ea\u0001\u0007\u0017\ta\u0001]1sK:$\bc\u0001%\u0004\u000e%\u00191qB\u001e\u0003\u001b\u001d\u0013Ek\u00117bgNLg-[3s\u0011\u001d\u0019\u0019B\u000ea\u0001\u0007+\t1cY1uK\u001e|'/[2bY\u001a+\u0017\r^;sKN\u0004r\u0001_B\f\u0003k\t)$C\u0002\u0004\u001ay\u00141!T1q\u0011%\t\tD\u000eI\u0001\u0002\u0004\t)\u0004C\u0005\u0002BY\u0002\n\u00111\u0001\u00026\u0005\tbM]8n\u001f2$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\r\"\u0006BA\u001b\u0007KY#aa\n\u0011\t\r%2\u0011G\u0007\u0003\u0007WQAa!\f\u00040\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000f\t\u0018\u0002BB\u001a\u0007W\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003E1'o\\7PY\u0012$C-\u001a4bk2$H%N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007w\u0001BA!<\u0004>%!1q\bBx\u0005\u0019y%M[3di\"*1%!\u0001\u0002\u000e\"*!%!\u0001\u0002\u000e\u0002")
public class GBTClassificationModel
extends ProbabilisticClassificationModel<Vector, GBTClassificationModel>
implements GBTClassifierParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int numClasses;
    private final int getNumTrees;
    private final ClassificationLoss loss;
    private int totalNumNodes;
    private Param<String> lossType;
    private Param<String> impurity;
    private DoubleParam validationTol;
    private DoubleParam stepSize;
    private Param<String> validationIndicatorCol;
    private IntParam maxIter;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTClassificationModel load(String path) {
        return GBTClassificationModel$.MODULE$.load(path);
    }

    public static MLReader<GBTClassificationModel> read() {
        return GBTClassificationModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public DecisionTreeModel getTree(int i) {
        return TreeEnsembleModel.getTree$(this, i);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public long getEstimatedSize() {
        return TreeEnsembleModel.getEstimatedSize$(this);
    }

    @Override
    public String getLossType() {
        return GBTClassifierParams.getLossType$(this);
    }

    @Override
    public ClassificationLoss getOldLossType() {
        return GBTClassifierParams.getOldLossType$(this);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.totalNumNodes$lzycompute();
        }
        return this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTClassifierParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public long estimatedSize() {
        return this.getEstimatedSize();
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Dataset<Row> outputData = super.transform(dataset);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTClassificationModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GBTClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1(GBTClassificationModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1(GBTClassificationModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> this.predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_GBTClassificationModel$$typecreator2$1(null)));
            return outputData.withColumn(this.$(this.leafCol()), leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})), outputSchema.apply(this.$(this.leafCol())).metadata());
        }
        return outputData;
    }

    @Override
    public double predict(Vector features) {
        if (this.isDefined(this.thresholds())) {
            return super.predict(features);
        }
        if (this.margin(features) > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double prediction = this.margin(features);
        return Vectors$.MODULE$.dense(new double[]{-prediction, prediction});
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            denseVector.values()[0] = this.loss().computeProbability(denseVector.values()[0]);
            denseVector.values()[1] = 1.0 - denseVector.values()[0];
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in GBTClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public GBTClassificationModel copy(ParamMap extra) {
        return (GBTClassificationModel)((Model)this.copyValues(new GBTClassificationModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "GBTClassificationModel: uid = " + this.uid() + ", numTrees=" + this.getNumTrees() + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    private double margin(Vector features) {
        double[] treePredictions = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GBTClassificationModel.$anonfun$margin$1(features, x$4)), (ClassTag)ClassTag$.MODULE$.Double());
        return BLAS$.MODULE$.nativeBLAS().ddot(this.getNumTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Classification(), (org.apache.spark.mllib.tree.model.DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$5 -> x$5.toOld(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.tree.model.DecisionTreeModel.class)), this._treeWeights());
    }

    private ClassificationLoss loss() {
        return this.loss;
    }

    public double[] evaluateEachIteration(Dataset<?> dataset) {
        RDD<Instance> data = DatasetUtils$.MODULE$.extractInstances(this, dataset, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration(data, this.trees(), this.treeWeights(), this.loss(), Algo$.MODULE$.Classification());
    }

    @Override
    public MLWriter write() {
        return new GBTClassificationModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$margin$1(Vector features$1, DecisionTreeRegressionModel x$4) {
        return x$4.rootNode().predictImpl(features$1).prediction();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeEnsembleClassifierParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        GBTClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "GBTClassificationModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable)() -> "GBTClassificationModel given trees, treeWeights of non-matching lengths (" + this._trees().length + ", " + this._treeWeights().length + ", respectively).");
        this.getNumTrees = this.trees().length;
        this.loss = this.getOldLossType();
        Statics.releaseFence();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this(uid, _trees, _treeWeights, numFeatures, 2);
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1, 2);
    }

    public GBTClassificationModel() {
        this("", (DecisionTreeRegressionModel[])((Object[])new DecisionTreeRegressionModel[]{new DecisionTreeRegressionModel()}), new double[]{Double.NaN}, -1, -1);
    }

    private static class GBTClassificationModelReader
    extends MLReader<GBTClassificationModel> {
        private final String className = GBTClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTClassificationModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple3._1();
            Tuple2[] treesData = (Tuple2[])tuple3._2();
            double[] treeWeights2 = (double[])tuple3._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey())), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey())), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                    Node root = (Node)tuple2._2();
                    DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                    treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                    return tree;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> "GBTClassificationModel.load expected " + numTrees + " trees based on metadata but found " + trees.length + " trees.");
            GBTClassificationModel model = new GBTClassificationModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, (Option<List<String>>)new Some((Object)new .colon.colon((Object)"impurity", (List)Nil$.MODULE$)));
            return model;
        }
    }

    public static class GBTClassificationModelWriter
    extends MLWriter {
        private final GBTClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTClassificationModelWriter(GBTClassificationModel instance) {
            this.instance = instance;
        }
    }
}

