/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ml;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.SparkException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.util.ConnectHelper;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.Summary;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.ml.MLCache$CacheItem$;
import org.apache.spark.sql.connect.ml.MLCacheSizeOverflowException;
import org.apache.spark.sql.connect.ml.MLModelSizeOverflowException;
import org.apache.spark.sql.connect.ml.MLUtils$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.util.SparkFileUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t%e!B\u001d;\u0001q2\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u000bm\u0003A\u0011\u0001/\t\u000f\u0001\u0004!\u0019!C\u0005C\"1\u0011\u000e\u0001Q\u0001\n\tDqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004u\u0001\u0001\u0006I\u0001\u001c\u0005\bk\u0002\u0011\r\u0011\"\u0003l\u0011\u00191\b\u0001)A\u0005Y\"Aq\u000f\u0001b\u0001\n\u0003Q\u0004\u0010C\u0004\u0002\u0006\u0001\u0001\u000b\u0011B=\t\u0013\u0005\u001d\u0001A1A\u0005\u0002\u0005%\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0003\t\u0011\u0005u\u0001\u0001\"\u0001A\u0003?Aq!a\n\u0001\t\u0013\tI\u0003\u0003\u0005\u00022\u0001!\tAOA\u0015\r\u001d\t\u0019\u0004\u0001!;\u0003kA!\"!\u0016\u0011\u0005+\u0007I\u0011AA,\u0011)\ty\u0006\u0005B\tB\u0003%\u0011\u0011\f\u0005\u000b\u0003C\u0002\"Q3A\u0005\u0002\u0005%\u0002BCA2!\tE\t\u0015!\u0003\u0002,!11\f\u0005C\u0001\u0003KB\u0011\"a\u001c\u0011\u0003\u0003%\t!!\u001d\t\u0013\u0005]\u0004#%A\u0005\u0002\u0005e\u0004\"CAH!E\u0005I\u0011AAI\u0011!\t)\nEA\u0001\n\u0003Z\u0007\"CAL!\u0005\u0005I\u0011AAM\u0011%\t\t\u000bEA\u0001\n\u0003\t\u0019\u000bC\u0005\u00020B\t\t\u0011\"\u0011\u00022\"I\u0011q\u0018\t\u0002\u0002\u0013\u0005\u0011\u0011\u0019\u0005\n\u0003\u000b\u0004\u0012\u0011!C!\u0003\u000fD\u0011\"a3\u0011\u0003\u0003%\t%!4\t\u0013\u0005=\u0007#!A\u0005B\u0005E\u0007\"CAj!\u0005\u0005I\u0011IAk\u000f)\tI\u000eAA\u0001\u0012\u0003Q\u00141\u001c\u0004\u000b\u0003g\u0001\u0011\u0011!E\u0001u\u0005u\u0007BB.$\t\u0003\t)\u0010C\u0005\u0002P\u000e\n\t\u0011\"\u0012\u0002R\"I\u0011q_\u0012\u0002\u0002\u0013\u0005\u0015\u0011 \u0005\n\u0003\u007f\u001c\u0013\u0011!CA\u0005\u0003A!Ba\u0005\u0001\u0005\u0004%\tA\u000fB\u000b\u0011!\u0011i\u0003\u0001Q\u0001\n\t]\u0001\"\u0003B\u0018\u0001\t\u0007I\u0011\u0001\u001ey\u0011\u001d\u0011\t\u0004\u0001Q\u0001\neD\u0001Ba\r\u0001\t\u0003\u0001\u0015\u0011\u0006\u0005\t\u0005k\u0001A\u0011\u0001!\u0002*!9!q\u0007\u0001\u0005\u0002\te\u0002b\u0002B#\u0001\u0011%!q\t\u0005\t\u0005\u0017\u0002A\u0011\u0001!\u0003N!9!1\u000b\u0001\u0005\u0002\tU\u0003\u0002\u0003B-\u0001\u0011\u0005\u0001Ia\u0017\t\u000f\t}\u0003\u0001\"\u0001\u0003b!9!Q\r\u0001\u0005\u0002\t\u001d\u0004b\u0002B8\u0001\u0011\u0005!\u0011\u000f\u0005\n\u0005o\u0002\u0011\u0013!C\u0001\u0005sBqA! \u0001\t\u0003\ti\rC\u0004\u0003\u0000\u0001!\tA!!\u0003\u000f5c5)Y2iK*\u00111\bP\u0001\u0003[2T!!\u0010 \u0002\u000f\r|gN\\3di*\u0011q\bQ\u0001\u0004gFd'BA!C\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019E)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000b\u0006\u0019qN]4\u0014\u0007\u00019U\n\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0002\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003%>\u0013q\u0001T8hO&tw-A\u0007tKN\u001c\u0018n\u001c8I_2$WM]\u0002\u0001!\t1\u0016,D\u0001X\u0015\tAF(A\u0004tKJ4\u0018nY3\n\u0005i;&!D*fgNLwN\u001c%pY\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0003;~\u0003\"A\u0018\u0001\u000e\u0003iBQa\u0015\u0002A\u0002U\u000ba\u0001[3ma\u0016\u0014X#\u00012\u0011\u0005\r<W\"\u00013\u000b\u0005\u00154\u0017\u0001B;uS2T!a\u000f!\n\u0005!$'!D\"p]:,7\r\u001e%fYB,'/A\u0004iK2\u0004XM\u001d\u0011\u0002\u0011!,G\u000e]3s\u0013\u0012+\u0012\u0001\u001c\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\fA\u0001\\1oO*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005\u0019\u0019FO]5oO\u0006I\u0001.\u001a7qKJLE\tI\u0001\u0013[>$W\r\\\"mCN\u001ch*Y7f\r&dW-A\nn_\u0012,Gn\u00117bgNt\u0015-\\3GS2,\u0007%A\u000fu_R\fG.\u0014'DC\u000eDW-\u00138NK6|'/_*ju\u0016\u0014\u0015\u0010^3t+\u0005I\bc\u0001>\u0002\u00025\t1P\u0003\u0002}{\u00061\u0011\r^8nS\u000eT!A`@\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002fa&\u0019\u00111A>\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\u0010u_R\fG.\u0014'DC\u000eDW-\u00138NK6|'/_*ju\u0016\u0014\u0015\u0010^3tA\u0005\u0011rN\u001a4m_\u0006$W\rZ'pI\u0016d7\u000fR5s+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\t\u0019LG.\u001a\u0006\u0004\u0003+\u0001\u0018a\u00018j_&!\u0011\u0011DA\b\u0005\u0011\u0001\u0016\r\u001e5\u0002'=4g\r\\8bI\u0016$Wj\u001c3fYN$\u0015N\u001d\u0011\u0002/\u001d,G/T3n_JL8i\u001c8ue>dWI\\1cY\u0016$WCAA\u0011!\rA\u00151E\u0005\u0004\u0003KI%a\u0002\"p_2,\u0017M\\\u0001\u001aO\u0016$X*\u0019=J]6+Wn\u001c:z\u0007\u0006\u001c\u0007.Z*ju\u0016\\%)\u0006\u0002\u0002,A\u0019\u0001*!\f\n\u0007\u0005=\u0012J\u0001\u0003M_:<\u0017AG4fi>3g\r\\8bI&tw\rV5nK>,H/T5okR,'!C\"bG\",\u0017\n^3n'\u0019\u0001r)a\u000e\u0002>A\u0019\u0001*!\u000f\n\u0007\u0005m\u0012JA\u0004Qe>$Wo\u0019;\u0011\t\u0005}\u0012q\n\b\u0005\u0003\u0003\nYE\u0004\u0003\u0002D\u0005%SBAA#\u0015\r\t9\u0005V\u0001\u0007yI|w\u000e\u001e \n\u0003)K1!!\u0014J\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0015\u0002T\ta1+\u001a:jC2L'0\u00192mK*\u0019\u0011QJ%\u0002\u0007=\u0014'.\u0006\u0002\u0002ZA\u0019Q.a\u0017\n\u0007\u0005ucN\u0001\u0004PE*,7\r^\u0001\u0005_\nT\u0007%A\u0005tSj,')\u001f;fg\u0006Q1/\u001b>f\u0005f$Xm\u001d\u0011\u0015\r\u0005\u001d\u00141NA7!\r\tI\u0007E\u0007\u0002\u0001!9\u0011QK\u000bA\u0002\u0005e\u0003bBA1+\u0001\u0007\u00111F\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002h\u0005M\u0014Q\u000f\u0005\n\u0003+2\u0002\u0013!a\u0001\u00033B\u0011\"!\u0019\u0017!\u0003\u0005\r!a\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0010\u0016\u0005\u00033\nih\u000b\u0002\u0002\u0000A!\u0011\u0011QAF\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015!C;oG\",7m[3e\u0015\r\tI)S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAG\u0003\u0007\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a%+\t\u0005-\u0012QP\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0005c\u0001%\u0002\u001e&\u0019\u0011qT%\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015\u00161\u0016\t\u0004\u0011\u0006\u001d\u0016bAAU\u0013\n\u0019\u0011I\\=\t\u0013\u000556$!AA\u0002\u0005m\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00024B1\u0011QWA^\u0003Kk!!a.\u000b\u0007\u0005e\u0016*\u0001\u0006d_2dWm\u0019;j_:LA!!0\u00028\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t#a1\t\u0013\u00055V$!AA\u0002\u0005\u0015\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2\u0001\\Ae\u0011%\tiKHA\u0001\u0002\u0004\tY*\u0001\u0005iCND7i\u001c3f)\t\tY*\u0001\u0005u_N#(/\u001b8h)\u0005a\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002\"\u0005]\u0007\"CAWC\u0005\u0005\t\u0019AAS\u0003%\u0019\u0015m\u00195f\u0013R,W\u000eE\u0002\u0002j\r\u001aRaIAp\u0003W\u0004\"\"!9\u0002h\u0006e\u00131FA4\u001b\t\t\u0019OC\u0002\u0002f&\u000bqA];oi&lW-\u0003\u0003\u0002j\u0006\r(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011Q^Az\u001b\t\tyOC\u0002\u0002rB\f!![8\n\t\u0005E\u0013q\u001e\u000b\u0003\u00037\fQ!\u00199qYf$b!a\u001a\u0002|\u0006u\bbBA+M\u0001\u0007\u0011\u0011\f\u0005\b\u0003C2\u0003\u0019AA\u0016\u0003\u001d)h.\u00199qYf$BAa\u0001\u0003\u0010A)\u0001J!\u0002\u0003\n%\u0019!qA%\u0003\r=\u0003H/[8o!\u001dA%1BA-\u0003WI1A!\u0004J\u0005\u0019!V\u000f\u001d7fe!I!\u0011C\u0014\u0002\u0002\u0003\u0007\u0011qM\u0001\u0004q\u0012\u0002\u0014aC2bG\",G-T8eK2,\"Aa\u0006\u0011\u0011\te!1\u0004B\u0010\u0003Oj\u0011!`\u0005\u0004\u0005;i(!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0003\u0003\"\t%b\u0002\u0002B\u0012\u0005K\u00012!a\u0011J\u0013\r\u00119#S\u0001\u0007!J,G-\u001a4\n\u0007M\u0014YCC\u0002\u0003(%\u000bAbY1dQ\u0016$Wj\u001c3fY\u0002\nQ\u0003^8uC2lEjQ1dQ\u0016\u001c\u0016N_3CsR,7/\u0001\fu_R\fG.\u0014'DC\u000eDWmU5{K\nKH/Z:!\u0003E9W\r^'M\u0007\u0006\u001c\u0007.Z'bqNK'0Z\u0001\u0010O\u0016$Xj\u001c3fY6\u000b\u0007pU5{K\u0006q1\r[3dW6{G-\u001a7TSj,G\u0003\u0002B\u001e\u0005\u0003\u00022\u0001\u0013B\u001f\u0013\r\u0011y$\u0013\u0002\u0005+:LG\u000fC\u0004\u0003D9\u0002\r!a\u000b\u0002%\u0015\u001cH/[7bi\u0016$Wj\u001c3fYNK'0Z\u0001\u0013KN$\u0018.\\1uK>\u0013'.Z2u'&TX\r\u0006\u0003\u0002,\t%\u0003bBA+_\u0001\u0007\u0011\u0011L\u0001\u0017O\u0016$Xj\u001c3fY>3g\r\\8bI&tw\rU1uQR!\u00111\u0002B(\u0011\u001d\u0011\t\u0006\ra\u0001\u0005?\tQA]3g\u0013\u0012\f\u0001B]3hSN$XM\u001d\u000b\u0005\u0005?\u00119\u0006C\u0004\u0002VE\u0002\r!!\u0017\u0002\u001dY,'/\u001b4z\u001f\nTWm\u0019;JIR!!1\bB/\u0011\u001d\u0011\tF\ra\u0001\u0005?\t1aZ3u)\u0011\tIFa\u0019\t\u000f\tE3\u00071\u0001\u0003 \u0005aqL]3n_Z,Wj\u001c3fYR1\u0011\u0011\u0005B5\u0005WBqA!\u00155\u0001\u0004\u0011y\u0002C\u0004\u0003nQ\u0002\r!!\t\u0002\u0013\u00154\u0018n\u0019;P]2L\u0018A\u0002:f[>4X\r\u0006\u0004\u0002\"\tM$Q\u000f\u0005\b\u0005#*\u0004\u0019\u0001B\u0010\u0011%\u0011i'\u000eI\u0001\u0002\u0004\t\t#\u0001\tsK6|g/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0010\u0016\u0005\u0003C\ti(A\u0003dY\u0016\f'/A\u0004hKRLeNZ8\u0015\u0005\t\r\u0005#\u0002%\u0003\u0006\n}\u0011b\u0001BD\u0013\n)\u0011I\u001d:bs\u0002")
public class MLCache
implements Logging {
    private volatile MLCache$CacheItem$ CacheItem$module;
    private final SessionHolder sessionHolder;
    private final ConnectHelper helper;
    private final String helperID;
    private final String modelClassNameFile;
    private final AtomicLong totalMLCacheInMemorySizeBytes;
    private final Path offloadedModelsDir;
    private final ConcurrentMap<String, CacheItem> cachedModel;
    private final AtomicLong totalMLCacheSizeBytes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public MLCache$CacheItem$ CacheItem() {
        if (this.CacheItem$module == null) {
            this.CacheItem$lzycompute$1();
        }
        return this.CacheItem$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConnectHelper helper() {
        return this.helper;
    }

    private String helperID() {
        return this.helperID;
    }

    private String modelClassNameFile() {
        return this.modelClassNameFile;
    }

    public AtomicLong totalMLCacheInMemorySizeBytes() {
        return this.totalMLCacheInMemorySizeBytes;
    }

    public Path offloadedModelsDir() {
        return this.offloadedModelsDir;
    }

    public boolean getMemoryControlEnabled() {
        return BoxesRunTime.unboxToBoolean((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_ENABLED()));
    }

    private long getMaxInMemoryCacheSizeKB() {
        return BoxesRunTime.unboxToLong((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_IN_MEMORY_SIZE())) / 1024L;
    }

    public long getOffloadingTimeoutMinute() {
        return BoxesRunTime.unboxToLong((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_OFFLOADING_TIMEOUT()));
    }

    public ConcurrentMap<String, CacheItem> cachedModel() {
        return this.cachedModel;
    }

    public AtomicLong totalMLCacheSizeBytes() {
        return this.totalMLCacheSizeBytes;
    }

    public long getMLCacheMaxSize() {
        return BoxesRunTime.unboxToLong((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_STORAGE_SIZE()));
    }

    public long getModelMaxSize() {
        return BoxesRunTime.unboxToLong((Object)this.sessionHolder.session().conf().get(Connect$.MODULE$.CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_MODEL_SIZE()));
    }

    public void checkModelSize(long estimatedModelSize) {
        if (this.totalMLCacheSizeBytes().get() + estimatedModelSize > this.getMLCacheMaxSize()) {
            throw new MLCacheSizeOverflowException(this.getMLCacheMaxSize());
        }
        if (estimatedModelSize > this.getModelMaxSize()) {
            throw new MLModelSizeOverflowException(estimatedModelSize, this.getModelMaxSize());
        }
    }

    private long estimateObjectSize(Object obj) {
        Object object = obj;
        if (object instanceof Model) {
            Model model = (Model)object;
            return model.estimatedSize();
        }
        throw new RuntimeException("Unexpected model object type.");
    }

    public Path getModelOffloadingPath(String refId) {
        Path path = this.offloadedModelsDir().resolve(refId);
        Predef$.MODULE$.require(path.startsWith(this.offloadedModelsDir()));
        return path;
    }

    public synchronized String register(Object obj) {
        String objectId = UUID.randomUUID().toString();
        if (obj instanceof Summary) {
            v0 = this.cachedModel().put(objectId, new CacheItem(this, obj, 0L));
        } else if (obj instanceof Model) {
            long l;
            if (this.getMemoryControlEnabled()) {
                long _sizeBytes = this.estimateObjectSize(obj);
                this.checkModelSize(_sizeBytes);
                l = _sizeBytes;
            } else {
                l = 0L;
            }
            long sizeBytes = l;
            this.cachedModel().put(objectId, new CacheItem(this, obj, sizeBytes));
            if (this.getMemoryControlEnabled()) {
                Path savePath = this.getModelOffloadingPath(objectId);
                ((MLWritable)obj).write().saveToLocal(((Object)savePath).toString());
                if (obj instanceof HasTrainingSummary && ((HasTrainingSummary)obj).hasSummary()) {
                    ((HasTrainingSummary)obj).saveSummary(((Object)savePath.resolve("summary")).toString());
                }
                Files.writeString(savePath.resolve(this.modelClassNameFile()), (CharSequence)obj.getClass().getName(), new OpenOption[0]);
                this.totalMLCacheInMemorySizeBytes().addAndGet(sizeBytes);
                v0 = BoxesRunTime.boxToLong((long)this.totalMLCacheSizeBytes().addAndGet(sizeBytes));
            } else {
                v0 = BoxedUnit.UNIT;
            }
        } else {
            throw new RuntimeException("'MLCache.register' only accepts model or summary objects.");
        }
        return objectId;
    }

    public void verifyObjectId(String refId) {
        try {
            UUID.fromString(refId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw SparkException$.MODULE$.internalError("The MLCache key " + refId + " is invalid.");
        }
    }

    public synchronized Object get(String refId) {
        String string = refId;
        String string2 = this.helperID();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.helper();
        }
        this.verifyObjectId(refId);
        Object obj = Option$.MODULE$.apply(this.cachedModel().get(refId)).map((Function1 & Serializable)x$1 -> x$1.obj()).getOrElse((Function0 & Serializable)() -> null);
        if (obj == null && this.getMemoryControlEnabled()) {
            Path loadPath = this.getModelOffloadingPath(refId);
            if (Files.isDirectory(loadPath, new LinkOption[0])) {
                String className = Files.readString(loadPath.resolve(this.modelClassNameFile()));
                obj = MLUtils$.MODULE$.loadTransformer(this.sessionHolder, className, ((Object)loadPath).toString(), true);
                long sizeBytes = this.estimateObjectSize(obj);
                this.cachedModel().put(refId, new CacheItem(this, obj, sizeBytes));
                v1 = BoxesRunTime.boxToLong((long)this.totalMLCacheInMemorySizeBytes().addAndGet(sizeBytes));
            } else {
                v1 = BoxedUnit.UNIT;
            }
        } else {
            v1 = BoxedUnit.UNIT;
        }
        return obj;
    }

    public boolean _removeModel(String refId, boolean evictOnly) {
        boolean bl;
        boolean removedFromMem;
        this.verifyObjectId(refId);
        CacheItem removedModel = (CacheItem)this.cachedModel().remove(refId);
        boolean bl2 = removedFromMem = removedModel != null;
        if (!evictOnly && removedModel != null && this.getMemoryControlEnabled()) {
            this.totalMLCacheSizeBytes().addAndGet(-removedModel.sizeBytes());
            Path removePath = this.getModelOffloadingPath(refId);
            File offloadingPath = new File(((Object)removePath).toString());
            if (offloadingPath.exists()) {
                SparkFileUtils$.MODULE$.deleteRecursively(offloadingPath);
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        boolean removedFromDisk = bl;
        return removedFromMem || removedFromDisk;
    }

    public synchronized boolean remove(String refId, boolean evictOnly) {
        boolean modelIsRemoved = this._removeModel(refId, evictOnly);
        return modelIsRemoved;
    }

    public boolean remove$default$2() {
        return false;
    }

    public synchronized int clear() {
        int size;
        block0: {
            size = this.cachedModel().size();
            this.cachedModel().clear();
            this.totalMLCacheSizeBytes().set(0L);
            if (!this.getMemoryControlEnabled()) break block0;
            SparkFileUtils$.MODULE$.cleanDirectory(new File(((Object)this.offloadedModelsDir()).toString()));
        }
        return size;
    }

    public synchronized String[] getInfo() {
        ArrayBuilder info = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        this.cachedModel().forEach((x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                CacheItem value = (CacheItem)tuple2._2();
                info.$plus$eq((Object)("id: " + key + ", obj: " + value.obj().getClass() + ", size: " + value.sizeBytes()));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return (String[])info.result();
    }

    private final void CacheItem$lzycompute$1() {
        MLCache mLCache = this;
        synchronized (mLCache) {
            if (this.CacheItem$module == null) {
                this.CacheItem$module = new MLCache$CacheItem$(this);
            }
        }
    }

    public MLCache(SessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
        Logging.$init$((Logging)this);
        this.helper = new ConnectHelper((SparkSession)sessionHolder.session());
        this.helperID = "______ML_CONNECT_HELPER______";
        this.modelClassNameFile = "__model_class_name__";
        this.totalMLCacheInMemorySizeBytes = new AtomicLong(0L);
        Path path = Paths.get(System.getProperty("java.io.tmpdir"), "spark_connect_model_cache", sessionHolder.sessionId());
        this.offloadedModelsDir = Files.createDirectories(path, new FileAttribute[0]);
        this.cachedModel = this.getMemoryControlEnabled() ? CacheBuilder.newBuilder().softValues().removalListener(removed -> this.totalMLCacheInMemorySizeBytes().addAndGet(-((CacheItem)removed.getValue()).sizeBytes())).maximumWeight(this.getMaxInMemoryCacheSizeKB()).weigher((key, value) -> (int)Math.ceil((double)value.sizeBytes() / (double)1024)).expireAfterAccess(this.getOffloadingTimeoutMinute(), TimeUnit.MINUTES).build().asMap() : new ConcurrentHashMap<String, CacheItem>();
        this.totalMLCacheSizeBytes = new AtomicLong(0L);
    }

    public class CacheItem
    implements Product,
    Serializable {
        private final Object obj;
        private final long sizeBytes;
        public final /* synthetic */ MLCache $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Object obj() {
            return this.obj;
        }

        public long sizeBytes() {
            return this.sizeBytes;
        }

        public CacheItem copy(Object obj, long sizeBytes) {
            return new CacheItem(this.org$apache$spark$sql$connect$ml$MLCache$CacheItem$$$outer(), obj, sizeBytes);
        }

        public Object copy$default$1() {
            return this.obj();
        }

        public long copy$default$2() {
            return this.sizeBytes();
        }

        public String productPrefix() {
            return "CacheItem";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.obj();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.sizeBytes());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheItem;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "obj";
                }
                case 1: {
                    return "sizeBytes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)1450061205);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.obj()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.sizeBytes()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheItem)) return false;
            if (((CacheItem)object).org$apache$spark$sql$connect$ml$MLCache$CacheItem$$$outer() != this.org$apache$spark$sql$connect$ml$MLCache$CacheItem$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheItem cacheItem = (CacheItem)x$1;
            if (this.sizeBytes() != cacheItem.sizeBytes()) return false;
            if (!BoxesRunTime.equals((Object)this.obj(), (Object)cacheItem.obj())) return false;
            if (!cacheItem.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MLCache org$apache$spark$sql$connect$ml$MLCache$CacheItem$$$outer() {
            return this.$outer;
        }

        public CacheItem(MLCache $outer, Object obj, long sizeBytes) {
            this.obj = obj;
            this.sizeBytes = sizeBytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

