/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSetInfo;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.DataOutputBuffer;

public class VectorGroupKeyHelper
extends VectorColumnSetInfo {
    public VectorGroupKeyHelper(int keyCount) {
        super(keyCount);
    }

    void init(VectorExpression[] keyExpressions) throws HiveException {
        for (int i = 0; i < this.keyCount; ++i) {
            String typeName = VectorizationContext.mapTypeNameSynonyms(keyExpressions[i].getOutputType());
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            ColumnVector.Type columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
            this.addKey(columnVectorType);
        }
        this.finishAdding();
    }

    public void copyGroupKey(VectorizedRowBatch inputBatch, VectorizedRowBatch outputBatch, DataOutputBuffer buffer) throws HiveException {
        LongColumnVector outputColumnVector;
        LongColumnVector inputColumnVector;
        int keyIndex;
        int i;
        for (i = 0; i < this.longIndices.length; ++i) {
            keyIndex = this.longIndices[i];
            inputColumnVector = (LongColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (LongColumnVector)outputBatch.cols[keyIndex];
            if (inputColumnVector.noNulls || !inputColumnVector.isNull[0]) {
                outputColumnVector.vector[outputBatch.size] = inputColumnVector.vector[0];
                continue;
            }
            outputColumnVector.noNulls = false;
            outputColumnVector.isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.doubleIndices.length; ++i) {
            keyIndex = this.doubleIndices[i];
            inputColumnVector = (DoubleColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (DoubleColumnVector)outputBatch.cols[keyIndex];
            if (inputColumnVector.noNulls || !inputColumnVector.isNull[0]) {
                outputColumnVector.vector[outputBatch.size] = inputColumnVector.vector[0];
                continue;
            }
            outputColumnVector.noNulls = false;
            outputColumnVector.isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.stringIndices.length; ++i) {
            keyIndex = this.stringIndices[i];
            inputColumnVector = (BytesColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (BytesColumnVector)outputBatch.cols[keyIndex];
            if (inputColumnVector.noNulls || !inputColumnVector.isNull[0]) {
                int start = buffer.getLength();
                int length = inputColumnVector.length[0];
                try {
                    buffer.write(inputColumnVector.vector[0], inputColumnVector.start[0], length);
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("bad write", ioe);
                }
                outputColumnVector.setRef(outputBatch.size, buffer.getData(), start, length);
                continue;
            }
            outputColumnVector.noNulls = false;
            outputColumnVector.isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.decimalIndices.length; ++i) {
            keyIndex = this.decimalIndices[i];
            inputColumnVector = (DecimalColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (DecimalColumnVector)outputBatch.cols[keyIndex];
            if (inputColumnVector.noNulls || !inputColumnVector.isNull[0]) {
                outputColumnVector.set(outputBatch.size, inputColumnVector.vector[0]);
                continue;
            }
            outputColumnVector.noNulls = false;
            outputColumnVector.isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.timestampIndices.length; ++i) {
            keyIndex = this.timestampIndices[i];
            inputColumnVector = (TimestampColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (TimestampColumnVector)outputBatch.cols[keyIndex];
            if (inputColumnVector.noNulls || !inputColumnVector.isNull[0]) {
                outputColumnVector.setElement(outputBatch.size, 0, (ColumnVector)inputColumnVector);
                continue;
            }
            outputColumnVector.noNulls = false;
            outputColumnVector.isNull[outputBatch.size] = true;
        }
        for (i = 0; i < this.intervalDayTimeIndices.length; ++i) {
            keyIndex = this.intervalDayTimeIndices[i];
            inputColumnVector = (IntervalDayTimeColumnVector)inputBatch.cols[keyIndex];
            outputColumnVector = (IntervalDayTimeColumnVector)outputBatch.cols[keyIndex];
            if (inputColumnVector.noNulls || !inputColumnVector.isNull[0]) {
                outputColumnVector.setElement(outputBatch.size, 0, (ColumnVector)inputColumnVector);
                continue;
            }
            outputColumnVector.noNulls = false;
            outputColumnVector.isNull[outputBatch.size] = true;
        }
    }
}

