/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkDecoder;
import com.ning.compress.lzf.util.ChunkDecoderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LZFInputStream
extends InputStream {
    protected final ChunkDecoder _decoder;
    protected final BufferRecycler _recycler;
    protected final InputStream _inputStream;
    protected boolean _inputStreamClosed;
    protected boolean _cfgFullReads = false;
    protected byte[] _inputBuffer;
    protected byte[] _decodedBytes;
    protected int _bufferPosition = 0;
    protected int _bufferLength = 0;

    public LZFInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public LZFInputStream(ChunkDecoder decoder, InputStream in) throws IOException {
        this(decoder, in, BufferRecycler.instance(), false);
    }

    public LZFInputStream(InputStream in, boolean fullReads) throws IOException {
        this(ChunkDecoderFactory.optimalInstance(), in, BufferRecycler.instance(), fullReads);
    }

    public LZFInputStream(ChunkDecoder decoder, InputStream in, boolean fullReads) throws IOException {
        this(decoder, in, BufferRecycler.instance(), fullReads);
    }

    public LZFInputStream(InputStream inputStream, BufferRecycler bufferRecycler) throws IOException {
        this(inputStream, bufferRecycler, false);
    }

    public LZFInputStream(InputStream in, BufferRecycler bufferRecycler, boolean fullReads) throws IOException {
        this(ChunkDecoderFactory.optimalInstance(), in, bufferRecycler, fullReads);
    }

    public LZFInputStream(ChunkDecoder decoder, InputStream in, BufferRecycler bufferRecycler, boolean fullReads) throws IOException {
        this._decoder = decoder;
        this._recycler = bufferRecycler;
        this._inputStream = in;
        this._inputStreamClosed = false;
        this._cfgFullReads = fullReads;
        this._inputBuffer = bufferRecycler.allocInputBuffer(65535);
        this._decodedBytes = bufferRecycler.allocDecodeBuffer(65535);
    }

    public void setUseFullReads(boolean b) {
        this._cfgFullReads = b;
    }

    @Override
    public int available() {
        if (this._inputStreamClosed) {
            return 0;
        }
        int left = this._bufferLength - this._bufferPosition;
        return left <= 0 ? 0 : left;
    }

    @Override
    public int read() throws IOException {
        if (!this.readyBuffer()) {
            return -1;
        }
        return this._decodedBytes[this._bufferPosition++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        if (!this.readyBuffer()) {
            return -1;
        }
        int chunkLength = Math.min(this._bufferLength - this._bufferPosition, length);
        System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
        this._bufferPosition += chunkLength;
        if (chunkLength == length || !this._cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this._bufferLength - this._bufferPosition, length - totalRead);
            System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
            this._bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    @Override
    public void close() throws IOException {
        this._bufferLength = 0;
        this._bufferPosition = 0;
        byte[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._recycler.releaseInputBuffer(buf);
        }
        if ((buf = this._decodedBytes) != null) {
            this._decodedBytes = null;
            this._recycler.releaseDecodeBuffer(buf);
        }
        if (!this._inputStreamClosed) {
            this._inputStreamClosed = true;
            this._inputStream.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        int amount;
        long skipped;
        if (this._inputStreamClosed) {
            return -1L;
        }
        if (n <= 0L) {
            return n;
        }
        if (this._bufferPosition < this._bufferLength) {
            int left = this._bufferLength - this._bufferPosition;
            if (n <= (long)left) {
                this._bufferPosition += (int)n;
                return n;
            }
            this._bufferPosition = this._bufferLength;
            skipped = left;
            n -= (long)left;
        } else {
            skipped = 0L;
        }
        while ((amount = this._decoder.skipOrDecodeChunk(this._inputStream, this._inputBuffer, this._decodedBytes, n)) >= 0) {
            skipped += (long)amount;
            if ((n -= (long)amount) > 0L) continue;
            return skipped;
        }
        if (amount == -1) {
            this.close();
            return skipped;
        }
        this._bufferLength = -(amount + 1);
        this._bufferPosition = (int)n;
        return skipped += n;
    }

    public InputStream getUnderlyingInputStream() {
        return this._inputStream;
    }

    public void discardBuffered() {
        this._bufferLength = 0;
        this._bufferPosition = 0;
    }

    public int readAndWrite(OutputStream out) throws IOException {
        int total = 0;
        while (this.readyBuffer()) {
            int avail = this._bufferLength - this._bufferPosition;
            out.write(this._decodedBytes, this._bufferPosition, avail);
            this._bufferPosition += avail;
            total += avail;
        }
        return total;
    }

    protected boolean readyBuffer() throws IOException {
        if (this._bufferPosition < this._bufferLength) {
            return true;
        }
        if (this._inputStreamClosed) {
            return false;
        }
        this._bufferLength = this._decoder.decodeChunk(this._inputStream, this._inputBuffer, this._decodedBytes);
        if (this._bufferLength < 0) {
            this.close();
            return false;
        }
        this._bufferPosition = 0;
        return this._bufferPosition < this._bufferLength;
    }
}

