/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.execution.aggregate.HashMapGenerator;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t4A\u0001D\u0007\u00015!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u00119\u0003!\u0011!Q\u0001\n!C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\u0006;\u0002!\tF\u0018\u0005\u0006?\u0002!\tB\u0018\u0005\u0006A\u0002!\tB\u0018\u0005\u0006C\u0002!\tB\u0018\u0002\u0019%><()Y:fI\"\u000b7\u000f['ba\u001e+g.\u001a:bi>\u0014(B\u0001\b\u0010\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\u0011#\u0005IQ\r_3dkRLwN\u001c\u0006\u0003%M\t1a]9m\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u000f\u000e\u00035I!AH\u0007\u0003!!\u000b7\u000f['ba\u001e+g.\u001a:bi>\u0014\u0018aA2uqB\u0011\u0011\u0005K\u0007\u0002E)\u00111\u0005J\u0001\bG>$WmZ3o\u0015\t)c%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0014\u0012\u0003!\u0019\u0017\r^1msN$\u0018BA\u0015#\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqR\fA#Y4he\u0016<\u0017\r^3FqB\u0014Xm]:j_:\u001c\bc\u0001\u00177s9\u0011Qf\r\b\u0003]Ej\u0011a\f\u0006\u0003ae\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q*\u0014a\u00029bG.\fw-\u001a\u0006\u0002e%\u0011q\u0007\u000f\u0002\u0004'\u0016\f(B\u0001\u001b6!\tQD(D\u0001<\u0015\tqA%\u0003\u0002>w\t\u0019\u0012iZ4sK\u001e\fG/Z#yaJ,7o]5p]\u0006\u0011r-\u001a8fe\u0006$X\rZ\"mCN\u001ch*Y7f!\t\u0001EI\u0004\u0002B\u0005B\u0011a&N\u0005\u0003\u0007V\na\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111)N\u0001\u0012OJ|W\u000f]5oO.+\u0017pU2iK6\f\u0007CA%M\u001b\u0005Q%BA&\u0012\u0003\u0015!\u0018\u0010]3t\u0013\ti%J\u0001\u0006TiJ,8\r\u001e+za\u0016\fABY;gM\u0016\u00148k\u00195f[\u0006\faBY5u\u001b\u0006D8)\u00199bG&$\u0018\u0010\u0005\u0002R%6\tQ'\u0003\u0002Tk\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\u001d1v\u000bW-[7r\u0003\"\u0001\b\u0001\t\u000b}9\u0001\u0019\u0001\u0011\t\u000b):\u0001\u0019A\u0016\t\u000by:\u0001\u0019A \t\u000b\u001d;\u0001\u0019\u0001%\t\u000b9;\u0001\u0019\u0001%\t\u000b=;\u0001\u0019\u0001)\u00025%t\u0017\u000e^5bY&TX-Q4he\u0016<\u0017\r^3ICNDW*\u00199\u0015\u0003}\nabZ3oKJ\fG/Z#rk\u0006d7/\u0001\u000bhK:,'/\u0019;f\r&tGm\u0014:J]N,'\u000f^\u0001\u0014O\u0016tWM]1uKJ{w/\u0013;fe\u0006$xN\u001d")
public class RowBasedHashMapGenerator
extends HashMapGenerator {
    private final CodegenContext ctx;
    private final String generatedClassName;
    private final StructType groupingKeySchema;
    private final StructType bufferSchema;
    private final int bitMaxCapacity;

    @Override
    public String initializeAggregateHashMap() {
        String keySchema = this.ctx.addReferenceObj("keySchemaTerm", (Object)this.groupingKeySchema, this.ctx.addReferenceObj$default$3());
        String valueSchema = this.ctx.addReferenceObj("valueSchemaTerm", (Object)this.bufferSchema, this.ctx.addReferenceObj$default$3());
        int numVarLenFields = ((IterableOnceOps)this.groupingKeys().map((Function1 & Serializable)x$1 -> x$1.dataType())).count((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RowBasedHashMapGenerator.$anonfun$initializeAggregateHashMap$2(x0$1)));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |  private org.apache.spark.sql.catalyst.expressions.RowBasedKeyValueBatch batch;\n       |  private int[] buckets;\n       |  private int capacity = 1 << " + this.bitMaxCapacity + ";\n       |  private double loadFactor = 0.5;\n       |  private int numBuckets = (int) (capacity / loadFactor);\n       |  private int maxSteps = 2;\n       |  private int numRows = 0;\n       |  private Object emptyVBase;\n       |  private long emptyVOff;\n       |  private int emptyVLen;\n       |  private boolean isBatchFull = false;\n       |  private org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter agg_rowWriter;\n       |\n       |\n       |  public " + this.generatedClassName + "(\n       |    org.apache.spark.memory.TaskMemoryManager taskMemoryManager,\n       |    InternalRow emptyAggregationBuffer) {\n       |    batch = org.apache.spark.sql.catalyst.expressions.RowBasedKeyValueBatch\n       |      .allocate(" + keySchema + ", " + valueSchema + ", taskMemoryManager, capacity);\n       |\n       |    final UnsafeProjection valueProjection = UnsafeProjection.create(" + valueSchema + ");\n       |    final byte[] emptyBuffer = valueProjection.apply(emptyAggregationBuffer).getBytes();\n       |\n       |    emptyVBase = emptyBuffer;\n       |    emptyVOff = Platform.BYTE_ARRAY_OFFSET;\n       |    emptyVLen = emptyBuffer.length;\n       |\n       |    agg_rowWriter = new org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter(\n       |      " + this.groupingKeySchema.length() + ", " + numVarLenFields * 32 + ");\n       |\n       |    buckets = new int[numBuckets];\n       |    java.util.Arrays.fill(buckets, -1);\n       |  }\n     "));
    }

    @Override
    public String generateEquals() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |private boolean equals(int idx, " + this.groupingKeySignature() + ") {\n       |  UnsafeRow row = batch.getKeyRow(buckets[idx]);\n       |  return " + this.genEqualsForKeys$1(this.groupingKeys()) + ";\n       |}\n     "));
    }

    @Override
    public String generateFindOrInsert() {
        String createUnsafeRowForKey = ((IterableOnceOps)((IterableOps)this.groupingKeys().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HashMapGenerator.Buffer key = (HashMapGenerator.Buffer)tuple2._1();
                int ordinal = tuple2._2$mcI$sp();
                if (key != null) {
                    HashMapGenerator.Buffer buffer = key;
                    if (true) {
                        int n = ordinal;
                        DataType dataType = buffer.dataType();
                        if (dataType instanceof DecimalType) {
                            DecimalType decimalType = (DecimalType)dataType;
                            return "agg_rowWriter.write(" + n + ", " + buffer.name() + ", " + decimalType.precision() + ", " + decimalType.scale() + ")";
                        }
                        if (dataType != null) {
                            DataType dataType2 = dataType;
                            if (!(dataType2 instanceof StringType || dataType2 instanceof CalendarIntervalType || CodeGenerator$.MODULE$.isPrimitiveType(dataType2))) {
                                throw new IllegalArgumentException("cannot generate code for unsupported type: " + dataType2);
                            }
                            return "agg_rowWriter.write(" + n + ", " + buffer.name() + ")";
                        }
                        throw new MatchError((Object)dataType);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        })).mkString(";\n");
        String resetNullBits = ((IterableOnceOps)this.groupingKeySchema.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nullable()))).forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RowBasedHashMapGenerator.$anonfun$generateFindOrInsert$3(BoxesRunTime.unboxToBoolean((Object)x$3)))) ? "" : "agg_rowWriter.zeroOutNullBytes();";
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |public org.apache.spark.sql.catalyst.expressions.UnsafeRow findOrInsert(" + this.groupingKeySignature() + ") {\n       |  long h = hash(" + ((IterableOnceOps)this.groupingKeys().map((Function1 & Serializable)x$4 -> x$4.name())).mkString(", ") + ");\n       |  int step = 0;\n       |  int idx = (int) h & (numBuckets - 1);\n       |  while (step < maxSteps) {\n       |    // Return bucket index if it's either an empty slot or already contains the key\n       |    if (buckets[idx] == -1) {\n       |      if (numRows < capacity && !isBatchFull) {\n       |        agg_rowWriter.reset();\n       |        " + resetNullBits + "\n       |        " + createUnsafeRowForKey + ";\n       |        org.apache.spark.sql.catalyst.expressions.UnsafeRow agg_result\n       |          = agg_rowWriter.getRow();\n       |        Object kbase = agg_result.getBaseObject();\n       |        long koff = agg_result.getBaseOffset();\n       |        int klen = agg_result.getSizeInBytes();\n       |\n       |        UnsafeRow vRow\n       |            = batch.appendRow(kbase, koff, klen, emptyVBase, emptyVOff, emptyVLen);\n       |        if (vRow == null) {\n       |          isBatchFull = true;\n       |        } else {\n       |          buckets[idx] = numRows++;\n       |        }\n       |        return vRow;\n       |      } else {\n       |        // No more space\n       |        return null;\n       |      }\n       |    } else if (equals(idx, " + ((IterableOnceOps)this.groupingKeys().map((Function1 & Serializable)x$5 -> x$5.name())).mkString(", ") + ")) {\n       |      return batch.getValueRow(buckets[idx]);\n       |    }\n       |    idx = (idx + 1) & (numBuckets - 1);\n       |    step++;\n       |  }\n       |  // Didn't find it\n       |  return null;\n       |}\n     "));
    }

    @Override
    public String generateRowIterator() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |public org.apache.spark.unsafe.KVIterator<UnsafeRow, UnsafeRow> rowIterator() {\n       |  return batch.rowIterator();\n       |}\n     "));
    }

    public static final /* synthetic */ boolean $anonfun$initializeAggregateHashMap$2(DataType x0$1) {
        DataType dataType = x0$1;
        return !UnsafeRow.isFixedLength((DataType)dataType);
    }

    private final String genEqualsForKeys$1(Seq groupingKeys) {
        return ((IterableOnceOps)((IterableOps)groupingKeys.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HashMapGenerator.Buffer key = (HashMapGenerator.Buffer)tuple2._1();
                int ordinal = tuple2._2$mcI$sp();
                if (key != null) {
                    HashMapGenerator.Buffer buffer = key;
                    if (true) {
                        int n = ordinal;
                        return "(" + $this.ctx.genEqual(buffer.dataType(), CodeGenerator$.MODULE$.getValue("row", buffer.dataType(), Integer.toString(n)), buffer.name()) + ")";
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        })).mkString(" && ");
    }

    public static final /* synthetic */ boolean $anonfun$generateFindOrInsert$3(boolean x$3) {
        return !x$3;
    }

    public RowBasedHashMapGenerator(CodegenContext ctx, Seq<AggregateExpression> aggregateExpressions, String generatedClassName, StructType groupingKeySchema, StructType bufferSchema, int bitMaxCapacity) {
        this.ctx = ctx;
        this.generatedClassName = generatedClassName;
        this.groupingKeySchema = groupingKeySchema;
        this.bufferSchema = bufferSchema;
        this.bitMaxCapacity = bitMaxCapacity;
        super(ctx, aggregateExpressions, generatedClassName, groupingKeySchema, bufferSchema);
    }
}

