/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper$SchemaWriter$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadataValue;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tEc\u0001\u0002\u0013&\u0001QB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003d\u0011\u00151\u0007\u0001\"\u0001h\u0011\u001di\u0007A1A\u0005\n9Daa\u001c\u0001!\u0002\u0013a\u0006b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007q\u0002\u0001\u000b\u0011\u0002:\t\u000f)\u0003!\u0019!C\u0005s\"1q\u0010\u0001Q\u0001\niDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!A\u0011q\u0005\u0001\u0005\u0002-\ny\u0004C\u0004\u0002r\u0001!I!a\u0001\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBAV\u0001\u0011\u0005\u0011QV\u0004\b\u0003s+\u0003\u0012AA^\r\u0019!S\u0005#\u0001\u0002>\"1a-\u0006C\u0001\u0003\u007fC\u0011\"!1\u0016\u0005\u0004%\t!a1\t\u0011\u0005\u0015W\u0003)A\u0005\u0003sAq!a2\u0016\t\u0013\tI\rC\u0004\u0002\u0002U!\t!!4\t\u000f\u0005-V\u0003\"\u0001\u0002Z\"I!QC\u000b\u0012\u0002\u0013\u0005!q\u0003\u0005\n\u0005[)\u0012\u0013!C\u0001\u0005_A\u0011Ba\r\u0016#\u0003%\tA!\u000e\t\u0013\teR#%A\u0005\u0002\tm\u0002\"\u0003B +E\u0005I\u0011\u0001B!\u0011\u001d\u0011)%\u0006C\u0001\u0005\u000fB\u0011B!\u0014\u0016#\u0003%\tA!\u000e\t\u0013\t=S#%A\u0005\u0002\tm\"aH*uCR,7k\u00195f[\u0006\u001cu.\u001c9bi&\u0014\u0017\u000e\\5us\u000eCWmY6fe*\u0011aeJ\u0001\u0006gR\fG/\u001a\u0006\u0003Q%\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005)Z\u0013!C3yK\u000e,H/[8o\u0015\taS&A\u0002tc2T!AL\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0002\u0001'\r\u0001Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qzT\"A\u001f\u000b\u0005yj\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0001k$a\u0002'pO\u001eLgnZ\u0001\u000baJ|g/\u001b3fe&#\u0007CA\"E\u001b\u0005)\u0013BA#&\u0005Q\u0019F/\u0019;f'R|'/\u001a)s_ZLG-\u001a:JI\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005!kU\"A%\u000b\u0005)[\u0015\u0001B2p]\u001aT!\u0001T\u0018\u0002\r!\fGm\\8q\u0013\tq\u0015JA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0013_2$7k\u00195f[\u00064\u0015\u000e\\3QCRD7\u000fE\u0002R3rs!AU,\u000f\u0005M3V\"\u0001+\u000b\u0005U\u001b\u0014A\u0002\u001fs_>$h(C\u00019\u0013\tAv'A\u0004qC\u000e\\\u0017mZ3\n\u0005i[&\u0001\u0002'jgRT!\u0001W\u001c\u0011\u0005u\u0003W\"\u00010\u000b\u0005}[\u0015A\u00014t\u0013\t\tgL\u0001\u0003QCRD\u0017!\u00058foN\u001b\u0007.Z7b\r&dW\rU1uQB\u0019a\u0007\u001a/\n\u0005\u0015<$AB(qi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0006Q&T7\u000e\u001c\t\u0003\u0007\u0002AQ!Q\u0003A\u0002\tCQAR\u0003A\u0002\u001dCqaT\u0003\u0011\u0002\u0003\u0007\u0001\u000bC\u0004c\u000bA\u0005\t\u0019A2\u0002%M\u001c\u0007.Z7b\r&dW\rT8dCRLwN\\\u000b\u00029\u0006\u00192o\u00195f[\u00064\u0015\u000e\\3M_\u000e\fG/[8oA\u0005\u0011a-\\\u000b\u0002eB\u00111O^\u0007\u0002i*\u0011QoJ\u0001\u000eG\",7m\u001b9pS:$\u0018N\\4\n\u0005]$(!F\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM]\u0001\u0004M6\u0004S#\u0001>\u0011\u0005mlX\"\u0001?\u000b\u0005yZ\u0013B\u0001@}\u0005\u001d\u0019\u0016\u000bT\"p]\u001a\fQaY8oM\u0002\naB]3bIN\u001b\u0007.Z7b\r&dW\r\u0006\u0002\u0002\u0006A!\u0011+WA\u0004!\r\u0019\u0015\u0011B\u0005\u0004\u0003\u0017)#!G*uCR,7\u000b^8sK\u000e{GNR1nS2L8k\u00195f[\u0006\fqB]3bIN\u001b\u0007.Z7b\r&dWm\u001d\u000b\u0003\u0003#\u0001\u0002\"a\u0005\u0002\u001c\u0005\u0005\u0012Q\u0001\b\u0005\u0003+\t9\u0002\u0005\u0002To%\u0019\u0011\u0011D\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\ti\"a\b\u0003\u00075\u000b\u0007OC\u0002\u0002\u001a]\u0002B!a\u0005\u0002$%!\u0011QEA\u0010\u0005\u0019\u0019FO]5oO\u0006\u00012M]3bi\u0016\u001c6\r[3nC\u001aKG.\u001a\u000b\u0007\u0003W\t\t$!\u000e\u0011\u0007Y\ni#C\u0002\u00020]\u0012A!\u00168ji\"9\u00111\u0007\bA\u0002\u0005\u0015\u0011!G:uCR,7\u000b^8sK\u000e{GNR1nS2L8k\u00195f[\u0006Dq!a\u000e\u000f\u0001\u0004\tI$\u0001\nti\u0006$XmU2iK6\fg+\u001a:tS>t\u0007c\u0001\u001c\u0002<%\u0019\u0011QH\u001c\u0003\u0007%sG\u000f\u0006\u0004\u0002,\u0005\u0005\u00131\t\u0005\b\u0003gy\u0001\u0019AA\u0003\u0011\u001d\t)e\u0004a\u0001\u0003\u000f\nAb]2iK6\fwK]5uKJ\u0004B!!\u0013\u0002l9!\u00111JA4\u001d\u0011\ti%!\u001a\u000f\t\u0005=\u00131\r\b\u0005\u0003#\n\tG\u0004\u0003\u0002T\u0005}c\u0002BA+\u0003;rA!a\u0016\u0002\\9\u00191+!\u0017\n\u0003IJ!\u0001M\u0019\n\u00059z\u0013B\u0001\u0017.\u0013\tQ3&\u0003\u0002)S%\u0011aeJ\u0005\u0004\u0003S*\u0013\u0001D*dQ\u0016l\u0017\rS3ma\u0016\u0014\u0018\u0002BA7\u0003_\u0012AbU2iK6\fwK]5uKJT1!!\u001b&\u0003q9W\r^#ySN$\u0018N\\4LKf\fe\u000e\u001a,bYV,7k\u00195f[\u0006\f\u0011c]2iK6\f7oQ8na\u0006$\u0018N\u00197f)\u0019\t9(! \u0002\u000eB\u0019a'!\u001f\n\u0007\u0005mtGA\u0004C_>dW-\u00198\t\u000f\u0005}\u0014\u00031\u0001\u0002\u0002\u0006a1\u000f^8sK\u0012\u001c6\r[3nCB!\u00111QAE\u001b\t\t)IC\u0002\u0002\b.\nQ\u0001^=qKNLA!a#\u0002\u0006\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005=\u0015\u00031\u0001\u0002\u0002\u000611o\u00195f[\u0006\fQa\u00195fG.$\"\"!&\u0002\u001c\u0006}\u00151UAT!\u001d1\u0014qSA\u0004\u0003oJ1!!'8\u0005\u0019!V\u000f\u001d7fe!9\u0011Q\u0014\nA\u0002\u0005\u0015\u0011AC8mIN\u001b\u0007.Z7bg\"9\u0011\u0011\u0015\nA\u0002\u0005\u001d\u0011!\u00038foN\u001b\u0007.Z7b\u0011\u001d\t)K\u0005a\u0001\u0003o\n\u0011#[4o_J,g+\u00197vKN\u001b\u0007.Z7b\u0011\u001d\tIK\u0005a\u0001\u0003o\nac]2iK6\fWI^8mkRLwN\\#oC\ndW\rZ\u0001\"m\u0006d\u0017\u000eZ1uK\u0006sG-T1zE\u0016,eo\u001c7wKN#\u0018\r^3TG\",W.\u0019\u000b\u000b\u0003o\ny+a-\u00026\u0006]\u0006bBAY'\u0001\u0007\u0011QA\u0001\u000f]\u0016<8\u000b^1uKN\u001b\u0007.Z7b\u0011\u001d\t)k\u0005a\u0001\u0003oBq!a\u000e\u0014\u0001\u0004\tI\u0004C\u0004\u0002*N\u0001\r!a\u001e\u0002?M#\u0018\r^3TG\",W.Y\"p[B\fG/\u001b2jY&$\u0018p\u00115fG.,'\u000f\u0005\u0002D+M\u0019Q#N\u001e\u0015\u0005\u0005m\u0016\u0001E*D\u0011\u0016k\u0015i\u0018$P%6\u000bEk\u0018,4+\t\tI$A\tT\u0007\"+U*Q0G\u001fJk\u0015\tV0Wg\u0001\na\u0004Z5tC2dwn\u001e\"j]\u0006\u0014\u00180\u00138fcV\fG.\u001b;z\u0007>dW/\u001c8\u0015\t\u0005-\u00121\u001a\u0005\b\u0003\u001fK\u0002\u0019AAA)\u0011\t)!a4\t\u000f\u0005E'\u00041\u0001\u0002T\u0006A\u0011N\\*ue\u0016\fW\u000eE\u0002^\u0003+L1!a6_\u0005E15\u000bR1uC&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0017\u00037\f\t/!>\u0002x\u0006e(1\u0001B\u0003\u0005\u0017\u0011yA!\u0005\u0003\u0014A\u00191)!8\n\u0007\u0005}WEA\u000eTi\u0006$XmU2iK6\fg+\u00197jI\u0006$\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u0003G\\\u0002\u0019AAs\u0003%\u0019H/\u0019;f\u0013:4w\u000e\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\u0011M$\u0018\r^3gk2T1!a<(\u0003%y\u0007/\u001a:bi>\u00148/\u0003\u0003\u0002t\u0006%(!G*uCR,g-\u001e7Pa\u0016\u0014\u0018\r^8s'R\fG/Z%oM>DQAR\u000eA\u0002\u001dCq!!-\u001c\u0001\u0004\t)\u0001C\u0004\u0002|n\u0001\r!!@\u0002\u0019M,7o]5p]N#\u0018\r^3\u0011\u0007m\fy0C\u0002\u0003\u0002q\u0014AbU3tg&|gn\u0015;bi\u0016Dq!a\u000e\u001c\u0001\u0004\tI\u0004C\u0005\u0003\bm\u0001\n\u00111\u0001\u0003\n\u0005aQ\r\u001f;sC>\u0003H/[8ogBA\u00111CA\u000e\u0003C\t\t\u0003C\u0005\u0003\u000em\u0001\n\u00111\u0001\u0002\"\u0005I1\u000f^8sK:\u000bW.\u001a\u0005\b\u001fn\u0001\n\u00111\u0001Q\u0011\u001d\u00117\u0004%AA\u0002\rD\u0011\"!+\u001c!\u0003\u0005\r!a\u001e\u0002WY\fG.\u001b3bi\u0016\fe\u000eZ'bs\n,WI^8mm\u0016\u001cF/\u0019;f'\u000eDW-\\1%I\u00164\u0017-\u001e7uIY*\"A!\u0007+\t\t%!1D\u0016\u0003\u0005;\u0001BAa\b\u0003*5\u0011!\u0011\u0005\u0006\u0005\u0005G\u0011)#A\u0005v]\u000eDWmY6fI*\u0019!qE\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003,\t\u0005\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Yc/\u00197jI\u0006$X-\u00118e\u001b\u0006L(-Z#w_24Xm\u0015;bi\u0016\u001c6\r[3nC\u0012\"WMZ1vYR$s'\u0006\u0002\u00032)\"\u0011\u0011\u0005B\u000e\u0003-2\u0018\r\\5eCR,\u0017I\u001c3NCf\u0014W-\u0012<pYZ,7\u000b^1uKN\u001b\u0007.Z7bI\u0011,g-Y;mi\u0012BTC\u0001B\u001cU\r\u0001&1D\u0001,m\u0006d\u0017\u000eZ1uK\u0006sG-T1zE\u0016,eo\u001c7wKN#\u0018\r^3TG\",W.\u0019\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!Q\b\u0016\u0004G\nm\u0011\u0001\f<bY&$\u0017\r^3B]\u0012l\u0015-\u001f2f\u000bZ|GN^3Ti\u0006$XmU2iK6\fG\u0005Z3gCVdG\u000fJ\u00191+\t\u0011\u0019E\u000b\u0003\u0002x\tm\u0011AC:dQ\u0016l\u0017MR5mKR\u0019AL!\u0013\t\r\t-\u0013\u00051\u0001]\u0003=\u0019Ho\u001c:f\u0007BdunY1uS>t\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005\u000e")
public class StateSchemaCompatibilityChecker
implements Logging {
    private final List<Path> oldSchemaFilePaths;
    private final Option<Path> newSchemaFilePath;
    private final Path org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation;
    private final CheckpointFileManager fm;
    private final SQLConf conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Path> $lessinit$greater$default$4() {
        return StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4();
    }

    public static List<Path> $lessinit$greater$default$3() {
        return StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$3();
    }

    public static Path schemaFile(Path storeCpLocation) {
        return StateSchemaCompatibilityChecker$.MODULE$.schemaFile(storeCpLocation);
    }

    public static boolean validateAndMaybeEvolveStateSchema$default$10() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$10();
    }

    public static Option<Path> validateAndMaybeEvolveStateSchema$default$9() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$9();
    }

    public static List<Path> validateAndMaybeEvolveStateSchema$default$8() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$8();
    }

    public static String validateAndMaybeEvolveStateSchema$default$7() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$7();
    }

    public static scala.collection.immutable.Map<String, String> validateAndMaybeEvolveStateSchema$default$6() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$6();
    }

    public static int SCHEMA_FORMAT_V3() {
        return StateSchemaCompatibilityChecker$.MODULE$.SCHEMA_FORMAT_V3();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Path org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation() {
        return this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation;
    }

    private CheckpointFileManager fm() {
        return this.fm;
    }

    private SQLConf conf() {
        return this.conf;
    }

    public List<StateStoreColFamilySchema> readSchemaFile() {
        FSDataInputStream inStream = this.fm().open(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation());
        return StateSchemaCompatibilityChecker$.MODULE$.readSchemaFile(inStream);
    }

    public scala.collection.immutable.Map<String, List<StateStoreColFamilySchema>> readSchemaFiles() {
        List stateSchemaFilePaths = (List)((SeqOps)this.oldSchemaFilePaths.$plus$plus((IterableOnce)new .colon.colon((Object)this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation(), (List)Nil$.MODULE$))).distinct();
        return stateSchemaFilePaths.flatMap((Function1 & Serializable)schemaFile -> {
            if (this.fm().exists((Path)schemaFile)) {
                FSDataInputStream inStream = this.fm().open((Path)schemaFile);
                return StateSchemaCompatibilityChecker$.MODULE$.readSchemaFile(inStream);
            }
            return package$.MODULE$.List().empty();
        }).groupBy((Function1 & Serializable)x$2 -> x$2.colFamilyName());
    }

    private void createSchemaFile(List<StateStoreColFamilySchema> stateStoreColFamilySchema, int stateSchemaVersion) {
        if (stateSchemaVersion == StateSchemaCompatibilityChecker$.MODULE$.SCHEMA_FORMAT_V3() && this.newSchemaFilePath.isEmpty()) {
            throw new IllegalStateException("Schema file path is required for schema version 3");
        }
        SchemaHelper.SchemaWriter schemaWriter = SchemaHelper$SchemaWriter$.MODULE$.createSchemaWriter(stateSchemaVersion);
        this.createSchemaFile(stateStoreColFamilySchema, schemaWriter);
    }

    public void createSchemaFile(List<StateStoreColFamilySchema> stateStoreColFamilySchema, SchemaHelper.SchemaWriter schemaWriter) {
        Path path;
        Option<Path> option = this.newSchemaFilePath;
        if (option instanceof Some) {
            Some some = (Some)option;
            Path path2 = (Path)some.value();
            this.fm().mkdirs(path2.getParent());
            path = path2;
        } else if (None$.MODULE$.equals(option)) {
            path = this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation();
        } else {
            throw new MatchError(option);
        }
        Path schemaFilePath = path;
        CheckpointFileManager.CancellableFSDataOutputStream outStream = this.fm().createAtomic(schemaFilePath, false);
        try {
            schemaWriter.write(stateStoreColFamilySchema, outStream);
            outStream.close();
        }
        catch (Throwable e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to write schema file to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, schemaFilePath)}))), e);
            outStream.cancel();
            throw e;
        }
    }

    private List<StateStoreColFamilySchema> getExistingKeyAndValueSchema() {
        if (this.fm().exists(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation())) {
            return this.readSchemaFile();
        }
        return package$.MODULE$.List().empty();
    }

    private boolean schemasCompatible(StructType storedSchema, StructType schema) {
        return DataType$.MODULE$.equalsIgnoreNameAndCompatibleNullability((DataType)schema, (DataType)storedSchema);
    }

    private Tuple2<StateStoreColFamilySchema, Object> check(List<StateStoreColFamilySchema> oldSchemas, StateStoreColFamilySchema newSchema, boolean ignoreValueSchema, boolean schemaEvolutionEnabled) {
        StateStoreColFamilySchema mostRecentSchema = (StateStoreColFamilySchema)oldSchemas.last();
        short x$1 = mostRecentSchema.keySchemaId();
        short x$2 = mostRecentSchema.valueSchemaId();
        String x$3 = newSchema.copy$default$1();
        StructType x$4 = newSchema.copy$default$3();
        StructType x$52 = newSchema.copy$default$5();
        Option<KeyStateEncoderSpec> x$6 = newSchema.copy$default$6();
        Option<StructType> x$7 = newSchema.copy$default$7();
        StateStoreColFamilySchema resultSchema = newSchema.copy(x$3, x$1, x$4, x$2, x$52, x$6, x$7);
        Tuple2 tuple2 = new Tuple2((Object)mostRecentSchema.keySchema(), (Object)mostRecentSchema.valueSchema());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructType storedKeySchema = (StructType)tuple2._1();
        StructType storedValueSchema = (StructType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storedKeySchema, (Object)storedValueSchema);
        StructType storedKeySchema2 = (StructType)tuple22._1();
        StructType storedValueSchema2 = (StructType)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)newSchema.keySchema(), (Object)newSchema.valueSchema());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        StructType keySchema = (StructType)tuple23._1();
        StructType valueSchema = (StructType)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)keySchema, (Object)valueSchema);
        StructType keySchema2 = (StructType)tuple24._1();
        StructType valueSchema2 = (StructType)tuple24._2();
        if (storedKeySchema2.equals((Object)keySchema2) && (ignoreValueSchema || storedValueSchema2.equals((Object)valueSchema2))) {
            return new Tuple2((Object)mostRecentSchema, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (!this.schemasCompatible(storedKeySchema2, keySchema2)) {
            throw StateStoreErrors$.MODULE$.stateStoreKeySchemaNotCompatible(storedKeySchema2.toString(), keySchema2.toString());
        }
        if (!ignoreValueSchema && schemaEvolutionEnabled) {
            java.lang.Iterable oldStateSchemas = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((List)oldSchemas.sortBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToShort((short)x$5.valueSchemaId()), (Ordering)Ordering.Short$.MODULE$)).reverse().map((Function1 & Serializable)oldSchema -> new StateSchemaMetadataValue(oldSchema.valueSchema(), SchemaConverters$.MODULE$.toAvroTypeWithDefaults(oldSchema.valueSchema())))).asJava();
            Schema newAvroSchema = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(valueSchema2);
            SchemaValidator validator = new SchemaValidatorBuilder().canReadStrategy().validateAll();
            oldStateSchemas.forEach(oldStateSchema -> {
                try {
                    validator.validate(newAvroSchema, CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)oldStateSchema.avroSchema(), (List)Nil$.MODULE$)).asJava());
                }
                catch (SchemaValidationException schemaValidationException) {
                    throw StateStoreErrors$.MODULE$.stateStoreInvalidValueSchemaEvolution(oldStateSchema.sqlSchema().toString(), valueSchema2.toString());
                }
                catch (Throwable e) {
                    throw e;
                }
            });
            if (resultSchema.valueSchemaId() + 1 >= this.conf().streamingValueStateSchemaEvolutionThreshold()) {
                throw StateStoreErrors$.MODULE$.stateStoreValueSchemaEvolutionThresholdExceeded(resultSchema.valueSchemaId() + 1, this.conf().streamingValueStateSchemaEvolutionThreshold(), newSchema.colFamilyName());
            }
            short x$8 = StateSchemaCompatibilityChecker.incrementSchemaId$1(mostRecentSchema.valueSchemaId());
            String x$9 = resultSchema.copy$default$1();
            short x$10 = resultSchema.copy$default$2();
            StructType x$11 = resultSchema.copy$default$3();
            StructType x$12 = resultSchema.copy$default$5();
            Option<KeyStateEncoderSpec> x$13 = resultSchema.copy$default$6();
            Option<StructType> x$14 = resultSchema.copy$default$7();
            return new Tuple2((Object)resultSchema.copy(x$9, x$10, x$11, x$8, x$12, x$13, x$14), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (!ignoreValueSchema && !this.schemasCompatible(storedValueSchema2, valueSchema2)) {
            throw StateStoreErrors$.MODULE$.stateStoreValueSchemaNotCompatible(storedValueSchema2.toString(), valueSchema2.toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Detected schema change which is compatible. Allowing to put rows.");
        return new Tuple2((Object)mostRecentSchema, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean validateAndMaybeEvolveStateSchema(List<StateStoreColFamilySchema> newStateSchema, boolean ignoreValueSchema, int stateSchemaVersion, boolean schemaEvolutionEnabled) {
        boolean newSchemaFileWritten;
        block3: {
            scala.collection.immutable.Map<String, List<StateStoreColFamilySchema>> existingStateSchemaMap = this.readSchemaFiles();
            List mostRecentColFamilies = this.getExistingKeyAndValueSchema().map((Function1 & Serializable)x$6 -> x$6.colFamilyName());
            if (mostRecentColFamilies.isEmpty()) {
                List initializedSchemas = newStateSchema.map((Function1 & Serializable)schema -> {
                    boolean x$1 = false;
                    boolean x$2 = false;
                    String x$3 = schema.copy$default$1();
                    StructType x$4 = schema.copy$default$3();
                    StructType x$5 = schema.copy$default$5();
                    Option<KeyStateEncoderSpec> x$6 = schema.copy$default$6();
                    Option<StructType> x$7 = schema.copy$default$7();
                    return schema.copy(x$3, (short)0, x$4, (short)0, x$5, x$6, x$7);
                });
                this.createSchemaFile((List<StateStoreColFamilySchema>)((List)initializedSchemas.sortBy((Function1 & Serializable)x$7 -> x$7.colFamilyName(), (Ordering)Ordering.String$.MODULE$)), stateSchemaVersion);
                return true;
            }
            Tuple2 tuple2 = (Tuple2)newStateSchema.foldLeft((Object)new Tuple2((Object)package$.MODULE$.List().empty(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    StateStoreColFamilySchema newSchema = (StateStoreColFamilySchema)tuple2._2();
                    if (tuple22 != null) {
                        List schemas = (List)tuple22._1();
                        boolean evolved = tuple22._2$mcZ$sp();
                        Option option = existingStateSchemaMap.get((Object)newSchema.colFamilyName());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            List existingSchemas = (List)some.value();
                            Tuple2<StateStoreColFamilySchema, Object> tuple23 = this.check((List<StateStoreColFamilySchema>)existingSchemas, newSchema, ignoreValueSchema, schemaEvolutionEnabled);
                            if (tuple23 == null) {
                                throw new MatchError(tuple23);
                            }
                            StateStoreColFamilySchema updatedSchema = (StateStoreColFamilySchema)tuple23._1();
                            boolean hasEvolved = tuple23._2$mcZ$sp();
                            Tuple2 tuple24 = new Tuple2((Object)updatedSchema, (Object)BoxesRunTime.boxToBoolean((boolean)hasEvolved));
                            StateStoreColFamilySchema updatedSchema2 = (StateStoreColFamilySchema)tuple24._1();
                            boolean hasEvolved2 = tuple24._2$mcZ$sp();
                            StateStoreColFamilySchema stateStoreColFamilySchema = updatedSchema2;
                            return new Tuple2((Object)schemas.$colon$colon((Object)stateStoreColFamilySchema), (Object)BoxesRunTime.boxToBoolean((evolved || hasEvolved2 ? 1 : 0) != 0));
                        }
                        if (None$.MODULE$.equals(option)) {
                            StateStoreColFamilySchema newSchemaWithIds;
                            boolean x$8 = false;
                            boolean x$9 = false;
                            String x$10 = newSchema.copy$default$1();
                            StructType x$11 = newSchema.copy$default$3();
                            StructType x$12 = newSchema.copy$default$5();
                            Option<KeyStateEncoderSpec> x$13 = newSchema.copy$default$6();
                            Option<StructType> x$14 = newSchema.copy$default$7();
                            StateStoreColFamilySchema stateStoreColFamilySchema = newSchemaWithIds = newSchema.copy(x$10, (short)0, x$11, (short)0, x$12, x$13, x$14);
                            return new Tuple2((Object)schemas.$colon$colon((Object)stateStoreColFamilySchema), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        }
                        throw new MatchError((Object)option);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List evolvedSchemas = (List)tuple2._1();
            boolean hasEvolutions = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)evolvedSchemas, (Object)BoxesRunTime.boxToBoolean((boolean)hasEvolutions));
            List evolvedSchemas2 = (List)tuple22._1();
            boolean hasEvolutions2 = tuple22._2$mcZ$sp();
            scala.collection.immutable.Set newColFamilies = newStateSchema.map((Function1 & Serializable)x$10 -> x$10.colFamilyName()).toSet();
            scala.collection.immutable.Set oldColFamilies = mostRecentColFamilies.toSet();
            scala.collection.immutable.Set set = newColFamilies;
            scala.collection.immutable.Set set2 = oldColFamilies;
            boolean colFamiliesAddedOrRemoved = set == null ? set2 != null : !set.equals(set2);
            boolean bl = newSchemaFileWritten = hasEvolutions2 || colFamiliesAddedOrRemoved;
            if (this.oldSchemaFilePaths.size() == this.conf().streamingStateSchemaFilesThreshold() && colFamiliesAddedOrRemoved) {
                throw StateStoreErrors$.MODULE$.streamingStateSchemaFilesThresholdExceeded(this.oldSchemaFilePaths.size() + 1, this.conf().streamingStateSchemaFilesThreshold(), (List<String>)newColFamilies.diff((Set)oldColFamilies).toList(), (List<String>)oldColFamilies.diff((Set)newColFamilies).toList());
            }
            if (stateSchemaVersion != StateSchemaCompatibilityChecker$.MODULE$.SCHEMA_FORMAT_V3() || !newSchemaFileWritten) break block3;
            this.createSchemaFile((List<StateStoreColFamilySchema>)((List)evolvedSchemas2.sortBy((Function1 & Serializable)x$11 -> x$11.colFamilyName(), (Ordering)Ordering.String$.MODULE$)), stateSchemaVersion);
        }
        return newSchemaFileWritten;
    }

    private static final short incrementSchemaId$1(short id) {
        return (short)(id + 1);
    }

    public StateSchemaCompatibilityChecker(StateStoreProviderId providerId, Configuration hadoopConf, List<Path> oldSchemaFilePaths, Option<Path> newSchemaFilePath) {
        Path path;
        this.oldSchemaFilePaths = oldSchemaFilePaths;
        this.newSchemaFilePath = newSchemaFilePath;
        Logging.$init$((Logging)this);
        if (oldSchemaFilePaths.isEmpty()) {
            Path storeCpLocation = providerId.storeId().storeCheckpointLocation();
            path = StateSchemaCompatibilityChecker$.MODULE$.schemaFile(storeCpLocation);
        } else {
            path = (Path)oldSchemaFilePaths.last();
        }
        this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation = path;
        this.fm = CheckpointFileManager$.MODULE$.create(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation(), hadoopConf);
        this.fm().mkdirs(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation().getParent());
        this.conf = (SQLConf)SparkSession$.MODULE$.getActiveSession().map((Function1 & Serializable)x$1 -> x$1.sessionState().conf()).getOrElse((Function0 & Serializable)() -> new SQLConf());
    }
}

