/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Map;

public final class TemporalFields {
    public static final TemporalField DAY_OF_HALF = DayOfHalfField.INSTANCE;
    public static final TemporalField HALF_OF_YEAR = HalfOfYearField.INSTANCE;
    public static final TemporalUnit HALF_YEARS = HalfUnit.INSTANCE;

    private TemporalFields() {
    }

    private static enum HalfUnit implements TemporalUnit
    {
        INSTANCE;


        @Override
        public Duration getDuration() {
            return Duration.ofSeconds(15778476L);
        }

        @Override
        public boolean isDurationEstimated() {
            return true;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public boolean isSupportedBy(Temporal temporal) {
            return temporal.isSupported(IsoFields.QUARTER_OF_YEAR);
        }

        @Override
        public <R extends Temporal> R addTo(R temporal, long amount) {
            return (R)temporal.plus(Math.multiplyExact(amount, 2L), IsoFields.QUARTER_YEARS);
        }

        @Override
        public long between(Temporal temporal1Inclusive, Temporal temporal2Exclusive) {
            if (temporal1Inclusive.getClass() != temporal2Exclusive.getClass()) {
                return temporal1Inclusive.until(temporal2Exclusive, this);
            }
            return temporal1Inclusive.until(temporal2Exclusive, IsoFields.QUARTER_YEARS) / 2L;
        }

        @Override
        public String toString() {
            return "HalfYears";
        }
    }

    private static enum HalfOfYearField implements TemporalField
    {
        INSTANCE;

        private static final long serialVersionUID = -29115701L;

        @Override
        public TemporalUnit getBaseUnit() {
            return HALF_YEARS;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return ChronoUnit.YEARS;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public ValueRange range() {
            return ValueRange.of(1L, 2L);
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(IsoFields.QUARTER_OF_YEAR);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            if (!this.isSupportedBy(temporal)) {
                throw new UnsupportedTemporalTypeException("Unsupported field: HalfOfYear");
            }
            long qoy = temporal.get(IsoFields.QUARTER_OF_YEAR);
            return qoy <= 2L ? 1L : 2L;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            long curValue = this.getFrom(temporal);
            this.range().checkValidValue(newValue, this);
            return (R)temporal.with(ChronoField.MONTH_OF_YEAR, temporal.getLong(ChronoField.MONTH_OF_YEAR) + (newValue - curValue) * 6L);
        }

        @Override
        public String toString() {
            return "HalfOfYear";
        }
    }

    private static enum DayOfHalfField implements TemporalField
    {
        INSTANCE;

        private static final ValueRange RANGE;
        private static final long serialVersionUID = 262362728L;

        @Override
        public TemporalUnit getBaseUnit() {
            return ChronoUnit.DAYS;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return HALF_YEARS;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public ValueRange range() {
            return RANGE;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(ChronoField.DAY_OF_YEAR) && temporal.isSupported(ChronoField.MONTH_OF_YEAR) && temporal.isSupported(ChronoField.YEAR);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            if (!temporal.isSupported(this)) {
                throw new DateTimeException("Unsupported field: DayOfHalf");
            }
            long hoy = temporal.getLong(HALF_OF_YEAR);
            if (hoy == 1L) {
                long year = temporal.getLong(ChronoField.YEAR);
                return IsoChronology.INSTANCE.isLeapYear(year) ? ValueRange.of(1L, 182L) : ValueRange.of(1L, 181L);
            }
            if (hoy == 2L) {
                return ValueRange.of(1L, 184L);
            }
            return this.range();
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            if (!this.isSupportedBy(temporal)) {
                throw new UnsupportedTemporalTypeException("Unsupported field: DayOfHalf");
            }
            int doy = temporal.get(ChronoField.DAY_OF_YEAR);
            int moy = temporal.get(ChronoField.MONTH_OF_YEAR);
            long year = temporal.getLong(ChronoField.YEAR);
            return moy <= 6 ? (long)doy : (long)(doy - 181 - (IsoChronology.INSTANCE.isLeapYear(year) ? 1 : 0));
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            long curValue = this.getFrom(temporal);
            this.range().checkValidValue(newValue, this);
            return (R)temporal.with(ChronoField.DAY_OF_YEAR, temporal.getLong(ChronoField.DAY_OF_YEAR) + (newValue - curValue));
        }

        @Override
        public ChronoLocalDate resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            LocalDate date;
            Long yearLong = fieldValues.get(ChronoField.YEAR);
            Long hoyLong = fieldValues.get(HALF_OF_YEAR);
            if (yearLong == null || hoyLong == null) {
                return null;
            }
            int y = ChronoField.YEAR.checkValidIntValue(yearLong);
            long doh = fieldValues.get(DAY_OF_HALF);
            if (resolverStyle == ResolverStyle.LENIENT) {
                date = LocalDate.of(y, 1, 1).plusMonths(Math.multiplyExact(Math.subtractExact(hoyLong, 1L), 6L));
                doh = Math.subtractExact(doh, 1L);
            } else {
                int qoy = HALF_OF_YEAR.range().checkValidIntValue(hoyLong, HALF_OF_YEAR);
                date = LocalDate.of(y, (qoy - 1) * 6 + 1, 1);
                if (doh < 1L || doh > 181L) {
                    if (resolverStyle == ResolverStyle.STRICT) {
                        this.rangeRefinedBy(date).checkValidValue(doh, this);
                    } else {
                        this.range().checkValidValue(doh, this);
                    }
                }
                --doh;
            }
            fieldValues.remove(this);
            fieldValues.remove(ChronoField.YEAR);
            fieldValues.remove(HALF_OF_YEAR);
            return date.plusDays(doh);
        }

        @Override
        public String toString() {
            return "DayOfHalf";
        }

        static {
            RANGE = ValueRange.of(1L, 181L, 184L);
        }
    }
}

