/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExternalMetricStatusFluent<A extends ExternalMetricStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Quantity currentAverageValue;
    private Quantity currentValue;
    private String metricName;
    private LabelSelectorBuilder metricSelector;

    public ExternalMetricStatusFluent() {
    }

    public ExternalMetricStatusFluent(ExternalMetricStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public LabelSelector buildMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    protected void copyInstance(ExternalMetricStatus instance) {
        ExternalMetricStatus externalMetricStatus = instance = instance != null ? instance : new ExternalMetricStatus();
        if (instance != null) {
            this.withCurrentAverageValue(instance.getCurrentAverageValue());
            this.withCurrentValue(instance.getCurrentValue());
            this.withMetricName(instance.getMetricName());
            this.withMetricSelector(instance.getMetricSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MetricSelectorNested<A> editMetricSelector() {
        return this.withNewMetricSelectorLike(Optional.ofNullable(this.buildMetricSelector()).orElse(null));
    }

    public MetricSelectorNested<A> editOrNewMetricSelector() {
        return this.withNewMetricSelectorLike(Optional.ofNullable(this.buildMetricSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
        return this.withNewMetricSelectorLike(Optional.ofNullable(this.buildMetricSelector()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalMetricStatusFluent that = (ExternalMetricStatusFluent)((Object)o);
        if (!Objects.equals(this.currentAverageValue, that.currentAverageValue)) {
            return false;
        }
        if (!Objects.equals(this.currentValue, that.currentValue)) {
            return false;
        }
        if (!Objects.equals(this.metricName, that.metricName)) {
            return false;
        }
        if (!Objects.equals(this.metricSelector, that.metricSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public Quantity getCurrentValue() {
        return this.currentValue;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    public boolean hasCurrentValue() {
        return this.currentValue != null;
    }

    public boolean hasMetricName() {
        return this.metricName != null;
    }

    public boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    public int hashCode() {
        return Objects.hash(this.currentAverageValue, this.currentValue, this.metricName, this.metricSelector, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentAverageValue != null) {
            sb.append("currentAverageValue:");
            sb.append(this.currentAverageValue);
            sb.append(",");
        }
        if (this.currentValue != null) {
            sb.append("currentValue:");
            sb.append(this.currentValue);
            sb.append(",");
        }
        if (this.metricName != null) {
            sb.append("metricName:");
            sb.append(this.metricName);
            sb.append(",");
        }
        if (this.metricSelector != null) {
            sb.append("metricSelector:");
            sb.append(this.metricSelector);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return (A)((Object)this);
    }

    public A withCurrentValue(Quantity currentValue) {
        this.currentValue = currentValue;
        return (A)((Object)this);
    }

    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)((Object)this);
    }

    public A withMetricSelector(LabelSelector metricSelector) {
        this._visitables.remove((Object)"metricSelector");
        if (metricSelector != null) {
            this.metricSelector = new LabelSelectorBuilder(metricSelector);
            this._visitables.get((Object)"metricSelector").add(this.metricSelector);
        } else {
            this.metricSelector = null;
            this._visitables.get((Object)"metricSelector").remove(this.metricSelector);
        }
        return (A)((Object)this);
    }

    public A withNewCurrentAverageValue(String amount) {
        return this.withCurrentAverageValue(new Quantity(amount));
    }

    public A withNewCurrentAverageValue(String amount, String format) {
        return this.withCurrentAverageValue(new Quantity(amount, format));
    }

    public A withNewCurrentValue(String amount) {
        return this.withCurrentValue(new Quantity(amount));
    }

    public A withNewCurrentValue(String amount, String format) {
        return this.withCurrentValue(new Quantity(amount, format));
    }

    public MetricSelectorNested<A> withNewMetricSelector() {
        return new MetricSelectorNested(null);
    }

    public MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
        return new MetricSelectorNested(item);
    }

    public class MetricSelectorNested<N>
    extends LabelSelectorFluent<MetricSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        MetricSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ExternalMetricStatusFluent.this.withMetricSelector(this.builder.build());
        }

        public N endMetricSelector() {
            return this.and();
        }
    }
}

