/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.sparkproject.jetty.util.MemoryUtils;
import org.sparkproject.jetty.util.thread.AutoLock;

public class BlockingArrayQueue<E>
extends AbstractList<E>
implements BlockingQueue<E> {
    private static final int HEAD_OFFSET = MemoryUtils.getIntegersPerCacheLine() - 1;
    private static final int TAIL_OFFSET = HEAD_OFFSET + MemoryUtils.getIntegersPerCacheLine();
    public static final int DEFAULT_CAPACITY = 128;
    @Deprecated(since="12.1.2", forRemoval=true)
    public static final int DEFAULT_GROWTH = 64;
    private final int[] _indexes = new int[TAIL_OFFSET + 1];
    private final AtomicInteger _size = new AtomicInteger();
    private final AutoLock.WithCondition _headLock = new AutoLock.WithCondition();
    private final AutoLock.WithCondition _tailLock = new AutoLock.WithCondition();
    private Object[] _elements;
    private final int _maxCapacity;

    public BlockingArrayQueue() {
        this(128, Integer.MAX_VALUE, false);
    }

    public BlockingArrayQueue(int maxCapacity) {
        this(maxCapacity, maxCapacity, false);
    }

    @Deprecated(since="12.1.2", forRemoval=true)
    public BlockingArrayQueue(int capacity, int growBy) {
        this(capacity, Integer.MAX_VALUE, false);
    }

    @Deprecated(since="12.1.2", forRemoval=true)
    public BlockingArrayQueue(int capacity, int growBy, int maxCapacity) {
        this(capacity, maxCapacity, false);
    }

    private BlockingArrayQueue(int capacity, int maxCapacity, boolean ignored) {
        if (capacity < 0 || maxCapacity < 0 || capacity > maxCapacity) {
            throw new IllegalArgumentException();
        }
        this._elements = new Object[capacity];
        this._maxCapacity = maxCapacity;
    }

    public static <E> BlockingArrayQueue<E> newInstance(int capacity, int maxCapacity) {
        return new BlockingArrayQueue<E>(capacity, maxCapacity, false);
    }

    @Override
    public void clear() {
        try (AutoLock.WithCondition tailLock = this._tailLock.lock();
             AutoLock.WithCondition ignored = this._headLock.lock();){
            this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
            this._indexes[BlockingArrayQueue.TAIL_OFFSET] = 0;
            this._size.set(0);
            tailLock.signalAll();
        }
    }

    @Override
    public int size() {
        return this._size.get();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public E poll() {
        if (this._size.get() == 0) {
            return null;
        }
        E e = null;
        boolean wasFull = false;
        try (AutoLock.WithCondition ignored = this._headLock.lock();){
            if (this._size.get() > 0) {
                e = this.lockedTakeFromHead();
                wasFull = this.lockedDecrementSize();
            }
        }
        if (wasFull) {
            this.signal(this._tailLock);
        }
        return e;
    }

    @Override
    public E poll(long time, TimeUnit unit) throws InterruptedException {
        boolean wasFull;
        E e;
        long nanos = unit.toNanos(time);
        try (AutoLock.WithCondition headLock = this._headLock.lockInterruptibly();){
            while (this._size.get() == 0) {
                if (nanos <= 0L) {
                    E e2 = null;
                    return e2;
                }
                try {
                    nanos = headLock.awaitNanos(nanos);
                }
                catch (InterruptedException x) {
                    headLock.signal();
                    throw x;
                }
            }
            e = this.lockedTakeFromHead();
            wasFull = this.lockedDecrementSize();
        }
        if (wasFull) {
            this.signal(this._tailLock);
        }
        return e;
    }

    @Override
    public E peek() {
        if (this._size.get() == 0) {
            return null;
        }
        try (AutoLock.WithCondition ignored = this._headLock.lock();){
            Object e = null;
            if (this._size.get() > 0) {
                e = this._elements[this._indexes[HEAD_OFFSET]];
            }
            Object object = e;
            return (E)object;
        }
    }

    @Override
    public E remove() {
        E e = this.poll();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E remove(int index) {
        try (AutoLock.WithCondition tailLock = this._tailLock.lock();){
            Object object;
            block20: {
                AutoLock.WithCondition headLock = this._headLock.lock();
                try {
                    if (index < 0 || index >= this._size.get()) {
                        throw new IndexOutOfBoundsException("!(0<" + index + "<=" + String.valueOf(this._size) + ")");
                    }
                    int i = this._indexes[HEAD_OFFSET] + index;
                    int capacity = this._elements.length;
                    if (i >= capacity) {
                        i -= capacity;
                    }
                    Object old = this._elements[i];
                    int tail = this._indexes[TAIL_OFFSET];
                    if (i < tail) {
                        System.arraycopy(this._elements, i + 1, this._elements, i, tail - i);
                        int n = TAIL_OFFSET;
                        this._indexes[n] = this._indexes[n] - 1;
                    } else {
                        System.arraycopy(this._elements, i + 1, this._elements, i, capacity - i - 1);
                        this._elements[capacity - 1] = this._elements[0];
                        if (tail > 0) {
                            System.arraycopy(this._elements, 1, this._elements, 0, tail);
                            int n = TAIL_OFFSET;
                            this._indexes[n] = this._indexes[n] - 1;
                        } else {
                            this._indexes[BlockingArrayQueue.TAIL_OFFSET] = capacity - 1;
                        }
                        this._elements[this._indexes[BlockingArrayQueue.TAIL_OFFSET]] = null;
                    }
                    int oldSize = this._size.getAndDecrement();
                    if (oldSize == this._maxCapacity) {
                        tailLock.signal();
                    }
                    if (oldSize > 1) {
                        headLock.signal();
                    }
                    object = old;
                    if (headLock == null) break block20;
                }
                catch (Throwable throwable) {
                    if (headLock != null) {
                        try {
                            headLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                headLock.close();
            }
            return (E)object;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean remove(Object o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public E element() {
        E e = this.peek();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public boolean offer(E e) {
        boolean wasEmpty;
        Objects.requireNonNull(e);
        try (AutoLock.WithCondition ignoredT = this._tailLock.lock();){
            int size = this._size.get();
            if (size >= this._maxCapacity) {
                boolean bl = false;
                return bl;
            }
            if (size == this._elements.length) {
                try (AutoLock.WithCondition ignoredH = this._headLock.lock();){
                    size = this._size.get();
                    if (size == this._elements.length) {
                        this.lockedGrow();
                    }
                }
            }
            this.lockedAddToTail(e);
            wasEmpty = this.lockedIncrementSize();
        }
        if (wasEmpty) {
            this.signal(this._headLock);
        }
        return true;
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        boolean wasEmpty;
        Objects.requireNonNull(o);
        try (AutoLock.WithCondition tailLock = this._tailLock.lockInterruptibly();){
            int size;
            long nanos = unit.toNanos(timeout);
            while ((size = this._size.get()) >= this._maxCapacity) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = tailLock.awaitNanos(nanos);
            }
            if (size == this._elements.length) {
                try (AutoLock.WithCondition ignored = this._headLock.lock();){
                    size = this._size.get();
                    if (size == this._elements.length) {
                        this.lockedGrow();
                    }
                }
            }
            this.lockedAddToTail(o);
            wasEmpty = this.lockedIncrementSize();
        }
        if (wasEmpty) {
            this.signal(this._headLock);
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException();
    }

    @Override
    public void add(int index, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        try (AutoLock.WithCondition tailLock = this._tailLock.lock();
             AutoLock.WithCondition headLock = this._headLock.lock();){
            int size = this._size.get();
            if (index < 0 || index > size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + String.valueOf(this._size) + ")");
            }
            if (index == size) {
                this.add(e);
            } else {
                int capacity;
                int i;
                if (this._indexes[TAIL_OFFSET] == this._indexes[HEAD_OFFSET]) {
                    if (this._size.get() == this._maxCapacity) {
                        throw new IllegalStateException("full");
                    }
                    this.lockedGrow();
                }
                if ((i = this._indexes[HEAD_OFFSET] + index) >= (capacity = this._elements.length)) {
                    i -= capacity;
                }
                int tail = this._indexes[TAIL_OFFSET];
                this._indexes[BlockingArrayQueue.TAIL_OFFSET] = tail = (tail + 1) % capacity;
                if (i < tail) {
                    System.arraycopy(this._elements, i, this._elements, i + 1, tail - i);
                    this._elements[i] = e;
                } else {
                    if (tail > 0) {
                        System.arraycopy(this._elements, 0, this._elements, 1, tail);
                        this._elements[0] = this._elements[capacity - 1];
                    }
                    System.arraycopy(this._elements, i, this._elements, i + 1, capacity - i - 1);
                    this._elements[i] = e;
                }
                size = this._size.incrementAndGet();
                if (size >= 1) {
                    headLock.signal();
                }
                if (size < this._maxCapacity) {
                    tailLock.signal();
                }
            }
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        boolean wasEmpty;
        Objects.requireNonNull(e);
        try (AutoLock.WithCondition tailLock = this._tailLock.lockInterruptibly();){
            int size;
            while ((size = this._size.get()) >= this._maxCapacity) {
                tailLock.await();
            }
            if (size == this._elements.length) {
                try (AutoLock.WithCondition ignored = this._headLock.lock();){
                    size = this._size.get();
                    if (size == this._elements.length) {
                        this.lockedGrow();
                    }
                }
            }
            this.lockedAddToTail(e);
            wasEmpty = this.lockedIncrementSize();
        }
        if (wasEmpty) {
            this.signal(this._headLock);
        }
    }

    @Override
    public E take() throws InterruptedException {
        boolean wasFull;
        E e;
        try (AutoLock.WithCondition headLock = this._headLock.lockInterruptibly();){
            try {
                while (this._size.get() == 0) {
                    headLock.await();
                }
            }
            catch (InterruptedException ex) {
                headLock.signal();
                throw ex;
            }
            e = this.lockedTakeFromHead();
            wasFull = this.lockedDecrementSize();
        }
        if (wasFull) {
            this.signal(this._tailLock);
        }
        return e;
    }

    @Override
    public int remainingCapacity() {
        int maxCapacity = this.getMaxCapacity();
        if (maxCapacity == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return maxCapacity - this.size();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int elements;
        try (AutoLock.WithCondition tailLock = this._tailLock.lock();
             AutoLock.WithCondition ignored = this._headLock.lock();){
            if (this._size.get() == 0) {
                int n = 0;
                return n;
            }
            int head = this._indexes[HEAD_OFFSET];
            int tail = this._indexes[TAIL_OFFSET];
            int capacity = this._elements.length;
            int i = head;
            for (elements = 0; elements < maxElements && (i != tail || elements <= 0); ++elements) {
                Object e = this._elements[i];
                c.add(e);
                if (++i != capacity) continue;
                i = 0;
            }
            if (i == tail) {
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
                this._indexes[BlockingArrayQueue.TAIL_OFFSET] = 0;
                this._size.set(0);
            } else {
                this._indexes[BlockingArrayQueue.HEAD_OFFSET] = i;
                this._size.addAndGet(-elements);
            }
            tailLock.signalAll();
        }
        return elements;
    }

    @Override
    public E get(int index) {
        try (AutoLock.WithCondition ignoredT = this._tailLock.lock();){
            Object object;
            block14: {
                AutoLock.WithCondition ignoredH = this._headLock.lock();
                try {
                    if (index < 0 || index >= this._size.get()) {
                        throw new IndexOutOfBoundsException("!(0<" + index + "<=" + String.valueOf(this._size) + ")");
                    }
                    int i = this._indexes[HEAD_OFFSET] + index;
                    int capacity = this._elements.length;
                    if (i >= capacity) {
                        i -= capacity;
                    }
                    object = this._elements[i];
                    if (ignoredH == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ignoredH != null) {
                        try {
                            ignoredH.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignoredH.close();
            }
            return (E)object;
        }
    }

    @Override
    public E set(int index, E e) {
        Objects.requireNonNull(e);
        try (AutoLock.WithCondition ignoredT = this._tailLock.lock();){
            Object object;
            block14: {
                AutoLock.WithCondition ignoredH = this._headLock.lock();
                try {
                    if (index < 0 || index >= this._size.get()) {
                        throw new IndexOutOfBoundsException("!(0<" + index + "<=" + String.valueOf(this._size) + ")");
                    }
                    int i = this._indexes[HEAD_OFFSET] + index;
                    int capacity = this._elements.length;
                    if (i >= capacity) {
                        i -= capacity;
                    }
                    Object old = this._elements[i];
                    this._elements[i] = e;
                    object = old;
                    if (ignoredH == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ignoredH != null) {
                        try {
                            ignoredH.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignoredH.close();
            }
            return (E)object;
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        try (AutoLock.WithCondition ignoredT = this._tailLock.lock();){
            Itr itr;
            block15: {
                AutoLock.WithCondition ignoredH = this._headLock.lock();
                try {
                    Object[] elements = new Object[this.size()];
                    if (this.size() > 0) {
                        int head = this._indexes[HEAD_OFFSET];
                        int tail = this._indexes[TAIL_OFFSET];
                        if (head < tail) {
                            System.arraycopy(this._elements, head, elements, 0, tail - head);
                        } else {
                            int chunk = this._elements.length - head;
                            System.arraycopy(this._elements, head, elements, 0, chunk);
                            System.arraycopy(this._elements, 0, elements, chunk, tail);
                        }
                    }
                    itr = new Itr(elements, index);
                    if (ignoredH == null) break block15;
                }
                catch (Throwable throwable) {
                    if (ignoredH != null) {
                        try {
                            ignoredH.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignoredH.close();
            }
            return itr;
        }
    }

    public int getCapacity() {
        try (AutoLock.WithCondition ignored = this._tailLock.lock();){
            int n = this._elements.length;
            return n;
        }
    }

    public int getMaxCapacity() {
        return this._maxCapacity;
    }

    private void lockedGrow() {
        int newTail;
        assert (this._tailLock.isHeldByCurrentThread());
        assert (this._headLock.isHeldByCurrentThread());
        int head = this._indexes[HEAD_OFFSET];
        int tail = this._indexes[TAIL_OFFSET];
        int capacity = this._elements.length;
        Object[] elements = new Object[BlockingArrayQueue.newCapacity(capacity, this._maxCapacity)];
        if (head < tail) {
            newTail = tail - head;
            System.arraycopy(this._elements, head, elements, 0, newTail);
        } else if (head > tail || this._size.get() > 0) {
            newTail = capacity + tail - head;
            int cut = capacity - head;
            System.arraycopy(this._elements, head, elements, 0, cut);
            System.arraycopy(this._elements, 0, elements, cut, tail);
        } else {
            newTail = 0;
        }
        this._elements = elements;
        this._indexes[BlockingArrayQueue.HEAD_OFFSET] = 0;
        this._indexes[BlockingArrayQueue.TAIL_OFFSET] = newTail;
    }

    private void signal(AutoLock.WithCondition lock) {
        try (AutoLock.WithCondition ignored = lock.lock();){
            lock.signal();
        }
    }

    private void lockedAddToTail(E e) {
        assert (this._tailLock.isHeldByCurrentThread());
        int tail = this._indexes[TAIL_OFFSET];
        this._elements[tail] = e;
        this._indexes[BlockingArrayQueue.TAIL_OFFSET] = (tail + 1) % this._elements.length;
    }

    private E lockedTakeFromHead() {
        assert (this._headLock.isHeldByCurrentThread());
        int head = this._indexes[HEAD_OFFSET];
        Object e = this._elements[head];
        this._elements[head] = null;
        this._indexes[BlockingArrayQueue.HEAD_OFFSET] = (head + 1) % this._elements.length;
        return (E)e;
    }

    private boolean lockedIncrementSize() {
        boolean wasEmpty;
        assert (this._tailLock.isHeldByCurrentThread());
        int oldSize = this._size.getAndIncrement();
        boolean bl = wasEmpty = oldSize == 0;
        if (oldSize + 1 < this._maxCapacity) {
            this._tailLock.signal();
        }
        return wasEmpty;
    }

    private boolean lockedDecrementSize() {
        boolean wasFull;
        assert (this._headLock.isHeldByCurrentThread());
        int oldSize = this._size.getAndDecrement();
        boolean bl = wasFull = oldSize == this._maxCapacity;
        if (oldSize > 1) {
            this._headLock.signal();
        }
        return wasFull;
    }

    static int newCapacity(int currentCapacity, int maxCapacity) {
        int newCapacity = currentCapacity + Math.max(8, currentCapacity / 2);
        if (newCapacity >= maxCapacity || newCapacity < 0) {
            return maxCapacity;
        }
        return newCapacity;
    }

    private class Itr
    implements ListIterator<E> {
        private final Object[] _elements;
        private int _cursor;

        public Itr(Object[] elements, int offset) {
            this._elements = elements;
            this._cursor = offset;
        }

        @Override
        public boolean hasNext() {
            return this._cursor < this._elements.length;
        }

        @Override
        public E next() {
            return this._elements[this._cursor++];
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public E previous() {
            return this._elements[--this._cursor];
        }

        @Override
        public int nextIndex() {
            return this._cursor + 1;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

