/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

class WkbParseException
extends RuntimeException {
    private final long position;
    private final String wkbString;

    WkbParseException(String message, long position, byte[] wkb) {
        super(WkbParseException.formatMessage(message, position, wkb));
        this.position = position;
        this.wkbString = wkb != null ? WkbParseException.bytesToHex(wkb) : "";
    }

    private static String formatMessage(String message, long position, byte[] wkb) {
        String baseMessage = message + " at position " + position;
        if (wkb != null && wkb.length > 0) {
            baseMessage = baseMessage + " in WKB: " + WkbParseException.bytesToHex(wkb);
        }
        return baseMessage;
    }

    private static String bytesToHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    long getPosition() {
        return this.position;
    }

    String getWkbString() {
        return this.wkbString;
    }
}

