/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.WeakValueMap;

public class CandidateIdsQueryResult<E>
extends AbstractQueryResult<E> {
    final List<Object> ids;
    Map<Integer, E> results = null;
    boolean validateObjects = true;

    public CandidateIdsQueryResult(Query query, List<Object> ids) {
        super(query);
        this.ids = ids;
        this.size = ids != null ? ids.size() : 0;
        this.validateObjects = query.getBooleanExtensionProperty("datanucleus.query.resultCache.validateObjects", true);
        String ext = (String)query.getExtension("datanucleus.query.resultCache.type");
        this.results = ext != null ? (ext.equalsIgnoreCase("soft") ? new SoftValueMap() : (ext.equalsIgnoreCase("strong") ? new HashMap<Integer, E>() : (ext.equalsIgnoreCase("weak") ? new WeakValueMap() : (ext.equalsIgnoreCase("none") ? null : new HashMap<Integer, E>())))) : new HashMap<Integer, E>();
    }

    @Override
    protected void closeResults() {
    }

    @Override
    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen()) {
            for (int i = 0; i < this.size; ++i) {
                this.getObjectForIndex(i);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CandidateIdsQueryResult)) {
            return false;
        }
        CandidateIdsQueryResult other = (CandidateIdsQueryResult)o;
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString(other).equals(StringUtils.toJVMIDString(this));
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("Index should be between 0 and " + (this.size - 1));
        }
        return this.getObjectForIndex(index);
    }

    @Override
    public Iterator<E> iterator() {
        return new ResultIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ResultIterator();
    }

    protected E getObjectForIndex(int index) {
        E obj;
        if (this.ids == null) {
            return null;
        }
        Object id = this.ids.get(index);
        if (this.results != null && (obj = this.results.get(index)) != null) {
            return obj;
        }
        if (this.query == null) {
            throw new NucleusUserException("Query has already been closed");
        }
        if (this.query.getExecutionContext() == null || this.query.getExecutionContext().isClosed()) {
            throw new NucleusUserException("ExecutionContext has already been closed");
        }
        ExecutionContext ec = this.query.getExecutionContext();
        Object obj2 = ec.findObject(id, this.validateObjects, false, null);
        if (this.results != null) {
            this.results.put(index, obj2);
        }
        return (E)obj2;
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.disconnect();
        ArrayList<E> results = new ArrayList<E>(this.results.size());
        for (int i = 0; i < this.results.size(); ++i) {
            results.add(this.results.get(i));
        }
        return results;
    }

    public class ResultIterator
    extends AbstractQueryResultIterator<E> {
        int next = 0;

        @Override
        public boolean hasNext() {
            if (!CandidateIdsQueryResult.this.isOpen()) {
                return false;
            }
            return CandidateIdsQueryResult.this.size - this.next > 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.next >= 1;
        }

        @Override
        public E next() {
            if (this.next == CandidateIdsQueryResult.this.size) {
                throw new NoSuchElementException("Already at end of List");
            }
            Object obj = CandidateIdsQueryResult.this.getObjectForIndex(this.next);
            ++this.next;
            return obj;
        }

        @Override
        public int nextIndex() {
            return this.next;
        }

        @Override
        public E previous() {
            if (this.next == 0) {
                throw new NoSuchElementException("Already at start of List");
            }
            Object obj = CandidateIdsQueryResult.this.getObjectForIndex(this.next - 1);
            --this.next;
            return obj;
        }

        @Override
        public int previousIndex() {
            return this.next - 1;
        }
    }
}

