/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import scala.Function0;

public class BestEffortLazyVal<T>
implements Serializable {
    private volatile Function0<T> compute;
    protected volatile T cached;
    private static final VarHandle HANDLE;

    public BestEffortLazyVal(Function0<T> compute) {
        this.compute = compute;
    }

    public T apply() {
        T value = this.cached;
        if (value != null) {
            return value;
        }
        Function0<T> f = this.compute;
        if (f != null) {
            Object newValue = f.apply();
            assert (newValue != null) : "compute function cannot return null.";
            HANDLE.compareAndSet(this, null, newValue);
            this.compute = null;
        }
        return this.cached;
    }

    static {
        try {
            HANDLE = MethodHandles.lookup().in(BestEffortLazyVal.class).findVarHandle(BestEffortLazyVal.class, "cached", Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to initialize VarHandle", e);
        }
    }
}

