/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.util.FileID;
import org.sparkproject.jetty.util.HostPort;
import org.sparkproject.jetty.util.Index;
import org.sparkproject.jetty.util.StringUtil;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.Utf8StringBuilder;

public final class URIUtil {
    private static final Logger LOG = LoggerFactory.getLogger(URIUtil.class);
    public static final int UNDEFINED_PORT = -1;
    private static final String UNRESERVED = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~";
    private static final String SUBDELIMS = "!$&'()*+,;=";
    private static final String REGNAME = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-._~!$&'()*+,;=";
    private static final boolean[] REGNAME_ALLOWED = new boolean[128];
    private static final boolean[] URI_SUPPORTED_CHARACTERS;
    private static final boolean[] ENCODE_PATH_NEEDS_ENCODING;
    private static final Index<Integer> DEFAULT_PORT_FOR_SCHEME;

    private URIUtil() {
    }

    public static String encodePath(String path) {
        if (StringUtil.isEmpty(path)) {
            return path;
        }
        boolean needsByteEncoding = false;
        boolean needsEncoding = false;
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            char c = path.charAt(i);
            if (c > '\u007f') {
                needsByteEncoding = true;
                break;
            }
            if (!ENCODE_PATH_NEEDS_ENCODING[c]) continue;
            needsEncoding = true;
        }
        if (needsByteEncoding) {
            return URIUtil.encodePathBytes(path);
        }
        if (needsEncoding) {
            return URIUtil.encodePathString(path);
        }
        return path;
    }

    private static String encodePathString(String path) {
        StringBuilder buf = new StringBuilder(path.length() * 2);
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            char c = path.charAt(i);
            if (ENCODE_PATH_NEEDS_ENCODING[c]) {
                buf.append('%');
                TypeUtil.toHex((byte)c, (Appendable)buf);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static String encodePathBytes(String path) {
        byte[] pathBytes;
        StringBuilder buf = new StringBuilder(path.length() * 2);
        for (byte b : pathBytes = path.getBytes(StandardCharsets.UTF_8)) {
            if (b < 0 || ENCODE_PATH_NEEDS_ENCODING[b]) {
                buf.append('%');
                TypeUtil.toHex(b, (Appendable)buf);
                continue;
            }
            buf.append((char)b);
        }
        return buf.toString();
    }

    public static String encodeSpecific(String str, String charsToEncode) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (charsToEncode == null || charsToEncode.length() == 0) {
            return str;
        }
        char[] find = charsToEncode.toCharArray();
        int len = str.length();
        StringBuilder ret = new StringBuilder((int)((double)len * 0.2));
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            boolean escaped = false;
            for (char f : find) {
                if (c != f) continue;
                escaped = true;
                ret.append('%');
                int d = 0xF & (0xF0 & c) >> 4;
                ret.append((char)((d > 9 ? 55 : 48) + d));
                d = 0xF & c;
                ret.append((char)((d > 9 ? 55 : 48) + d));
                break;
            }
            if (escaped) continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String decodeSpecific(String str, String charsToDecode) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (charsToDecode == null || charsToDecode.length() == 0) {
            return str;
        }
        int idx = str.indexOf(37);
        if (idx == -1) {
            return str;
        }
        char[] find = charsToDecode.toCharArray();
        int len = str.length();
        Utf8StringBuilder ret = new Utf8StringBuilder(len);
        ret.append(str, 0, idx);
        for (int i = idx; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '%') {
                if (i + 2 < len) {
                    char u = str.charAt(i + 1);
                    char l = str.charAt(i + 2);
                    char result = (char)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(l));
                    boolean decoded = false;
                    for (char f : find) {
                        if (f != result) continue;
                        ret.append(result);
                        decoded = true;
                        break;
                    }
                    if (decoded) {
                        i += 2;
                        continue;
                    }
                    ret.append(c);
                    continue;
                }
                throw new IllegalArgumentException("Bad URI % encoding");
            }
            ret.append(c);
        }
        return ret.toCompleteString();
    }

    public static StringBuilder encodeString(StringBuilder buf, String path, String encode) {
        char c;
        int i;
        if (buf == null) {
            for (i = 0; i < path.length(); ++i) {
                c = path.charAt(i);
                if (c != '%' && encode.indexOf(c) < 0) continue;
                buf = new StringBuilder(path.length() << 1);
                break;
            }
            if (buf == null) {
                return null;
            }
        }
        for (i = 0; i < path.length(); ++i) {
            c = path.charAt(i);
            if (c == '%' || encode.indexOf(c) >= 0) {
                buf.append('%');
                StringUtil.append(buf, (byte)(0xFF & c), 16);
                continue;
            }
            buf.append(c);
        }
        return buf;
    }

    public static String decodePath(String path) {
        if (path == null) {
            return null;
        }
        return URIUtil.decodePath(path, 0, path.length());
    }

    public static String decodePath(String path, int offset, int length) {
        if (path == null) {
            return null;
        }
        try {
            Utf8StringBuilder builder = null;
            int end = offset + length;
            block7: for (int i = offset; i < end; ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '%': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(length);
                            builder.append(path, offset, i - offset);
                        }
                        if (i + 2 < end) {
                            char u = path.charAt(i + 1);
                            if (u == 'u') {
                                byte[] bytes;
                                int[] codePoints = new int[]{0xFFFF & TypeUtil.parseInt(path, i + 2, 4, 16)};
                                String str = new String(codePoints, 0, 1);
                                for (byte b : bytes = str.getBytes(StandardCharsets.UTF_8)) {
                                    builder.append(b);
                                }
                                i += 5;
                                continue block7;
                            }
                            byte b = (byte)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i + 2)));
                            builder.append(b);
                            i += 2;
                            continue block7;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i - offset);
                        }
                        while (++i < end) {
                            if (path.charAt(i) != '/') continue;
                            builder.append('/');
                            continue block7;
                        }
                        continue block7;
                    }
                    default: {
                        if (builder == null) continue block7;
                        builder.append(c);
                    }
                }
            }
            if (builder != null) {
                return builder.toCompleteString();
            }
            if (offset == 0 && length == path.length()) {
                return path;
            }
            return path.substring(offset, end);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot decode URI", e);
        }
    }

    public static boolean isPathValid(String path) {
        if (path == null) {
            return true;
        }
        int end = path.length();
        for (int i = 0; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '#': 
                case '?': {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isRelative(String uriOrPath) {
        if (uriOrPath.isEmpty()) {
            return true;
        }
        char c = uriOrPath.charAt(0);
        if (c == '/' || File.separatorChar != '/' && c == File.separatorChar) {
            return false;
        }
        return !URIUtil.hasScheme(uriOrPath);
    }

    private static boolean isSafe(int code) {
        return code >= URI_SUPPORTED_CHARACTERS.length || URI_SUPPORTED_CHARACTERS[code];
    }

    private static boolean isSafeElseEncode(int code, Utf8StringBuilder builder) {
        if (URIUtil.isSafe(code)) {
            return true;
        }
        URIUtil.encodeCodepoint(code, builder);
        return false;
    }

    private static void encodeCodepoint(int code, Utf8StringBuilder builder) {
        if (code <= 127) {
            builder.append('%');
            URIUtil.appendHexValue(builder, (byte)code);
        } else {
            byte[] bytes;
            int[] codePoints = new int[]{code};
            String str = new String(codePoints, 0, 1);
            for (byte b : bytes = str.getBytes(StandardCharsets.UTF_8)) {
                builder.append('%');
                URIUtil.appendHexValue(builder, b);
            }
        }
    }

    private static void appendHexValue(Utf8StringBuilder builder, byte value) {
        byte d = (byte)((0xF0 & value) >> 4);
        builder.append((char)((d > 9 ? 55 : 48) + d));
        d = (byte)(0xF & value);
        builder.append((char)((d > 9 ? 55 : 48) + d));
    }

    public static String canonicalPath(String encodedPath) {
        return URIUtil.canonicalPath(encodedPath, null);
    }

    public static <X extends Throwable> String canonicalPath(String encodedPath, Supplier<X> onBadUtf8) throws X {
        if (encodedPath == null) {
            return null;
        }
        Utf8StringBuilder builder = null;
        int end = encodedPath.length();
        boolean slash = true;
        boolean normal = true;
        for (int i = 0; i < end; ++i) {
            char c = encodedPath.charAt(i);
            block0 : switch (c) {
                case '%': {
                    if (builder == null) {
                        builder = new Utf8StringBuilder(encodedPath.length());
                        builder.append(encodedPath, 0, i);
                    }
                    if (i + 2 < end) {
                        int code;
                        char u = encodedPath.charAt(i + 1);
                        if (u == 'u') {
                            code = TypeUtil.parseInt(encodedPath, i + 2, 4, 16);
                            if (URIUtil.isSafeElseEncode(code, builder)) {
                                char[] chars;
                                for (char ch : chars = Character.toChars(code)) {
                                    builder.append(ch);
                                    if (slash && ch == '.') {
                                        normal = false;
                                    }
                                    slash = false;
                                }
                            }
                            i += 5;
                            break;
                        }
                        code = TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(encodedPath.charAt(i + 2));
                        if (URIUtil.isSafeElseEncode(code, builder)) {
                            builder.append((byte)(0xFF & code));
                            if (slash && code == 46) {
                                normal = false;
                            }
                        }
                        i += 2;
                        break;
                    }
                    throw new IllegalArgumentException("Bad URI % encoding");
                }
                case ';': {
                    if (builder == null) {
                        builder = new Utf8StringBuilder(encodedPath.length());
                        builder.append(encodedPath, 0, i);
                    }
                    while (++i < end) {
                        if (encodedPath.charAt(i) != '/') continue;
                        builder.append('/');
                        break block0;
                    }
                    break;
                }
                case '/': {
                    if (builder == null) break;
                    builder.append(c);
                    break;
                }
                case '.': {
                    if (slash) {
                        normal = false;
                    }
                    if (builder == null) break;
                    builder.append(c);
                    break;
                }
                default: {
                    if (builder == null && !URIUtil.isSafe(c)) {
                        builder = new Utf8StringBuilder(encodedPath.length());
                        builder.append(encodedPath, 0, i);
                    }
                    if (builder == null || !URIUtil.isSafeElseEncode(c, builder)) break;
                    builder.append(c);
                }
            }
            slash = c == '/';
        }
        String canonical = builder != null ? (onBadUtf8 == null ? builder.toCompleteString() : builder.takeCompleteString(onBadUtf8)) : encodedPath;
        return normal ? canonical : URIUtil.normalizePath(canonical);
    }

    public static String addEncodedPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith("/")) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith("/")) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        boolean p1EndsWithSlash = p1.endsWith("/");
        boolean p2StartsWithSlash = p2.startsWith("/");
        if (p1EndsWithSlash && p2StartsWithSlash) {
            if (p2.length() == 1) {
                return p1;
            }
            if (p1.length() == 1) {
                return p2;
            }
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (p1.endsWith("/")) {
            if (p2.startsWith("/")) {
                buf.setLength(buf.length() - 1);
            }
        } else if (!p2.startsWith("/")) {
            buf.append("/");
        }
        buf.append(p2);
        return buf.toString();
    }

    public static String addPathQuery(String path, String query) {
        if (StringUtil.isBlank(query)) {
            return path;
        }
        if (path.indexOf(63) >= 0) {
            return path + "&" + query;
        }
        return path + "?" + query;
    }

    public static String getUriLastPathSegment(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        int idx = ssp.indexOf("!/");
        if (idx != -1) {
            ssp = ssp.substring(0, idx);
        }
        if (ssp.endsWith("/")) {
            ssp = ssp.substring(0, ssp.length() - 1);
        }
        if ((idx = ssp.lastIndexOf(47)) != -1) {
            ssp = ssp.substring(idx + 1);
        }
        return ssp;
    }

    public static String parentPath(String p) {
        if (p == null || "/".equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    public static String normalizePathQuery(String pathQuery) {
        int i;
        if (pathQuery == null || pathQuery.isEmpty()) {
            return pathQuery;
        }
        boolean slash = true;
        int end = pathQuery.length();
        block10: for (i = 0; i < end; ++i) {
            char c = pathQuery.charAt(i);
            switch (c) {
                case '/': {
                    slash = true;
                    continue block10;
                }
                case '.': {
                    if (!slash) continue block10;
                    break block10;
                }
                case '#': 
                case '?': {
                    return pathQuery;
                }
                default: {
                    slash = false;
                }
            }
        }
        if (i == end) {
            return pathQuery;
        }
        StringBuilder canonical = new StringBuilder(pathQuery.length());
        canonical.append(pathQuery, 0, i);
        int dots = 1;
        ++i;
        block11: while (i < end) {
            char c = pathQuery.charAt(i);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(canonical, dots)) {
                        return null;
                    }
                    slash = true;
                    dots = 0;
                    break;
                }
                case '#': 
                case '?': {
                    break block11;
                }
                case '.': {
                    if (dots > 0) {
                        ++dots;
                    } else if (slash) {
                        dots = 1;
                    } else {
                        canonical.append('.');
                    }
                    slash = false;
                    break;
                }
                default: {
                    while (dots-- > 0) {
                        canonical.append('.');
                    }
                    canonical.append(c);
                    dots = 0;
                    slash = false;
                }
            }
            ++i;
        }
        if (URIUtil.doDots(canonical, dots)) {
            return null;
        }
        if (i < end) {
            canonical.append(pathQuery, i, end);
        }
        return canonical.toString();
    }

    public static boolean isNotNormalWithinSelf(String path) {
        return URIUtil.normalizePath(path) == null;
    }

    public static String normalizePath(String path) {
        int i;
        if (path == null || path.isEmpty()) {
            return path;
        }
        boolean slash = true;
        int end = path.length();
        block8: for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '/': {
                    slash = true;
                    continue block8;
                }
                case '.': {
                    if (!slash) continue block8;
                    break block8;
                }
                default: {
                    slash = false;
                }
            }
        }
        if (i == end) {
            return path;
        }
        StringBuilder canonical = new StringBuilder(path.length());
        canonical.append(path, 0, i);
        int dots = 1;
        ++i;
        while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '/': {
                    if (URIUtil.doDotsSlash(canonical, dots)) {
                        return null;
                    }
                    slash = true;
                    dots = 0;
                    break;
                }
                case '.': {
                    if (dots > 0) {
                        ++dots;
                    } else if (slash) {
                        dots = 1;
                    } else {
                        canonical.append('.');
                    }
                    slash = false;
                    break;
                }
                default: {
                    while (dots-- > 0) {
                        canonical.append('.');
                    }
                    canonical.append(c);
                    dots = 0;
                    slash = false;
                }
            }
            ++i;
        }
        if (URIUtil.doDots(canonical, dots)) {
            return null;
        }
        return canonical.toString();
    }

    private static boolean doDots(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                canonical.setLength(canonical.length() - 1);
                canonical.setLength(canonical.lastIndexOf("/") + 1);
                break;
            }
            default: {
                while (dots-- > 0) {
                    canonical.append('.');
                }
                break block0;
            }
        }
        return false;
    }

    private static boolean doDotsSlash(StringBuilder canonical, int dots) {
        switch (dots) {
            case 0: {
                canonical.append('/');
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (canonical.length() < 2) {
                    return true;
                }
                canonical.setLength(canonical.length() - 1);
                canonical.setLength(canonical.lastIndexOf("/") + 1);
                break;
            }
            default: {
                while (dots-- > 0) {
                    canonical.append('.');
                }
                canonical.append('/');
            }
        }
        return false;
    }

    public static String compactPath(String path) {
        int i;
        if (path == null || path.length() == 0) {
            return path;
        }
        int state = 0;
        int end = path.length();
        block8: for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    return path;
                }
                case '/': {
                    if (++state != 2) continue block8;
                    break block8;
                }
                default: {
                    state = 0;
                }
            }
        }
        if (state < 2) {
            return path;
        }
        StringBuilder buf = new StringBuilder(path.length());
        buf.append(path, 0, i);
        block9: while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    buf.append(path, i, end);
                    break block9;
                }
                case '/': {
                    if (state++ != 0) break;
                    buf.append(c);
                    break;
                }
                default: {
                    state = 0;
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean hasScheme(String uri) {
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }

    public static boolean isValidHostRegisteredName(String token) {
        if (token == null) {
            return true;
        }
        int length = token.length();
        for (int i = 0; i < length; ++i) {
            char c = token.charAt(i);
            if (c > '\u007f') {
                return false;
            }
            if (REGNAME_ALLOWED[c]) continue;
            if (c == '%') {
                if (StringUtil.isHex(token, i + 1, 2)) {
                    i += 2;
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public static String newURI(String scheme, String server, int port) {
        return URIUtil.newURI(scheme, server, port, null, null);
    }

    public static String newURI(String scheme, String server, int port, String path, String query) {
        return URIUtil.newURI(scheme, server, port, path, query, null);
    }

    public static String newURI(String scheme, String server, int port, String path, String query, String fragment) {
        boolean hasFragment;
        StringBuilder builder = URIUtil.newURIBuilder(scheme, server, port);
        boolean hasQuery = query != null;
        boolean bl = hasFragment = fragment != null;
        if (StringUtil.isNotBlank(path)) {
            builder.append(path);
        } else if (hasQuery || hasFragment) {
            builder.append('/');
        }
        if (hasQuery) {
            builder.append('?').append(query);
        }
        if (hasFragment) {
            builder.append('#').append(fragment);
        }
        return builder.toString();
    }

    public static StringBuilder newURIBuilder(String scheme, String server, int port) {
        StringBuilder builder = new StringBuilder(128);
        URIUtil.appendSchemeHostPort(builder, scheme, server, port);
        return builder;
    }

    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        scheme = URIUtil.normalizeScheme(scheme);
        url.append(scheme).append("://").append(HostPort.normalizeHost(server));
        port = URIUtil.normalizePortForScheme(scheme, port);
        if (port > 0) {
            url.append(':').append(port);
        }
    }

    @Deprecated
    public static void appendSchemeHostPort(StringBuffer url, String scheme, String server, int port) {
        scheme = URIUtil.normalizeScheme(scheme);
        url.append(scheme).append("://").append(HostPort.normalizeHost(server));
        port = URIUtil.normalizePortForScheme(scheme, port);
        if (port > 0) {
            url.append(':').append(port);
        }
    }

    public static String encodePathSafeEncoding(String path) {
        if (path == null) {
            return null;
        }
        if ("".equals(path) || "/".equals(path)) {
            return path;
        }
        int offset = 0;
        int length = path.length();
        try {
            Utf8StringBuilder builder = null;
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                char c = path.charAt(i);
                if (c == '%') {
                    if (builder == null) {
                        builder = new Utf8StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    if (i + 2 < end) {
                        char u = path.charAt(i + 1);
                        if (u == 'u') {
                            if (TypeUtil.isHex(path, i + 2, 4)) {
                                int codepoint = 0xFFFF & TypeUtil.parseInt(path, i + 2, 4, 16);
                                URIUtil.encodeCodepoint(codepoint, builder);
                                i += 5;
                                continue;
                            }
                            builder.append("%25");
                            continue;
                        }
                        if (TypeUtil.isHex(path, i + 1, 2)) {
                            byte b = (byte)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i + 2)));
                            if (URIUtil.mustBeEncoded(b) || b == 47) {
                                URIUtil.encodeCodepoint(b, builder);
                            } else {
                                builder.append(b);
                            }
                            i += 2;
                            continue;
                        }
                        builder.append("%25");
                        continue;
                    }
                    builder.append("%25");
                    continue;
                }
                if (URIUtil.mustBeEncoded(c)) {
                    if (builder == null) {
                        builder = new Utf8StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    URIUtil.encodeCodepoint(c, builder);
                    continue;
                }
                if (builder == null) continue;
                builder.append(c);
            }
            if (builder != null) {
                return builder.toCompleteString();
            }
            return path;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot decode URI", e);
        }
    }

    private static boolean mustBeEncoded(int codepoint) {
        if (codepoint > 127) {
            return true;
        }
        if (codepoint <= 31 || codepoint == 127) {
            return true;
        }
        if (codepoint == 34 || codepoint == 60 || codepoint == 62 || codepoint == 37 || codepoint == 123 || codepoint == 125 || codepoint == 124 || codepoint == 92 || codepoint == 94 || codepoint == 96) {
            return true;
        }
        if (codepoint == 32 || codepoint == 91 || codepoint == 93) {
            return true;
        }
        return codepoint == 63 || codepoint == 35;
    }

    public static URI addPath(URI uri, String path) {
        Objects.requireNonNull(uri, "URI");
        if (path == null || "".equals(path)) {
            return uri;
        }
        int pathLen = (path = URIUtil.compactPath(path)).length();
        if (pathLen == 0) {
            return uri;
        }
        String base = URIUtil.correctURI(uri).toASCIIString();
        path = URIUtil.encodePathSafeEncoding(path);
        pathLen = path.length();
        if (base.length() == 0) {
            return URI.create(path);
        }
        StringBuilder buf = new StringBuilder(base.length() + pathLen * 3);
        buf.append(base);
        if (buf.charAt(base.length() - 1) != '/') {
            buf.append('/');
        }
        int offset = path.charAt(0) == '/' ? 1 : 0;
        buf.append(path, offset, pathLen);
        return URI.create(buf.toString());
    }

    public static String addQueries(String query1, String query2) {
        if (StringUtil.isEmpty(query1)) {
            return query2;
        }
        if (StringUtil.isEmpty(query2)) {
            return query1;
        }
        return query1 + "&" + query2;
    }

    @Deprecated(since="12.0.7", forRemoval=true)
    public static URI correctFileURI(URI uri) {
        return URIUtil.correctURI(uri);
    }

    public static URI correctURI(URI uri) {
        if (uri == null || uri.getScheme() == null) {
            return uri;
        }
        if (!uri.getScheme().equalsIgnoreCase("file") && !uri.getScheme().equalsIgnoreCase("jar")) {
            return uri;
        }
        if (uri.getRawAuthority() != null) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return uri;
        }
        String rawURI = uri.toASCIIString();
        int colon2 = rawURI.indexOf(":/");
        if (colon2 < 0) {
            return uri;
        }
        if (colon2 + 2 == rawURI.length()) {
            return URI.create("file:///");
        }
        int end = -1;
        if (rawURI.charAt(colon2 + 2) != '/') {
            end = colon2 + 2;
        }
        if (end >= 0) {
            return URI.create(rawURI.substring(0, colon2) + ":///" + rawURI.substring(end));
        }
        return uri;
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public static List<URI> split(String str) {
        ArrayList<URI> uris = new ArrayList<URI>();
        StringTokenizer tokenizer = new StringTokenizer(str, ",;|");
        while (tokenizer.hasMoreTokens()) {
            String reference = tokenizer.nextToken();
            try {
                if (reference.endsWith("/*") || reference.endsWith("\\*")) {
                    String dir = reference.substring(0, reference.length() - 2);
                    Path pathDir = Paths.get(dir, new String[0]);
                    if (!Files.exists(pathDir, new LinkOption[0]) || !Files.isDirectory(pathDir, new LinkOption[0])) continue;
                    try {
                        Stream<Path> listStream = Files.list(pathDir);
                        try {
                            listStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(FileID::isLibArchive).sorted(Comparator.naturalOrder()).forEach(path -> uris.add(URIUtil.toJarFileUri(path.toUri())));
                            continue;
                        }
                        finally {
                            if (listStream == null) continue;
                            listStream.close();
                            continue;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to process directory glob listing: " + reference, e);
                    }
                }
                URI refUri = URIUtil.toURI(reference);
                uris.add(URIUtil.toJarFileUri(refUri));
            }
            catch (Exception e) {
                LOG.warn("Invalid Resource Reference: " + reference);
                throw e;
            }
        }
        return uris;
    }

    public static URI toJarFileUri(URI uri) {
        boolean hasInternalReference;
        Objects.requireNonNull(uri, "URI");
        String scheme = Objects.requireNonNull(uri.getScheme(), "URI scheme");
        boolean bl = hasInternalReference = uri.getRawSchemeSpecificPart().indexOf("!/") > 0;
        if (scheme.equalsIgnoreCase("jar")) {
            if (uri.getRawSchemeSpecificPart().startsWith("file:")) {
                if (hasInternalReference) {
                    return uri;
                }
                return URI.create(uri.toASCIIString() + "!/");
            }
        } else if (scheme.equalsIgnoreCase("file")) {
            String rawUri = uri.toASCIIString();
            if (rawUri.endsWith("/")) {
                return uri;
            }
            if (hasInternalReference) {
                return URI.create("jar:" + rawUri);
            }
            return URI.create("jar:" + rawUri + "!/");
        }
        throw new IllegalArgumentException("Cannot make %s into `jar:file:` URI".formatted(uri));
    }

    public static URI toURI(String reference) {
        Objects.requireNonNull(reference);
        try {
            URI uri = new URI(reference);
            if (uri.isAbsolute()) {
                String scheme = uri.getScheme();
                if (scheme.length() == 1 && Character.isLetter(scheme.charAt(0))) {
                    return URIUtil.toURI("file:///" + uri.toASCIIString());
                }
                return URIUtil.correctURI(uri);
            }
        }
        catch (URISyntaxException e) {
            LOG.trace("IGNORED: Invalid as URI Reference: {}", (Object)reference, (Object)e);
        }
        try {
            Path path = Path.of(reference, new String[0]).toAbsolutePath();
            return path.toUri();
        }
        catch (InvalidPathException e) {
            LOG.trace("IGNORED: Invalid as Path Reference: {}", (Object)reference, (Object)e);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Input string cannot be converted to URI \"{}\"", (Object)reference);
            }
            throw new IllegalArgumentException("Cannot be converted to URI");
        }
    }

    public static URI unwrapContainer(URI uri) {
        Objects.requireNonNull(uri);
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("jar")) {
            return uri;
        }
        String spec = uri.getRawSchemeSpecificPart();
        int sep = spec.indexOf("!/");
        if (sep != -1) {
            spec = spec.substring(0, sep);
        }
        return URI.create(spec);
    }

    public static URI uriJarPrefix(URI uri, String encodedSuffix) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null");
        }
        if (encodedSuffix == null) {
            throw new IllegalArgumentException("Encoded Suffix must not be null");
        }
        if (!encodedSuffix.startsWith("!/")) {
            throw new IllegalArgumentException("Suffix must start with \"!/\"");
        }
        String uriString = uri.toASCIIString();
        int bangSlash = uriString.indexOf("!/");
        if (bangSlash >= 0) {
            uriString = uriString.substring(0, bangSlash);
        }
        if (uri.getScheme().equalsIgnoreCase("jar")) {
            return URI.create(uriString + encodedSuffix);
        }
        if (uri.getScheme().equalsIgnoreCase("file")) {
            return URI.create("jar:" + uriString + encodedSuffix);
        }
        throw new IllegalArgumentException("Unsupported URI scheme: " + String.valueOf(uri));
    }

    public static Stream<URI> streamOf(URLClassLoader urlClassLoader) {
        URL[] urls = urlClassLoader.getURLs();
        return Stream.of(urls).filter(Objects::nonNull).map(URL::toString).map(URI::create).map(URIUtil::unwrapContainer).map(URIUtil::correctURI);
    }

    public static int getDefaultPortForScheme(String scheme) {
        if (scheme == null) {
            return -1;
        }
        Integer port = DEFAULT_PORT_FOR_SCHEME.get(scheme);
        return port == null ? -1 : port;
    }

    public static String normalizeScheme(String scheme) {
        return scheme == null ? null : StringUtil.asciiToLowerCase(scheme);
    }

    private static boolean isHexDigit(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    public static void validateInetAddress(String inetAddress) {
        try {
            InetAddress inetAddress2 = InetAddress.getByName(inetAddress);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Bad [IPv6] address: " + inetAddress, e);
        }
    }

    public static String validateScheme(String scheme) {
        if (scheme == null || scheme.isEmpty()) {
            throw new IllegalArgumentException("Bad scheme");
        }
        StringBuilder toLowerCase = null;
        for (int i = 0; i < scheme.length(); ++i) {
            char c = scheme.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (toLowerCase == null) {
                    toLowerCase = new StringBuilder(scheme.length());
                    toLowerCase.append(scheme, 0, i);
                }
                toLowerCase.append(Character.toLowerCase(c));
                continue;
            }
            if (c >= 'a' && c <= 'z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-')) {
                if (toLowerCase == null) continue;
                toLowerCase.append(c);
                continue;
            }
            throw new IllegalArgumentException("Bad scheme");
        }
        return toLowerCase == null ? scheme : toLowerCase.toString();
    }

    public static int normalizePortForScheme(String scheme, int port) {
        if (port <= 0) {
            return 0;
        }
        return port == URIUtil.getDefaultPortForScheme(scheme) ? 0 : port;
    }

    static {
        Arrays.fill(REGNAME_ALLOWED, false);
        for (char c : REGNAME.toCharArray()) {
            URIUtil.REGNAME_ALLOWED[c] = true;
        }
        URI_SUPPORTED_CHARACTERS = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, false, false, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, false};
        ENCODE_PATH_NEEDS_ENCODING = new boolean[128];
        for (char c : "%?;#\"'<> [\\]^`{|}".toCharArray()) {
            URIUtil.ENCODE_PATH_NEEDS_ENCODING[c] = true;
        }
        URIUtil.ENCODE_PATH_NEEDS_ENCODING[127] = true;
        for (int i = 0; i < 32; ++i) {
            URIUtil.ENCODE_PATH_NEEDS_ENCODING[i] = true;
        }
        DEFAULT_PORT_FOR_SCHEME = new Index.Builder().caseSensitive(false).with("ftp", 21).with("ssh", 22).with("telnet", 23).with("smtp", 25).with("http", 80).with("ws", 80).with("https", 443).with("wss", 443).build();
    }
}

