/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.geospatial;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class GeospatialTypes {
    private static final int UNKNOWN_TYPE_ID = -1;
    private Set<Integer> types = new HashSet<Integer>();
    private boolean valid = true;

    public GeospatialTypes(Set<Integer> types) {
        this.types = types;
        this.valid = true;
    }

    public GeospatialTypes(Set<Integer> types, boolean valid) {
        this.types = types;
        this.valid = valid;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeospatialTypes)) {
            return false;
        }
        GeospatialTypes other = (GeospatialTypes)obj;
        if (obj == this) {
            return true;
        }
        return this.valid == other.valid && this.types.equals(other.types);
    }

    public int hashCode() {
        return this.types.hashCode() ^ Boolean.hashCode(this.valid);
    }

    public GeospatialTypes() {
    }

    public Set<Integer> getTypes() {
        return this.types;
    }

    public void update(Geometry geometry) {
        if (!this.valid) {
            return;
        }
        if (geometry == null || geometry.isEmpty()) {
            return;
        }
        int code = this.getGeometryTypeCode(geometry);
        if (code != -1) {
            this.types.add(code);
        } else {
            this.valid = false;
            this.types.clear();
        }
    }

    public void merge(GeospatialTypes other) {
        if (!this.valid) {
            return;
        }
        if (other == null || !other.valid) {
            this.valid = false;
            this.types.clear();
            return;
        }
        this.types.addAll(other.types);
    }

    public void reset() {
        this.types.clear();
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public GeospatialTypes copy() {
        return new GeospatialTypes(new HashSet<Integer>(this.types), this.valid);
    }

    private int getBaseTypeCode(int typeId) {
        return typeId % 1000;
    }

    private int getDimensionPrefix(int typeId) {
        return typeId / 1000 * 1000;
    }

    public String toString() {
        return "GeospatialTypes{types=" + String.valueOf(this.types.stream().map(this::typeIdToString).collect(Collectors.toSet())) + "}";
    }

    private int getGeometryTypeId(Geometry geometry) {
        return switch (geometry.getGeometryType()) {
            case "Point" -> 1;
            case "LineString" -> 2;
            case "Polygon" -> 3;
            case "MultiPoint" -> 4;
            case "MultiLineString" -> 5;
            case "MultiPolygon" -> 6;
            case "GeometryCollection" -> 7;
            default -> -1;
        };
    }

    private int getGeometryTypeCode(Geometry geometry) {
        int typeId = this.getGeometryTypeId(geometry);
        if (typeId == -1) {
            return -1;
        }
        Coordinate[] coordinates = geometry.getCoordinates();
        boolean hasZ = false;
        boolean hasM = false;
        if (coordinates.length > 0) {
            Coordinate firstCoord = coordinates[0];
            hasZ = !Double.isNaN(firstCoord.getZ());
            boolean bl = hasM = !Double.isNaN(firstCoord.getM());
        }
        if (hasZ) {
            typeId += 1000;
        }
        if (hasM) {
            typeId += 2000;
        }
        return typeId;
    }

    private String typeIdToString(int typeId) {
        Object typeString;
        switch (typeId % 1000) {
            case 1: {
                Object object = "Point";
                break;
            }
            case 2: {
                Object object = "LineString";
                break;
            }
            case 3: {
                Object object = "Polygon";
                break;
            }
            case 4: {
                Object object = "MultiPoint";
                break;
            }
            case 5: {
                Object object = "MultiLineString";
                break;
            }
            case 6: {
                Object object = "MultiPolygon";
                break;
            }
            case 7: {
                Object object = "GeometryCollection";
                break;
            }
            default: {
                Object object = typeString = "Unknown";
            }
        }
        typeString = typeId >= 3000 ? (String)typeString + " (XYZM)" : (typeId >= 2000 ? (String)typeString + " (XYM)" : (typeId >= 1000 ? (String)typeString + " (XYZ)" : (String)typeString + " (XY)"));
        return typeString;
    }
}

