/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.util.UUID;
import org.apache.spark.SparkEnv;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.sql.execution.streaming.state.CheckIfShouldForceSnapshotUploadForTesting;
import org.apache.spark.sql.execution.streaming.state.DeactivateInstances;
import org.apache.spark.sql.execution.streaming.state.GetLaggingStoresForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLatestSnapshotVersionForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLocation;
import org.apache.spark.sql.execution.streaming.state.LogLaggingStateStores;
import org.apache.spark.sql.execution.streaming.state.ReportActiveInstance;
import org.apache.spark.sql.execution.streaming.state.ReportActiveInstanceResponse;
import org.apache.spark.sql.execution.streaming.state.ReportSnapshotUploaded;
import org.apache.spark.sql.execution.streaming.state.ReportStateStoreCommit;
import org.apache.spark.sql.execution.streaming.state.StartStateStoreCommitTrackingForBatch;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StopCoordinator$;
import org.apache.spark.sql.execution.streaming.state.ValidateStateStoreCommitForBatch;
import org.apache.spark.sql.execution.streaming.state.VerifyIfInstanceActive;
import org.apache.spark.sql.internal.SQLConf;
import scala.Option;
import scala.StringContext;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mw!B\r\u001b\u0011\u0003Ic!B\u0016\u001b\u0011\u0003a\u0003\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%I\u0001\u0010\u0005\u0007\u000b\u0006\u0001\u000b\u0011B\u001f\t\u000b\u0019\u000bA\u0011A$\t\u000f\u00055\u0017\u0001\"\u0001\u0002P\u001a!1F\u0007\u0001J\u0011!QuA!A!\u0002\u0013Y\u0005\"B\u001d\b\t\u0013\t\u0006BB*\b\t\u0003\u0001C\u000b\u0003\u0004w\u000f\u0011\u0005\u0001e\u001e\u0005\u0007{\u001e!\t\u0001\t@\t\u0011\u0005\u001dq\u0001\"\u0001!\u0003\u0013A\u0001\"!\t\b\t\u0003\u0001\u00131\u0005\u0005\t\u0003o9A\u0011\u0001\u0011\u0002:!A\u0011qI\u0004\u0005\u0002\u0001\nI\u0005\u0003\u0005\u0002d\u001d!\t\u0001IA3\u0011)\t\thBI\u0001\n\u0003\u0001\u00131\u000f\u0005\t\u0003\u0013;A\u0011\u0001\u0011\u0002\f\"A\u0011\u0011S\u0004\u0005\u0002i\t\u0019\n\u0003\u0005\u0002\u001a\u001e!\tAGAN\u0011)\t\u0019kBI\u0001\n\u0003Q\u0012Q\u0015\u0005\t\u0003S;A\u0011\u0001\u000e\u0002,\"A\u0011qV\u0004\u0005\u0002i\t\t,\u0001\rTi\u0006$Xm\u0015;pe\u0016\u001cun\u001c:eS:\fGo\u001c:SK\u001aT!a\u0007\u000f\u0002\u000bM$\u0018\r^3\u000b\u0005uq\u0012!C:ue\u0016\fW.\u001b8h\u0015\ty\u0002%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001A\u0011!&A\u0007\u00025\tA2\u000b^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014(+\u001a4\u0014\u0007\u0005i3\u0007\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VM\u001a\t\u0003i]j\u0011!\u000e\u0006\u0003m\t\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003qU\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002S\u0005aQM\u001c3q_&tGOT1nKV\tQ\b\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006!A.\u00198h\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R \u0003\rM#(/\u001b8h\u00035)g\u000e\u001a9pS:$h*Y7fA\u0005Iam\u001c:Ee&4XM\u001d\u000b\u0006\u0011\u0006M\u0016q\u0018\t\u0003U\u001d\u0019\"aB\u0017\u0002\u001dI\u00048-\u00128ea>Lg\u000e\u001e*fMB\u0011AjT\u0007\u0002\u001b*\u0011aJI\u0001\u0004eB\u001c\u0017B\u0001)N\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a$\"\u0001\u0013*\t\u000b)K\u0001\u0019A&\u0002)I,\u0007o\u001c:u\u0003\u000e$\u0018N^3J]N$\u0018M\\2f)\u0015)\u0006,X5l!\tQc+\u0003\u0002X5\ta\"+\u001a9peR\f5\r^5wK&s7\u000f^1oG\u0016\u0014Vm\u001d9p]N,\u0007\"B-\u000b\u0001\u0004Q\u0016\u0001F:uCR,7\u000b^8sKB\u0013xN^5eKJLE\r\u0005\u0002+7&\u0011AL\u0007\u0002\u0015'R\fG/Z*u_J,\u0007K]8wS\u0012,'/\u00133\t\u000byS\u0001\u0019A0\u0002\t!|7\u000f\u001e\t\u0003A\u001et!!Y3\u0011\u0005\t|S\"A2\u000b\u0005\u0011D\u0013A\u0002\u001fs_>$h(\u0003\u0002g_\u00051\u0001K]3eK\u001aL!\u0001\u00125\u000b\u0005\u0019|\u0003\"\u00026\u000b\u0001\u0004y\u0016AC3yK\u000e,Ho\u001c:JI\")AN\u0003a\u0001[\u0006\u0001r\u000e\u001e5feB\u0013xN^5eKJLEm\u001d\t\u0004]NTfBA8r\u001d\t\u0011\u0007/C\u00011\u0013\t\u0011x&A\u0004qC\u000e\\\u0017mZ3\n\u0005Q,(aA*fc*\u0011!oL\u0001\u0017m\u0016\u0014\u0018NZ=JM&s7\u000f^1oG\u0016\f5\r^5wKR\u0019\u0001p\u001f?\u0011\u00059J\u0018B\u0001>0\u0005\u001d\u0011un\u001c7fC:DQ!W\u0006A\u0002iCQA[\u0006A\u0002}\u000b1bZ3u\u0019>\u001c\u0017\r^5p]R\u0019q0!\u0002\u0011\t9\n\taX\u0005\u0004\u0003\u0007y#AB(qi&|g\u000eC\u0003Z\u0019\u0001\u0007!,A\neK\u0006\u001cG/\u001b<bi\u0016Len\u001d;b]\u000e,7\u000f\u0006\u0003\u0002\f\u0005E\u0001c\u0001\u0018\u0002\u000e%\u0019\u0011qB\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003'i\u0001\u0019AA\u000b\u0003\u0015\u0011XO\\%e!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e\u0003\u0006!Q\u000f^5m\u0013\u0011\ty\"!\u0007\u0003\tU+\u0016\nR\u0001\u0011g:\f\u0007o\u001d5piV\u0003Hn\\1eK\u0012$r\u0001_A\u0013\u0003S\t\u0019\u0004\u0003\u0004\u0002(9\u0001\rAW\u0001\u000baJ|g/\u001b3fe&#\u0007bBA\u0016\u001d\u0001\u0007\u0011QF\u0001\bm\u0016\u00148/[8o!\rq\u0013qF\u0005\u0004\u0003cy#\u0001\u0002'p]\u001eDq!!\u000e\u000f\u0001\u0004\ti#A\u0005uS6,7\u000f^1na\u0006)Bn\\4MC\u001e<\u0017N\\4Ti\u0006$Xm\u0015;pe\u0016\u001cHc\u0002=\u0002<\u0005}\u00121\t\u0005\b\u0003{y\u0001\u0019AA\u000b\u0003)\tX/\u001a:z%Vt\u0017\n\u001a\u0005\b\u0003\u0003z\u0001\u0019AA\u0017\u00035a\u0017\r^3tiZ+'o]5p]\"1\u0011QI\bA\u0002a\fA#[:UKJl\u0017N\\1uS:<GK]5hO\u0016\u0014\u0018!J:uCJ$8\u000b^1uKN#xN]3D_6l\u0017\u000e\u001e+sC\u000e\\\u0017N\\4G_J\u0014\u0015\r^2i)!\tY!a\u0013\u0002N\u0005E\u0003bBA\n!\u0001\u0007\u0011Q\u0003\u0005\b\u0003\u001f\u0002\u0002\u0019AA\u0017\u0003\u001d\u0011\u0017\r^2i\u0013\u0012Dq!a\u0015\u0011\u0001\u0004\t)&\u0001\bfqB,7\r^3e'R|'/Z:\u0011\u000f\u0001\f9&!\f\u0002\\%\u0019\u0011\u0011\f5\u0003\u00075\u000b\u0007\u000f\u0005\u0004a\u0003/z\u0016Q\f\t\u0004]\u0005}\u0013bAA1_\t\u0019\u0011J\u001c;\u0002-I,\u0007o\u001c:u'R\fG/Z*u_J,7i\\7nSR$\u0002\"a\u0003\u0002h\u0005-\u0014Q\u000e\u0005\u0007\u0003S\n\u0002\u0019\u0001.\u0002\u000fM$xN]3JI\"9\u00111F\tA\u0002\u00055\u0002\u0002CA8#A\u0005\t\u0019A0\u0002\u0013M$xN]3OC6,\u0017\u0001\t:fa>\u0014Ho\u0015;bi\u0016\u001cFo\u001c:f\u0007>lW.\u001b;%I\u00164\u0017-\u001e7uIM*\"!!\u001e+\u0007}\u000b9h\u000b\u0002\u0002zA!\u00111PAC\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015!C;oG\",7m[3e\u0015\r\t\u0019iL\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAD\u0003{\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u00012\u0018\r\\5eCR,7\u000b^1uKN#xN]3D_6l\u0017\u000e\u001e$pe\n\u000bGo\u00195\u0015\r\u0005-\u0011QRAH\u0011\u001d\t\u0019b\u0005a\u0001\u0003+Aq!a\u0014\u0014\u0001\u0004\ti#\u0001\u0012hKRd\u0015\r^3tiNs\u0017\r]:i_R4VM]:j_:4uN\u001d+fgRLgn\u001a\u000b\u0005\u0003+\u000b9\nE\u0003/\u0003\u0003\ti\u0003\u0003\u0004\u0002(Q\u0001\rAW\u0001\u001bO\u0016$H*Y4hS:<7\u000b^8sKN4uN\u001d+fgRLgn\u001a\u000b\b[\u0006u\u0015qTAQ\u0011\u001d\ti$\u0006a\u0001\u0003+Aq!!\u0011\u0016\u0001\u0004\ti\u0003\u0003\u0005\u0002FU\u0001\n\u00111\u0001y\u0003\u0011:W\r\u001e'bO\u001eLgnZ*u_J,7OR8s)\u0016\u001cH/\u001b8hI\u0011,g-Y;mi\u0012\u001aTCAATU\rA\u0018qO\u0001+G\",7m[%g'\"|W\u000f\u001c3G_J\u001cWm\u00158baNDw\u000e^+qY>\fGMR8s)\u0016\u001cH/\u001b8h)\rA\u0018Q\u0016\u0005\u0007\u0003O9\u0002\u0019\u0001.\u0002\tM$x\u000e\u001d\u000b\u0003\u0003\u0017Aq!!.\u0006\u0001\u0004\t9,A\u0002f]Z\u0004B!!/\u0002<6\t!%C\u0002\u0002>\n\u0012\u0001b\u00159be.,eN\u001e\u0005\b\u0003\u0003,\u0001\u0019AAb\u0003\u001d\u0019\u0018\u000f\\\"p]\u001a\u0004B!!2\u0002J6\u0011\u0011q\u0019\u0006\u0003m\u0001JA!a3\u0002H\n91+\u0015'D_:4\u0017a\u00034pe\u0016CXmY;u_J$2\u0001SAi\u0011\u001d\t)L\u0002a\u0001\u0003o\u0003")
public class StateStoreCoordinatorRef {
    private final RpcEndpointRef rpcEndpointRef;

    public static StateStoreCoordinatorRef forExecutor(SparkEnv env) {
        return StateStoreCoordinatorRef$.MODULE$.forExecutor(env);
    }

    public static StateStoreCoordinatorRef forDriver(SparkEnv env, SQLConf sqlConf) {
        return StateStoreCoordinatorRef$.MODULE$.forDriver(env, sqlConf);
    }

    public static Logging.LogStringContext LogStringContext(StringContext sc) {
        return StateStoreCoordinatorRef$.MODULE$.LogStringContext(sc);
    }

    public ReportActiveInstanceResponse reportActiveInstance(StateStoreProviderId stateStoreProviderId, String host, String executorId, Seq<StateStoreProviderId> otherProviderIds) {
        return (ReportActiveInstanceResponse)this.rpcEndpointRef.askSync((Object)new ReportActiveInstance(stateStoreProviderId, host, executorId, otherProviderIds), ClassTag$.MODULE$.apply(ReportActiveInstanceResponse.class));
    }

    public boolean verifyIfInstanceActive(StateStoreProviderId stateStoreProviderId, String executorId) {
        return BoxesRunTime.unboxToBoolean((Object)this.rpcEndpointRef.askSync((Object)new VerifyIfInstanceActive(stateStoreProviderId, executorId), (ClassTag)ClassTag$.MODULE$.Boolean()));
    }

    public Option<String> getLocation(StateStoreProviderId stateStoreProviderId) {
        return (Option)this.rpcEndpointRef.askSync((Object)new GetLocation(stateStoreProviderId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void deactivateInstances(UUID runId) {
        this.rpcEndpointRef.askSync((Object)new DeactivateInstances(runId), (ClassTag)ClassTag$.MODULE$.Boolean());
    }

    public boolean snapshotUploaded(StateStoreProviderId providerId, long version, long timestamp) {
        return BoxesRunTime.unboxToBoolean((Object)this.rpcEndpointRef.askSync((Object)new ReportSnapshotUploaded(providerId, version, timestamp), (ClassTag)ClassTag$.MODULE$.Boolean()));
    }

    public boolean logLaggingStateStores(UUID queryRunId, long latestVersion, boolean isTerminatingTrigger) {
        return BoxesRunTime.unboxToBoolean((Object)this.rpcEndpointRef.askSync((Object)new LogLaggingStateStores(queryRunId, latestVersion, isTerminatingTrigger), (ClassTag)ClassTag$.MODULE$.Boolean()));
    }

    public void startStateStoreCommitTrackingForBatch(UUID runId, long batchId, Map<Object, Map<String, Object>> expectedStores) {
        this.rpcEndpointRef.askSync((Object)new StartStateStoreCommitTrackingForBatch(runId, batchId, expectedStores), (ClassTag)ClassTag$.MODULE$.Unit());
    }

    public void reportStateStoreCommit(StateStoreProviderId storeId, long version, String storeName) {
        this.rpcEndpointRef.askSync((Object)new ReportStateStoreCommit(storeId, version, storeName), (ClassTag)ClassTag$.MODULE$.Unit());
    }

    public String reportStateStoreCommit$default$3() {
        return StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
    }

    public void validateStateStoreCommitForBatch(UUID runId, long batchId) {
        this.rpcEndpointRef.askSync((Object)new ValidateStateStoreCommitForBatch(runId, batchId), (ClassTag)ClassTag$.MODULE$.Unit());
    }

    public Option<Object> getLatestSnapshotVersionForTesting(StateStoreProviderId providerId) {
        return (Option)this.rpcEndpointRef.askSync((Object)new GetLatestSnapshotVersionForTesting(providerId), ClassTag$.MODULE$.apply(Option.class));
    }

    public Seq<StateStoreProviderId> getLaggingStoresForTesting(UUID queryRunId, long latestVersion, boolean isTerminatingTrigger) {
        return (Seq)this.rpcEndpointRef.askSync((Object)new GetLaggingStoresForTesting(queryRunId, latestVersion, isTerminatingTrigger), ClassTag$.MODULE$.apply(Seq.class));
    }

    public boolean getLaggingStoresForTesting$default$3() {
        return false;
    }

    public boolean checkIfShouldForceSnapshotUploadForTesting(StateStoreProviderId providerId) {
        return BoxesRunTime.unboxToBoolean((Object)this.rpcEndpointRef.askSync((Object)new CheckIfShouldForceSnapshotUploadForTesting(providerId), (ClassTag)ClassTag$.MODULE$.Boolean()));
    }

    public void stop() {
        this.rpcEndpointRef.askSync((Object)StopCoordinator$.MODULE$, (ClassTag)ClassTag$.MODULE$.Boolean());
    }

    public StateStoreCoordinatorRef(RpcEndpointRef rpcEndpointRef) {
        this.rpcEndpointRef = rpcEndpointRef;
    }
}

