/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed$;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Uuid$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_() - Returns an universally unique identifier (UUID) string. The value is returned as a canonical UUID 36-character string.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       46707d92-02f4-4817-8116-a4c3b23e6266\n  ", note="\n    The function is non-deterministic.\n  ", since="2.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5a\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t1\u0002\u0011\t\u0012)A\u0005%\")\u0011\f\u0001C\u00015\")\u0011\f\u0001C\u0001;\")\u0011\f\u0001C\u0001=\")A\r\u0001C!K\")a\r\u0001C!O\")\u0011\u000e\u0001C!U\"AQ\u000e\u0001EC\u0002\u0013\u0005c\u000eC\u0003s\u0001\u0011\u0005c\u000eC\u0003t\u0001\u0011\u0005c\u000eC\u0005u\u0001\u0001\u0007\t\u0011)Q\u0005k\"1q\u0010\u0001C)\u0003\u0003Aq!a\u0005\u0001\t#\n)\u0002C\u0004\u0002*\u0001!\t%a\u000b\t\u0013\u0005\u001d\u0003!!A\u0005\u0002\u0005%\u0003\"CA'\u0001E\u0005I\u0011AA(\u0011%\t)\u0007AA\u0001\n\u0003\n9\u0007C\u0005\u0002z\u0001\t\t\u0011\"\u0001\u0002|!I\u0011Q\u0010\u0001\u0002\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0003\u000b\u0003\u0011\u0011!C!\u0003\u000fC\u0011\"!&\u0001\u0003\u0003%\t!a&\t\u0013\u0005m\u0005!!A\u0005B\u0005u\u0005\"CAQ\u0001\u0005\u0005I\u0011IAR\u000f%\timIA\u0001\u0012\u0003\tyM\u0002\u0005#G\u0005\u0005\t\u0012AAi\u0011\u0019I&\u0004\"\u0001\u0002j\"I\u00111\u001e\u000e\u0002\u0002\u0013\u0015\u0013Q\u001e\u0005\n\u0003_T\u0012\u0011!CA\u0003cD\u0011\"!>\u001b#\u0003%\t!a\u0014\t\u0013\u0005]($!A\u0005\u0002\u0006e\b\"\u0003B\u00015E\u0005I\u0011AA(\u0011%\u0011\u0019AGA\u0001\n\u0013\u0011)A\u0001\u0003Vk&$'B\u0001\u0013&\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0019:\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005!J\u0013aA:rY*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\tT\u0007O\u001e?\tB\u0011!gM\u0007\u0002G%\u0011Ag\t\u0002\u000f\u0019\u0016\fg-\u0012=qe\u0016\u001c8/[8o!\t\u0011d'\u0003\u00028G\t\u0001bj\u001c8eKR,'/\\5oSN$\u0018n\u0019\t\u0003eeJ!AO\u0012\u0003A\u0011+g-Y;miN#(/\u001b8h!J|G-^2j]\u001e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003eqJ!!P\u0012\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0015keB\u0001$L\u001d\t9%*D\u0001I\u0015\tIu&\u0001\u0004=e>|GOP\u0005\u0002\u0003&\u0011A\nQ\u0001\ba\u0006\u001c7.Y4f\u0013\tquJ\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002M\u0001\u0006Q!/\u00198e_6\u001cV-\u001a3\u0016\u0003I\u00032aP*V\u0013\t!\u0006I\u0001\u0004PaRLwN\u001c\t\u0003\u007fYK!a\u0016!\u0003\t1{gnZ\u0001\fe\u0006tGm\\7TK\u0016$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00037r\u0003\"A\r\u0001\t\u000fA\u001b\u0001\u0013!a\u0001%R\t1\f\u0006\u0002\\?\")\u0001-\u0002a\u0001C\u0006!1/Z3e!\t\u0011$-\u0003\u0002dG\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u001dM,W\rZ#yaJ,7o]5p]V\t\u0011-A\u0006xSRDg*Z<TK\u0016$GCA.i\u0011\u0015\u0001w\u00011\u0001V\u0003=9\u0018\u000e\u001e5TQ&4G/\u001a3TK\u0016$GCA.l\u0011\u0015a\u0007\u00021\u0001V\u0003\u0015\u0019\b.\u001b4u\u0003!\u0011Xm]8mm\u0016$W#A8\u0011\u0005}\u0002\u0018BA9A\u0005\u001d\u0011un\u001c7fC:\f\u0001B\\;mY\u0006\u0014G.Z\u0001\tgR\fG/\u001a4vY\u0006y!/\u00198e_6<UM\\3sCR|'\u000f\u0005\u0002ws6\tqO\u0003\u0002yK\u0005!Q\u000f^5m\u0013\tQxOA\nSC:$w.\\+V\u0013\u0012;UM\\3sCR|'\u000f\u000b\u0002\ryB\u0011q(`\u0005\u0003}\u0002\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002%%t\u0017\u000e^5bY&TX-\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003\u0007\tI\u0001E\u0002@\u0003\u000bI1!a\u0002A\u0005\u0011)f.\u001b;\t\u000f\u0005-Q\u00021\u0001\u0002\u000e\u0005q\u0001/\u0019:uSRLwN\\%oI\u0016D\bcA \u0002\u0010%\u0019\u0011\u0011\u0003!\u0003\u0007%sG/\u0001\u0007fm\u0006d\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002\u0018\u0005u\u0001cA \u0002\u001a%\u0019\u00111\u0004!\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002 9\u0001\r!!\t\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005\r\u0012QE\u0007\u0002K%\u0019\u0011qE\u0013\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$b!!\f\u0002:\u0005\r\u0003\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M2%A\u0004d_\u0012,w-\u001a8\n\t\u0005]\u0012\u0011\u0007\u0002\t\u000bb\u0004(oQ8eK\"9\u00111H\bA\u0002\u0005u\u0012aA2uqB!\u0011qFA \u0013\u0011\t\t%!\r\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011QI\bA\u0002\u00055\u0012AA3w\u0003\u0011\u0019w\u000e]=\u0015\u0007m\u000bY\u0005C\u0004Q!A\u0005\t\u0019\u0001*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u000b\u0016\u0004%\u0006M3FAA+!\u0011\t9&!\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0003)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0019\u0002Z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\t1\fgn\u001a\u0006\u0003\u0003g\nAA[1wC&!\u0011qOA7\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011QB\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9\"!!\t\u0013\u0005\rE#!AA\u0002\u00055\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\nB1\u00111RAI\u0003/i!!!$\u000b\u0007\u0005=\u0005)\u0001\u0006d_2dWm\u0019;j_:LA!a%\u0002\u000e\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ry\u0017\u0011\u0014\u0005\n\u0003\u00073\u0012\u0011!a\u0001\u0003/\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011NAP\u0011%\t\u0019iFA\u0001\u0002\u0004\ti!\u0001\u0004fcV\fGn\u001d\u000b\u0004_\u0006\u0015\u0006\"CAB1\u0005\u0005\t\u0019AA\fQ]\u0001\u0011\u0011VAX\u0003c\u000b),a.\u0002<\u0006u\u0016\u0011YAb\u0003\u000f\fI\rE\u00023\u0003WK1!!,$\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a-\u0002\u0003\u0007yf)\u0016(D?\"J\u0003%\f\u0011SKR,(O\\:!C:\u0004SO\\5wKJ\u001c\u0018\r\u001c7zAUt\u0017.];fA%$WM\u001c;jM&,'\u000f\t\u0015V+&#\u0015\u0006I:ue&twM\f\u0011UQ\u0016\u0004c/\u00197vK\u0002J7\u000f\t:fiV\u0014h.\u001a3!CN\u0004\u0013\rI2b]>t\u0017nY1mAU+\u0016\n\u0012\u00114m5\u001a\u0007.\u0019:bGR,'\u000fI:ue&twML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011X\u0001W\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"J3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001b7oA:D-\u000f\u001a.aI2G'\f\u001b9c]j\u0003(M\u00197[\u0005$4m\r23g\u00154$G\u000e\u001c\u000bA\u0001\nAA\\8uK\u0006\u0012\u0011qX\u0001+\u0015\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007%[:!]>tW\u0006Z3uKJl\u0017N\\5ti&\u001cgF\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t)-A\u00033]Mr\u0003'A\u0003he>,\b/\t\u0002\u0002L\u0006QQ.[:d?\u001a,hnY:\u0002\tU+\u0018\u000e\u001a\t\u0003ei\u0019RAGAj\u0003?\u0004b!!6\u0002\\J[VBAAl\u0015\r\tI\u000eQ\u0001\beVtG/[7f\u0013\u0011\ti.a6\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\u0011\t)/!\u001d\u0002\u0005%|\u0017b\u0001(\u0002dR\u0011\u0011qZ\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011N\u0001\u0006CB\u0004H.\u001f\u000b\u00047\u0006M\bb\u0002)\u001e!\u0003\u0005\rAU\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%c\u00059QO\\1qa2LH\u0003BA~\u0003{\u00042aP*S\u0011!\typHA\u0001\u0002\u0004Y\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0002\u0011\t\u0005-$\u0011B\u0005\u0005\u0005\u0017\tiG\u0001\u0004PE*,7\r\u001e")
public class Uuid
extends LeafExpression
implements Nondeterministic,
DefaultStringProducingExpression,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private final Option<Object> randomSeed;
    private transient RandomUUIDGenerator randomGenerator;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$1() {
        return Uuid$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<Object>> unapply(Uuid x$0) {
        return Uuid$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$1() {
        return Uuid$.MODULE$.apply$default$1();
    }

    public static <A> Function1<Option<Object>, A> andThen(Function1<Uuid, A> g) {
        return Uuid$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Uuid> compose(Function1<A$, Option<Object>> g) {
        return Uuid$.MODULE$.compose(g);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Uuid withNewSeed(long seed) {
        return new Uuid((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)seed)));
    }

    @Override
    public Uuid withShiftedSeed(long shift) {
        return new Uuid((Option<Object>)this.randomSeed().map((Function1)(JFunction1.mcJJ.sp & Serializable)x$1 -> x$1 + shift));
    }

    private boolean resolved$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.randomGenerator = new RandomUUIDGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        return this.randomGenerator.getNextUUIDUTF8String();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String randomGen = ctx.freshName("randomGen");
        String x$1 = "org.apache.spark.sql.catalyst.util.RandomUUIDGenerator";
        String x$2 = randomGen;
        boolean x$3 = true;
        boolean x$4 = false;
        Function1<String, String> x$5 = ctx.addMutableState$default$3();
        ctx.addMutableState("org.apache.spark.sql.catalyst.util.RandomUUIDGenerator", x$2, x$5, true, false);
        ctx.addPartitionInitializationStatement(randomGen + " = new org.apache.spark.sql.catalyst.util.RandomUUIDGenerator(" + this.randomSeed().get() + "L + partitionIndex);");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"final UTF8String ", " = ", ".getNextUUIDUTF8String();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), randomGen})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public Uuid copy(Option<Object> randomSeed) {
        return new Uuid(randomSeed);
    }

    public Option<Object> copy$default$1() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Uuid";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.randomSeed();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uuid;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "randomSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uuid)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uuid uuid = (Uuid)x$1;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = uuid.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!uuid.canEqual(this)) return false;
        return true;
    }

    public Uuid(Option<Object> randomSeed) {
        this.randomSeed = randomSeed;
        Nondeterministic.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        Statics.releaseFence();
    }

    public Uuid() {
        this((Option<Object>)None$.MODULE$);
    }

    public Uuid(Expression seed) {
        this(ExpressionWithRandomSeed$.MODULE$.expressionToSeed(seed, "UUID"));
    }
}

