/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TupleSketchAggDouble;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter$;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$Sum$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

@ExpressionDescription(usage="\n    _FUNC_(key, summary, lgNomEntries, mode) - Returns the TupleSketch compact binary representation.\n      `key` is the expression for unique value counting.\n      `summary` is the double value to be aggregated.\n      `lgNomEntries` is the log-base-2 of nominal entries, with nominal entries deciding\n      the number buckets or slots for the TupleSketch. Default is 12.\n      `mode` is the aggregation mode for numeric summaries (sum, min, max, alwaysone). Default is sum. ", examples="\n    Examples:\n      > SELECT tuple_sketch_estimate_double(_FUNC_(key, summary, 12, 'sum')) FROM VALUES (1, 5.0D), (1, 1.0D), (2, 2.0D), (2, 3.0D), (3, 2.2D) tab(key, summary);\n       3.0\n  ", group="agg_funcs", since="4.2.0")
public final class TupleSketchAggDoubleExpressionBuilder$
implements ExpressionBuilder {
    public static final TupleSketchAggDoubleExpressionBuilder$ MODULE$ = new TupleSketchAggDoubleExpressionBuilder$();
    private static final FunctionSignature defaultFunctionSignature;

    static {
        FunctionBuilderBase.$init$(MODULE$);
        defaultFunctionSignature = new FunctionSignature((Seq<InputParameter>)new .colon.colon((Object)new InputParameter("key", InputParameter$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new InputParameter("summary", InputParameter$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new InputParameter("lgNomEntries", (Option<Expression>)new Some((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)12)))), (List)new .colon.colon((Object)new InputParameter("mode", (Option<Expression>)new Some((Object)Literal$.MODULE$.apply(TupleSummaryMode$Sum$.MODULE$.toString()))), (List)Nil$.MODULE$)))));
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName, resolver);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    public final FunctionSignature defaultFunctionSignature() {
        return defaultFunctionSignature;
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return new Some((Object)this.defaultFunctionSignature());
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        Predef$.MODULE$.assert(expressions.size() == 4);
        return new TupleSketchAggDouble((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (Expression)expressions.apply(3));
    }

    private TupleSketchAggDoubleExpressionBuilder$() {
    }
}

