/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.util.Geo;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;
import org.apache.spark.sql.catalyst.util.geo.WkbReader;
import org.apache.spark.sql.catalyst.util.geo.WkbWriter;
import org.apache.spark.unsafe.types.GeometryVal;

public final class Geometry
implements Geo {
    protected final GeometryVal value;
    public static int DEFAULT_SRID = 0;

    private Geometry(byte[] bytes) {
        this.value = GeometryVal.fromBytes((byte[])bytes);
    }

    private Geometry(GeometryVal value) {
        this.value = value;
    }

    public static Geometry fromBytes(byte[] bytes) {
        return new Geometry(bytes);
    }

    public static Geometry fromValue(GeometryVal value) {
        return new Geometry(value);
    }

    public GeometryVal getValue() {
        return this.value;
    }

    public byte[] getBytes() {
        return this.value.getBytes();
    }

    public Geometry copy() {
        byte[] bytes = this.getBytes();
        return Geometry.fromBytes(Arrays.copyOf(bytes, bytes.length));
    }

    public static Geometry fromWkb(byte[] wkb, int srid) {
        WkbReader reader = new WkbReader();
        reader.read(wkb);
        byte[] bytes = new byte[4 + wkb.length];
        ByteBuffer.wrap(bytes).order(DEFAULT_ENDIANNESS).putInt(srid);
        System.arraycopy(wkb, 0, bytes, 4, wkb.length);
        return Geometry.fromBytes(bytes);
    }

    public static Geometry fromWkb(byte[] wkb) {
        return Geometry.fromWkb(wkb, DEFAULT_SRID);
    }

    public static Geometry fromEwkb(byte[] ewkb) {
        throw new UnsupportedOperationException("Geometry EWKB parsing is not yet supported.");
    }

    public static Geometry fromWkt(byte[] wkt, int srid) {
        throw new UnsupportedOperationException("Geometry WKT parsing is not yet supported.");
    }

    public static Geometry fromWkt(byte[] wkt) {
        return Geometry.fromWkt(wkt, DEFAULT_SRID);
    }

    public static Geometry fromEwkt(byte[] ewkt) {
        throw new UnsupportedOperationException("Geometry EWKT parsing is not yet supported.");
    }

    @Override
    public byte[] toWkb() {
        return this.toWkbInternal(DEFAULT_ENDIANNESS);
    }

    @Override
    public byte[] toWkb(ByteOrder endianness) {
        return this.toWkbInternal(endianness);
    }

    private byte[] toWkbInternal(ByteOrder endianness) {
        WkbReader reader = new WkbReader();
        GeometryModel model = reader.read(Arrays.copyOfRange(this.getBytes(), 4, this.getBytes().length));
        WkbWriter writer = new WkbWriter();
        return writer.write(model, endianness);
    }

    @Override
    public byte[] toEwkb() {
        throw new UnsupportedOperationException("Geometry EWKB conversion is not yet supported.");
    }

    @Override
    public byte[] toEwkb(ByteOrder endianness) {
        throw new UnsupportedOperationException("Geometry EWKB endianness is not yet supported.");
    }

    @Override
    public byte[] toWkt() {
        throw new UnsupportedOperationException("Geometry WKT conversion is not yet supported.");
    }

    @Override
    public byte[] toEwkt() {
        throw new UnsupportedOperationException("Geometry EWKT conversion is not yet supported.");
    }

    @Override
    public int srid() {
        return this.getWrapper().getInt(0);
    }

    @Override
    public void setSrid(int srid) {
        this.getWrapper().putInt(0, srid);
    }

    private ByteBuffer getWrapper() {
        return ByteBuffer.wrap(this.getBytes()).order(DEFAULT_ENDIANNESS);
    }
}

