/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.expressions.Expression;

@Evolving
public class DefaultValue {
    private final String sql;
    private final Expression expr;

    public DefaultValue(String sql2) {
        this(sql2, null);
    }

    public DefaultValue(Expression expr) {
        this(null, expr);
    }

    public DefaultValue(String sql2, Expression expr) {
        if (sql2 == null && expr == null) {
            throw new SparkIllegalArgumentException("INTERNAL_ERROR", Map.of("message", "SQL and expression can't be both null"));
        }
        this.sql = sql2;
        this.expr = expr;
    }

    @Nullable
    public String getSql() {
        return this.sql;
    }

    @Nullable
    public Expression getExpression() {
        return this.expr;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DefaultValue that = (DefaultValue)other;
        return Objects.equals(this.sql, that.sql) && Objects.equals(this.expr, that.expr);
    }

    public int hashCode() {
        return Objects.hash(this.sql, this.expr);
    }

    public String toString() {
        return String.format("DefaultValue{sql=%s, expression=%s}", this.sql, this.expr);
    }
}

