/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.Configuration;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.InternalConfiguration;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveRegistry;
import com.google.crypto.tink.jwt.JsonUtil;
import com.google.crypto.tink.jwt.JwtEcdsaParameters;
import com.google.crypto.tink.jwt.JwtEcdsaPrivateKey;
import com.google.crypto.tink.jwt.JwtEcdsaPublicKey;
import com.google.crypto.tink.jwt.JwtFormat;
import com.google.crypto.tink.jwt.JwtPublicKeySign;
import com.google.crypto.tink.jwt.JwtPublicKeySignWrapper;
import com.google.crypto.tink.jwt.JwtPublicKeyVerify;
import com.google.crypto.tink.jwt.JwtPublicKeyVerifyWrapper;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.signature.EcdsaParameters;
import com.google.crypto.tink.signature.EcdsaPrivateKey;
import com.google.crypto.tink.signature.EcdsaPublicKey;
import com.google.crypto.tink.subtle.EcdsaSignJce;
import com.google.crypto.tink.subtle.EcdsaVerifyJce;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;

class JwtSignatureConfigurationV0 {
    private static final InternalConfiguration INTERNAL_CONFIGURATION = JwtSignatureConfigurationV0.create();
    private static final TinkFipsUtil.AlgorithmFipsCompatibility FIPS = TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;

    private JwtSignatureConfigurationV0() {
    }

    private static InternalConfiguration create() {
        try {
            PrimitiveRegistry.Builder builder = PrimitiveRegistry.builder();
            JwtPublicKeySignWrapper.registerToInternalPrimitiveRegistry(builder);
            builder.registerPrimitiveConstructor(PrimitiveConstructor.create(JwtSignatureConfigurationV0::createJwtEcdsaSign, JwtEcdsaPrivateKey.class, JwtPublicKeySign.class));
            JwtPublicKeyVerifyWrapper.registerToInternalPrimitiveRegistry(builder);
            builder.registerPrimitiveConstructor(PrimitiveConstructor.create(JwtSignatureConfigurationV0::createJwtEcdsaVerify, JwtEcdsaPublicKey.class, JwtPublicKeyVerify.class));
            return InternalConfiguration.createFromPrimitiveRegistry(builder.build());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static EcdsaParameters.CurveType getCurveType(JwtEcdsaParameters parameters) throws GeneralSecurityException {
        if (parameters.getAlgorithm().equals(JwtEcdsaParameters.Algorithm.ES256)) {
            return EcdsaParameters.CurveType.NIST_P256;
        }
        if (parameters.getAlgorithm().equals(JwtEcdsaParameters.Algorithm.ES384)) {
            return EcdsaParameters.CurveType.NIST_P384;
        }
        if (parameters.getAlgorithm().equals(JwtEcdsaParameters.Algorithm.ES512)) {
            return EcdsaParameters.CurveType.NIST_P521;
        }
        throw new GeneralSecurityException("unknown algorithm in parameters: " + parameters);
    }

    private static EcdsaParameters.HashType getHash(JwtEcdsaParameters parameters) throws GeneralSecurityException {
        if (parameters.getAlgorithm().equals(JwtEcdsaParameters.Algorithm.ES256)) {
            return EcdsaParameters.HashType.SHA256;
        }
        if (parameters.getAlgorithm().equals(JwtEcdsaParameters.Algorithm.ES384)) {
            return EcdsaParameters.HashType.SHA384;
        }
        if (parameters.getAlgorithm().equals(JwtEcdsaParameters.Algorithm.ES512)) {
            return EcdsaParameters.HashType.SHA512;
        }
        throw new GeneralSecurityException("unknown algorithm in parameters: " + parameters);
    }

    @AccessesPartialKey
    private static EcdsaPublicKey toEcdsaPublicKey(JwtEcdsaPublicKey publicKey) throws GeneralSecurityException {
        EcdsaParameters ecdsaParameters = EcdsaParameters.builder().setSignatureEncoding(EcdsaParameters.SignatureEncoding.IEEE_P1363).setCurveType(JwtSignatureConfigurationV0.getCurveType(publicKey.getParameters())).setHashType(JwtSignatureConfigurationV0.getHash(publicKey.getParameters())).build();
        return EcdsaPublicKey.builder().setParameters(ecdsaParameters).setPublicPoint(publicKey.getPublicPoint()).build();
    }

    @AccessesPartialKey
    private static EcdsaPrivateKey toEcdsaPrivateKey(JwtEcdsaPrivateKey privateKey) throws GeneralSecurityException {
        return EcdsaPrivateKey.builder().setPublicKey(JwtSignatureConfigurationV0.toEcdsaPublicKey(privateKey.getPublicKey())).setPrivateValue(privateKey.getPrivateValue()).build();
    }

    private static JwtPublicKeySign createJwtEcdsaSign(JwtEcdsaPrivateKey privateKey) throws GeneralSecurityException {
        EcdsaPrivateKey ecdsaPrivateKey = JwtSignatureConfigurationV0.toEcdsaPrivateKey(privateKey);
        PublicKeySign signer = EcdsaSignJce.create(ecdsaPrivateKey);
        String algorithm = privateKey.getParameters().getAlgorithm().getStandardName();
        return rawJwt -> {
            String unsignedCompact = JwtFormat.createUnsignedCompact(algorithm, privateKey.getPublicKey().getKid(), rawJwt);
            return JwtFormat.createSignedCompact(unsignedCompact, signer.sign(unsignedCompact.getBytes(StandardCharsets.US_ASCII)));
        };
    }

    private static JwtPublicKeyVerify createJwtEcdsaVerify(JwtEcdsaPublicKey publicKey) throws GeneralSecurityException {
        EcdsaPublicKey ecdsaPublicKey = JwtSignatureConfigurationV0.toEcdsaPublicKey(publicKey);
        PublicKeyVerify verifier = EcdsaVerifyJce.create(ecdsaPublicKey);
        return (compact, validator) -> {
            JwtFormat.Parts parts = JwtFormat.splitSignedCompact(compact);
            verifier.verify(parts.signatureOrMac, parts.unsignedCompact.getBytes(StandardCharsets.US_ASCII));
            JsonObject parsedHeader = JsonUtil.parseJson(parts.header);
            JwtFormat.validateHeader(parsedHeader, publicKey.getParameters().getAlgorithm().getStandardName(), publicKey.getKid(), publicKey.getParameters().allowKidAbsent());
            RawJwt token = RawJwt.fromJsonPayload(JwtFormat.getTypeHeader(parsedHeader), parts.payload);
            return validator.validate(token);
        };
    }

    public static Configuration get() throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Cannot use JwtSignatureConfigurationV0, as BoringCrypto module is needed for FIPS compatibility");
        }
        return INTERNAL_CONFIGURATION;
    }
}

