/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.json.JsonToStructsEvaluator;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n      > SELECT _FUNC_('{\"teacher\": \"Alice\", \"student\": [{\"name\": \"Bob\", \"rank\": 1}, {\"name\": \"Charlie\", \"rank\": 2}]}', 'STRUCT<teacher: STRING, student: ARRAY<STRUCT<name: STRING, rank: INT>>>');\n       {\"teacher\":\"Alice\",\"student\":[{\"name\":\"Bob\",\"rank\":1},{\"name\":\"Charlie\",\"rank\":2}]}\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\tEg\u0001B\u001b7\u0001\u000eC\u0001\u0002\u001c\u0001\u0003\u0016\u0004%\t!\u001c\u0005\ti\u0002\u0011\t\u0012)A\u0005]\"AQ\u000f\u0001BK\u0002\u0013\u0005a\u000fC\u0005\u0002\u0006\u0001\u0011\t\u0012)A\u0005o\"Q\u0011q\u0001\u0001\u0003\u0016\u0004%\t!!\u0003\t\u0015\u0005E\u0001A!E!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0014\u0001\u0011)\u001a!C\u0001\u0003+A!\"!\b\u0001\u0005#\u0005\u000b\u0011BA\f\u0011)\ty\u0002\u0001BK\u0002\u0013\u0005\u0011\u0011\u0005\u0005\u000b\u0003S\u0001!\u0011#Q\u0001\n\u0005\r\u0002bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\t\u0003w\u0001!\u0019!C\u0005[\"9\u0011Q\b\u0001!\u0002\u0013q\u0007bBA \u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003\u0003\u0002AQIA\"\u0011\u001d\t)\b\u0001C!\u0003CAq!a\u000b\u0001\t\u0003\t9\bC\u0004\u0002,\u0001!\t!a \t\u000f\u0005-\u0002\u0001\"\u0001\u0002\u0006\"9\u0011Q\u0012\u0001\u0005B\u0005=\u0005BBAO\u0001\u0011\u0005S\u000eC\u0004\u0002 \u0002!\t%!)\t\u0015\u0005\u0015\u0006\u0001#b\u0001\n\u0013\t9\u000b\u0003\u0006\u00022\u0002A)\u0019!C\u0005\u0003gCq!a1\u0001\t\u0003\n)\rC\u0004\u0002P\u0002!\t%!5\t\rm\u0002A\u0011IAT\u0011\u001d\tY\u000e\u0001C!\u0003OCq!!8\u0001\t#\ny\u000eC\u0005\u0002f\u0002\t\t\u0011\"\u0001\u0002h\"I\u00111\u001f\u0001\u0012\u0002\u0013\u0005\u0011Q\u001f\u0005\n\u0005\u0017\u0001\u0011\u0013!C\u0001\u0005\u001bA\u0011B!\u0005\u0001#\u0003%\tAa\u0005\t\u0013\t]\u0001!%A\u0005\u0002\te\u0001\"\u0003B\u000f\u0001E\u0005I\u0011\u0001B\u0010\u0011%\u0011\u0019\u0003AA\u0001\n\u0003\u0012)\u0003C\u0005\u00036\u0001\t\t\u0011\"\u0001\u00038!I!q\b\u0001\u0002\u0002\u0013\u0005!\u0011\t\u0005\n\u0005\u000f\u0002\u0011\u0011!C!\u0005\u0013B\u0011Ba\u0016\u0001\u0003\u0003%\tA!\u0017\t\u0013\tu\u0003!!A\u0005B\t}\u0003\"\u0003B2\u0001\u0005\u0005I\u0011\tB3\u000f\u001d\u0011II\u000eE\u0001\u0005\u00173a!\u000e\u001c\t\u0002\t5\u0005bBA\u0016Y\u0011\u0005!q\u0014\u0005\b\u0005CcC\u0011\u0001BR\u0011%\u0011\t\fLA\u0001\n\u0003\u0013\u0019\fC\u0005\u0003@2\n\n\u0011\"\u0001\u0003\u001a!I!\u0011\u0019\u0017\u0012\u0002\u0013\u0005!q\u0004\u0005\n\u0005\u0007d\u0013\u0013!C\u0001\u00053A\u0011B!2-#\u0003%\tAa\b\t\u0013\t\u001dG&!A\u0005\n\t%'!\u0004&t_:$vn\u0015;sk\u000e$8O\u0003\u00028q\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tI$(\u0001\u0005dCR\fG._:u\u0015\tYD(A\u0002tc2T!!\u0010 \u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\u0002\u0001'!\u0001A\tS&R)j\u0003\u0007CA#G\u001b\u00051\u0014BA$7\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA#J\u0013\tQeGA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011AjT\u0007\u0002\u001b*\u0011aJN\u0001\bG>$WmZ3o\u0013\t\u0001VJA\bD_\u0012,w-\u001a8GC2d'-Y2l!\t)%+\u0003\u0002Tm\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005UCV\"\u0001,\u000b\u0005]S\u0014AB3se>\u00148/\u0003\u0002Z-\ny\u0011+^3ss\u0016\u0013(o\u001c:t\u0005\u0006\u001cX\r\u0005\u0002\\=6\tALC\u0001^\u0003\u0015\u00198-\u00197b\u0013\tyFLA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005LgB\u00012h\u001d\t\u0019g-D\u0001e\u0015\t)')\u0001\u0004=e>|GOP\u0005\u0002;&\u0011\u0001\u000eX\u0001\ba\u0006\u001c7.Y4f\u0013\tQ7N\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002i9\u000611o\u00195f[\u0006,\u0012A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cj\nQ\u0001^=qKNL!a\u001d9\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fqa]2iK6\f\u0007%A\u0004paRLwN\\:\u0016\u0003]\u0004B\u0001\u001f?\u0000\u007f:\u0011\u0011P\u001f\t\u0003GrK!a\u001f/\u0002\rA\u0013X\rZ3g\u0013\tihPA\u0002NCBT!a\u001f/\u0011\u0007a\f\t!C\u0002\u0002\u0004y\u0014aa\u0015;sS:<\u0017\u0001C8qi&|gn\u001d\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0005\u0005-\u0001cA#\u0002\u000e%\u0019\u0011q\u0002\u001c\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u000bi&lWMW8oK&#WCAA\f!\u0011Y\u0016\u0011D@\n\u0007\u0005mAL\u0001\u0004PaRLwN\\\u0001\fi&lWMW8oK&#\u0007%A\rwCJL\u0017M\u001c;BY2|w\u000fR;qY&\u001c\u0017\r^3LKf\u001cXCAA\u0012!\rY\u0016QE\u0005\u0004\u0003Oa&a\u0002\"p_2,\u0017M\\\u0001\u001bm\u0006\u0014\u0018.\u00198u\u00032dwn\u001e#va2L7-\u0019;f\u0017\u0016L8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005=\u0012\u0011GA\u001a\u0003k\t9$!\u000f\u0011\u0005\u0015\u0003\u0001\"\u00027\f\u0001\u0004q\u0007\"B;\f\u0001\u00049\bbBA\u0004\u0017\u0001\u0007\u00111\u0002\u0005\n\u0003'Y\u0001\u0013!a\u0001\u0003/A\u0011\"a\b\f!\u0003\u0005\r!a\t\u0002\u001d9,H\u000e\\1cY\u0016\u001c6\r[3nC\u0006ya.\u001e7mC\ndWmU2iK6\f\u0007%\u0001\u0005ok2d\u0017M\u00197f\u0003Qqw\u000eZ3QCR$XM\u001d8t\u0013:$XM\u001d8bYR\u0011\u0011Q\t\t\u0006C\u0006\u001d\u00131J\u0005\u0004\u0003\u0013Z'aA*fcB!\u0011QJA8\u001d\u0011\ty%!\u001b\u000f\t\u0005E\u0013Q\r\b\u0005\u0003'\n\u0019G\u0004\u0003\u0002V\u0005\u0005d\u0002BA,\u0003?rA!!\u0017\u0002^9\u00191-a\u0017\n\u0003\u0005K!a\u0010!\n\u0005ur\u0014BA\u001e=\u0013\tI$(C\u0002\u0002ha\nQ\u0001\u001e:fKNLA!a\u001b\u0002n\u0005YAK]3f!\u0006$H/\u001a:o\u0015\r\t9\u0007O\u0005\u0005\u0003c\n\u0019HA\u0006Ue\u0016,\u0007+\u0019;uKJt'\u0002BA6\u0003[\naB\\;mY&sGo\u001c7fe\u0006tG\u000f\u0006\u0005\u00020\u0005e\u00141PA?\u0011\u001d\t9!\u0005a\u0001\u0003\u0017Aa\u0001\\\tA\u0002\u0005-\u0001\"B;\u0012\u0001\u00049HCBA\u0018\u0003\u0003\u000b\u0019\tC\u0004\u0002\bI\u0001\r!a\u0003\t\r1\u0014\u0002\u0019AA\u0006)!\ty#a\"\u0002\n\u0006-\u0005bBA\u0004'\u0001\u0007\u00111\u0002\u0005\u0007YN\u0001\r!a\u0003\t\rU\u001c\u0002\u0019AA\u0006\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\t\n\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9\nO\u0001\tC:\fG._:jg&!\u00111TAK\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0007!\u000b\u0019\u000b\u0003\u0004\u0002\u0014Y\u0001\ra`\u0001\u0014]\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000fZ\u000b\u0002\u007f\"\u001aq#a+\u0011\u0007m\u000bi+C\u0002\u00020r\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0013\u00154\u0018\r\\;bi>\u0014XCAA[!\u0011\t9,!0\u000e\u0005\u0005e&bAA^m\u0005!!n]8o\u0013\u0011\ty,!/\u0003-)\u001bxN\u001c+p'R\u0014Xo\u0019;t\u000bZ\fG.^1u_JD3\u0001GAV\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\t9-!4\u0011\u0007m\u000bI-C\u0002\u0002Lr\u00131!\u00118z\u0011\u001d\tY,\u0007a\u0001\u0003\u000f\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t\u0019\u000eE\u0003b\u0003\u000f\n)\u000eE\u0002p\u0003/L1!!7q\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dG\u0003BA\u0018\u0003CDq!a9\u001e\u0001\u0004\tY!\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0019\u0005=\u0012\u0011^Av\u0003[\fy/!=\t\u000f1t\u0002\u0013!a\u0001]\"9QO\bI\u0001\u0002\u00049\b\"CA\u0004=A\u0005\t\u0019AA\u0006\u0011%\t\u0019B\bI\u0001\u0002\u0004\t9\u0002C\u0005\u0002 y\u0001\n\u00111\u0001\u0002$\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA|U\rq\u0017\u0011`\u0016\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!A\u0005v]\u000eDWmY6fI*\u0019!Q\u0001/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\n\u0005}(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\bU\r9\u0018\u0011`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)B\u000b\u0003\u0002\f\u0005e\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u00057QC!a\u0006\u0002z\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001B\u0011U\u0011\t\u0019#!?\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u0003\u0005\u0003\u0003*\tMRB\u0001B\u0016\u0015\u0011\u0011iCa\f\u0002\t1\fgn\u001a\u0006\u0003\u0005c\tAA[1wC&!\u00111\u0001B\u0016\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011I\u0004E\u0002\\\u0005wI1A!\u0010]\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9Ma\u0011\t\u0013\t\u0015c%!AA\u0002\te\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003LA1!Q\nB*\u0003\u000fl!Aa\u0014\u000b\u0007\tEC,\u0001\u0006d_2dWm\u0019;j_:LAA!\u0016\u0003P\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019Ca\u0017\t\u0013\t\u0015\u0003&!AA\u0002\u0005\u001d\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BAa\n\u0003b!I!QI\u0015\u0002\u0002\u0003\u0007!\u0011H\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\"q\r\u0005\n\u0005\u000bR\u0013\u0011!a\u0001\u0003\u000fD3\u0003\u0001B6\u0005c\u0012\u0019Ha\u001e\u0003z\tu$q\u0010BB\u0005\u000b\u00032!\u0012B7\u0013\r\u0011yG\u000e\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011)(\u00012`\rVs5i\u0018\u0015kg>t7\u000b\u001e:-AM\u001c\u0007.Z7b72\u0002s\u000e\u001d;j_:\u001cX,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007e\u001d;sk\u000e$\bE^1mk\u0016\u0004s/\u001b;iAQDW\rI4jm\u0016t\u0007\u0005\u00196t_:\u001cFO\u001d1!C:$\u0007\u0005Y:dQ\u0016l\u0017\r\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\u001f\u0002\tGQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#C\nR\u0014\u0007\f\u0011#E\nR\u0004G\f\u001d~O1\u0002s%\u0019\u0011J\u001dRc\u0003E\u0019\u0011E\u001fV\u0013E*R\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;c1\u0012#M\t\u001e1]aj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014|EQLW.\u001a\u0012;EI2t\u0006\r\u001d0eA\nTGI?(Y\u0001:C/[7fAQKW.Z:uC6\u0004x\u0005\f\u0011nCBDs\u0005^5nKN$\u0018-\u001c9G_Jl\u0017\r^\u0014-A\u001d\"GmL'N_eL\u00180_\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u00023P\t;j[\u0016\u0014#H\r\u00192k5\u0002\u0004(\f\u001a7AA\u0002$\b\r\u0019;aAj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014|EQ,\u0017m\u00195fe\nR\u0004EI!mS\u000e,'\u0005\f\u0011#gR,H-\u001a8uEi\u00023l\u001f\u0012oC6,'E\u000f\u0011#\u0005>\u0014'\u0005\f\u0011#e\u0006t7N\t\u001e!cud\u0003e\u001f\u0012oC6,'E\u000f\u0011#\u0007\"\f'\u000f\\5fE1\u0002#E]1oW\nR\u0004EM?^{\u001eb\u0003eJ*U%V\u001bE\u000b\u0010;fC\u000eDWM\u001d\u001e!'R\u0013\u0016JT$-AM$X\u000fZ3oij\u0002\u0013I\u0015*B3r\u001aFKU+D)rr\u0017-\\3;AM#&+\u0013(HY\u0001\u0012\u0018M\\6;A%sEK\u0010 ?O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uK\u0006\u001c\u0007.\u001a:#u\t\nE.[2fE1\u00123\u000f^;eK:$(EO.|E9\fW.\u001a\u0012;E\t{'M\t\u0017#e\u0006t7N\t\u001e2{2Z(E\\1nK\nR$e\u00115be2LWM\t\u0017#e\u0006t7N\t\u001e3{vk(\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\u0005\u0015A\u00036t_:|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!qQ\u0001\u0006e9\u0012d\u0006M\u0001\u000e\u0015N|g\u000eV8TiJ,8\r^:\u0011\u0005\u0015c3#\u0002\u0017\u0003\u0010\nU\u0005cA.\u0003\u0012&\u0019!1\u0013/\u0003\r\u0005s\u0017PU3g!\u0011\u00119J!(\u000e\u0005\te%\u0002\u0002BN\u0005_\t!![8\n\u0007)\u0014I\n\u0006\u0002\u0003\f\u00069QO\\1qa2LH\u0003\u0002BS\u0005[\u0003RaWA\r\u0005O\u0003\u0012b\u0017BU]^\fY!a\u0006\n\u0007\t-FL\u0001\u0004UkBdW\r\u000e\u0005\b\u0005_s\u0003\u0019AA\u0018\u0003\u0005Q\u0017!B1qa2LH\u0003DA\u0018\u0005k\u00139L!/\u0003<\nu\u0006\"\u000270\u0001\u0004q\u0007\"B;0\u0001\u00049\bbBA\u0004_\u0001\u0007\u00111\u0002\u0005\n\u0003'y\u0003\u0013!a\u0001\u0003/A\u0011\"a\b0!\u0003\u0005\r!a\t\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\r\u0005\u0003\u0003*\t5\u0017\u0002\u0002Bh\u0005W\u0011aa\u00142kK\u000e$\b")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
QueryErrorsBase,
Serializable {
    private transient String nameOfCorruptRecord;
    private transient JsonToStructsEvaluator evaluator;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final boolean variantAllowDuplicateKeys;
    private final DataType nullableSchema;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean apply$default$5() {
        return JsonToStructs$.MODULE$.apply$default$5();
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs j) {
        return JsonToStructs$.MODULE$.unapply(j);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean variantAllowDuplicateKeys() {
        return this.variantAllowDuplicateKeys;
    }

    private DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.JSON_TO_STRUCT(), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        if (dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof VariantType))) {
            TypeCheckResult checkResult = ExprUtils$.MODULE$.checkJsonSchema(this.nullableSchema());
            if (checkResult.isFailure()) {
                return checkResult;
            }
            return ExpectsInputTypes.checkInputDataTypes$(this);
        }
        return new TypeCheckResult.DataTypeMismatch("INVALID_JSON_SCHEMA", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)this.nullableSchema()))}))));
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        boolean x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1, x$5);
    }

    private String nameOfCorruptRecord$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.nameOfCorruptRecord;
    }

    private String nameOfCorruptRecord() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.nameOfCorruptRecord$lzycompute();
        }
        return this.nameOfCorruptRecord;
    }

    private JsonToStructsEvaluator evaluator$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.evaluator = new JsonToStructsEvaluator(this.options(), this.nullableSchema(), this.nameOfCorruptRecord(), this.timeZoneId(), this.variantAllowDuplicateKeys());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.evaluator;
    }

    private JsonToStructsEvaluator evaluator() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.evaluator$lzycompute();
        }
        return this.evaluator;
    }

    @Override
    public Object nullSafeEval(Object json) {
        return this.evaluator().evaluate((UTF8String)json);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringTypeWithCollation stringTypeWithCollation = StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)stringTypeWithCollation);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        if (dataType instanceof MapType) {
            return "entries";
        }
        return super.sql();
    }

    @Override
    public String prettyName() {
        return "from_json";
    }

    @Override
    public JsonToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        boolean x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$1, x$4, x$5);
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, boolean variantAllowDuplicateKeys) {
        return new JsonToStructs(schema, options, child, timeZoneId, variantAllowDuplicateKeys);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    public boolean copy$default$5() {
        return this.variantAllowDuplicateKeys();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.schema();
            }
            case 1: {
                return this.options();
            }
            case 2: {
                return this.child();
            }
            case 3: {
                return this.timeZoneId();
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this.variantAllowDuplicateKeys());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "schema";
            }
            case 1: {
                return "options";
            }
            case 2: {
                return "child";
            }
            case 3: {
                return "timeZoneId";
            }
            case 4: {
                return "variantAllowDuplicateKeys";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        if (this.variantAllowDuplicateKeys() != jsonToStructs.variantAllowDuplicateKeys()) return false;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId, boolean variantAllowDuplicateKeys) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        this.variantAllowDuplicateKeys = variantAllowDuplicateKeys;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nullableSchema = schema.asNullable();
        Statics.releaseFence();
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$, JsonToStructs$.MODULE$.$lessinit$greater$default$5());
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$, JsonToStructs$.MODULE$.$lessinit$greater$default$5());
    }
}

