/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.VectorSum$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array) - Returns the element-wise sum of float vectors in a group.\n    All vectors must have the same dimension.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (array(1.0F, 2.0F)), (array(3.0F, 4.0F)) AS tab(col);\n       [4.0,6.0]\n  ", since="4.2.0", group="vector_funcs")
@ScalaSignature(bytes="\u0006\u0005\t=e\u0001\u0002\u001b6\u0001\nC\u0001b\u001b\u0001\u0003\u0016\u0004%\t\u0001\u001c\u0005\t[\u0002\u0011\t\u0012)A\u0005\u001f\"Aa\u000e\u0001BK\u0002\u0013\u0005q\u000e\u0003\u0005t\u0001\tE\t\u0015!\u0003q\u0011!!\bA!f\u0001\n\u0003y\u0007\u0002C;\u0001\u0005#\u0005\u000b\u0011\u00029\t\u000bY\u0004A\u0011A<\t\u000bY\u0004A\u0011\u0001?\t\u000by\u0004A\u0011I@\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u00111\u0004\u0001\u0005B\u0005u\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\u000b\u0003w\u0001\u0001R1A\u0005\n\u0005u\u0002BCA#\u0001!\u0015\r\u0011\"\u0003\u0002>!9\u0011q\t\u0001\u0005B\u0005%\u0003bBA)\u0001\u0011\u0005\u00131\u000b\u0005\u000b\u00037\u0002\u0001R1A\u0005B\u0005%\u0003\u0002CA/\u0001\t\u0007I\u0011B8\t\u000f\u0005}\u0003\u0001)A\u0005a\"A\u0011\u0011\r\u0001C\u0002\u0013%q\u000eC\u0004\u0002d\u0001\u0001\u000b\u0011\u00029\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004BCA;\u0001!\u0015\r\u0011\"\u0003\u0002\u0014!9\u0011q\u000f\u0001\u0005B\u0005e\u0004bBAG\u0001\u0011\u0005\u0013q\u0012\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\t\t\u000b\u0001C!\u0003GCq!!,\u0001\t#\ny\u000bC\u0005\u00026\u0002\t\t\u0011\"\u0001\u00028\"I\u0011q\u0018\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0019\u0005\n\u0003/\u0004\u0011\u0013!C\u0001\u00033D\u0011\"!8\u0001#\u0003%\t!!7\t\u0013\u0005}\u0007!!A\u0005B\u0005\u0005\b\u0002CAy\u0001\u0005\u0005I\u0011A8\t\u0013\u0005M\b!!A\u0005\u0002\u0005U\b\"CA~\u0001\u0005\u0005I\u0011IA\u007f\u0011%\u0011Y\u0001AA\u0001\n\u0003\u0011i\u0001C\u0005\u0003\u0012\u0001\t\t\u0011\"\u0011\u0003\u0014!I!q\u0003\u0001\u0002\u0002\u0013\u0005#\u0011D\u0004\n\u0005{)\u0014\u0011!E\u0001\u0005\u007f1\u0001\u0002N\u001b\u0002\u0002#\u0005!\u0011\t\u0005\u0007m*\"\tA!\u0017\t\u0013\tm#&!A\u0005F\tu\u0003\"\u0003B0U\u0005\u0005I\u0011\u0011B1\u0011%\u0011IGKI\u0001\n\u0003\tI\u000eC\u0005\u0003l)\n\n\u0011\"\u0001\u0002Z\"I!Q\u000e\u0016\u0002\u0002\u0013\u0005%q\u000e\u0005\n\u0005\u0003S\u0013\u0013!C\u0001\u00033D\u0011Ba!+#\u0003%\t!!7\t\u0013\t\u0015%&!A\u0005\n\t\u001d%!\u0003,fGR|'oU;n\u0015\t1t'A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u001d:\u0003!\u0019\u0017\r^1msN$(B\u0001\u001e<\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003yu\nQa\u001d9be.T!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO\u000e\u00011C\u0002\u0001D\u0013NKv\f\u0005\u0002E\u000f6\tQI\u0003\u0002Gk\u0005I\u0011mZ4sK\u001e\fG/Z\u0005\u0003\u0011\u0016\u00131#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u00042AS'P\u001b\u0005Y%B\u0001'8\u0003\u0015!(/Z3t\u0013\tq5JA\u0005V]\u0006\u0014\u0018\u0010T5lKB\u0011\u0001+U\u0007\u0002k%\u0011!+\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001+X\u001b\u0005)&B\u0001,:\u0003\u0019)'O]8sg&\u0011\u0001,\u0016\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011!,X\u0007\u00027*\tA,A\u0003tG\u0006d\u0017-\u0003\u0002_7\n9\u0001K]8ek\u000e$\bC\u00011i\u001d\t\tgM\u0004\u0002cK6\t1M\u0003\u0002e\u0003\u00061AH]8pizJ\u0011\u0001X\u0005\u0003On\u000bq\u0001]1dW\u0006<W-\u0003\u0002jU\na1+\u001a:jC2L'0\u00192mK*\u0011qmW\u0001\u0006G\"LG\u000eZ\u000b\u0002\u001f\u000611\r[5mI\u0002\na#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u000b\u0002aB\u0011!,]\u0005\u0003en\u00131!\u00138u\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003\u0019a\u0014N\\5u}Q!\u00010\u001f>|!\t\u0001\u0006\u0001C\u0003l\u000f\u0001\u0007q\nC\u0004o\u000fA\u0005\t\u0019\u00019\t\u000fQ<\u0001\u0013!a\u0001aR\u0011\u00010 \u0005\u0006W\"\u0001\raT\u0001\u000baJ,G\u000f^=OC6,WCAA\u0001!\u0011\t\u0019!a\u0003\u000f\t\u0005\u0015\u0011q\u0001\t\u0003EnK1!!\u0003\\\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\b\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011B.\u0002\u00119,H\u000e\\1cY\u0016,\"!!\u0006\u0011\u0007i\u000b9\"C\u0002\u0002\u001am\u0013qAQ8pY\u0016\fg.\u0001\u0005eCR\fG+\u001f9f+\t\ty\u0002\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)#O\u0001\u0006if\u0004Xm]\u0005\u0005\u0003S\t\u0019C\u0001\u0005ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)dN\u0001\tC:\fG._:jg&!\u0011\u0011HA\u001a\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018aB:v[\u0006#HO]\u000b\u0003\u0003\u007f\u00012\u0001UA!\u0013\r\t\u0019%\u000e\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW-A\u0004eS6\fE\u000f\u001e:\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0005\u0005-\u0003#\u00021\u0002N\u0005}\u0012bAA(U\n\u00191+Z9\u0002\u001f\u0005<wMQ;gM\u0016\u00148k\u00195f[\u0006,\"!!\u0016\u0011\t\u0005\u0005\u0012qK\u0005\u0005\u00033\n\u0019C\u0001\u0006TiJ,8\r\u001e+za\u0016\f\u0001$\u001b8qkR\fum\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3t\u0003!\u0019X/\\%oI\u0016D\u0018!C:v[&sG-\u001a=!\u0003!!\u0017.\\%oI\u0016D\u0018!\u00033j[&sG-\u001a=!\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$HcA\"\u0002j!1\u00111\u000e\fA\u0002A\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2aQA9\u0011\u0019\t\u0019h\u0006a\u0001a\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0012S:\u0004X\u000f^\"p]R\f\u0017N\\:Ok2d\u0017AC5oSRL\u0017\r\\5{KR!\u00111PAA!\rQ\u0016QP\u0005\u0004\u0003\u007fZ&\u0001B+oSRDq!a!\u001a\u0001\u0004\t))\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003\u000f\u000bI)D\u00018\u0013\r\tYi\u000e\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0003w\n\t*a%\t\u000f\u0005\r%\u00041\u0001\u0002\u0006\"9\u0011Q\u0013\u000eA\u0002\u0005\u0015\u0015!B5oaV$\u0018!B7fe\u001e,GCBA>\u00037\u000bi\nC\u0004\u0002\u0004n\u0001\r!!\"\t\u000f\u0005}5\u00041\u0001\u0002\u0006\u0006Y\u0011N\u001c9vi\n+hMZ3s\u0003\u0011)g/\u00197\u0015\t\u0005\u0015\u00161\u0016\t\u00045\u0006\u001d\u0016bAAU7\n\u0019\u0011I\\=\t\u0013\u0005\rE\u0004%AA\u0002\u0005\u0015\u0015\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002y\u0003cCa!a-\u001e\u0001\u0004y\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\bq\u0006e\u00161XA_\u0011\u001dYg\u0004%AA\u0002=CqA\u001c\u0010\u0011\u0002\u0003\u0007\u0001\u000fC\u0004u=A\u0005\t\u0019\u00019\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0019\u0016\u0004\u001f\u0006\u00157FAAd!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E7,\u0001\u0006b]:|G/\u0019;j_:LA!!6\u0002L\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001c\u0016\u0004a\u0006\u0015\u0017AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\b\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\u0005Y\u0006twM\u0003\u0002\u0002n\u0006!!.\u0019<b\u0013\u0011\ti!a:\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QUA|\u0011!\tI\u0010JA\u0001\u0002\u0004\u0001\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0000B1!\u0011\u0001B\u0004\u0003Kk!Aa\u0001\u000b\u0007\t\u00151,\u0001\u0006d_2dWm\u0019;j_:LAA!\u0003\u0003\u0004\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)Ba\u0004\t\u0013\u0005eh%!AA\u0002\u0005\u0015\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a9\u0003\u0016!A\u0011\u0011`\u0014\u0002\u0002\u0003\u0007\u0001/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003+\u0011Y\u0002C\u0005\u0002z\"\n\t\u00111\u0001\u0002&\"\u001a\u0002Aa\b\u0003&\t\u001d\"1\u0006B\u0017\u0005c\u0011\u0019Da\u000e\u0003:A\u0019\u0001K!\t\n\u0007\t\rRGA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t%\u0012a \u0006!A\u0001\u0002sLR+O\u0007~C\u0013M\u001d:bs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004S\r\\3nK:$Xf^5tK\u0002\u001aX/\u001c\u0011pM\u00022Gn\\1uAY,7\r^8sg\u0002Jg\u000eI1!OJ|W\u000f\u001d\u0018\u000bA\u0001\u0002\u0003%\u00117mAY,7\r^8sg\u0002jWo\u001d;!Q\u00064X\r\t;iK\u0002\u001a\u0018-\\3!I&lWM\\:j_:t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\f\u0002\u007f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)CJ\u0014\u0018-\u001f\u00152]A2E\u0006\t\u001a/a\u0019K\u0013\u0006\f\u0011)CJ\u0014\u0018-\u001f\u00154]A2E\u0006\t\u001b/a\u0019K\u0013\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u001b/a12d\u0006M/\u000bA\u0001\nQa]5oG\u0016\f#A!\u000e\u0002\u000bQr#G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tm\u0012\u0001\u0004<fGR|'o\u00184v]\u000e\u001c\u0018!\u0003,fGR|'oU;n!\t\u0001&fE\u0003+\u0005\u0007\u0012y\u0005\u0005\u0005\u0003F\t-s\n\u001d9y\u001b\t\u00119EC\u0002\u0003Jm\u000bqA];oi&lW-\u0003\u0003\u0003N\t\u001d#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!!\u0011\u000bB,\u001b\t\u0011\u0019F\u0003\u0003\u0003V\u0005-\u0018AA5p\u0013\rI'1\u000b\u000b\u0003\u0005\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003G\fQ!\u00199qYf$r\u0001\u001fB2\u0005K\u00129\u0007C\u0003l[\u0001\u0007q\nC\u0004o[A\u0005\t\u0019\u00019\t\u000fQl\u0003\u0013!a\u0001a\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BA!\u001d\u0003~A)!La\u001d\u0003x%\u0019!QO.\u0003\r=\u0003H/[8o!\u0019Q&\u0011P(qa&\u0019!1P.\u0003\rQ+\b\u000f\\34\u0011!\u0011y\bMA\u0001\u0002\u0004A\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BE!\u0011\t)Oa#\n\t\t5\u0015q\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class VectorSum
extends ImperativeAggregate
implements UnaryLike<Expression>,
QueryErrorsBase,
Serializable {
    private AttributeReference sumAttr;
    private AttributeReference dimAttr;
    private Seq<AttributeReference> inputAggBufferAttributes;
    private boolean inputContainsNull;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final int sumIndex;
    private final int dimIndex;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$3() {
        return VectorSum$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return VectorSum$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(VectorSum x$0) {
        return VectorSum$.MODULE$.unapply(x$0);
    }

    public static int apply$default$3() {
        return VectorSum$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return VectorSum$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, VectorSum> tupled() {
        return VectorSum$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, VectorSum>>> curried() {
        return VectorSum$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        VectorSum vectorSum = this;
        synchronized (vectorSum) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "vector_sum";
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType((DataType)FloatType$.MODULE$, false);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2 = this.child().dataType();
        if (dataType2 instanceof ArrayType && FloatType$.MODULE$.equals(dataType = (arrayType = (ArrayType)dataType2).elementType())) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$.apply((DataType)FloatType$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.child())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.child().dataType()))}))));
    }

    private AttributeReference sumAttr$lzycompute() {
        VectorSum vectorSum = this;
        synchronized (vectorSum) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String x$1 = "sum";
                BinaryType$ x$2 = BinaryType$.MODULE$;
                boolean x$3 = true;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("sum", (DataType)x$2, true, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("sum", (DataType)x$2, true, x$4);
                this.sumAttr = new AttributeReference("sum", (DataType)x$2, true, x$4, x$5, x$6);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sumAttr;
    }

    private AttributeReference sumAttr() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sumAttr$lzycompute();
        }
        return this.sumAttr;
    }

    private AttributeReference dimAttr$lzycompute() {
        VectorSum vectorSum = this;
        synchronized (vectorSum) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String x$1 = "dim";
                IntegerType$ x$2 = IntegerType$.MODULE$;
                boolean x$3 = true;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("dim", (DataType)x$2, true, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("dim", (DataType)x$2, true, x$4);
                this.dimAttr = new AttributeReference("dim", (DataType)x$2, true, x$4, x$5, x$6);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dimAttr;
    }

    private AttributeReference dimAttr() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dimAttr$lzycompute();
        }
        return this.dimAttr;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return new .colon.colon((Object)this.sumAttr(), (List)new .colon.colon((Object)this.dimAttr(), (List)Nil$.MODULE$));
    }

    @Override
    public StructType aggBufferSchema() {
        return DataTypeUtils$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    private Seq<AttributeReference> inputAggBufferAttributes$lzycompute() {
        VectorSum vectorSum = this;
        synchronized (vectorSum) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1 & Serializable)x$2 -> x$2.newInstance());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.inputAggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.inputAggBufferAttributes$lzycompute();
        }
        return this.inputAggBufferAttributes;
    }

    private int sumIndex() {
        return this.sumIndex;
    }

    private int dimIndex() {
        return this.dimIndex;
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    private boolean inputContainsNull$lzycompute() {
        VectorSum vectorSum = this;
        synchronized (vectorSum) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.inputContainsNull = ((ArrayType)this.child().dataType()).containsNull();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.inputContainsNull;
    }

    private boolean inputContainsNull() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.inputContainsNull$lzycompute();
        }
        return this.inputContainsNull;
    }

    @Override
    public void initialize(InternalRow buffer) {
        buffer.update(this.mutableAggBufferOffset() + this.sumIndex(), null);
        buffer.update(this.mutableAggBufferOffset() + this.dimIndex(), null);
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        Object inputValue = this.child().eval(input);
        if (inputValue == null) {
            return;
        }
        ArrayData inputArray = (ArrayData)inputValue;
        int inputLen = inputArray.numElements();
        if (this.inputContainsNull()) {
            for (int i = 0; i < inputLen; ++i) {
                if (!inputArray.isNullAt(i)) continue;
                return;
            }
        }
        int sumOffset = this.mutableAggBufferOffset() + this.sumIndex();
        int dimOffset = this.mutableAggBufferOffset() + this.dimIndex();
        if (buffer.isNullAt(sumOffset)) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(inputLen * 4).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < inputLen; ++i) {
                byteBuffer.putFloat(inputArray.getFloat(i));
            }
            buffer.update(sumOffset, byteBuffer.array());
            buffer.setInt(dimOffset, inputLen);
            return;
        }
        int currentDim = buffer.getInt(dimOffset);
        if (currentDim == 0 && inputLen == 0) {
            return;
        }
        if (currentDim != inputLen) {
            throw QueryExecutionErrors$.MODULE$.vectorDimensionMismatchError(this.prettyName(), currentDim, inputLen);
        }
        byte[] currentSumBytes = buffer.getBinary(sumOffset);
        ByteBuffer sumBuffer = ByteBuffer.wrap(currentSumBytes).order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        int idx = 0;
        while (i < currentDim) {
            sumBuffer.putFloat(idx, sumBuffer.getFloat(idx) + inputArray.getFloat(i));
            ++i;
            idx += 4;
        }
    }

    @Override
    public void merge(InternalRow buffer, InternalRow inputBuffer) {
        int sumOffset = this.mutableAggBufferOffset() + this.sumIndex();
        int dimOffset = this.mutableAggBufferOffset() + this.dimIndex();
        int inputSumOffset = this.inputAggBufferOffset() + this.sumIndex();
        int inputDimOffset = this.inputAggBufferOffset() + this.dimIndex();
        if (inputBuffer.isNullAt(inputSumOffset)) {
            return;
        }
        byte[] inputSumBytes = inputBuffer.getBinary(inputSumOffset);
        int inputDim = inputBuffer.getInt(inputDimOffset);
        if (buffer.isNullAt(sumOffset)) {
            buffer.update(sumOffset, inputSumBytes.clone());
            buffer.setInt(dimOffset, inputDim);
            return;
        }
        int currentDim = buffer.getInt(dimOffset);
        if (currentDim == 0 && inputDim == 0) {
            return;
        }
        if (currentDim != inputDim) {
            throw QueryExecutionErrors$.MODULE$.vectorDimensionMismatchError(this.prettyName(), currentDim, inputDim);
        }
        byte[] currentSumBytes = buffer.getBinary(sumOffset);
        ByteBuffer sumBuffer = ByteBuffer.wrap(currentSumBytes).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer inputSumBuffer = ByteBuffer.wrap(inputSumBytes).order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        int idx = 0;
        while (i < currentDim) {
            sumBuffer.putFloat(idx, sumBuffer.getFloat(idx) + inputSumBuffer.getFloat(idx));
            ++i;
            idx += 4;
        }
    }

    @Override
    public Object eval(InternalRow buffer) {
        int sumOffset = this.mutableAggBufferOffset() + this.sumIndex();
        if (buffer.isNullAt(sumOffset)) {
            return null;
        }
        int dim = buffer.getInt(this.mutableAggBufferOffset() + this.dimIndex());
        byte[] sumBytes = buffer.getBinary(sumOffset);
        ByteBuffer sumBuffer = ByteBuffer.wrap(sumBytes).order(ByteOrder.LITTLE_ENDIAN);
        float[] result = new float[dim];
        for (int i = 0; i < dim; ++i) {
            result[i] = sumBuffer.getFloat();
        }
        return ArrayData$.MODULE$.toArrayData(result);
    }

    @Override
    public VectorSum withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public VectorSum copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new VectorSum(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "VectorSum";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof VectorSum;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof VectorSum)) return false;
        boolean bl = true;
        if (!bl) return false;
        VectorSum vectorSum = (VectorSum)x$1;
        if (this.mutableAggBufferOffset() != vectorSum.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != vectorSum.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = vectorSum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!vectorSum.canEqual(this)) return false;
        return true;
    }

    public VectorSum(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        UnaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.sumIndex = 0;
        this.dimIndex = 1;
    }

    public VectorSum(Expression child) {
        this(child, 0, 0);
    }
}

