/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.MultiInstanceRelation;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Range$;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(start[, end[, step[, numSlices]]]) / _FUNC_(end) - Returns a table of values within a specified range.\n  ", arguments="\n    Arguments:\n      * start - An optional BIGINT literal defaulted to 0, marking the first value generated.\n      * end - A BIGINT literal marking endpoint (exclusive) of the number generation.\n      * step - An optional BIGINT literal defaulted to 1, specifying the increment used when generating values.\n      * numParts - An optional INTEGER literal specifying how the production of rows is spread across partitions.\n  ", examples="\n    Examples:\n      > SELECT * FROM _FUNC_(1);\n        +---+\n        | id|\n        +---+\n        |  0|\n        +---+\n      > SELECT * FROM _FUNC_(0, 2);\n        +---+\n        |id |\n        +---+\n        |0  |\n        |1  |\n        +---+\n      > SELECT * FROM _FUNC_(0, 4, 2);\n        +---+\n        |id |\n        +---+\n        |0  |\n        |2  |\n        +---+\n  ", since="2.0.0", group="table_funcs")
@ScalaSignature(bytes="\u0006\u0005\r\u0005q!B\u001e=\u0011\u0003Ye!B'=\u0011\u0003q\u0005\"B/\u0002\t\u0003q\u0006\"B0\u0002\t\u0003\u0001\u0007b\u0002B@\u0003\u0011\u0005\u00111\u0005\u0005\b\u0005\u0003\u000bA\u0011\u0002BB\u0011\u001d\u0011Y)\u0001C\u0005\u0005\u001bCqA!0\u0002\t\u0003\u0011y\fC\u0004\u0003H\u0006!\tA!3\t\u0011}\u000b\u0011\u0011!CA\u0005#D\u0011Ba8\u0002#\u0003%\tA!\u0002\t\u0013\t\u0005\u0018!%A\u0005\u0002\t-\u0001\"\u0003Br\u0003\u0005\u0005I\u0011\u0011Bs\u0011%\u0011\u00190AI\u0001\n\u0003\u0011)\u0001C\u0005\u0003v\u0006\t\n\u0011\"\u0001\u0003\f!I!q_\u0001\u0002\u0002\u0013%!\u0011 \u0004\u0005\u001br\u0002%\r\u0003\u0005~!\tU\r\u0011\"\u0001\u007f\u0011%\t)\u0001\u0005B\tB\u0003%q\u0010C\u0005\u0002\bA\u0011)\u001a!C\u0001}\"I\u0011\u0011\u0002\t\u0003\u0012\u0003\u0006Ia \u0005\n\u0003\u0017\u0001\"Q3A\u0005\u0002yD\u0011\"!\u0004\u0011\u0005#\u0005\u000b\u0011B@\t\u0015\u0005=\u0001C!f\u0001\n\u0003\t\t\u0002\u0003\u0006\u0002 A\u0011\t\u0012)A\u0005\u0003'A!\"!\t\u0011\u0005+\u0007I\u0011IA\u0012\u0011)\t9\u0004\u0005B\tB\u0003%\u0011Q\u0005\u0005\u000b\u0003s\u0001\"Q3A\u0005B\u0005m\u0002BCA\"!\tE\t\u0015!\u0003\u0002>!1Q\f\u0005C\u0001\u0003\u000bBa!\u0018\t\u0005\u0002\u0005M\u0003BB/\u0011\t\u0003\t\u0019\u0007\u0003\u0004^!\u0011\u0005\u00111\u000e\u0005\u0007;B!\t!!\u001d\t\u0013\u0005U\u0004C1A\u0005\u0002\u0005]\u0004\u0002CA@!\u0001\u0006I!!\u001f\t\u000f\u0005\u0005\u0005\u0003\"\u0001\u0002\u0004\"9\u0011Q\u0013\t\u0005B\u0005]\u0005bBAM!\u0011\u0005\u00131\u0014\u0005\b\u0003C\u0003B\u0011IAR\u0011\u001d\t9\u000b\u0005C!\u0003GCq!!+\u0011\t\u0003\nY\u000bC\u0004\u00024B!I!!.\t\u000f\u0005u\u0006\u0003\"\u0003\u0002@\"9\u0011Q\u0019\t\u0005B\u0005\u001d\u0007\"CAi!\u0005\u0005I\u0011AAj\u0011%\t\t\u000fEI\u0001\n\u0003\t\u0019\u000fC\u0005\u0002zB\t\n\u0011\"\u0001\u0002d\"I\u00111 \t\u0012\u0002\u0013\u0005\u00111\u001d\u0005\n\u0003{\u0004\u0012\u0013!C\u0001\u0003\u007fD\u0011Ba\u0001\u0011#\u0003%\tA!\u0002\t\u0013\t%\u0001#%A\u0005\u0002\t-\u0001\"\u0003B\b!\u0005\u0005I\u0011\tB\t\u0011%\u0011i\u0002EA\u0001\n\u0003\u0011y\u0002C\u0005\u0003\"A\t\t\u0011\"\u0001\u0003$!I!q\u0006\t\u0002\u0002\u0013\u0005#\u0011\u0007\u0005\n\u0005\u007f\u0001\u0012\u0011!C\u0001\u0005\u0003B\u0011B!\u0012\u0011\u0003\u0003%\tEa\u0012\t\u0013\t-\u0003#!A\u0005B\t5\u0013!\u0002*b]\u001e,'BA\u001f?\u0003\u001dawnZ5dC2T!a\u0010!\u0002\u000bAd\u0017M\\:\u000b\u0005\u0005\u0013\u0015\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r#\u0015aA:rY*\u0011QIR\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f\"\u000ba!\u00199bG\",'\"A%\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00051\u000bQ\"\u0001\u001f\u0003\u000bI\u000bgnZ3\u0014\u0007\u0005yU\u000b\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016K\u0001\u0004B]f\u0014VM\u001a\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000b!![8\u000b\u0003i\u000bAA[1wC&\u0011Al\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u000bQ!\u00199qYf$\u0012\"\u0019B<\u0005s\u0012YH! \u0011\u00051\u00032C\u0002\tdM&|'\u000f\u0005\u0002MI&\u0011Q\r\u0010\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002MO&\u0011\u0001\u000e\u0010\u0002\t\u0019\u0016\fgMT8eKB\u0011!.\\\u0007\u0002W*\u0011A\u000eQ\u0001\tC:\fG._:jg&\u0011an\u001b\u0002\u0016\u001bVdG/[%ogR\fgnY3SK2\fG/[8o!\t\u0001\u0006/\u0003\u0002r#\n9\u0001K]8ek\u000e$\bCA:|\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002x\u0015\u00061AH]8pizJ\u0011AU\u0005\u0003uF\u000bq\u0001]1dW\u0006<W-\u0003\u0002]y*\u0011!0U\u0001\u0006gR\f'\u000f^\u000b\u0002\u007fB\u0019\u0001+!\u0001\n\u0007\u0005\r\u0011K\u0001\u0003M_:<\u0017AB:uCJ$\b%A\u0002f]\u0012\fA!\u001a8eA\u0005!1\u000f^3q\u0003\u0015\u0019H/\u001a9!\u0003%qW/\\*mS\u000e,7/\u0006\u0002\u0002\u0014A)\u0001+!\u0006\u0002\u001a%\u0019\u0011qC)\u0003\r=\u0003H/[8o!\r\u0001\u00161D\u0005\u0004\u0003;\t&aA%oi\u0006Qa.^7TY&\u001cWm\u001d\u0011\u0002\r=,H\u000f];u+\t\t)\u0003E\u0003t\u0003O\tY#C\u0002\u0002*q\u00141aU3r!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019\u0001\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\t)$a\f\u0003\u0013\u0005#HO]5ckR,\u0017aB8viB,H\u000fI\u0001\fSN\u001cFO]3b[&tw-\u0006\u0002\u0002>A\u0019\u0001+a\u0010\n\u0007\u0005\u0005\u0013KA\u0004C_>dW-\u00198\u0002\u0019%\u001c8\u000b\u001e:fC6Lgn\u001a\u0011\u0015\u001b\u0005\f9%!\u0013\u0002L\u00055\u0013qJA)\u0011\u0015iX\u00041\u0001\u0000\u0011\u0019\t9!\ba\u0001\u007f\"1\u00111B\u000fA\u0002}Dq!a\u0004\u001e\u0001\u0004\t\u0019\u0002C\u0005\u0002\"u\u0001\n\u00111\u0001\u0002&!I\u0011\u0011H\u000f\u0011\u0002\u0003\u0007\u0011Q\b\u000b\nC\u0006U\u0013QLA0\u0003CBa! \u0010A\u0002\u0005]\u0003\u0003BA\u0017\u00033JA!a\u0017\u00020\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u0005\u001da\u00041\u0001\u0002X!9\u00111\u0002\u0010A\u0002\u0005]\u0003bBA\b=\u0001\u0007\u0011q\u000b\u000b\bC\u0006\u0015\u0014qMA5\u0011\u0019ix\u00041\u0001\u0002X!9\u0011qA\u0010A\u0002\u0005]\u0003bBA\u0006?\u0001\u0007\u0011q\u000b\u000b\u0006C\u00065\u0014q\u000e\u0005\u0007{\u0002\u0002\r!a\u0016\t\u000f\u0005\u001d\u0001\u00051\u0001\u0002XQ\u0019\u0011-a\u001d\t\u000f\u0005\u001d\u0011\u00051\u0001\u0002X\u0005Ya.^7FY\u0016lWM\u001c;t+\t\tI\bE\u0002t\u0003wJ1!! }\u0005\u0019\u0011\u0015nZ%oi\u0006aa.^7FY\u0016lWM\u001c;tA\u0005)Ao\\*R\u0019R\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000byI\u0004\u0003\u0002\n\u0006-\u0005CA;R\u0013\r\ti)U\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00151\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055\u0015+A\u0006oK^Len\u001d;b]\u000e,G#A1\u0002\u0019MLW\u000e\u001d7f'R\u0014\u0018N\\4\u0015\t\u0005\u0015\u0015Q\u0014\u0005\b\u0003?3\u0003\u0019AA\r\u0003%i\u0017\r\u001f$jK2$7/A\u0004nCb\u0014vn^:\u0016\u0005\u0005\u0015\u0006\u0003\u0002)\u0002\u0016}\f1#\\1y%><8\u000fU3s!\u0006\u0014H/\u001b;j_:\fAbY8naV$Xm\u0015;biN$\"!!,\u0011\u00071\u000by+C\u0002\u00022r\u0012!b\u0015;bi&\u001cH/[2t\u0003i\u0019w.\u001c9vi\u0016D\u0015n\u001d;pOJ\fWn\u0015;bi&\u001cH/[2t)\t\t9\fE\u0002M\u0003sK1!a/=\u0005%A\u0015n\u001d;pOJ\fW.A\u0007hKR\u0014\u0016M\\4f-\u0006dW/\u001a\u000b\u0004\u007f\u0006\u0005\u0007bBAbW\u0001\u0007\u0011\u0011D\u0001\u0006S:$W\r_\u0001\u000f_V$\b/\u001e;Pe\u0012,'/\u001b8h+\t\tI\rE\u0003t\u0003O\tY\r\u0005\u0003\u0002.\u00055\u0017\u0002BAh\u0003_\u0011\u0011bU8si>\u0013H-\u001a:\u0002\t\r|\u0007/\u001f\u000b\u000eC\u0006U\u0017q[Am\u00037\fi.a8\t\u000ful\u0003\u0013!a\u0001\u007f\"A\u0011qA\u0017\u0011\u0002\u0003\u0007q\u0010\u0003\u0005\u0002\f5\u0002\n\u00111\u0001\u0000\u0011%\ty!\fI\u0001\u0002\u0004\t\u0019\u0002C\u0005\u0002\"5\u0002\n\u00111\u0001\u0002&!I\u0011\u0011H\u0017\u0011\u0002\u0003\u0007\u0011QH\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)OK\u0002\u0000\u0003O\\#!!;\u0011\t\u0005-\u0018Q_\u0007\u0003\u0003[TA!a<\u0002r\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g\f\u0016AC1o]>$\u0018\r^5p]&!\u0011q_Aw\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\u0002)\"\u00111CAt\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"Aa\u0002+\t\u0005\u0015\u0012q]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011iA\u000b\u0003\u0002>\u0005\u001d\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0014A!!Q\u0003B\u000e\u001b\t\u00119BC\u0002\u0003\u001ae\u000bA\u0001\\1oO&!\u0011\u0011\u0013B\f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\"\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\u0015\"1\u0006\t\u0004!\n\u001d\u0012b\u0001B\u0015#\n\u0019\u0011I\\=\t\u0013\t5b'!AA\u0002\u0005e\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00034A1!Q\u0007B\u001e\u0005Ki!Aa\u000e\u000b\u0007\te\u0012+\u0001\u0006d_2dWm\u0019;j_:LAA!\u0010\u00038\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tiDa\u0011\t\u0013\t5\u0002(!AA\u0002\t\u0015\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BAa\u0005\u0003J!I!QF\u001d\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u\"q\n\u0005\n\u0005[Q\u0014\u0011!a\u0001\u0005KAs\u0003\u0005B*\u00053\u0012YFa\u0018\u0003b\t\u0015$q\rB6\u0005[\u0012\tHa\u001d\u0011\t\u00055\"QK\u0005\u0005\u0005/\nyCA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tu\u0013!\u001e\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f^1sinc\u0003%\u001a8e72\u00023\u000f^3q72\u0002c.^7TY&\u001cWm]/^;&\u0002s\u0006I0G+:\u001bu\fK3oI&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAQ\f'\r\\3!_\u001a\u0004c/\u00197vKN\u0004s/\u001b;iS:\u0004\u0013\rI:qK\u000eLg-[3eAI\fgnZ3/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\u0011\u0019'AB)\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f^1si\u0002j\u0003%\u00118!_B$\u0018n\u001c8bY\u0002\u0012\u0015jR%O)\u0002b\u0017\u000e^3sC2\u0004C-\u001a4bk2$X\r\u001a\u0011u_\u0002\u0002D\u0006I7be.Lgn\u001a\u0011uQ\u0016\u0004c-\u001b:ti\u00022\u0018\r\\;fA\u001d,g.\u001a:bi\u0016$gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011f]\u0012\u0004S\u0006I!!\u0005&;\u0015J\u0014+!Y&$XM]1mA5\f'o[5oO\u0002*g\u000e\u001a9pS:$\b\u0005K3yG2,8/\u001b<fS\u0001zg\r\t;iK\u0002rW/\u001c2fe\u0002:WM\\3sCRLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$X\r\u001d\u0011.A\u0005s\u0007e\u001c9uS>t\u0017\r\u001c\u0011C\u0013\u001eKe\n\u0016\u0011mSR,'/\u00197!I\u00164\u0017-\u001e7uK\u0012\u0004Co\u001c\u00112Y\u0001\u001a\b/Z2jMfLgn\u001a\u0011uQ\u0016\u0004\u0013N\\2sK6,g\u000e\u001e\u0011vg\u0016$\u0007e\u001e5f]\u0002:WM\\3sCRLgn\u001a\u0011wC2,Xm\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A9,X\u000eU1siN\u0004S\u0006I!oA=\u0004H/[8oC2\u0004\u0013J\u0014+F\u000f\u0016\u0013\u0006\u0005\\5uKJ\fG\u000eI:qK\u000eLg-_5oO\u0002Bwn\u001e\u0011uQ\u0016\u0004\u0003O]8ek\u000e$\u0018n\u001c8!_\u001a\u0004#o\\<tA%\u001c\be\u001d9sK\u0006$\u0007%Y2s_N\u001c\b\u0005]1si&$\u0018n\u001c8t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011I'\u0001Bl\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002R\u0003E\u0012*P\u001b\u0002zf)\u0016(D?\"\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!W5jSf\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!y\u0002JG\r \u0006!A\u0001\u0002\u0003\u0005\t\u0011!W5jSf\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!y\u0002\u0002\u0003\u0007 \u0006!A\u0001\u0002\u0003\u0005\t\u0011!W5jSf\u000b\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!U\u00012%kT'!?\u001a+fjQ0)a1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A-jS&L\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011!AqLG\r\t?\u000bA\u0001\u0002\u0003\u0005\t\u0011!A-jS&L\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011!Aq\u0004\u0004\u0005\t?\u000bA\u0001\u0002\u0003\u0005\t\u0011!Aq\f\u0004\u0005\t?\u000bA\u0001\u0002\u0003\u0005\t\u0011!A-jS&L\u0016\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA)\u0002cIU(NA}3UKT\"`QAb\u0003\u0005\u000e\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I\u0016.[5Z#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t?jI\u0002b(\u0002\t\u0011!A\u0001\u0002\u0003\u0005I\u0016.[5Z#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t?1A\u0001b(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t?3A\u0001b(\u0002\t\u0011!A\u0001\u0002\u0003\u0005I\u0016.[5Z#\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\t=\u0014!\u0002\u001a/a9\u0002\u0014!B4s_V\u0004\u0018E\u0001B;\u0003-!\u0018M\u00197f?\u001a,hnY:\t\u000bu\u001c\u0001\u0019A@\t\r\u0005\u001d1\u00011\u0001\u0000\u0011\u0019\tYa\u0001a\u0001\u007f\"9\u0011qB\u0002A\u0002\u0005e\u0011AD4fi>+H\u000f];u\u0003R$(o]\u0001\rif\u0004XmQ8fe\u000eLwN\\\u000b\u0003\u0005\u000b\u00032A\u001bBD\u0013\r\u0011Ii\u001b\u0002\u0011)f\u0004XmQ8fe\u000eLwN\u001c\"bg\u0016\f1bY1ti\u0006sG-\u0012<bYV!!q\u0012BK))\u0011\tJ!)\u0003&\nU&\u0011\u0018\t\u0005\u0005'\u0013)\n\u0004\u0001\u0005\u000f\t]eA1\u0001\u0003\u001a\n\tA+\u0005\u0003\u0003\u001c\n\u0015\u0002c\u0001)\u0003\u001e&\u0019!qT)\u0003\u000f9{G\u000f[5oO\"9!1\u0015\u0004A\u0002\u0005]\u0013AC3yaJ,7o]5p]\"9!q\u0015\u0004A\u0002\t%\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\t\t-&\u0011W\u0007\u0003\u0005[S1Aa,C\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0011\u0019L!,\u0003\u0011\u0011\u000bG/\u0019+za\u0016DqAa.\u0007\u0001\u0004\tI\"\u0001\u0006qCJ\fW.\u00138eKbDqAa/\u0007\u0001\u0004\t))A\u0005qCJ\fWNT1nK\u00061Ao\u001c'p]\u001e$ra Ba\u0005\u0007\u0014)\rC\u0004\u0003$\u001e\u0001\r!a\u0016\t\u000f\t]v\u00011\u0001\u0002\u001a!9!1X\u0004A\u0002\u0005\u0015\u0015!\u0002;p\u0013:$H\u0003CA\r\u0005\u0017\u0014iMa4\t\u000f\t\r\u0006\u00021\u0001\u0002X!9!q\u0017\u0005A\u0002\u0005e\u0001b\u0002B^\u0011\u0001\u0007\u0011Q\u0011\u000b\u000eC\nM'Q\u001bBl\u00053\u0014YN!8\t\u000buL\u0001\u0019A@\t\r\u0005\u001d\u0011\u00021\u0001\u0000\u0011\u0019\tY!\u0003a\u0001\u007f\"9\u0011qB\u0005A\u0002\u0005M\u0001\"CA\u0011\u0013A\u0005\t\u0019AA\u0013\u0011%\tI$\u0003I\u0001\u0002\u0004\ti$A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u00122\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005O\u0014y\u000fE\u0003Q\u0003+\u0011I\u000f\u0005\u0007Q\u0005W|xp`A\n\u0003K\ti$C\u0002\u0003nF\u0013a\u0001V;qY\u00164\u0004\u0002\u0003By\u0019\u0005\u0005\t\u0019A1\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tm\b\u0003\u0002B\u000b\u0005{LAAa@\u0003\u0018\t1qJ\u00196fGR\u0004")
public class Range
extends LogicalPlan
implements LeafNode,
MultiInstanceRelation,
Serializable {
    private final long start;
    private final long end;
    private final long step;
    private final Option<Object> numSlices;
    private final Seq<Attribute> output;
    private final boolean isStreaming;
    private final BigInt numElements;

    public static boolean $lessinit$greater$default$6() {
        return Range$.MODULE$.$lessinit$greater$default$6();
    }

    public static Seq<Attribute> $lessinit$greater$default$5() {
        return Range$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple6<Object, Object, Object, Option<Object>, Seq<Attribute>, Object>> unapply(Range x$0) {
        return Range$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$6() {
        return Range$.MODULE$.apply$default$6();
    }

    public static Seq<Attribute> apply$default$5() {
        return Range$.MODULE$.apply$default$5();
    }

    public static int toInt(Expression expression, int paramIndex, String paramName) {
        return Range$.MODULE$.toInt(expression, paramIndex, paramName);
    }

    public static long toLong(Expression expression, int paramIndex, String paramName) {
        return Range$.MODULE$.toLong(expression, paramIndex, paramName);
    }

    public static Seq<Attribute> getOutputAttrs() {
        return Range$.MODULE$.getOutputAttrs();
    }

    @Override
    public AttributeSet producedAttributes() {
        return LeafNode.producedAttributes$(this);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$(this, f);
    }

    @Override
    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$(this, newChildren);
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public long step() {
        return this.step;
    }

    public Option<Object> numSlices() {
        return this.numSlices;
    }

    @Override
    public Seq<Attribute> output() {
        return this.output;
    }

    @Override
    public boolean isStreaming() {
        return this.isStreaming;
    }

    public BigInt numElements() {
        return this.numElements;
    }

    public String toSQL() {
        if (this.numSlices().isDefined()) {
            return "SELECT id AS `" + ((NamedExpression)this.output().head()).name() + "` FROM range(" + this.start() + ", " + this.end() + ", " + this.step() + ", " + this.numSlices().get() + ")";
        }
        return "SELECT id AS `" + ((NamedExpression)this.output().head()).name() + "` FROM range(" + this.start() + ", " + this.end() + ", " + this.step() + ")";
    }

    @Override
    public Range newInstance() {
        Seq x$1 = (Seq)this.output().map((Function1 & Serializable)x$36 -> x$36.newInstance());
        long x$2 = this.copy$default$1();
        long x$3 = this.copy$default$2();
        long x$4 = this.copy$default$3();
        Option<Object> x$5 = this.copy$default$4();
        boolean x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, (Seq<Attribute>)x$1, x$6);
    }

    @Override
    public String simpleString(int maxFields) {
        String splits = this.numSlices().isDefined() ? ", splits=" + this.numSlices() : "";
        return "Range (" + this.start() + ", " + this.end() + ", step=" + this.step() + splits + ")";
    }

    @Override
    public Option<Object> maxRows() {
        if (this.numElements().isValidLong()) {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.numElements().toLong()));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> maxRowsPerPartition() {
        if (this.numSlices().isDefined()) {
            BigInt m = this.numElements().$div(BigInt$.MODULE$.int2bigInt(BoxesRunTime.unboxToInt((Object)this.numSlices().get())));
            if (!BoxesRunTime.equalsNumObject((Number)this.numElements().$percent(BigInt$.MODULE$.int2bigInt(BoxesRunTime.unboxToInt((Object)this.numSlices().get()))), (Object)BoxesRunTime.boxToInteger((int)0))) {
                m = m.$plus(BigInt$.MODULE$.int2bigInt(1));
            }
            if (m.isValidLong()) {
                return new Some((Object)BoxesRunTime.boxToLong((long)m.toLong()));
            }
            return this.maxRows();
        }
        return this.maxRows();
    }

    @Override
    public Statistics computeStats() {
        Tuple2 tuple2;
        if (BoxesRunTime.equalsNumObject((Number)this.numElements(), (Object)BoxesRunTime.boxToInteger((int)0))) {
            return new Statistics(BigInt$.MODULE$.int2bigInt(0), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), Statistics$.MODULE$.apply$default$3(), Statistics$.MODULE$.apply$default$4());
        }
        Tuple2 tuple22 = !this.numElements().isValidLong() ? new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$) : (tuple2 = this.step() > 0L ? new Tuple2((Object)new Some((Object)BoxesRunTime.boxToLong((long)this.start())), (Object)new Some((Object)BoxesRunTime.boxToLong((long)(this.start() + (this.numElements().toLong() - 1L) * this.step())))) : new Tuple2((Object)new Some((Object)BoxesRunTime.boxToLong((long)(this.start() + (this.numElements().toLong() - 1L) * this.step()))), (Object)new Some((Object)BoxesRunTime.boxToLong((long)this.start()))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option minVal = (Option)tuple2._1();
        Option maxVal = (Option)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)minVal, (Object)maxVal);
        Option minVal2 = (Option)tuple23._1();
        Option maxVal2 = (Option)tuple23._2();
        None$ histogram = this.conf().histogramEnabled() ? new Some((Object)this.computeHistogramStatistics()) : None$.MODULE$;
        Some x$1 = new Some((Object)this.numElements());
        Option x$2 = maxVal2;
        Option x$3 = minVal2;
        Some x$4 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
        Some x$5 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
        Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)LongType$.MODULE$.defaultSize()));
        None$ x$7 = histogram;
        int x$8 = ColumnStat$.MODULE$.apply$default$8();
        ColumnStat colStat = new ColumnStat((Option<BigInt>)x$1, (Option<Object>)x$3, (Option<Object>)x$2, (Option<BigInt>)x$4, (Option<Object>)x$5, (Option<Object>)x$6, (Option<Histogram>)x$7, x$8);
        return new Statistics(BigInt$.MODULE$.int2bigInt(LongType$.MODULE$.defaultSize()).$times(this.numElements()), (Option<BigInt>)new Some((Object)this.numElements()), AttributeMap$.MODULE$.apply(new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.output().head()), (Object)colStat), (List)Nil$.MODULE$)), Statistics$.MODULE$.apply$default$4());
    }

    private Histogram computeHistogramStatistics() {
        int numBins = this.conf().histogramNumBins();
        double height = this.numElements().toDouble() / (double)numBins;
        double[] percentileArray = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numBins).map((Function1)(JFunction1.mcDI.sp & Serializable)i -> (double)i * height).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double lowerIndexInitial = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.doubleArrayOps(percentileArray)));
        long lowerBinValueInitial = this.getRangeValue(0);
        Tuple3 tuple3 = (Tuple3)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.doubleArrayOps(percentileArray))), (Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)lowerIndexInitial), (Object)BoxesRunTime.boxToLong((long)lowerBinValueInitial), (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x0$1, x1$1) -> Range.$anonfun$computeHistogramStatistics$2(this, x0$1, BoxesRunTime.unboxToDouble((Object)x1$1)));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Seq binArray = (Seq)tuple3._3();
        Seq binArray2 = binArray;
        return new Histogram(height, (HistogramBin[])binArray2.toArray(ClassTag$.MODULE$.apply(HistogramBin.class)));
    }

    private long getRangeValue(int index) {
        Predef$.MODULE$.assert(index >= 0, (Function0 & Serializable)() -> "index must be greater than and equal to 0");
        if (this.step() < 0L) {
            return this.start() + (this.numElements().toLong() - (long)index - 1L) * this.step();
        }
        return this.start() + (long)index * this.step();
    }

    @Override
    public Seq<SortOrder> outputOrdering() {
        SortDirection order = this.step() > 0L ? Ascending$.MODULE$ : Descending$.MODULE$;
        return (Seq)this.output().map((Function1 & Serializable)a -> SortOrder$.MODULE$.apply((Expression)a, order, SortOrder$.MODULE$.apply$default$3()));
    }

    public Range copy(long start, long end, long step, Option<Object> numSlices, Seq<Attribute> output, boolean isStreaming) {
        return new Range(start, end, step, numSlices, output, isStreaming);
    }

    public long copy$default$1() {
        return this.start();
    }

    public long copy$default$2() {
        return this.end();
    }

    public long copy$default$3() {
        return this.step();
    }

    public Option<Object> copy$default$4() {
        return this.numSlices();
    }

    public Seq<Attribute> copy$default$5() {
        return this.output();
    }

    public boolean copy$default$6() {
        return this.isStreaming();
    }

    @Override
    public String productPrefix() {
        return "Range";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return BoxesRunTime.boxToLong((long)this.start());
            }
            case 1: {
                return BoxesRunTime.boxToLong((long)this.end());
            }
            case 2: {
                return BoxesRunTime.boxToLong((long)this.step());
            }
            case 3: {
                return this.numSlices();
            }
            case 4: {
                return this.output();
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this.isStreaming());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Range;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "start";
            }
            case 1: {
                return "end";
            }
            case 2: {
                return "step";
            }
            case 3: {
                return "numSlices";
            }
            case 4: {
                return "output";
            }
            case 5: {
                return "isStreaming";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Range)) return false;
        boolean bl = true;
        if (!bl) return false;
        Range range = (Range)x$1;
        if (this.start() != range.start()) return false;
        if (this.end() != range.end()) return false;
        if (this.step() != range.step()) return false;
        if (this.isStreaming() != range.isStreaming()) return false;
        Option<Object> option = this.numSlices();
        Option<Object> option2 = range.numSlices();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Seq<Attribute> seq = this.output();
        Seq<Attribute> seq2 = range.output();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!range.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ Tuple3 $anonfun$computeHistogramStatistics$2(Range $this, Tuple3 x0$1, double x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToDouble((double)x1$1));
        if (tuple2 != null) {
            Tuple3 tuple3 = (Tuple3)tuple2._1();
            double upperIndex = tuple2._2$mcD$sp();
            if (tuple3 != null) {
                double lowerIndex = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                long lowerBinValue = BoxesRunTime.unboxToLong((Object)tuple3._2());
                Seq binAr = (Seq)tuple3._3();
                int upperIndexPos = (int)scala.math.package$.MODULE$.ceil(upperIndex) - 1;
                int lowerIndexPos = (int)scala.math.package$.MODULE$.ceil(lowerIndex) - 1;
                long upperBinValue = $this.getRangeValue(scala.math.package$.MODULE$.max(upperIndexPos, 0));
                int ndv = scala.math.package$.MODULE$.max(upperIndexPos - lowerIndexPos, 1);
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)upperIndex), (Object)BoxesRunTime.boxToLong((long)upperBinValue), binAr.$colon$plus((Object)new HistogramBin(lowerBinValue, upperBinValue, ndv)));
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public Range(long start, long end, long step, Option<Object> numSlices, Seq<Attribute> output, boolean isStreaming) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.numSlices = numSlices;
        this.output = output;
        this.isStreaming = isStreaming;
        LeafLike.$init$(this);
        LeafNode.$init$(this);
        Predef$.MODULE$.require(step != 0L, (Function0 & Serializable)() -> "step (" + this.step() + ") cannot be 0");
        BigInt safeStart = package$.MODULE$.BigInt().apply(start);
        BigInt safeEnd = package$.MODULE$.BigInt().apply(end);
        this.numElements = BoxesRunTime.equalsNumObject((Number)safeEnd.$minus(safeStart).$percent(BigInt$.MODULE$.long2bigInt(step)), (Object)BoxesRunTime.boxToInteger((int)0)) || safeEnd.$greater((Object)safeStart) != step > 0L ? safeEnd.$minus(safeStart).$div(BigInt$.MODULE$.long2bigInt(step)) : safeEnd.$minus(safeStart).$div(BigInt$.MODULE$.long2bigInt(step)).$plus(BigInt$.MODULE$.int2bigInt(1));
    }

    public Range(Expression start, Expression end, Expression step, Expression numSlices) {
        this(Range$.MODULE$.toLong(start, 1, "start"), Range$.MODULE$.toLong(end, 2, "end"), Range$.MODULE$.toLong(step, 3, "step"), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Range$.MODULE$.toInt(numSlices, 4, "numSlices"))), Range$.MODULE$.$lessinit$greater$default$5(), Range$.MODULE$.$lessinit$greater$default$6());
    }

    public Range(Expression start, Expression end, Expression step) {
        this(Range$.MODULE$.toLong(start, 1, "start"), Range$.MODULE$.toLong(end, 2, "end"), Range$.MODULE$.toLong(step, 3, "step"), (Option<Object>)None$.MODULE$, Range$.MODULE$.$lessinit$greater$default$5(), Range$.MODULE$.$lessinit$greater$default$6());
    }

    public Range(Expression start, Expression end) {
        this(start, end, Literal$.MODULE$.create(BoxesRunTime.boxToLong((long)1L), (DataType)LongType$.MODULE$));
    }

    public Range(Expression end) {
        this(Literal$.MODULE$.create(BoxesRunTime.boxToLong((long)0L), (DataType)LongType$.MODULE$), end);
    }
}

