/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Map;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.connector.catalog.SupportsPartitionManagement;
import org.apache.spark.sql.errors.QueryExecutionErrors;

@Experimental
public interface SupportsAtomicPartitionManagement
extends SupportsPartitionManagement {
    @Override
    default public void createPartition(InternalRow ident, Map<String, String> properties) throws PartitionsAlreadyExistException, UnsupportedOperationException {
        try {
            this.createPartitions(new InternalRow[]{ident}, new Map[]{properties});
        }
        catch (PartitionsAlreadyExistException e) {
            throw new PartitionsAlreadyExistException("PARTITIONS_ALREADY_EXIST", (scala.collection.immutable.Map<String, String>)e.messageParameters());
        }
    }

    @Override
    default public boolean dropPartition(InternalRow ident) {
        return this.dropPartitions(new InternalRow[]{ident});
    }

    public void createPartitions(InternalRow[] var1, Map<String, String>[] var2) throws PartitionsAlreadyExistException, UnsupportedOperationException;

    public boolean dropPartitions(InternalRow[] var1);

    default public boolean purgePartitions(InternalRow[] idents) throws NoSuchPartitionException, UnsupportedOperationException {
        throw QueryExecutionErrors.unsupportedPurgePartitionError();
    }

    default public boolean truncatePartitions(InternalRow[] idents) throws NoSuchPartitionException, SparkUnsupportedOperationException {
        throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3145");
    }
}

