/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog.constraints;

import java.util.Arrays;
import java.util.Objects;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.constraints.BaseConstraint;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.connector.expressions.NamedReference;

@Evolving
public class ForeignKey
extends BaseConstraint {
    private final NamedReference[] columns;
    private final Identifier refTable;
    private final NamedReference[] refColumns;

    ForeignKey(String name, NamedReference[] columns, Identifier refTable, NamedReference[] refColumns, boolean enforced, Constraint.ValidationStatus validationStatus, boolean rely) {
        super(name, enforced, validationStatus, rely);
        this.columns = columns;
        this.refTable = refTable;
        this.refColumns = refColumns;
    }

    public NamedReference[] columns() {
        return this.columns;
    }

    public Identifier referencedTable() {
        return this.refTable;
    }

    public NamedReference[] referencedColumns() {
        return this.refColumns;
    }

    @Override
    protected String definition() {
        return String.format("FOREIGN KEY (%s) REFERENCES %s (%s)", this.toDDL(this.columns), this.refTable, this.toDDL(this.refColumns));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ForeignKey that = (ForeignKey)other;
        return Objects.equals(this.name(), that.name()) && Arrays.equals(this.columns, that.columns) && Objects.equals(this.refTable, that.refTable) && Arrays.equals(this.refColumns, that.refColumns) && this.enforced() == that.enforced() && Objects.equals((Object)this.validationStatus(), (Object)that.validationStatus()) && this.rely() == that.rely();
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.name(), this.refTable, this.enforced(), this.validationStatus(), this.rely()});
        result = 31 * result + Arrays.hashCode(this.columns);
        result = 31 * result + Arrays.hashCode(this.refColumns);
        return result;
    }

    public static class Builder
    extends BaseConstraint.Builder<Builder, ForeignKey> {
        private final NamedReference[] columns;
        private final Identifier refTable;
        private final NamedReference[] refColumns;

        public Builder(String name, NamedReference[] columns, Identifier refTable, NamedReference[] refColumns) {
            super(name);
            this.columns = columns;
            this.refTable = refTable;
            this.refColumns = refColumns;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ForeignKey build() {
            return new ForeignKey(this.name(), this.columns, this.refTable, this.refColumns, this.enforced(), this.validationStatus(), this.rely());
        }
    }
}

