/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.sparkproject.jetty.client.StringRequestContent;
import org.sparkproject.jetty.http.MimeTypes;
import org.sparkproject.jetty.util.Fields;

public class FormRequestContent
extends StringRequestContent {
    public FormRequestContent(Fields fields) {
        this(fields, StandardCharsets.UTF_8);
    }

    public FormRequestContent(Fields fields, Charset charset) {
        super((String)(charset == StandardCharsets.UTF_8 ? MimeTypes.Type.FORM_ENCODED_UTF_8.asString() : MimeTypes.Type.FORM_ENCODED.asString() + ";charset=" + charset.name().toLowerCase()), FormRequestContent.convert(fields, charset), charset);
    }

    public static String convert(Fields fields) {
        return FormRequestContent.convert(fields, StandardCharsets.UTF_8);
    }

    public static String convert(Fields fields, Charset charset) {
        StringBuilder builder = new StringBuilder(fields.getSize() * 32);
        for (Fields.Field field : fields) {
            for (String value : field.getValues()) {
                if (!builder.isEmpty()) {
                    builder.append("&");
                }
                builder.append(FormRequestContent.encode(field.getName(), charset)).append("=").append(FormRequestContent.encode(value, charset));
            }
        }
        return builder.toString();
    }

    private static String encode(String value, Charset charset) {
        return URLEncoder.encode(value, charset);
    }
}

