/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.io.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.ExceptionUtil;
import org.sparkproject.jetty.util.IteratingCallback;
import org.sparkproject.jetty.util.IteratingNestedCallback;
import org.sparkproject.jetty.util.thread.Invocable;

public class ContentCopier
extends IteratingNestedCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ContentCopier.class);
    private final Content.Source source;
    private final Content.Sink sink;
    private final Content.Chunk.Processor chunkProcessor;
    private Content.Chunk chunk;
    private boolean terminated;

    public ContentCopier(Content.Source source, Content.Sink sink, Content.Chunk.Processor chunkProcessor, Callback callback) {
        super(callback);
        this.source = source;
        this.sink = sink;
        this.chunkProcessor = chunkProcessor;
    }

    @Override
    protected IteratingCallback.Action process() throws Throwable {
        if (this.terminated) {
            return IteratingCallback.Action.SUCCEEDED;
        }
        this.chunk = this.source.read();
        if (this.chunk == null) {
            this.source.demand(Invocable.from(this.getInvocationType(), this::succeeded));
            return IteratingCallback.Action.SCHEDULED;
        }
        if (this.chunkProcessor != null && this.chunkProcessor.process(this.chunk, this)) {
            return IteratingCallback.Action.SCHEDULED;
        }
        this.terminated = this.chunk.isLast();
        if (Content.Chunk.isFailure(this.chunk)) {
            this.failed(this.chunk.getFailure());
            return IteratingCallback.Action.SCHEDULED;
        }
        this.sink.write(this.chunk.isLast(), this.chunk.getByteBuffer(), this);
        return IteratingCallback.Action.SCHEDULED;
    }

    @Override
    protected void onSuccess() {
        this.chunk = Content.Chunk.releaseAndNext(this.chunk);
    }

    @Override
    protected void onFailure(Throwable cause) {
        ExceptionUtil.callAndThen(cause, this.source::fail, x$0 -> super.onFailure((Throwable)x$0));
    }

    @Override
    protected void onCompleteFailure(Throwable x) {
        this.chunk = Content.Chunk.releaseAndNext(this.chunk);
    }
}

