/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.HTTPHeader;
import io.fabric8.kubernetes.api.model.HTTPHeaderBuilder;
import io.fabric8.kubernetes.api.model.HTTPHeaderFluent;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HTTPGetActionFluent<A extends HTTPGetActionFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String host;
    private ArrayList<HTTPHeaderBuilder> httpHeaders = new ArrayList();
    private String path;
    private IntOrStringBuilder port;
    private String scheme;

    public HTTPGetActionFluent() {
    }

    public HTTPGetActionFluent(HTTPGetAction instance) {
        this.copyInstance(instance);
    }

    public A addAllToHttpHeaders(Collection<HTTPHeader> items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)((Object)this);
    }

    public HttpHeadersNested<A> addNewHttpHeader() {
        return new HttpHeadersNested(-1, null);
    }

    public A addNewHttpHeader(String name, String value) {
        return this.addToHttpHeaders(new HTTPHeader(name, value));
    }

    public HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item) {
        return new HttpHeadersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToHttpHeaders(HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(index, builder);
        }
        return (A)((Object)this);
    }

    public HTTPHeader buildFirstHttpHeader() {
        return this.httpHeaders.get(0).build();
    }

    public HTTPHeader buildHttpHeader(int index) {
        return this.httpHeaders.get(index).build();
    }

    public List<HTTPHeader> buildHttpHeaders() {
        return this.httpHeaders != null ? HTTPGetActionFluent.build(this.httpHeaders) : null;
    }

    public HTTPHeader buildLastHttpHeader() {
        return this.httpHeaders.get(this.httpHeaders.size() - 1).build();
    }

    public HTTPHeader buildMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    protected void copyInstance(HTTPGetAction instance) {
        HTTPGetAction hTTPGetAction = instance = instance != null ? instance : new HTTPGetAction();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withHttpHeaders(instance.getHttpHeaders());
            this.withPath(instance.getPath());
            this.withPort(instance.getPort());
            this.withScheme(instance.getScheme());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HttpHeadersNested<A> editFirstHttpHeader() {
        if (this.httpHeaders.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "httpHeaders"));
        }
        return this.setNewHttpHeaderLike(0, this.buildHttpHeader(0));
    }

    public HttpHeadersNested<A> editHttpHeader(int index) {
        if (this.httpHeaders.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "httpHeaders"));
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public HttpHeadersNested<A> editLastHttpHeader() {
        int index = this.httpHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "httpHeaders"));
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public HttpHeadersNested<A> editMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpHeaders.size(); ++i) {
            if (!predicate.test(this.httpHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "httpHeaders"));
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new IntOrStringBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPGetActionFluent that = (HTTPGetActionFluent)((Object)o);
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.httpHeaders, that.httpHeaders)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals((Object)this.port, (Object)that.port)) {
            return false;
        }
        if (!Objects.equals(this.scheme, that.scheme)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public boolean hasHttpHeaders() {
        return this.httpHeaders != null && !this.httpHeaders.isEmpty();
    }

    public boolean hasMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public boolean hasScheme() {
        return this.scheme != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.httpHeaders, this.path, this.port, this.scheme, this.additionalProperties});
    }

    public A removeAllFromHttpHeaders(Collection<HTTPHeader> items) {
        if (this.httpHeaders == null) {
            return (A)((Object)this);
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").remove((Object)builder);
            this.httpHeaders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromHttpHeaders(HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            return (A)((Object)this);
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").remove((Object)builder);
            this.httpHeaders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHttpHeaders(Predicate<HTTPHeaderBuilder> predicate) {
        if (this.httpHeaders == null) {
            return (A)((Object)this);
        }
        Iterator<HTTPHeaderBuilder> each = this.httpHeaders.iterator();
        List visitables = this._visitables.get((Object)"httpHeaders");
        while (each.hasNext()) {
            HTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public HttpHeadersNested<A> setNewHttpHeaderLike(int index, HTTPHeader item) {
        return new HttpHeadersNested(index, item);
    }

    public A setToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host);
            sb.append(",");
        }
        if (this.httpHeaders != null && !this.httpHeaders.isEmpty()) {
            sb.append("httpHeaders:");
            sb.append(this.httpHeaders);
            sb.append(",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path);
            sb.append(",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append((Object)this.port);
            sb.append(",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public A withHttpHeaders(List<HTTPHeader> httpHeaders) {
        if (this.httpHeaders != null) {
            this._visitables.get((Object)"httpHeaders").clear();
        }
        if (httpHeaders != null) {
            this.httpHeaders = new ArrayList();
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        } else {
            this.httpHeaders = null;
        }
        return (A)((Object)this);
    }

    public A withHttpHeaders(HTTPHeader ... httpHeaders) {
        if (this.httpHeaders != null) {
            this.httpHeaders.clear();
            this._visitables.remove((Object)"httpHeaders");
        }
        if (httpHeaders != null) {
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)((Object)this);
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public A withNewPort(Object value) {
        return this.withPort(new IntOrString(value));
    }

    public PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNested(item);
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public A withPort(IntOrString port) {
        this._visitables.remove((Object)"port");
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove((Object)this.port);
        }
        return (A)((Object)this);
    }

    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)((Object)this);
    }

    public class PortNested<N>
    extends IntOrStringFluent<PortNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        PortNested(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        public N and() {
            return (N)HTTPGetActionFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class HttpHeadersNested<N>
    extends HTTPHeaderFluent<HttpHeadersNested<N>>
    implements Nested<N> {
        HTTPHeaderBuilder builder;
        int index;

        HttpHeadersNested(int index, HTTPHeader item) {
            this.index = index;
            this.builder = new HTTPHeaderBuilder(this, item);
        }

        public N and() {
            return (N)HTTPGetActionFluent.this.setToHttpHeaders(this.index, this.builder.build());
        }

        public N endHttpHeader() {
            return this.and();
        }
    }
}

