/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.pmml.export;

import java.io.Serializable;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.pmml.export.BinaryClassificationPMMLModelExport;
import org.apache.spark.mllib.pmml.export.GeneralizedLinearPMMLModelExport;
import org.apache.spark.mllib.pmml.export.KMeansPMMLModelExport;
import org.apache.spark.mllib.pmml.export.PMMLModelExport;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.sparkproject.dmg.pmml.regression.RegressionModel;
import scala.Function0;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class PMMLModelExportFactory$ {
    public static final PMMLModelExportFactory$ MODULE$ = new PMMLModelExportFactory$();

    public PMMLModelExport createPMMLModelExport(Object model) {
        Object object = model;
        if (object instanceof KMeansModel) {
            KMeansModel kMeansModel = (KMeansModel)object;
            return new KMeansPMMLModelExport(kMeansModel);
        }
        if (object instanceof LinearRegressionModel) {
            LinearRegressionModel linearRegressionModel = (LinearRegressionModel)object;
            return new GeneralizedLinearPMMLModelExport(linearRegressionModel, "linear regression");
        }
        if (object instanceof RidgeRegressionModel) {
            RidgeRegressionModel ridgeRegressionModel = (RidgeRegressionModel)object;
            return new GeneralizedLinearPMMLModelExport(ridgeRegressionModel, "ridge regression");
        }
        if (object instanceof LassoModel) {
            LassoModel lassoModel = (LassoModel)object;
            return new GeneralizedLinearPMMLModelExport(lassoModel, "lasso regression");
        }
        if (object instanceof SVMModel) {
            SVMModel sVMModel = (SVMModel)object;
            return new BinaryClassificationPMMLModelExport(sVMModel, "linear SVM", RegressionModel.NormalizationMethod.NONE, BoxesRunTime.unboxToDouble((Object)sVMModel.getThreshold().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)));
        }
        if (object instanceof LogisticRegressionModel) {
            LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)object;
            if (logisticRegressionModel.numClasses() == 2) {
                return new BinaryClassificationPMMLModelExport(logisticRegressionModel, "logistic regression", RegressionModel.NormalizationMethod.LOGIT, BoxesRunTime.unboxToDouble((Object)logisticRegressionModel.getThreshold().getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.5)));
            }
            throw new IllegalArgumentException("PMML Export not supported for Multinomial Logistic Regression");
        }
        throw new IllegalArgumentException("PMML Export not supported for model: " + model.getClass().getName());
    }

    private PMMLModelExportFactory$() {
    }
}

