/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import java.io.Serializable;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.ProtoDataTypes$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.CharType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.GeographyType$;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.sql.types.GeometryType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.VarcharType$;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.SparkClassUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class DataTypeProtoConverter$ {
    public static final DataTypeProtoConverter$ MODULE$ = new DataTypeProtoConverter$();

    public DataType toCatalystType(org.apache.spark.connect.proto.DataType t) {
        DataType.KindCase kindCase = t.getKindCase();
        if (DataType.KindCase.NULL.equals(kindCase)) {
            return NullType$.MODULE$;
        }
        if (DataType.KindCase.BINARY.equals(kindCase)) {
            return BinaryType$.MODULE$;
        }
        if (DataType.KindCase.BOOLEAN.equals(kindCase)) {
            return BooleanType$.MODULE$;
        }
        if (DataType.KindCase.BYTE.equals(kindCase)) {
            return ByteType$.MODULE$;
        }
        if (DataType.KindCase.SHORT.equals(kindCase)) {
            return ShortType$.MODULE$;
        }
        if (DataType.KindCase.INTEGER.equals(kindCase)) {
            return IntegerType$.MODULE$;
        }
        if (DataType.KindCase.LONG.equals(kindCase)) {
            return LongType$.MODULE$;
        }
        if (DataType.KindCase.FLOAT.equals(kindCase)) {
            return FloatType$.MODULE$;
        }
        if (DataType.KindCase.DOUBLE.equals(kindCase)) {
            return DoubleType$.MODULE$;
        }
        if (DataType.KindCase.DECIMAL.equals(kindCase)) {
            return this.toCatalystDecimalType(t.getDecimal());
        }
        if (DataType.KindCase.STRING.equals(kindCase)) {
            return this.toCatalystStringType(t.getString());
        }
        if (DataType.KindCase.CHAR.equals(kindCase)) {
            return CharType$.MODULE$.apply(t.getChar().getLength());
        }
        if (DataType.KindCase.VAR_CHAR.equals(kindCase)) {
            return VarcharType$.MODULE$.apply(t.getVarChar().getLength());
        }
        if (DataType.KindCase.DATE.equals(kindCase)) {
            return DateType$.MODULE$;
        }
        if (DataType.KindCase.TIMESTAMP.equals(kindCase)) {
            return TimestampType$.MODULE$;
        }
        if (DataType.KindCase.TIMESTAMP_NTZ.equals(kindCase)) {
            return TimestampNTZType$.MODULE$;
        }
        if (DataType.KindCase.TIME.equals(kindCase)) {
            if (t.getTime().hasPrecision()) {
                return new TimeType(t.getTime().getPrecision());
            }
            return TimeType$.MODULE$.apply();
        }
        if (DataType.KindCase.CALENDAR_INTERVAL.equals(kindCase)) {
            return CalendarIntervalType$.MODULE$;
        }
        if (DataType.KindCase.YEAR_MONTH_INTERVAL.equals(kindCase)) {
            return this.toCatalystYearMonthIntervalType(t.getYearMonthInterval());
        }
        if (DataType.KindCase.DAY_TIME_INTERVAL.equals(kindCase)) {
            return this.toCatalystDayTimeIntervalType(t.getDayTimeInterval());
        }
        if (DataType.KindCase.ARRAY.equals(kindCase)) {
            return this.toCatalystArrayType(t.getArray());
        }
        if (DataType.KindCase.STRUCT.equals(kindCase)) {
            return this.toCatalystStructType(t.getStruct());
        }
        if (DataType.KindCase.MAP.equals(kindCase)) {
            return this.toCatalystMapType(t.getMap());
        }
        if (DataType.KindCase.VARIANT.equals(kindCase)) {
            return VariantType$.MODULE$;
        }
        if (DataType.KindCase.GEOMETRY.equals(kindCase)) {
            int srid = t.getGeometry().getSrid();
            if (srid == GeometryType$.MODULE$.MIXED_SRID()) {
                return GeometryType$.MODULE$.apply("ANY");
            }
            return GeometryType$.MODULE$.apply(srid);
        }
        if (DataType.KindCase.GEOGRAPHY.equals(kindCase)) {
            int srid = t.getGeography().getSrid();
            if (srid == GeographyType$.MODULE$.MIXED_SRID()) {
                return GeographyType$.MODULE$.apply("ANY");
            }
            return GeographyType$.MODULE$.apply(srid);
        }
        if (DataType.KindCase.UDT.equals(kindCase)) {
            return this.toCatalystUDT(t.getUdt());
        }
        throw InvalidPlanInput$.MODULE$.apply("Does not support convert " + t.getKindCase() + " to catalyst types.");
    }

    private DecimalType toCatalystDecimalType(DataType.Decimal t) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t.hasPrecision(), t.hasScale());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new DecimalType(t.getPrecision(), t.getScale());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return new DecimalType(t.getPrecision());
            }
        }
        return new DecimalType();
    }

    private StringType toCatalystStringType(DataType.String t) {
        return StringType$.MODULE$.apply(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(t.getCollation())) ? t.getCollation() : "UTF8_BINARY");
    }

    private YearMonthIntervalType toCatalystYearMonthIntervalType(DataType.YearMonthInterval t) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t.hasStartField(), t.hasEndField());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new YearMonthIntervalType((byte)t.getStartField(), (byte)t.getEndField());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return YearMonthIntervalType$.MODULE$.apply((byte)t.getStartField());
            }
        }
        return YearMonthIntervalType$.MODULE$.apply();
    }

    private DayTimeIntervalType toCatalystDayTimeIntervalType(DataType.DayTimeInterval t) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t.hasStartField(), t.hasEndField());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new DayTimeIntervalType((byte)t.getStartField(), (byte)t.getEndField());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return DayTimeIntervalType$.MODULE$.apply((byte)t.getStartField());
            }
        }
        return DayTimeIntervalType$.MODULE$.apply();
    }

    private ArrayType toCatalystArrayType(DataType.Array t) {
        return new ArrayType(this.toCatalystType(t.getElementType()), t.getContainsNull());
    }

    public StructType toCatalystStructType(DataType.Struct t) {
        scala.collection.immutable.Seq fields = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.ListHasAsScala(t.getFieldsList()).asScala().toSeq().map((Function1 & Serializable)protoField -> {
            Metadata metadata = protoField.hasMetadata() ? Metadata$.MODULE$.fromJson(protoField.getMetadata()) : Metadata$.MODULE$.empty();
            return new StructField(protoField.getName(), MODULE$.toCatalystType(protoField.getDataType()), protoField.getNullable(), metadata);
        });
        return StructType$.MODULE$.apply((scala.collection.immutable.Seq<StructField>)fields);
    }

    private MapType toCatalystMapType(DataType.Map t) {
        return new MapType(this.toCatalystType(t.getKeyType()), this.toCatalystType(t.getValueType()), t.getValueContainsNull());
    }

    private UserDefinedType<?> toCatalystUDT(DataType.UDT t) {
        String string = t.getType();
        String string2 = "udt";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw InvalidPlanInput$.MODULE$.apply("UserDefinedType requires the 'type' field to be 'udt', but got '" + t.getType() + "'.");
        }
        if (t.hasJvmClass()) {
            return (UserDefinedType)SparkClassUtils$.MODULE$.classForName(t.getJvmClass(), SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (!(t.hasPythonClass() && t.hasSerializedPythonClass() && t.hasSqlType())) {
            throw InvalidPlanInput$.MODULE$.apply("PythonUserDefinedType requires all the three fields: python_class, serialized_python_class and sql_type.");
        }
        return new PythonUserDefinedType(this.toCatalystType(t.getSqlType()), t.getPythonClass(), t.getSerializedPythonClass());
    }

    public org.apache.spark.connect.proto.DataType toConnectProtoType(DataType t, boolean bytesToBinary) {
        return this.toConnectProtoTypeInternal(t, bytesToBinary);
    }

    public boolean toConnectProtoType$default$2() {
        return false;
    }

    private org.apache.spark.connect.proto.DataType toConnectProtoTypeInternal(DataType t, boolean bytesToBinary) {
        StructType structType;
        StructField[] fields;
        DecimalType decimalType;
        Option<Tuple2<Object, Object>> option;
        DataType dataType = t;
        if (NullType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.NullType();
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.BooleanType();
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.BinaryType();
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.ByteType();
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.ShortType();
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.IntegerType();
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.LongType();
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.FloatType();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.DoubleType();
        }
        if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return org.apache.spark.connect.proto.DataType.newBuilder().setDecimal(DataType.Decimal.newBuilder().setPrecision(precision).setScale(scale).build()).build();
        }
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setChar(DataType.Char.newBuilder().setLength(charType.length()).build()).build();
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setVarChar(DataType.VarChar.newBuilder().setLength(varcharType.length()).build()).build();
        }
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setString(DataType.String.newBuilder().setCollation(CollationFactory.fetchCollation((int)stringType.collationId()).collationName).build()).build();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.DateType();
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.TimestampType();
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.TimestampNTZType();
        }
        if (dataType instanceof TimeType) {
            TimeType timeType = (TimeType)dataType;
            int precision = timeType.precision();
            return org.apache.spark.connect.proto.DataType.newBuilder().setTime(DataType.Time.newBuilder().setPrecision(precision).build()).build();
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.CalendarIntervalType();
        }
        if (dataType instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
            byte startField = yearMonthIntervalType.startField();
            byte endField = yearMonthIntervalType.endField();
            return org.apache.spark.connect.proto.DataType.newBuilder().setYearMonthInterval(DataType.YearMonthInterval.newBuilder().setStartField(startField).setEndField(endField).build()).build();
        }
        if (dataType instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
            byte startField = dayTimeIntervalType.startField();
            byte endField = dayTimeIntervalType.endField();
            return org.apache.spark.connect.proto.DataType.newBuilder().setDayTimeInterval(DataType.DayTimeInterval.newBuilder().setStartField(startField).setEndField(endField).build()).build();
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (elementType != null) {
                DataType dataType2 = elementType;
                if (true) {
                    boolean bl = containsNull;
                    DataType dataType3 = dataType2;
                    ByteType$ byteType$ = ByteType$.MODULE$;
                    if (!(dataType3 != null ? !dataType3.equals(byteType$) : byteType$ != null) && bytesToBinary) {
                        return org.apache.spark.connect.proto.DataType.newBuilder().setBinary(DataType.Binary.newBuilder().build()).build();
                    }
                    return org.apache.spark.connect.proto.DataType.newBuilder().setArray(DataType.Array.newBuilder().setElementType(this.toConnectProtoTypeInternal(dataType2, bytesToBinary)).setContainsNull(bl).build()).build();
                }
            }
        }
        if (dataType instanceof StructType && (fields = (structType = (StructType)dataType).fields()) != null) {
            StructField[] structFieldArray = fields;
            ArraySeq protoFields = ArrayImplicits$.MODULE$.SparkArrayOps((Object)structFieldArray).toImmutableArraySeq().map((Function1 & Serializable)x0$1 -> {
                StructField structField = x0$1;
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType = structField.dataType();
                    boolean nullable = structField.nullable();
                    Metadata metadata = structField.metadata();
                    if (name != null) {
                        String string = name;
                        if (dataType != null) {
                            DataType dataType2 = dataType;
                            if (true) {
                                boolean bl = nullable;
                                if (metadata != null) {
                                    Metadata metadata2 = metadata;
                                    if (metadata2.equals(Metadata$.MODULE$.empty())) {
                                        return DataType.StructField.newBuilder().setName(string).setDataType(MODULE$.toConnectProtoTypeInternal(dataType2, bytesToBinary)).setNullable(bl).build();
                                    }
                                    return DataType.StructField.newBuilder().setName(string).setDataType(MODULE$.toConnectProtoTypeInternal(dataType2, bytesToBinary)).setNullable(bl).setMetadata(metadata2.json()).build();
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)structField);
            });
            return org.apache.spark.connect.proto.DataType.newBuilder().setStruct(DataType.Struct.newBuilder().addAllFields(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)protoFields).asJava()).build()).build();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (keyType != null) {
                DataType dataType4 = keyType;
                if (valueType != null) {
                    DataType dataType5 = valueType;
                    if (true) {
                        boolean bl = valueContainsNull;
                        return org.apache.spark.connect.proto.DataType.newBuilder().setMap(DataType.Map.newBuilder().setKeyType(this.toConnectProtoTypeInternal(dataType4, bytesToBinary)).setValueType(this.toConnectProtoTypeInternal(dataType5, bytesToBinary)).setValueContainsNull(bl).build()).build();
                    }
                }
            }
        }
        if (dataType instanceof GeographyType) {
            GeographyType geographyType = (GeographyType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setGeography(DataType.Geography.newBuilder().setSrid(geographyType.srid()).build()).build();
        }
        if (dataType instanceof GeometryType) {
            GeometryType geometryType = (GeometryType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setGeometry(DataType.Geometry.newBuilder().setSrid(geometryType.srid()).build()).build();
        }
        if (VariantType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.VariantType();
        }
        if (dataType instanceof PythonUserDefinedType) {
            PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setUdt(DataType.UDT.newBuilder().setType("udt").setPythonClass(pythonUserDefinedType.pyUDT()).setSqlType(this.toConnectProtoTypeInternal(pythonUserDefinedType.sqlType(), bytesToBinary)).setSerializedPythonClass(pythonUserDefinedType.serializedPyClass()).build()).build();
        }
        if (dataType instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            String string = userDefinedType.getClass().getName();
            switch (string == null ? 0 : string.hashCode()) {
                case -442626967: {
                    if (!"org.apache.spark.ml.linalg.MatrixUDT".equals(string)) break;
                    return ProtoDataTypes$.MODULE$.MatrixUDT();
                }
                case 1006386087: {
                    if (!"org.apache.spark.ml.linalg.VectorUDT".equals(string)) break;
                    return ProtoDataTypes$.MODULE$.VectorUDT();
                }
            }
            DataType.UDT.Builder builder = DataType.UDT.newBuilder();
            builder.setType("udt").setJvmClass(string).setSqlType(this.toConnectProtoTypeInternal(userDefinedType.sqlType(), bytesToBinary));
            Object object = userDefinedType.pyUDT() != null ? builder.setPythonClass(userDefinedType.pyUDT()) : BoxedUnit.UNIT;
            return org.apache.spark.connect.proto.DataType.newBuilder().setUdt(builder.build()).build();
        }
        throw InvalidPlanInput$.MODULE$.apply("Does not support convert " + t.typeName() + " to connect proto types.");
    }

    private DataTypeProtoConverter$() {
    }
}

